/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.eks.EKS2Component;
import org.apache.camel.component.aws2.eks.EKS2Configuration;

public interface Aws2EksComponentBuilderFactory {
    public static Aws2EksComponentBuilder aws2Eks() {
        return new Aws2EksComponentBuilderImpl();
    }

    public static class Aws2EksComponentBuilderImpl
    extends AbstractComponentBuilder<EKS2Component>
    implements Aws2EksComponentBuilder {
        @Override
        protected EKS2Component buildConcreteComponent() {
            return new EKS2Component();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "accessKey": {
                    ((EKS2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((EKS2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "region": {
                    ((EKS2Component)component).setRegion((String)value);
                    return true;
                }
                case "secretKey": {
                    ((EKS2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((EKS2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((EKS2Component)component).setConfiguration((EKS2Configuration)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2EksComponentBuilder
    extends ComponentBuilder<EKS2Component> {
        default public Aws2EksComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2EksComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2EksComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2EksComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2EksComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public Aws2EksComponentBuilder configuration(EKS2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }
    }
}

