/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.iam.IAM2Component;
import org.apache.camel.component.aws2.iam.IAM2Configuration;

public interface Aws2IamComponentBuilderFactory {
    public static Aws2IamComponentBuilder aws2Iam() {
        return new Aws2IamComponentBuilderImpl();
    }

    public static class Aws2IamComponentBuilderImpl
    extends AbstractComponentBuilder<IAM2Component>
    implements Aws2IamComponentBuilder {
        @Override
        protected IAM2Component buildConcreteComponent() {
            return new IAM2Component();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "accessKey": {
                    ((IAM2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((IAM2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "region": {
                    ((IAM2Component)component).setRegion((String)value);
                    return true;
                }
                case "secretKey": {
                    ((IAM2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((IAM2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((IAM2Component)component).setConfiguration((IAM2Configuration)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2IamComponentBuilder
    extends ComponentBuilder<IAM2Component> {
        default public Aws2IamComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2IamComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2IamComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2IamComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2IamComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public Aws2IamComponentBuilder configuration(IAM2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }
    }
}

