/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.kms.KMS2Component;
import org.apache.camel.component.aws2.kms.KMS2Configuration;

public interface Aws2KmsComponentBuilderFactory {
    public static Aws2KmsComponentBuilder aws2Kms() {
        return new Aws2KmsComponentBuilderImpl();
    }

    public static class Aws2KmsComponentBuilderImpl
    extends AbstractComponentBuilder<KMS2Component>
    implements Aws2KmsComponentBuilder {
        @Override
        protected KMS2Component buildConcreteComponent() {
            return new KMS2Component();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "accessKey": {
                    ((KMS2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((KMS2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "region": {
                    ((KMS2Component)component).setRegion((String)value);
                    return true;
                }
                case "secretKey": {
                    ((KMS2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((KMS2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((KMS2Component)component).setConfiguration((KMS2Configuration)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2KmsComponentBuilder
    extends ComponentBuilder<KMS2Component> {
        default public Aws2KmsComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2KmsComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2KmsComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2KmsComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2KmsComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public Aws2KmsComponentBuilder configuration(KMS2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }
    }
}

