/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.mq.MQ2Component;
import org.apache.camel.component.aws2.mq.MQ2Configuration;

public interface Aws2MqComponentBuilderFactory {
    public static Aws2MqComponentBuilder aws2Mq() {
        return new Aws2MqComponentBuilderImpl();
    }

    public static class Aws2MqComponentBuilderImpl
    extends AbstractComponentBuilder<MQ2Component>
    implements Aws2MqComponentBuilder {
        @Override
        protected MQ2Component buildConcreteComponent() {
            return new MQ2Component();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "accessKey": {
                    ((MQ2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((MQ2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "region": {
                    ((MQ2Component)component).setRegion((String)value);
                    return true;
                }
                case "secretKey": {
                    ((MQ2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((MQ2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((MQ2Component)component).setConfiguration((MQ2Configuration)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2MqComponentBuilder
    extends ComponentBuilder<MQ2Component> {
        default public Aws2MqComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2MqComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2MqComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2MqComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2MqComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public Aws2MqComponentBuilder configuration(MQ2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }
    }
}

