/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.msk.MSK2Component;
import org.apache.camel.component.aws2.msk.MSK2Configuration;

public interface Aws2MskComponentBuilderFactory {
    public static Aws2MskComponentBuilder aws2Msk() {
        return new Aws2MskComponentBuilderImpl();
    }

    public static class Aws2MskComponentBuilderImpl
    extends AbstractComponentBuilder<MSK2Component>
    implements Aws2MskComponentBuilder {
        @Override
        protected MSK2Component buildConcreteComponent() {
            return new MSK2Component();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "accessKey": {
                    ((MSK2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((MSK2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "region": {
                    ((MSK2Component)component).setRegion((String)value);
                    return true;
                }
                case "secretKey": {
                    ((MSK2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((MSK2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((MSK2Component)component).setConfiguration((MSK2Configuration)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2MskComponentBuilder
    extends ComponentBuilder<MSK2Component> {
        default public Aws2MskComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2MskComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2MskComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2MskComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2MskComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public Aws2MskComponentBuilder configuration(MSK2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }
    }
}

