/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.ses.Ses2Component;
import org.apache.camel.component.aws2.ses.Ses2Configuration;

public interface Aws2SesComponentBuilderFactory {
    public static Aws2SesComponentBuilder aws2Ses() {
        return new Aws2SesComponentBuilderImpl();
    }

    public static class Aws2SesComponentBuilderImpl
    extends AbstractComponentBuilder<Ses2Component>
    implements Aws2SesComponentBuilder {
        @Override
        protected Ses2Component buildConcreteComponent() {
            return new Ses2Component();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "accessKey": {
                    ((Ses2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((Ses2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "region": {
                    ((Ses2Component)component).setRegion((String)value);
                    return true;
                }
                case "secretKey": {
                    ((Ses2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((Ses2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((Ses2Component)component).setConfiguration((Ses2Configuration)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2SesComponentBuilder
    extends ComponentBuilder<Ses2Component> {
        default public Aws2SesComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2SesComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2SesComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2SesComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2SesComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public Aws2SesComponentBuilder configuration(Ses2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }
    }
}

