/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.sqs.Sqs2Component;
import org.apache.camel.component.aws2.sqs.Sqs2Configuration;

public interface Aws2SqsComponentBuilderFactory {
    public static Aws2SqsComponentBuilder aws2Sqs() {
        return new Aws2SqsComponentBuilderImpl();
    }

    public static class Aws2SqsComponentBuilderImpl
    extends AbstractComponentBuilder<Sqs2Component>
    implements Aws2SqsComponentBuilder {
        @Override
        protected Sqs2Component buildConcreteComponent() {
            return new Sqs2Component();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "accessKey": {
                    ((Sqs2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "region": {
                    ((Sqs2Component)component).setRegion((String)value);
                    return true;
                }
                case "secretKey": {
                    ((Sqs2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((Sqs2Component)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((Sqs2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((Sqs2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((Sqs2Component)component).setConfiguration((Sqs2Configuration)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2SqsComponentBuilder
    extends ComponentBuilder<Sqs2Component> {
        default public Aws2SqsComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2SqsComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2SqsComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2SqsComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public Aws2SqsComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2SqsComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public Aws2SqsComponentBuilder configuration(Sqs2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }
    }
}

