/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.eks.EKSComponent;
import org.apache.camel.component.aws.eks.EKSConfiguration;

public interface AwsEksComponentBuilderFactory {
    public static AwsEksComponentBuilder awsEks() {
        return new AwsEksComponentBuilderImpl();
    }

    public static class AwsEksComponentBuilderImpl
    extends AbstractComponentBuilder<EKSComponent>
    implements AwsEksComponentBuilder {
        @Override
        protected EKSComponent buildConcreteComponent() {
            return new EKSComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "accessKey": {
                    ((EKSComponent)component).setAccessKey((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((EKSComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "region": {
                    ((EKSComponent)component).setRegion((String)value);
                    return true;
                }
                case "secretKey": {
                    ((EKSComponent)component).setSecretKey((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((EKSComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((EKSComponent)component).setConfiguration((EKSConfiguration)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AwsEksComponentBuilder
    extends ComponentBuilder<EKSComponent> {
        default public AwsEksComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AwsEksComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AwsEksComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AwsEksComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public AwsEksComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AwsEksComponentBuilder configuration(EKSConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }
    }
}

