/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.s3.S3Component;
import org.apache.camel.component.aws.s3.S3Configuration;

public interface AwsS3ComponentBuilderFactory {
    public static AwsS3ComponentBuilder awsS3() {
        return new AwsS3ComponentBuilderImpl();
    }

    public static class AwsS3ComponentBuilderImpl
    extends AbstractComponentBuilder<S3Component>
    implements AwsS3ComponentBuilder {
        @Override
        protected S3Component buildConcreteComponent() {
            return new S3Component();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "accessKey": {
                    ((S3Component)component).setAccessKey((String)value);
                    return true;
                }
                case "region": {
                    ((S3Component)component).setRegion((String)value);
                    return true;
                }
                case "secretKey": {
                    ((S3Component)component).setSecretKey((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((S3Component)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((S3Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((S3Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((S3Component)component).setConfiguration((S3Configuration)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AwsS3ComponentBuilder
    extends ComponentBuilder<S3Component> {
        default public AwsS3ComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AwsS3ComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AwsS3ComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public AwsS3ComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AwsS3ComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AwsS3ComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AwsS3ComponentBuilder configuration(S3Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }
    }
}

