/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.ehcache.EhcacheComponent;
import org.apache.camel.component.ehcache.EhcacheConfiguration;
import org.ehcache.CacheManager;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;

public interface EhcacheComponentBuilderFactory {
    public static EhcacheComponentBuilder ehcache() {
        return new EhcacheComponentBuilderImpl();
    }

    public static class EhcacheComponentBuilderImpl
    extends AbstractComponentBuilder<EhcacheComponent>
    implements EhcacheComponentBuilder {
        @Override
        protected EhcacheComponent buildConcreteComponent() {
            return new EhcacheComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "cacheConfiguration": {
                    ((EhcacheComponent)component).setCacheConfiguration((CacheConfiguration)value);
                    return true;
                }
                case "cacheConfigurationUri": {
                    ((EhcacheComponent)component).setCacheConfigurationUri((String)value);
                    return true;
                }
                case "cacheManager": {
                    ((EhcacheComponent)component).setCacheManager((CacheManager)value);
                    return true;
                }
                case "cacheManagerConfiguration": {
                    ((EhcacheComponent)component).setCacheManagerConfiguration((Configuration)value);
                    return true;
                }
                case "cachesConfigurations": {
                    ((EhcacheComponent)component).setCachesConfigurations((Map)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((EhcacheComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((EhcacheComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((EhcacheComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((EhcacheComponent)component).setConfiguration((EhcacheConfiguration)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface EhcacheComponentBuilder
    extends ComponentBuilder<EhcacheComponent> {
        default public EhcacheComponentBuilder cacheConfiguration(CacheConfiguration cacheConfiguration) {
            this.doSetProperty("cacheConfiguration", cacheConfiguration);
            return this;
        }

        default public EhcacheComponentBuilder cacheConfigurationUri(String cacheConfigurationUri) {
            this.doSetProperty("cacheConfigurationUri", cacheConfigurationUri);
            return this;
        }

        default public EhcacheComponentBuilder cacheManager(CacheManager cacheManager) {
            this.doSetProperty("cacheManager", cacheManager);
            return this;
        }

        default public EhcacheComponentBuilder cacheManagerConfiguration(Configuration cacheManagerConfiguration) {
            this.doSetProperty("cacheManagerConfiguration", cacheManagerConfiguration);
            return this;
        }

        default public EhcacheComponentBuilder cachesConfigurations(Map<String, CacheConfiguration> cachesConfigurations) {
            this.doSetProperty("cachesConfigurations", cachesConfigurations);
            return this;
        }

        default public EhcacheComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public EhcacheComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public EhcacheComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public EhcacheComponentBuilder configuration(EhcacheConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }
    }
}

