/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.fhir.FhirComponent;
import org.apache.camel.component.fhir.FhirConfiguration;

public interface FhirComponentBuilderFactory {
    public static FhirComponentBuilder fhir() {
        return new FhirComponentBuilderImpl();
    }

    public static class FhirComponentBuilderImpl
    extends AbstractComponentBuilder<FhirComponent>
    implements FhirComponentBuilder {
        @Override
        protected FhirComponent buildConcreteComponent() {
            return new FhirComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((FhirComponent)component).setConfiguration((FhirConfiguration)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((FhirComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((FhirComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((FhirComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface FhirComponentBuilder
    extends ComponentBuilder<FhirComponent> {
        default public FhirComponentBuilder configuration(FhirConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public FhirComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public FhirComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public FhirComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
    }
}

