/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.hbase.HBaseComponent;
import org.apache.hadoop.conf.Configuration;

public interface HbaseComponentBuilderFactory {
    public static HbaseComponentBuilder hbase() {
        return new HbaseComponentBuilderImpl();
    }

    public static class HbaseComponentBuilderImpl
    extends AbstractComponentBuilder<HBaseComponent>
    implements HbaseComponentBuilder {
        @Override
        protected HBaseComponent buildConcreteComponent() {
            return new HBaseComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "poolMaxSize": {
                    ((HBaseComponent)component).setPoolMaxSize(((Integer)value).intValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((HBaseComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((HBaseComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((HBaseComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((HBaseComponent)component).setConfiguration((Configuration)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface HbaseComponentBuilder
    extends ComponentBuilder<HBaseComponent> {
        default public HbaseComponentBuilder poolMaxSize(int poolMaxSize) {
            this.doSetProperty("poolMaxSize", poolMaxSize);
            return this;
        }

        default public HbaseComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public HbaseComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public HbaseComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public HbaseComponentBuilder configuration(Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }
    }
}

