/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.concurrent.ExecutorService;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.kafka.KafkaComponent;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaManualCommitFactory;

public interface KafkaComponentBuilderFactory {
    public static KafkaComponentBuilder kafka() {
        return new KafkaComponentBuilderImpl();
    }

    public static class KafkaComponentBuilderImpl
    extends AbstractComponentBuilder<KafkaComponent>
    implements KafkaComponentBuilder {
        @Override
        protected KafkaComponent buildConcreteComponent() {
            return new KafkaComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "brokers": {
                    ((KafkaComponent)component).setBrokers((String)value);
                    return true;
                }
                case "configuration": {
                    ((KafkaComponent)component).setConfiguration((KafkaConfiguration)value);
                    return true;
                }
                case "allowManualCommit": {
                    ((KafkaComponent)component).setAllowManualCommit(((Boolean)value).booleanValue());
                    return true;
                }
                case "breakOnFirstError": {
                    ((KafkaComponent)component).setBreakOnFirstError(((Boolean)value).booleanValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((KafkaComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "kafkaManualCommitFactory": {
                    ((KafkaComponent)component).setKafkaManualCommitFactory((KafkaManualCommitFactory)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((KafkaComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((KafkaComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "workerPool": {
                    ((KafkaComponent)component).setWorkerPool((ExecutorService)value);
                    return true;
                }
                case "useGlobalSslContextParameters": {
                    ((KafkaComponent)component).setUseGlobalSslContextParameters(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface KafkaComponentBuilder
    extends ComponentBuilder<KafkaComponent> {
        default public KafkaComponentBuilder brokers(String brokers) {
            this.doSetProperty("brokers", brokers);
            return this;
        }

        default public KafkaComponentBuilder configuration(KafkaConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public KafkaComponentBuilder allowManualCommit(boolean allowManualCommit) {
            this.doSetProperty("allowManualCommit", allowManualCommit);
            return this;
        }

        default public KafkaComponentBuilder breakOnFirstError(boolean breakOnFirstError) {
            this.doSetProperty("breakOnFirstError", breakOnFirstError);
            return this;
        }

        default public KafkaComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public KafkaComponentBuilder kafkaManualCommitFactory(KafkaManualCommitFactory kafkaManualCommitFactory) {
            this.doSetProperty("kafkaManualCommitFactory", kafkaManualCommitFactory);
            return this;
        }

        default public KafkaComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public KafkaComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public KafkaComponentBuilder workerPool(ExecutorService workerPool) {
            this.doSetProperty("workerPool", workerPool);
            return this;
        }

        default public KafkaComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            this.doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    }
}

