/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import io.netty.util.concurrent.EventExecutorGroup;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.netty.NettyComponent;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.support.jsse.SSLContextParameters;

public interface NettyComponentBuilderFactory {
    public static NettyComponentBuilder netty() {
        return new NettyComponentBuilderImpl();
    }

    public static class NettyComponentBuilderImpl
    extends AbstractComponentBuilder<NettyComponent>
    implements NettyComponentBuilder {
        @Override
        protected NettyComponent buildConcreteComponent() {
            return new NettyComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "bridgeErrorHandler": {
                    ((NettyComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "executorService": {
                    ((NettyComponent)component).setExecutorService((EventExecutorGroup)value);
                    return true;
                }
                case "maximumPoolSize": {
                    ((NettyComponent)component).setMaximumPoolSize(((Integer)value).intValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((NettyComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((NettyComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((NettyComponent)component).setConfiguration((NettyConfiguration)value);
                    return true;
                }
                case "sslContextParameters": {
                    ((NettyComponent)component).setSslContextParameters((SSLContextParameters)value);
                    return true;
                }
                case "useGlobalSslContextParameters": {
                    ((NettyComponent)component).setUseGlobalSslContextParameters(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface NettyComponentBuilder
    extends ComponentBuilder<NettyComponent> {
        default public NettyComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public NettyComponentBuilder executorService(EventExecutorGroup executorService) {
            this.doSetProperty("executorService", executorService);
            return this;
        }

        default public NettyComponentBuilder maximumPoolSize(int maximumPoolSize) {
            this.doSetProperty("maximumPoolSize", maximumPoolSize);
            return this;
        }

        default public NettyComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public NettyComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public NettyComponentBuilder configuration(NettyConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public NettyComponentBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public NettyComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            this.doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    }
}

