/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import io.netty.util.concurrent.EventExecutorGroup;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.netty.http.NettyHttpBinding;
import org.apache.camel.component.netty.http.NettyHttpComponent;
import org.apache.camel.component.netty.http.NettyHttpConfiguration;
import org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.jsse.SSLContextParameters;

public interface NettyHttpComponentBuilderFactory {
    public static NettyHttpComponentBuilder nettyHttp() {
        return new NettyHttpComponentBuilderImpl();
    }

    public static class NettyHttpComponentBuilderImpl
    extends AbstractComponentBuilder<NettyHttpComponent>
    implements NettyHttpComponentBuilder {
        @Override
        protected NettyHttpComponent buildConcreteComponent() {
            return new NettyHttpComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((NettyHttpComponent)component).setConfiguration((NettyHttpConfiguration)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((NettyHttpComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "executorService": {
                    ((NettyHttpComponent)component).setExecutorService((EventExecutorGroup)value);
                    return true;
                }
                case "maximumPoolSize": {
                    ((NettyHttpComponent)component).setMaximumPoolSize(((Integer)value).intValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((NettyHttpComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((NettyHttpComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "headerFilterStrategy": {
                    ((NettyHttpComponent)component).setHeaderFilterStrategy((HeaderFilterStrategy)value);
                    return true;
                }
                case "nettyHttpBinding": {
                    ((NettyHttpComponent)component).setNettyHttpBinding((NettyHttpBinding)value);
                    return true;
                }
                case "securityConfiguration": {
                    ((NettyHttpComponent)component).setSecurityConfiguration((NettyHttpSecurityConfiguration)value);
                    return true;
                }
                case "sslContextParameters": {
                    ((NettyHttpComponent)component).setSslContextParameters((SSLContextParameters)value);
                    return true;
                }
                case "useGlobalSslContextParameters": {
                    ((NettyHttpComponent)component).setUseGlobalSslContextParameters(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface NettyHttpComponentBuilder
    extends ComponentBuilder<NettyHttpComponent> {
        default public NettyHttpComponentBuilder configuration(NettyHttpConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public NettyHttpComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public NettyHttpComponentBuilder executorService(EventExecutorGroup executorService) {
            this.doSetProperty("executorService", executorService);
            return this;
        }

        default public NettyHttpComponentBuilder maximumPoolSize(int maximumPoolSize) {
            this.doSetProperty("maximumPoolSize", maximumPoolSize);
            return this;
        }

        default public NettyHttpComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public NettyHttpComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public NettyHttpComponentBuilder headerFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public NettyHttpComponentBuilder nettyHttpBinding(NettyHttpBinding nettyHttpBinding) {
            this.doSetProperty("nettyHttpBinding", nettyHttpBinding);
            return this;
        }

        default public NettyHttpComponentBuilder securityConfiguration(NettyHttpSecurityConfiguration securityConfiguration) {
            this.doSetProperty("securityConfiguration", securityConfiguration);
            return this;
        }

        default public NettyHttpComponentBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public NettyHttpComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            this.doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    }
}

