/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.paho.PahoComponent;
import org.apache.camel.component.paho.PahoConfiguration;
import org.eclipse.paho.client.mqttv3.MqttClient;

public interface PahoComponentBuilderFactory {
    public static PahoComponentBuilder paho() {
        return new PahoComponentBuilderImpl();
    }

    public static class PahoComponentBuilderImpl
    extends AbstractComponentBuilder<PahoComponent>
    implements PahoComponentBuilder {
        @Override
        protected PahoComponent buildConcreteComponent() {
            return new PahoComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "brokerUrl": {
                    ((PahoComponent)component).setBrokerUrl((String)value);
                    return true;
                }
                case "configuration": {
                    ((PahoComponent)component).setConfiguration((PahoConfiguration)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((PahoComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((PahoComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((PahoComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "client": {
                    ((PahoComponent)component).setClient((MqttClient)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface PahoComponentBuilder
    extends ComponentBuilder<PahoComponent> {
        default public PahoComponentBuilder brokerUrl(String brokerUrl) {
            this.doSetProperty("brokerUrl", brokerUrl);
            return this;
        }

        default public PahoComponentBuilder configuration(PahoConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public PahoComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public PahoComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public PahoComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public PahoComponentBuilder client(MqttClient client) {
            this.doSetProperty("client", client);
            return this;
        }
    }
}

