/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.pulsar.PulsarComponent;
import org.apache.camel.component.pulsar.PulsarMessageReceiptFactory;
import org.apache.camel.component.pulsar.utils.AutoConfiguration;
import org.apache.pulsar.client.api.PulsarClient;

public interface PulsarComponentBuilderFactory {
    public static PulsarComponentBuilder pulsar() {
        return new PulsarComponentBuilderImpl();
    }

    public static class PulsarComponentBuilderImpl
    extends AbstractComponentBuilder<PulsarComponent>
    implements PulsarComponentBuilder {
        @Override
        protected PulsarComponent buildConcreteComponent() {
            return new PulsarComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "allowManualAcknowledgement": {
                    ((PulsarComponent)component).setAllowManualAcknowledgement(((Boolean)value).booleanValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((PulsarComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "pulsarMessageReceiptFactory": {
                    ((PulsarComponent)component).setPulsarMessageReceiptFactory((PulsarMessageReceiptFactory)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((PulsarComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autoConfiguration": {
                    ((PulsarComponent)component).setAutoConfiguration((AutoConfiguration)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((PulsarComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "pulsarClient": {
                    ((PulsarComponent)component).setPulsarClient((PulsarClient)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface PulsarComponentBuilder
    extends ComponentBuilder<PulsarComponent> {
        default public PulsarComponentBuilder allowManualAcknowledgement(boolean allowManualAcknowledgement) {
            this.doSetProperty("allowManualAcknowledgement", allowManualAcknowledgement);
            return this;
        }

        default public PulsarComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public PulsarComponentBuilder pulsarMessageReceiptFactory(PulsarMessageReceiptFactory pulsarMessageReceiptFactory) {
            this.doSetProperty("pulsarMessageReceiptFactory", pulsarMessageReceiptFactory);
            return this;
        }

        default public PulsarComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public PulsarComponentBuilder autoConfiguration(AutoConfiguration autoConfiguration) {
            this.doSetProperty("autoConfiguration", autoConfiguration);
            return this;
        }

        default public PulsarComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public PulsarComponentBuilder pulsarClient(PulsarClient pulsarClient) {
            this.doSetProperty("pulsarClient", pulsarClient);
            return this;
        }
    }
}

