/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.Map;
import java.util.Set;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.salesforce.AuthenticationType;
import org.apache.camel.component.salesforce.SalesforceComponent;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.support.jsse.SSLContextParameters;

public interface SalesforceComponentBuilderFactory {
    public static SalesforceComponentBuilder salesforce() {
        return new SalesforceComponentBuilderImpl();
    }

    public static class SalesforceComponentBuilderImpl
    extends AbstractComponentBuilder<SalesforceComponent>
    implements SalesforceComponentBuilder {
        @Override
        protected SalesforceComponent buildConcreteComponent() {
            return new SalesforceComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "httpClientConnectionTimeout": {
                    ((SalesforceComponent)component).setHttpClientConnectionTimeout(((Long)value).longValue());
                    return true;
                }
                case "httpClientIdleTimeout": {
                    ((SalesforceComponent)component).setHttpClientIdleTimeout(((Long)value).longValue());
                    return true;
                }
                case "httpMaxContentLength": {
                    ((SalesforceComponent)component).setHttpMaxContentLength((Integer)value);
                    return true;
                }
                case "packages": {
                    ((SalesforceComponent)component).setPackages((String[])value);
                    return true;
                }
                case "config": {
                    ((SalesforceComponent)component).setConfig((SalesforceEndpointConfig)value);
                    return true;
                }
                case "httpClientProperties": {
                    ((SalesforceComponent)component).setHttpClientProperties((Map)value);
                    return true;
                }
                case "longPollingTransportProperties": {
                    ((SalesforceComponent)component).setLongPollingTransportProperties((Map)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((SalesforceComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((SalesforceComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((SalesforceComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "httpProxyExcludedAddresses": {
                    ((SalesforceComponent)component).setHttpProxyExcludedAddresses((Set)value);
                    return true;
                }
                case "httpProxyHost": {
                    ((SalesforceComponent)component).setHttpProxyHost((String)value);
                    return true;
                }
                case "httpProxyIncludedAddresses": {
                    ((SalesforceComponent)component).setHttpProxyIncludedAddresses((Set)value);
                    return true;
                }
                case "httpProxyPort": {
                    ((SalesforceComponent)component).setHttpProxyPort((Integer)value);
                    return true;
                }
                case "isHttpProxySocks4": {
                    ((SalesforceComponent)component).setIsHttpProxySocks4(((Boolean)value).booleanValue());
                    return true;
                }
                case "authenticationType": {
                    ((SalesforceComponent)component).setAuthenticationType((AuthenticationType)value);
                    return true;
                }
                case "clientId": {
                    ((SalesforceComponent)component).setClientId((String)value);
                    return true;
                }
                case "clientSecret": {
                    ((SalesforceComponent)component).setClientSecret((String)value);
                    return true;
                }
                case "httpProxyAuthUri": {
                    ((SalesforceComponent)component).setHttpProxyAuthUri((String)value);
                    return true;
                }
                case "httpProxyPassword": {
                    ((SalesforceComponent)component).setHttpProxyPassword((String)value);
                    return true;
                }
                case "httpProxyRealm": {
                    ((SalesforceComponent)component).setHttpProxyRealm((String)value);
                    return true;
                }
                case "httpProxyUseDigestAuth": {
                    ((SalesforceComponent)component).setHttpProxyUseDigestAuth(((Boolean)value).booleanValue());
                    return true;
                }
                case "httpProxyUsername": {
                    ((SalesforceComponent)component).setHttpProxyUsername((String)value);
                    return true;
                }
                case "instanceUrl": {
                    ((SalesforceComponent)component).setInstanceUrl((String)value);
                    return true;
                }
                case "isHttpProxySecure": {
                    ((SalesforceComponent)component).setIsHttpProxySecure(((Boolean)value).booleanValue());
                    return true;
                }
                case "keystore": {
                    ((SalesforceComponent)component).setKeystore((KeyStoreParameters)value);
                    return true;
                }
                case "lazyLogin": {
                    ((SalesforceComponent)component).setLazyLogin(((Boolean)value).booleanValue());
                    return true;
                }
                case "loginConfig": {
                    ((SalesforceComponent)component).setLoginConfig((SalesforceLoginConfig)value);
                    return true;
                }
                case "loginUrl": {
                    ((SalesforceComponent)component).setLoginUrl((String)value);
                    return true;
                }
                case "password": {
                    ((SalesforceComponent)component).setPassword((String)value);
                    return true;
                }
                case "refreshToken": {
                    ((SalesforceComponent)component).setRefreshToken((String)value);
                    return true;
                }
                case "sslContextParameters": {
                    ((SalesforceComponent)component).setSslContextParameters((SSLContextParameters)value);
                    return true;
                }
                case "useGlobalSslContextParameters": {
                    ((SalesforceComponent)component).setUseGlobalSslContextParameters(((Boolean)value).booleanValue());
                    return true;
                }
                case "userName": {
                    ((SalesforceComponent)component).setUserName((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface SalesforceComponentBuilder
    extends ComponentBuilder<SalesforceComponent> {
        default public SalesforceComponentBuilder httpClientConnectionTimeout(long httpClientConnectionTimeout) {
            this.doSetProperty("httpClientConnectionTimeout", httpClientConnectionTimeout);
            return this;
        }

        default public SalesforceComponentBuilder httpClientIdleTimeout(long httpClientIdleTimeout) {
            this.doSetProperty("httpClientIdleTimeout", httpClientIdleTimeout);
            return this;
        }

        default public SalesforceComponentBuilder httpMaxContentLength(Integer httpMaxContentLength) {
            this.doSetProperty("httpMaxContentLength", httpMaxContentLength);
            return this;
        }

        default public SalesforceComponentBuilder packages(String[] packages) {
            this.doSetProperty("packages", packages);
            return this;
        }

        default public SalesforceComponentBuilder config(SalesforceEndpointConfig config) {
            this.doSetProperty("config", config);
            return this;
        }

        default public SalesforceComponentBuilder httpClientProperties(Map<String, Object> httpClientProperties) {
            this.doSetProperty("httpClientProperties", httpClientProperties);
            return this;
        }

        default public SalesforceComponentBuilder longPollingTransportProperties(Map<String, Object> longPollingTransportProperties) {
            this.doSetProperty("longPollingTransportProperties", longPollingTransportProperties);
            return this;
        }

        default public SalesforceComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public SalesforceComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public SalesforceComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public SalesforceComponentBuilder httpProxyExcludedAddresses(Set<String> httpProxyExcludedAddresses) {
            this.doSetProperty("httpProxyExcludedAddresses", httpProxyExcludedAddresses);
            return this;
        }

        default public SalesforceComponentBuilder httpProxyHost(String httpProxyHost) {
            this.doSetProperty("httpProxyHost", httpProxyHost);
            return this;
        }

        default public SalesforceComponentBuilder httpProxyIncludedAddresses(Set<String> httpProxyIncludedAddresses) {
            this.doSetProperty("httpProxyIncludedAddresses", httpProxyIncludedAddresses);
            return this;
        }

        default public SalesforceComponentBuilder httpProxyPort(Integer httpProxyPort) {
            this.doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }

        default public SalesforceComponentBuilder isHttpProxySocks4(boolean isHttpProxySocks4) {
            this.doSetProperty("isHttpProxySocks4", isHttpProxySocks4);
            return this;
        }

        default public SalesforceComponentBuilder authenticationType(AuthenticationType authenticationType) {
            this.doSetProperty("authenticationType", authenticationType);
            return this;
        }

        default public SalesforceComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public SalesforceComponentBuilder clientSecret(String clientSecret) {
            this.doSetProperty("clientSecret", clientSecret);
            return this;
        }

        default public SalesforceComponentBuilder httpProxyAuthUri(String httpProxyAuthUri) {
            this.doSetProperty("httpProxyAuthUri", httpProxyAuthUri);
            return this;
        }

        default public SalesforceComponentBuilder httpProxyPassword(String httpProxyPassword) {
            this.doSetProperty("httpProxyPassword", httpProxyPassword);
            return this;
        }

        default public SalesforceComponentBuilder httpProxyRealm(String httpProxyRealm) {
            this.doSetProperty("httpProxyRealm", httpProxyRealm);
            return this;
        }

        default public SalesforceComponentBuilder httpProxyUseDigestAuth(boolean httpProxyUseDigestAuth) {
            this.doSetProperty("httpProxyUseDigestAuth", httpProxyUseDigestAuth);
            return this;
        }

        default public SalesforceComponentBuilder httpProxyUsername(String httpProxyUsername) {
            this.doSetProperty("httpProxyUsername", httpProxyUsername);
            return this;
        }

        default public SalesforceComponentBuilder instanceUrl(String instanceUrl) {
            this.doSetProperty("instanceUrl", instanceUrl);
            return this;
        }

        default public SalesforceComponentBuilder isHttpProxySecure(boolean isHttpProxySecure) {
            this.doSetProperty("isHttpProxySecure", isHttpProxySecure);
            return this;
        }

        default public SalesforceComponentBuilder keystore(KeyStoreParameters keystore) {
            this.doSetProperty("keystore", keystore);
            return this;
        }

        default public SalesforceComponentBuilder lazyLogin(boolean lazyLogin) {
            this.doSetProperty("lazyLogin", lazyLogin);
            return this;
        }

        default public SalesforceComponentBuilder loginConfig(SalesforceLoginConfig loginConfig) {
            this.doSetProperty("loginConfig", loginConfig);
            return this;
        }

        default public SalesforceComponentBuilder loginUrl(String loginUrl) {
            this.doSetProperty("loginUrl", loginUrl);
            return this;
        }

        default public SalesforceComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public SalesforceComponentBuilder refreshToken(String refreshToken) {
            this.doSetProperty("refreshToken", refreshToken);
            return this;
        }

        default public SalesforceComponentBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public SalesforceComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            this.doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }

        default public SalesforceComponentBuilder userName(String userName) {
            this.doSetProperty("userName", userName);
            return this;
        }
    }
}

