/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.ssh.SshComponent;
import org.apache.camel.component.ssh.SshConfiguration;
import org.apache.sshd.common.keyprovider.KeyPairProvider;

public interface SshComponentBuilderFactory {
    public static SshComponentBuilder ssh() {
        return new SshComponentBuilderImpl();
    }

    public static class SshComponentBuilderImpl
    extends AbstractComponentBuilder<SshComponent>
    implements SshComponentBuilder {
        @Override
        protected SshComponent buildConcreteComponent() {
            return new SshComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "host": {
                    ((SshComponent)component).setHost((String)value);
                    return true;
                }
                case "pollCommand": {
                    ((SshComponent)component).setPollCommand((String)value);
                    return true;
                }
                case "port": {
                    ((SshComponent)component).setPort(((Integer)value).intValue());
                    return true;
                }
                case "timeout": {
                    ((SshComponent)component).setTimeout(((Long)value).longValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((SshComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((SshComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((SshComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "channelType": {
                    ((SshComponent)component).setChannelType((String)value);
                    return true;
                }
                case "configuration": {
                    ((SshComponent)component).setConfiguration((SshConfiguration)value);
                    return true;
                }
                case "shellPrompt": {
                    ((SshComponent)component).setShellPrompt((String)value);
                    return true;
                }
                case "sleepForShellPrompt": {
                    ((SshComponent)component).setSleepForShellPrompt(((Long)value).longValue());
                    return true;
                }
                case "certResource": {
                    ((SshComponent)component).setCertResource((String)value);
                    return true;
                }
                case "certResourcePassword": {
                    ((SshComponent)component).setCertResourcePassword((String)value);
                    return true;
                }
                case "keyPairProvider": {
                    ((SshComponent)component).setKeyPairProvider((KeyPairProvider)value);
                    return true;
                }
                case "keyType": {
                    ((SshComponent)component).setKeyType((String)value);
                    return true;
                }
                case "password": {
                    ((SshComponent)component).setPassword((String)value);
                    return true;
                }
                case "username": {
                    ((SshComponent)component).setUsername((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface SshComponentBuilder
    extends ComponentBuilder<SshComponent> {
        default public SshComponentBuilder host(String host) {
            this.doSetProperty("host", host);
            return this;
        }

        default public SshComponentBuilder pollCommand(String pollCommand) {
            this.doSetProperty("pollCommand", pollCommand);
            return this;
        }

        default public SshComponentBuilder port(int port) {
            this.doSetProperty("port", port);
            return this;
        }

        default public SshComponentBuilder timeout(long timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }

        default public SshComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public SshComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public SshComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public SshComponentBuilder channelType(String channelType) {
            this.doSetProperty("channelType", channelType);
            return this;
        }

        default public SshComponentBuilder configuration(SshConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public SshComponentBuilder shellPrompt(String shellPrompt) {
            this.doSetProperty("shellPrompt", shellPrompt);
            return this;
        }

        default public SshComponentBuilder sleepForShellPrompt(long sleepForShellPrompt) {
            this.doSetProperty("sleepForShellPrompt", sleepForShellPrompt);
            return this;
        }

        default public SshComponentBuilder certResource(String certResource) {
            this.doSetProperty("certResource", certResource);
            return this;
        }

        default public SshComponentBuilder certResourcePassword(String certResourcePassword) {
            this.doSetProperty("certResourcePassword", certResourcePassword);
            return this;
        }

        default public SshComponentBuilder keyPairProvider(KeyPairProvider keyPairProvider) {
            this.doSetProperty("keyPairProvider", keyPairProvider);
            return this;
        }

        default public SshComponentBuilder keyType(String keyType) {
            this.doSetProperty("keyType", keyType);
            return this;
        }

        default public SshComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public SshComponentBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }
    }
}

