/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.zendesk.ZendeskComponent;
import org.apache.camel.component.zendesk.ZendeskConfiguration;
import org.zendesk.client.v2.Zendesk;

public interface ZendeskComponentBuilderFactory {
    public static ZendeskComponentBuilder zendesk() {
        return new ZendeskComponentBuilderImpl();
    }

    public static class ZendeskComponentBuilderImpl
    extends AbstractComponentBuilder<ZendeskComponent>
    implements ZendeskComponentBuilder {
        @Override
        protected ZendeskComponent buildConcreteComponent() {
            return new ZendeskComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((ZendeskComponent)component).setConfiguration((ZendeskConfiguration)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((ZendeskComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((ZendeskComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((ZendeskComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "zendesk": {
                    ((ZendeskComponent)component).setZendesk((Zendesk)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface ZendeskComponentBuilder
    extends ComponentBuilder<ZendeskComponent> {
        default public ZendeskComponentBuilder configuration(ZendeskConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public ZendeskComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public ZendeskComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public ZendeskComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public ZendeskComponentBuilder zendesk(Zendesk zendesk) {
            this.doSetProperty("zendesk", zendesk);
            return this;
        }
    }
}

