/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.Map;
import java.util.Properties;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.kamelet.KameletComponent;

public interface KameletComponentBuilderFactory {
    public static KameletComponentBuilder kamelet() {
        return new KameletComponentBuilderImpl();
    }

    public static class KameletComponentBuilderImpl
    extends AbstractComponentBuilder<KameletComponent>
    implements KameletComponentBuilder {
        @Override
        protected KameletComponent buildConcreteComponent() {
            return new KameletComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "location": {
                    ((KameletComponent)component).setLocation((String)value);
                    return true;
                }
                case "routeProperties": {
                    ((KameletComponent)component).setRouteProperties((Map)value);
                    return true;
                }
                case "templateProperties": {
                    ((KameletComponent)component).setTemplateProperties((Map)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((KameletComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "block": {
                    ((KameletComponent)component).setBlock(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((KameletComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "timeout": {
                    ((KameletComponent)component).setTimeout(((Long)value).longValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((KameletComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface KameletComponentBuilder
    extends ComponentBuilder<KameletComponent> {
        default public KameletComponentBuilder location(String location) {
            this.doSetProperty("location", location);
            return this;
        }

        default public KameletComponentBuilder routeProperties(Map<String, Properties> routeProperties) {
            this.doSetProperty("routeProperties", routeProperties);
            return this;
        }

        default public KameletComponentBuilder templateProperties(Map<String, Properties> templateProperties) {
            this.doSetProperty("templateProperties", templateProperties);
            return this;
        }

        default public KameletComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public KameletComponentBuilder block(boolean block) {
            this.doSetProperty("block", block);
            return this;
        }

        default public KameletComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public KameletComponentBuilder timeout(long timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }

        default public KameletComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    }
}

