/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.milo.client.MiloClientComponent;
import org.apache.camel.component.milo.client.MiloClientConfiguration;
import org.apache.camel.component.milo.client.MiloClientConnectionManager;

public interface MiloClientComponentBuilderFactory {
    public static MiloClientComponentBuilder miloClient() {
        return new MiloClientComponentBuilderImpl();
    }

    public static class MiloClientComponentBuilderImpl
    extends AbstractComponentBuilder<MiloClientComponent>
    implements MiloClientComponentBuilder {
        @Override
        protected MiloClientComponent buildConcreteComponent() {
            return new MiloClientComponent();
        }

        private MiloClientConfiguration getOrCreateConfiguration(MiloClientComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new MiloClientConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "clientId": {
                    this.getOrCreateConfiguration((MiloClientComponent)component).setClientId((String)value);
                    return true;
                }
                case "configuration": {
                    ((MiloClientComponent)component).setConfiguration((MiloClientConfiguration)value);
                    return true;
                }
                case "discoveryEndpointSuffix": {
                    this.getOrCreateConfiguration((MiloClientComponent)component).setDiscoveryEndpointSuffix((String)value);
                    return true;
                }
                case "discoveryEndpointUri": {
                    this.getOrCreateConfiguration((MiloClientComponent)component).setDiscoveryEndpointUri((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((MiloClientComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((MiloClientComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((MiloClientComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "allowedSecurityPolicies": {
                    this.getOrCreateConfiguration((MiloClientComponent)component).setAllowedSecurityPolicies((String)value);
                    return true;
                }
                case "applicationName": {
                    this.getOrCreateConfiguration((MiloClientComponent)component).setApplicationName((String)value);
                    return true;
                }
                case "applicationUri": {
                    this.getOrCreateConfiguration((MiloClientComponent)component).setApplicationUri((String)value);
                    return true;
                }
                case "channelLifetime": {
                    this.getOrCreateConfiguration((MiloClientComponent)component).setChannelLifetime((Long)value);
                    return true;
                }
                case "keyAlias": {
                    this.getOrCreateConfiguration((MiloClientComponent)component).setKeyAlias((String)value);
                    return true;
                }
                case "keyPassword": {
                    this.getOrCreateConfiguration((MiloClientComponent)component).setKeyPassword((String)value);
                    return true;
                }
                case "keyStorePassword": {
                    this.getOrCreateConfiguration((MiloClientComponent)component).setKeyStorePassword((String)value);
                    return true;
                }
                case "keyStoreType": {
                    this.getOrCreateConfiguration((MiloClientComponent)component).setKeyStoreType((String)value);
                    return true;
                }
                case "keyStoreUrl": {
                    this.getOrCreateConfiguration((MiloClientComponent)component).setKeyStoreUrl((String)value);
                    return true;
                }
                case "maxPendingPublishRequests": {
                    this.getOrCreateConfiguration((MiloClientComponent)component).setMaxPendingPublishRequests((Long)value);
                    return true;
                }
                case "maxResponseMessageSize": {
                    this.getOrCreateConfiguration((MiloClientComponent)component).setMaxResponseMessageSize((Long)value);
                    return true;
                }
                case "miloClientConnectionManager": {
                    ((MiloClientComponent)component).setMiloClientConnectionManager((MiloClientConnectionManager)value);
                    return true;
                }
                case "overrideHost": {
                    this.getOrCreateConfiguration((MiloClientComponent)component).setOverrideHost(((Boolean)value).booleanValue());
                    return true;
                }
                case "productUri": {
                    this.getOrCreateConfiguration((MiloClientComponent)component).setProductUri((String)value);
                    return true;
                }
                case "requestedPublishingInterval": {
                    this.getOrCreateConfiguration((MiloClientComponent)component).setRequestedPublishingInterval((Double)value);
                    return true;
                }
                case "requestTimeout": {
                    this.getOrCreateConfiguration((MiloClientComponent)component).setRequestTimeout((Long)value);
                    return true;
                }
                case "sessionName": {
                    this.getOrCreateConfiguration((MiloClientComponent)component).setSessionName((String)value);
                    return true;
                }
                case "sessionTimeout": {
                    this.getOrCreateConfiguration((MiloClientComponent)component).setSessionTimeout((Long)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface MiloClientComponentBuilder
    extends ComponentBuilder<MiloClientComponent> {
        default public MiloClientComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public MiloClientComponentBuilder configuration(MiloClientConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public MiloClientComponentBuilder discoveryEndpointSuffix(String discoveryEndpointSuffix) {
            this.doSetProperty("discoveryEndpointSuffix", discoveryEndpointSuffix);
            return this;
        }

        default public MiloClientComponentBuilder discoveryEndpointUri(String discoveryEndpointUri) {
            this.doSetProperty("discoveryEndpointUri", discoveryEndpointUri);
            return this;
        }

        default public MiloClientComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public MiloClientComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public MiloClientComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public MiloClientComponentBuilder allowedSecurityPolicies(String allowedSecurityPolicies) {
            this.doSetProperty("allowedSecurityPolicies", allowedSecurityPolicies);
            return this;
        }

        default public MiloClientComponentBuilder applicationName(String applicationName) {
            this.doSetProperty("applicationName", applicationName);
            return this;
        }

        default public MiloClientComponentBuilder applicationUri(String applicationUri) {
            this.doSetProperty("applicationUri", applicationUri);
            return this;
        }

        default public MiloClientComponentBuilder channelLifetime(Long channelLifetime) {
            this.doSetProperty("channelLifetime", channelLifetime);
            return this;
        }

        default public MiloClientComponentBuilder keyAlias(String keyAlias) {
            this.doSetProperty("keyAlias", keyAlias);
            return this;
        }

        default public MiloClientComponentBuilder keyPassword(String keyPassword) {
            this.doSetProperty("keyPassword", keyPassword);
            return this;
        }

        default public MiloClientComponentBuilder keyStorePassword(String keyStorePassword) {
            this.doSetProperty("keyStorePassword", keyStorePassword);
            return this;
        }

        default public MiloClientComponentBuilder keyStoreType(String keyStoreType) {
            this.doSetProperty("keyStoreType", keyStoreType);
            return this;
        }

        default public MiloClientComponentBuilder keyStoreUrl(String keyStoreUrl) {
            this.doSetProperty("keyStoreUrl", keyStoreUrl);
            return this;
        }

        default public MiloClientComponentBuilder maxPendingPublishRequests(Long maxPendingPublishRequests) {
            this.doSetProperty("maxPendingPublishRequests", maxPendingPublishRequests);
            return this;
        }

        default public MiloClientComponentBuilder maxResponseMessageSize(Long maxResponseMessageSize) {
            this.doSetProperty("maxResponseMessageSize", maxResponseMessageSize);
            return this;
        }

        default public MiloClientComponentBuilder miloClientConnectionManager(MiloClientConnectionManager miloClientConnectionManager) {
            this.doSetProperty("miloClientConnectionManager", miloClientConnectionManager);
            return this;
        }

        default public MiloClientComponentBuilder overrideHost(boolean overrideHost) {
            this.doSetProperty("overrideHost", overrideHost);
            return this;
        }

        default public MiloClientComponentBuilder productUri(String productUri) {
            this.doSetProperty("productUri", productUri);
            return this;
        }

        default public MiloClientComponentBuilder requestedPublishingInterval(Double requestedPublishingInterval) {
            this.doSetProperty("requestedPublishingInterval", requestedPublishingInterval);
            return this;
        }

        default public MiloClientComponentBuilder requestTimeout(Long requestTimeout) {
            this.doSetProperty("requestTimeout", requestTimeout);
            return this;
        }

        default public MiloClientComponentBuilder sessionName(String sessionName) {
            this.doSetProperty("sessionName", sessionName);
            return this;
        }

        default public MiloClientComponentBuilder sessionTimeout(Long sessionTimeout) {
            this.doSetProperty("sessionTimeout", sessionTimeout);
            return this;
        }
    }
}

