/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.google.sheets.GoogleSheetsClientFactory;
import org.apache.camel.component.google.sheets.GoogleSheetsComponent;
import org.apache.camel.component.google.sheets.GoogleSheetsConfiguration;

public interface GoogleSheetsComponentBuilderFactory {
    public static GoogleSheetsComponentBuilder googleSheets() {
        return new GoogleSheetsComponentBuilderImpl();
    }

    public static class GoogleSheetsComponentBuilderImpl
    extends AbstractComponentBuilder<GoogleSheetsComponent>
    implements GoogleSheetsComponentBuilder {
        @Override
        protected GoogleSheetsComponent buildConcreteComponent() {
            return new GoogleSheetsComponent();
        }

        private GoogleSheetsConfiguration getOrCreateConfiguration(GoogleSheetsComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new GoogleSheetsConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "applicationName": {
                    this.getOrCreateConfiguration((GoogleSheetsComponent)component).setApplicationName((String)value);
                    return true;
                }
                case "clientId": {
                    this.getOrCreateConfiguration((GoogleSheetsComponent)component).setClientId((String)value);
                    return true;
                }
                case "configuration": {
                    ((GoogleSheetsComponent)component).setConfiguration((GoogleSheetsConfiguration)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((GoogleSheetsComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "splitResult": {
                    this.getOrCreateConfiguration((GoogleSheetsComponent)component).setSplitResult(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((GoogleSheetsComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((GoogleSheetsComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "clientFactory": {
                    ((GoogleSheetsComponent)component).setClientFactory((GoogleSheetsClientFactory)value);
                    return true;
                }
                case "accessToken": {
                    this.getOrCreateConfiguration((GoogleSheetsComponent)component).setAccessToken((String)value);
                    return true;
                }
                case "clientSecret": {
                    this.getOrCreateConfiguration((GoogleSheetsComponent)component).setClientSecret((String)value);
                    return true;
                }
                case "refreshToken": {
                    this.getOrCreateConfiguration((GoogleSheetsComponent)component).setRefreshToken((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface GoogleSheetsComponentBuilder
    extends ComponentBuilder<GoogleSheetsComponent> {
        default public GoogleSheetsComponentBuilder applicationName(String applicationName) {
            this.doSetProperty("applicationName", applicationName);
            return this;
        }

        default public GoogleSheetsComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public GoogleSheetsComponentBuilder configuration(GoogleSheetsConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public GoogleSheetsComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public GoogleSheetsComponentBuilder splitResult(boolean splitResult) {
            this.doSetProperty("splitResult", splitResult);
            return this;
        }

        default public GoogleSheetsComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public GoogleSheetsComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public GoogleSheetsComponentBuilder clientFactory(GoogleSheetsClientFactory clientFactory) {
            this.doSetProperty("clientFactory", clientFactory);
            return this;
        }

        default public GoogleSheetsComponentBuilder accessToken(String accessToken) {
            this.doSetProperty("accessToken", accessToken);
            return this;
        }

        default public GoogleSheetsComponentBuilder clientSecret(String clientSecret) {
            this.doSetProperty("clientSecret", clientSecret);
            return this;
        }

        default public GoogleSheetsComponentBuilder refreshToken(String refreshToken) {
            this.doSetProperty("refreshToken", refreshToken);
            return this;
        }
    }
}

