/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.ses.Ses2Component;
import org.apache.camel.component.aws2.ses.Ses2Configuration;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.ses.SesClient;

public interface Aws2SesComponentBuilderFactory {
    public static Aws2SesComponentBuilder aws2Ses() {
        return new Aws2SesComponentBuilderImpl();
    }

    public static class Aws2SesComponentBuilderImpl
    extends AbstractComponentBuilder<Ses2Component>
    implements Aws2SesComponentBuilder {
        @Override
        protected Ses2Component buildConcreteComponent() {
            return new Ses2Component();
        }

        private Ses2Configuration getOrCreateConfiguration(Ses2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new Ses2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "amazonSESClient": {
                    this.getOrCreateConfiguration((Ses2Component)component).setAmazonSESClient((SesClient)value);
                    return true;
                }
                case "configuration": {
                    ((Ses2Component)component).setConfiguration((Ses2Configuration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((Ses2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "overrideEndpoint": {
                    this.getOrCreateConfiguration((Ses2Component)component).setOverrideEndpoint(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((Ses2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((Ses2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((Ses2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((Ses2Component)component).setRegion((String)value);
                    return true;
                }
                case "replyToAddresses": {
                    this.getOrCreateConfiguration((Ses2Component)component).setReplyToAddresses((String)value);
                    return true;
                }
                case "returnPath": {
                    this.getOrCreateConfiguration((Ses2Component)component).setReturnPath((String)value);
                    return true;
                }
                case "subject": {
                    this.getOrCreateConfiguration((Ses2Component)component).setSubject((String)value);
                    return true;
                }
                case "to": {
                    this.getOrCreateConfiguration((Ses2Component)component).setTo((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((Ses2Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "uriEndpointOverride": {
                    this.getOrCreateConfiguration((Ses2Component)component).setUriEndpointOverride((String)value);
                    return true;
                }
                case "useDefaultCredentialsProvider": {
                    this.getOrCreateConfiguration((Ses2Component)component).setUseDefaultCredentialsProvider(Boolean.valueOf((Boolean)value));
                    return true;
                }
                case "autowiredEnabled": {
                    ((Ses2Component)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((Ses2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((Ses2Component)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2SesComponentBuilder
    extends ComponentBuilder<Ses2Component> {
        default public Aws2SesComponentBuilder amazonSESClient(SesClient amazonSESClient) {
            this.doSetProperty("amazonSESClient", amazonSESClient);
            return this;
        }

        default public Aws2SesComponentBuilder configuration(Ses2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2SesComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2SesComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Aws2SesComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2SesComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2SesComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2SesComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2SesComponentBuilder replyToAddresses(String replyToAddresses) {
            this.doSetProperty("replyToAddresses", replyToAddresses);
            return this;
        }

        default public Aws2SesComponentBuilder returnPath(String returnPath) {
            this.doSetProperty("returnPath", returnPath);
            return this;
        }

        default public Aws2SesComponentBuilder subject(String subject) {
            this.doSetProperty("subject", subject);
            return this;
        }

        default public Aws2SesComponentBuilder to(String to) {
            this.doSetProperty("to", to);
            return this;
        }

        default public Aws2SesComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2SesComponentBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public Aws2SesComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Aws2SesComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Aws2SesComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2SesComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

