/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import net.corda.core.contracts.ContractState;
import net.corda.core.flows.FlowLogic;
import net.corda.core.node.services.vault.PageSpecification;
import net.corda.core.node.services.vault.QueryCriteria;
import net.corda.core.node.services.vault.Sort;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.corda.CordaComponent;
import org.apache.camel.component.corda.CordaConfiguration;

public interface CordaComponentBuilderFactory {
    public static CordaComponentBuilder corda() {
        return new CordaComponentBuilderImpl();
    }

    public static class CordaComponentBuilderImpl
    extends AbstractComponentBuilder<CordaComponent>
    implements CordaComponentBuilder {
        @Override
        protected CordaComponent buildConcreteComponent() {
            return new CordaComponent();
        }

        private CordaConfiguration getOrCreateConfiguration(CordaComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new CordaConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((CordaComponent)component).setConfiguration((CordaConfiguration)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((CordaComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "pageSpecification": {
                    this.getOrCreateConfiguration((CordaComponent)component).setPageSpecification((PageSpecification)value);
                    return true;
                }
                case "processSnapshot": {
                    this.getOrCreateConfiguration((CordaComponent)component).setProcessSnapshot(((Boolean)value).booleanValue());
                    return true;
                }
                case "sort": {
                    this.getOrCreateConfiguration((CordaComponent)component).setSort((Sort)value);
                    return true;
                }
                case "contractStateClass": {
                    this.getOrCreateConfiguration((CordaComponent)component).setContractStateClass((Class)value);
                    return true;
                }
                case "flowLogicArguments": {
                    this.getOrCreateConfiguration((CordaComponent)component).setFlowLogicArguments((Object[])value);
                    return true;
                }
                case "flowLogicClass": {
                    this.getOrCreateConfiguration((CordaComponent)component).setFlowLogicClass((Class)value);
                    return true;
                }
                case "queryCriteria": {
                    this.getOrCreateConfiguration((CordaComponent)component).setQueryCriteria((QueryCriteria)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((CordaComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((CordaComponent)component).setOperation((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((CordaComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((CordaComponent)component).setPassword((String)value);
                    return true;
                }
                case "username": {
                    this.getOrCreateConfiguration((CordaComponent)component).setUsername((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface CordaComponentBuilder
    extends ComponentBuilder<CordaComponent> {
        default public CordaComponentBuilder configuration(CordaConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public CordaComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public CordaComponentBuilder pageSpecification(PageSpecification pageSpecification) {
            this.doSetProperty("pageSpecification", pageSpecification);
            return this;
        }

        default public CordaComponentBuilder processSnapshot(boolean processSnapshot) {
            this.doSetProperty("processSnapshot", processSnapshot);
            return this;
        }

        default public CordaComponentBuilder sort(Sort sort) {
            this.doSetProperty("sort", sort);
            return this;
        }

        default public CordaComponentBuilder contractStateClass(Class<ContractState> contractStateClass) {
            this.doSetProperty("contractStateClass", contractStateClass);
            return this;
        }

        default public CordaComponentBuilder flowLogicArguments(Object[] flowLogicArguments) {
            this.doSetProperty("flowLogicArguments", flowLogicArguments);
            return this;
        }

        default public CordaComponentBuilder flowLogicClass(Class<FlowLogic<Object>> flowLogicClass) {
            this.doSetProperty("flowLogicClass", flowLogicClass);
            return this;
        }

        default public CordaComponentBuilder queryCriteria(QueryCriteria queryCriteria) {
            this.doSetProperty("queryCriteria", queryCriteria);
            return this;
        }

        default public CordaComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public CordaComponentBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public CordaComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public CordaComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public CordaComponentBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }
    }
}

