/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.robotframework.RobotFrameworkComponent;

/**
 * Pass camel exchanges to acceptence test written in Robot DSL.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface RobotframeworkComponentBuilderFactory {

    /**
     * Robot Framework (camel-robotframework)
     * Pass camel exchanges to acceptence test written in Robot DSL.
     * 
     * Category: testing
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-robotframework
     * 
     * @return the dsl builder
     */
    static RobotframeworkComponentBuilder robotframework() {
        return new RobotframeworkComponentBuilderImpl();
    }

    /**
     * Builder for the Robot Framework component.
     */
    interface RobotframeworkComponentBuilder
            extends
                ComponentBuilder<RobotFrameworkComponent> {
        /**
         * Sets whether the context map should allow access to all details. By
         * default only the message body and headers can be accessed. This
         * option can be enabled for full access to the current Exchange and
         * CamelContext. Doing so impose a potential security risk as this opens
         * access to the full power of CamelContext API.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param allowContextMapAll the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder allowContextMapAll(
                boolean allowContextMapAll) {
            doSetProperty("allowContextMapAll", allowContextMapAll);
            return this;
        }
        /**
         * Whether to allow to use resource template from header or not (default
         * false). Enabling this allows to specify dynamic templates via message
         * header. However this can be seen as a potential security
         * vulnerability if the header is coming from a malicious user, so use
         * this with care.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param allowTemplateFromHeader the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder allowTemplateFromHeader(
                boolean allowTemplateFromHeader) {
            doSetProperty("allowTemplateFromHeader", allowTemplateFromHeader);
            return this;
        }
        /**
         * A text file to read more arguments from.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param argumentFile the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder argumentFile(
                java.io.File argumentFile) {
            doSetProperty("argumentFile", argumentFile);
            return this;
        }
        /**
         * Creates combined statistics based on tags. Use the format tags:title
         * List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param combinedTagStats the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder combinedTagStats(
                java.lang.String combinedTagStats) {
            doSetProperty("combinedTagStats", combinedTagStats);
            return this;
        }
        /**
         * Tests that have the given tags are considered critical. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param criticalTags the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder criticalTags(
                java.lang.String criticalTags) {
            doSetProperty("criticalTags", criticalTags);
            return this;
        }
        /**
         * A debug file that is written during execution.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param debugFile the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder debugFile(java.io.File debugFile) {
            doSetProperty("debugFile", debugFile);
            return this;
        }
        /**
         * Sets the documentation of the top-level tests suites.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param document the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder document(
                java.lang.String document) {
            doSetProperty("document", document);
            return this;
        }
        /**
         * Sets dryrun mode on use. In the dry run mode tests are run without
         * executing keywords originating from test libraries. Useful for
         * validating test data syntax.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param dryrun the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder dryrun(boolean dryrun) {
            doSetProperty("dryrun", dryrun);
            return this;
        }
        /**
         * Selects the tests cases by tags. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param excludes the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder excludes(
                java.lang.String excludes) {
            doSetProperty("excludes", excludes);
            return this;
        }
        /**
         * Sets robot to stop execution immediately if a critical test fails.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param exitOnFailure the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder exitOnFailure(
                boolean exitOnFailure) {
            doSetProperty("exitOnFailure", exitOnFailure);
            return this;
        }
        /**
         * Selects the tests cases by tags. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includes the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder includes(
                java.lang.String includes) {
            doSetProperty("includes", includes);
            return this;
        }
        /**
         * Sets a single listener for monitoring tests execution.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param listener the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder listener(
                java.lang.String listener) {
            doSetProperty("listener", listener);
            return this;
        }
        /**
         * Sets multiple listeners for monitoring tests execution. Use the
         * format ListenerWithArgs:arg1:arg2 or simply ListenerWithoutArgs List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param listeners the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder listeners(
                java.lang.String listeners) {
            doSetProperty("listeners", listeners);
            return this;
        }
        /**
         * Sets the path to the generated log file.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param log the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder log(java.io.File log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Sets the threshold level for logging.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param logLevel the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder logLevel(
                java.lang.String logLevel) {
            doSetProperty("logLevel", logLevel);
            return this;
        }
        /**
         * Sets a title for the generated tests log.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param logTitle the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder logTitle(
                java.lang.String logTitle) {
            doSetProperty("logTitle", logTitle);
            return this;
        }
        /**
         * Sets free metadata for the top level tests suites. comma seperated
         * list of string resulting as List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param metadata the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder metadata(
                java.lang.String metadata) {
            doSetProperty("metadata", metadata);
            return this;
        }
        /**
         * Using ANSI colors in console. Normally colors work in unixes but not
         * in Windows. Default is 'on'. 'on' - use colors in unixes but not in
         * Windows 'off' - never use colors 'force' - always use colors (also in
         * Windows).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param monitorColors the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder monitorColors(
                java.lang.String monitorColors) {
            doSetProperty("monitorColors", monitorColors);
            return this;
        }
        /**
         * Width of the monitor output. Default is 78.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 78
         * Group: common
         * 
         * @param monitorWidth the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder monitorWidth(
                java.lang.String monitorWidth) {
            doSetProperty("monitorWidth", monitorWidth);
            return this;
        }
        /**
         * Sets the name of the top-level tests suites.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param name the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder name(java.lang.String name) {
            doSetProperty("name", name);
            return this;
        }
        /**
         * Tests that have the given tags are not critical. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param nonCriticalTags the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder nonCriticalTags(
                java.lang.String nonCriticalTags) {
            doSetProperty("nonCriticalTags", nonCriticalTags);
            return this;
        }
        /**
         * If true, sets the return code to zero regardless of failures in test
         * cases. Error codes are returned normally.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param noStatusReturnCode the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder noStatusReturnCode(
                boolean noStatusReturnCode) {
            doSetProperty("noStatusReturnCode", noStatusReturnCode);
            return this;
        }
        /**
         * Sets the path to the generated output file.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param output the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder output(java.io.File output) {
            doSetProperty("output", output);
            return this;
        }
        /**
         * Configures where generated reports are to be placed.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputDirectory the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder outputDirectory(
                java.io.File outputDirectory) {
            doSetProperty("outputDirectory", outputDirectory);
            return this;
        }
        /**
         * Sets the test execution order to be randomized. Valid values are all,
         * suite, and test.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param randomize the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder randomize(
                java.lang.String randomize) {
            doSetProperty("randomize", randomize);
            return this;
        }
        /**
         * Sets the path to the generated report file.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param report the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder report(java.io.File report) {
            doSetProperty("report", report);
            return this;
        }
        /**
         * Sets background colors for the generated report and summary.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportBackground the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder reportBackground(
                java.lang.String reportBackground) {
            doSetProperty("reportBackground", reportBackground);
            return this;
        }
        /**
         * Sets a title for the generated tests report.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportTitle the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder reportTitle(
                java.lang.String reportTitle) {
            doSetProperty("reportTitle", reportTitle);
            return this;
        }
        /**
         * Executes tests also if the top level test suite is empty. Useful e.g.
         * with --include/--exclude when it is not an error that no test matches
         * the condition.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param runEmptySuite the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder runEmptySuite(
                boolean runEmptySuite) {
            doSetProperty("runEmptySuite", runEmptySuite);
            return this;
        }
        /**
         * Re-run failed tests, based on output.xml file.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param runFailed the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder runFailed(java.io.File runFailed) {
            doSetProperty("runFailed", runFailed);
            return this;
        }
        /**
         * Sets the execution mode for this tests run. Note that this setting
         * has been deprecated in Robot Framework 2.8. Use separate dryryn,
         * skipTeardownOnExit, exitOnFailure, and randomize settings instead.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param runMode the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder runMode(java.lang.String runMode) {
            doSetProperty("runMode", runMode);
            return this;
        }
        /**
         * Sets whether the teardowns are skipped if the test execution is
         * prematurely stopped.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipTeardownOnExit the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder skipTeardownOnExit(
                boolean skipTeardownOnExit) {
            doSetProperty("skipTeardownOnExit", skipTeardownOnExit);
            return this;
        }
        /**
         * Splits output and log files.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param splitOutputs the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder splitOutputs(
                java.lang.String splitOutputs) {
            doSetProperty("splitOutputs", splitOutputs);
            return this;
        }
        /**
         * Selects the tests suites by name. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param suites the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder suites(java.lang.String suites) {
            doSetProperty("suites", suites);
            return this;
        }
        /**
         * Defines how many levels to show in the Statistics by Suite table in
         * outputs.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param suiteStatLevel the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder suiteStatLevel(
                java.lang.String suiteStatLevel) {
            doSetProperty("suiteStatLevel", suiteStatLevel);
            return this;
        }
        /**
         * Sets a title for the generated summary report.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param summaryTitle the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder summaryTitle(
                java.lang.String summaryTitle) {
            doSetProperty("summaryTitle", summaryTitle);
            return this;
        }
        /**
         * Adds documentation to the specified tags. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagDocs the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder tagDocs(java.lang.String tagDocs) {
            doSetProperty("tagDocs", tagDocs);
            return this;
        }
        /**
         * Sets the tags(s) to all executed tests cases. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tags the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder tags(java.lang.String tags) {
            doSetProperty("tags", tags);
            return this;
        }
        /**
         * Excludes these tags from the Statistics by Tag and Test Details by
         * Tag tables in outputs. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagStatExcludes the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder tagStatExcludes(
                java.lang.String tagStatExcludes) {
            doSetProperty("tagStatExcludes", tagStatExcludes);
            return this;
        }
        /**
         * Includes only these tags in the Statistics by Tag and Test Details by
         * Tag tables in outputs. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagStatIncludes the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder tagStatIncludes(
                java.lang.String tagStatIncludes) {
            doSetProperty("tagStatIncludes", tagStatIncludes);
            return this;
        }
        /**
         * Adds external links to the Statistics by Tag table in outputs. Use
         * the format pattern:link:title List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagStatLinks the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder tagStatLinks(
                java.lang.String tagStatLinks) {
            doSetProperty("tagStatLinks", tagStatLinks);
            return this;
        }
        /**
         * Selects the tests cases by name. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tests the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder tests(java.lang.String tests) {
            doSetProperty("tests", tests);
            return this;
        }
        /**
         * Adds a timestamp to all output files.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param timestampOutputs the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder timestampOutputs(
                boolean timestampOutputs) {
            doSetProperty("timestampOutputs", timestampOutputs);
            return this;
        }
        /**
         * Sets variables using variables files. Use the format path:args List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param variableFiles the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder variableFiles(
                java.lang.String variableFiles) {
            doSetProperty("variableFiles", variableFiles);
            return this;
        }
        /**
         * Sets individual variables. Use the format name:value List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param variables the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder variables(
                java.lang.String variables) {
            doSetProperty("variables", variables);
            return this;
        }
        /**
         * Show a warning when an invalid file is skipped.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param warnOnSkippedFiles the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder warnOnSkippedFiles(
                boolean warnOnSkippedFiles) {
            doSetProperty("warnOnSkippedFiles", warnOnSkippedFiles);
            return this;
        }
        /**
         * Sets the path to the generated XUnit compatible result file, relative
         * to outputDirectory. The file is in xml format. By default, the file
         * name is derived from the testCasesDirectory parameter, replacing
         * blanks in the directory name by underscores.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param xunitFile the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder xunitFile(java.io.File xunitFile) {
            doSetProperty("xunitFile", xunitFile);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder autowiredEnabled(
                boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
        /**
         * The configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.robotframework.RobotFrameworkCamelConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default RobotframeworkComponentBuilder configuration(
                org.apache.camel.component.robotframework.RobotFrameworkCamelConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    }

    class RobotframeworkComponentBuilderImpl
            extends
                AbstractComponentBuilder<RobotFrameworkComponent>
            implements
                RobotframeworkComponentBuilder {
        @Override
        protected RobotFrameworkComponent buildConcreteComponent() {
            return new RobotFrameworkComponent();
        }
        private org.apache.camel.component.robotframework.RobotFrameworkCamelConfiguration getOrCreateConfiguration(
                org.apache.camel.component.robotframework.RobotFrameworkComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.robotframework.RobotFrameworkCamelConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "allowContextMapAll": getOrCreateConfiguration((RobotFrameworkComponent) component).setAllowContextMapAll((boolean) value); return true;
            case "allowTemplateFromHeader": getOrCreateConfiguration((RobotFrameworkComponent) component).setAllowTemplateFromHeader((boolean) value); return true;
            case "argumentFile": getOrCreateConfiguration((RobotFrameworkComponent) component).setArgumentFile((java.io.File) value); return true;
            case "combinedTagStats": getOrCreateConfiguration((RobotFrameworkComponent) component).setCombinedTagStats((java.lang.String) value); return true;
            case "criticalTags": getOrCreateConfiguration((RobotFrameworkComponent) component).setCriticalTags((java.lang.String) value); return true;
            case "debugFile": getOrCreateConfiguration((RobotFrameworkComponent) component).setDebugFile((java.io.File) value); return true;
            case "document": getOrCreateConfiguration((RobotFrameworkComponent) component).setDocument((java.lang.String) value); return true;
            case "dryrun": getOrCreateConfiguration((RobotFrameworkComponent) component).setDryrun((boolean) value); return true;
            case "excludes": getOrCreateConfiguration((RobotFrameworkComponent) component).setExcludes((java.lang.String) value); return true;
            case "exitOnFailure": getOrCreateConfiguration((RobotFrameworkComponent) component).setExitOnFailure((boolean) value); return true;
            case "includes": getOrCreateConfiguration((RobotFrameworkComponent) component).setIncludes((java.lang.String) value); return true;
            case "listener": getOrCreateConfiguration((RobotFrameworkComponent) component).setListener((java.lang.String) value); return true;
            case "listeners": getOrCreateConfiguration((RobotFrameworkComponent) component).setListeners((java.lang.String) value); return true;
            case "log": getOrCreateConfiguration((RobotFrameworkComponent) component).setLog((java.io.File) value); return true;
            case "logLevel": getOrCreateConfiguration((RobotFrameworkComponent) component).setLogLevel((java.lang.String) value); return true;
            case "logTitle": getOrCreateConfiguration((RobotFrameworkComponent) component).setLogTitle((java.lang.String) value); return true;
            case "metadata": getOrCreateConfiguration((RobotFrameworkComponent) component).setMetadata((java.lang.String) value); return true;
            case "monitorColors": getOrCreateConfiguration((RobotFrameworkComponent) component).setMonitorColors((java.lang.String) value); return true;
            case "monitorWidth": getOrCreateConfiguration((RobotFrameworkComponent) component).setMonitorWidth((java.lang.String) value); return true;
            case "name": getOrCreateConfiguration((RobotFrameworkComponent) component).setName((java.lang.String) value); return true;
            case "nonCriticalTags": getOrCreateConfiguration((RobotFrameworkComponent) component).setNonCriticalTags((java.lang.String) value); return true;
            case "noStatusReturnCode": getOrCreateConfiguration((RobotFrameworkComponent) component).setNoStatusReturnCode((boolean) value); return true;
            case "output": getOrCreateConfiguration((RobotFrameworkComponent) component).setOutput((java.io.File) value); return true;
            case "outputDirectory": getOrCreateConfiguration((RobotFrameworkComponent) component).setOutputDirectory((java.io.File) value); return true;
            case "randomize": getOrCreateConfiguration((RobotFrameworkComponent) component).setRandomize((java.lang.String) value); return true;
            case "report": getOrCreateConfiguration((RobotFrameworkComponent) component).setReport((java.io.File) value); return true;
            case "reportBackground": getOrCreateConfiguration((RobotFrameworkComponent) component).setReportBackground((java.lang.String) value); return true;
            case "reportTitle": getOrCreateConfiguration((RobotFrameworkComponent) component).setReportTitle((java.lang.String) value); return true;
            case "runEmptySuite": getOrCreateConfiguration((RobotFrameworkComponent) component).setRunEmptySuite((boolean) value); return true;
            case "runFailed": getOrCreateConfiguration((RobotFrameworkComponent) component).setRunFailed((java.io.File) value); return true;
            case "runMode": getOrCreateConfiguration((RobotFrameworkComponent) component).setRunMode((java.lang.String) value); return true;
            case "skipTeardownOnExit": getOrCreateConfiguration((RobotFrameworkComponent) component).setSkipTeardownOnExit((boolean) value); return true;
            case "splitOutputs": getOrCreateConfiguration((RobotFrameworkComponent) component).setSplitOutputs((java.lang.String) value); return true;
            case "suites": getOrCreateConfiguration((RobotFrameworkComponent) component).setSuites((java.lang.String) value); return true;
            case "suiteStatLevel": getOrCreateConfiguration((RobotFrameworkComponent) component).setSuiteStatLevel((java.lang.String) value); return true;
            case "summaryTitle": getOrCreateConfiguration((RobotFrameworkComponent) component).setSummaryTitle((java.lang.String) value); return true;
            case "tagDocs": getOrCreateConfiguration((RobotFrameworkComponent) component).setTagDocs((java.lang.String) value); return true;
            case "tags": getOrCreateConfiguration((RobotFrameworkComponent) component).setTags((java.lang.String) value); return true;
            case "tagStatExcludes": getOrCreateConfiguration((RobotFrameworkComponent) component).setTagStatExcludes((java.lang.String) value); return true;
            case "tagStatIncludes": getOrCreateConfiguration((RobotFrameworkComponent) component).setTagStatIncludes((java.lang.String) value); return true;
            case "tagStatLinks": getOrCreateConfiguration((RobotFrameworkComponent) component).setTagStatLinks((java.lang.String) value); return true;
            case "tests": getOrCreateConfiguration((RobotFrameworkComponent) component).setTests((java.lang.String) value); return true;
            case "timestampOutputs": getOrCreateConfiguration((RobotFrameworkComponent) component).setTimestampOutputs((boolean) value); return true;
            case "variableFiles": getOrCreateConfiguration((RobotFrameworkComponent) component).setVariableFiles((java.lang.String) value); return true;
            case "variables": getOrCreateConfiguration((RobotFrameworkComponent) component).setVariables((java.lang.String) value); return true;
            case "warnOnSkippedFiles": getOrCreateConfiguration((RobotFrameworkComponent) component).setWarnOnSkippedFiles((boolean) value); return true;
            case "xunitFile": getOrCreateConfiguration((RobotFrameworkComponent) component).setXunitFile((java.io.File) value); return true;
            case "bridgeErrorHandler": ((RobotFrameworkComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "lazyStartProducer": ((RobotFrameworkComponent) component).setLazyStartProducer((boolean) value); return true;
            case "autowiredEnabled": ((RobotFrameworkComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "configuration": ((RobotFrameworkComponent) component).setConfiguration((org.apache.camel.component.robotframework.RobotFrameworkCamelConfiguration) value); return true;
            default: return false;
            }
        }
    }
}