/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component;

import javax.annotation.Generated;

/**
 * Component entry DSL builder. You can build a component like this:
 * ComponentBuilderFactory.kafka().setBrokers("{{host:port}}").build()
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface ComponentsBuilderFactory {

    /**
     * ActiveMQ (camel-activemq)
     * The activemq component allows messages to be sent to (or consumed from)
     * Apache ActiveMQ. This component extends the Camel JMS component.
     * 
     * Category: messaging
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-activemq
     */
    static org.apache.camel.builder.component.dsl.ActivemqComponentBuilderFactory.ActivemqComponentBuilder activemq() {
        return org.apache.camel.builder.component.dsl.ActivemqComponentBuilderFactory.activemq();
    }
    /**
     * AHC (camel-ahc)
     * To call external HTTP services using Async Http Client.
     * 
     * Category: http
     * Since: 2.8
     * Maven coordinates: org.apache.camel:camel-ahc
     */
    static org.apache.camel.builder.component.dsl.AhcComponentBuilderFactory.AhcComponentBuilder ahc() {
        return org.apache.camel.builder.component.dsl.AhcComponentBuilderFactory.ahc();
    }
    /**
     * AHC Websocket (camel-ahc-ws)
     * To exchange data with external Websocket servers using Async Http Client.
     * 
     * Category: websocket
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-ahc-ws
     */
    static org.apache.camel.builder.component.dsl.AhcWsComponentBuilderFactory.AhcWsComponentBuilder ahcWs() {
        return org.apache.camel.builder.component.dsl.AhcWsComponentBuilderFactory.ahcWs();
    }
    /**
     * AHC Secure Websocket (Secure) (camel-ahc-ws)
     * To exchange data with external Websocket servers using Async Http Client.
     * 
     * Category: websocket
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-ahc-ws
     */
    static org.apache.camel.builder.component.dsl.AhcWssComponentBuilderFactory.AhcWssComponentBuilder ahcWss() {
        return org.apache.camel.builder.component.dsl.AhcWssComponentBuilderFactory.ahcWss();
    }
    /**
     * AMQP (camel-amqp)
     * Messaging with AMQP protocol using Apache QPid Client.
     * 
     * Category: messaging
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-amqp
     */
    static org.apache.camel.builder.component.dsl.AmqpComponentBuilderFactory.AmqpComponentBuilder amqp() {
        return org.apache.camel.builder.component.dsl.AmqpComponentBuilderFactory.amqp();
    }
    /**
     * APNS (camel-apns)
     * For sending notifications to Apple iOS devices.
     * 
     * Category: eventbus,mobile
     * Since: 2.8
     * Maven coordinates: org.apache.camel:camel-apns
     */
    static org.apache.camel.builder.component.dsl.ApnsComponentBuilderFactory.ApnsComponentBuilder apns() {
        return org.apache.camel.builder.component.dsl.ApnsComponentBuilderFactory.apns();
    }
    /**
     * AS2 (camel-as2)
     * Component used for transferring data secure and reliable over the
     * internet using the AS2 protocol.
     * 
     * Category: file
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-as2
     */
    static org.apache.camel.builder.component.dsl.As2ComponentBuilderFactory.As2ComponentBuilder as2() {
        return org.apache.camel.builder.component.dsl.As2ComponentBuilderFactory.as2();
    }
    /**
     * Asterisk (camel-asterisk)
     * The asterisk component is used to interact with Asterisk PBX Server.
     * 
     * Category: voip
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-asterisk
     */
    static org.apache.camel.builder.component.dsl.AsteriskComponentBuilderFactory.AsteriskComponentBuilder asterisk() {
        return org.apache.camel.builder.component.dsl.AsteriskComponentBuilderFactory.asterisk();
    }
    /**
     * Atmos (camel-atmos)
     * The atmos component is used for integrating with EMC's Atomos Storage.
     * 
     * Category: file,cloud
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-atmos
     */
    static org.apache.camel.builder.component.dsl.AtmosComponentBuilderFactory.AtmosComponentBuilder atmos() {
        return org.apache.camel.builder.component.dsl.AtmosComponentBuilderFactory.atmos();
    }
    /**
     * Atmosphere Websocket (camel-atmosphere-websocket)
     * To exchange data with external Websocket clients using Atmosphere.
     * 
     * Category: websocket
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-atmosphere-websocket
     */
    static org.apache.camel.builder.component.dsl.AtmosphereWebsocketComponentBuilderFactory.AtmosphereWebsocketComponentBuilder atmosphereWebsocket() {
        return org.apache.camel.builder.component.dsl.AtmosphereWebsocketComponentBuilderFactory.atmosphereWebsocket();
    }
    /**
     * Atom (camel-atom)
     * The atom component is used for consuming Atom RSS feeds.
     * 
     * Category: rss
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-atom
     */
    static org.apache.camel.builder.component.dsl.AtomComponentBuilderFactory.AtomComponentBuilder atom() {
        return org.apache.camel.builder.component.dsl.AtomComponentBuilderFactory.atom();
    }
    /**
     * Atomix Map (camel-atomix)
     * The atomix-map component is used to access Atomix's distributed map.
     * 
     * Category: clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-atomix
     */
    static org.apache.camel.builder.component.dsl.AtomixMapComponentBuilderFactory.AtomixMapComponentBuilder atomixMap() {
        return org.apache.camel.builder.component.dsl.AtomixMapComponentBuilderFactory.atomixMap();
    }
    /**
     * Atomix Messaging (camel-atomix)
     * The atomix-messaging component is used to access Atomix's group
     * messaging.
     * 
     * Category: clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-atomix
     */
    static org.apache.camel.builder.component.dsl.AtomixMessagingComponentBuilderFactory.AtomixMessagingComponentBuilder atomixMessaging() {
        return org.apache.camel.builder.component.dsl.AtomixMessagingComponentBuilderFactory.atomixMessaging();
    }
    /**
     * Atomix MultiMap (camel-atomix)
     * The atomix-multimap component is used to access Atomix's distributed
     * multi map.
     * 
     * Category: clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-atomix
     */
    static org.apache.camel.builder.component.dsl.AtomixMultimapComponentBuilderFactory.AtomixMultimapComponentBuilder atomixMultimap() {
        return org.apache.camel.builder.component.dsl.AtomixMultimapComponentBuilderFactory.atomixMultimap();
    }
    /**
     * Atomix Queue (camel-atomix)
     * The atomix-queue component is used to access Atomix's distributed queue.
     * 
     * Category: clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-atomix
     */
    static org.apache.camel.builder.component.dsl.AtomixQueueComponentBuilderFactory.AtomixQueueComponentBuilder atomixQueue() {
        return org.apache.camel.builder.component.dsl.AtomixQueueComponentBuilderFactory.atomixQueue();
    }
    /**
     * Atomix Set (camel-atomix)
     * The atomix-set component is used to access Atomix's distributed set.
     * 
     * Category: clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-atomix
     */
    static org.apache.camel.builder.component.dsl.AtomixSetComponentBuilderFactory.AtomixSetComponentBuilder atomixSet() {
        return org.apache.camel.builder.component.dsl.AtomixSetComponentBuilderFactory.atomixSet();
    }
    /**
     * Atomix Value (camel-atomix)
     * The atomix-value component is used to access Atomix's distributed value.
     * 
     * Category: clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-atomix
     */
    static org.apache.camel.builder.component.dsl.AtomixValueComponentBuilderFactory.AtomixValueComponentBuilder atomixValue() {
        return org.apache.camel.builder.component.dsl.AtomixValueComponentBuilderFactory.atomixValue();
    }
    /**
     * Avro (camel-avro-rpc)
     * Working with Apache Avro for data serialization.
     * 
     * Category: messaging,transformation
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-avro-rpc
     */
    static org.apache.camel.builder.component.dsl.AvroComponentBuilderFactory.AvroComponentBuilder avro() {
        return org.apache.camel.builder.component.dsl.AvroComponentBuilderFactory.avro();
    }
    /**
     * AWS CloudWatch (camel-aws-cw)
     * The aws-cw component is used for sending metrics to an Amazon CloudWatch.
     * 
     * Category: cloud,monitoring
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-aws-cw
     */
    static org.apache.camel.builder.component.dsl.AwsCwComponentBuilderFactory.AwsCwComponentBuilder awsCw() {
        return org.apache.camel.builder.component.dsl.AwsCwComponentBuilderFactory.awsCw();
    }
    /**
     * AWS DynamoDB (camel-aws-ddb)
     * The aws-ddb component is used for storing and retrieving data from
     * Amazon's DynamoDB service.
     * 
     * Category: cloud,database,nosql
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-aws-ddb
     */
    static org.apache.camel.builder.component.dsl.AwsDdbComponentBuilderFactory.AwsDdbComponentBuilder awsDdb() {
        return org.apache.camel.builder.component.dsl.AwsDdbComponentBuilderFactory.awsDdb();
    }
    /**
     * AWS DynamoDB Streams (camel-aws-ddb)
     * The aws-ddbstream component is used for working with Amazon DynamoDB
     * Streams.
     * 
     * Category: cloud,messaging,streams
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-aws-ddb
     */
    static org.apache.camel.builder.component.dsl.AwsDdbstreamComponentBuilderFactory.AwsDdbstreamComponentBuilder awsDdbstream() {
        return org.apache.camel.builder.component.dsl.AwsDdbstreamComponentBuilderFactory.awsDdbstream();
    }
    /**
     * AWS EC2 (camel-aws-ec2)
     * The aws-ec2 is used for managing Amazon EC2 instances.
     * 
     * Category: cloud,management
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-aws-ec2
     */
    static org.apache.camel.builder.component.dsl.AwsEc2ComponentBuilderFactory.AwsEc2ComponentBuilder awsEc2() {
        return org.apache.camel.builder.component.dsl.AwsEc2ComponentBuilderFactory.awsEc2();
    }
    /**
     * AWS ECS (camel-aws-ecs)
     * The aws-ecs is used for managing Amazon ECS
     * 
     * Category: cloud,management
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-aws-ecs
     */
    static org.apache.camel.builder.component.dsl.AwsEcsComponentBuilderFactory.AwsEcsComponentBuilder awsEcs() {
        return org.apache.camel.builder.component.dsl.AwsEcsComponentBuilderFactory.awsEcs();
    }
    /**
     * AWS EKS (camel-aws-eks)
     * The aws-eks is used for managing Amazon EKS
     * 
     * Category: cloud,management
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-aws-eks
     */
    static org.apache.camel.builder.component.dsl.AwsEksComponentBuilderFactory.AwsEksComponentBuilder awsEks() {
        return org.apache.camel.builder.component.dsl.AwsEksComponentBuilderFactory.awsEks();
    }
    /**
     * AWS IAM (camel-aws-iam)
     * The aws-iam is used for managing Amazon IAM
     * 
     * Category: cloud,management
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-aws-iam
     */
    static org.apache.camel.builder.component.dsl.AwsIamComponentBuilderFactory.AwsIamComponentBuilder awsIam() {
        return org.apache.camel.builder.component.dsl.AwsIamComponentBuilderFactory.awsIam();
    }
    /**
     * AWS Kinesis (camel-aws-kinesis)
     * The aws-kinesis component is for consuming and producing records from
     * Amazon Kinesis Streams.
     * 
     * Category: cloud,messaging
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-aws-kinesis
     */
    static org.apache.camel.builder.component.dsl.AwsKinesisComponentBuilderFactory.AwsKinesisComponentBuilder awsKinesis() {
        return org.apache.camel.builder.component.dsl.AwsKinesisComponentBuilderFactory.awsKinesis();
    }
    /**
     * AWS Kinesis Firehose (camel-aws-kinesis)
     * The aws-kinesis-firehose component is used for producing Amazon's Kinesis
     * Firehose streams.
     * 
     * Category: cloud,messaging
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-aws-kinesis
     */
    static org.apache.camel.builder.component.dsl.AwsKinesisFirehoseComponentBuilderFactory.AwsKinesisFirehoseComponentBuilder awsKinesisFirehose() {
        return org.apache.camel.builder.component.dsl.AwsKinesisFirehoseComponentBuilderFactory.awsKinesisFirehose();
    }
    /**
     * AWS KMS (camel-aws-kms)
     * The aws-kms is used for managing Amazon KMS
     * 
     * Category: cloud,management
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-aws-kms
     */
    static org.apache.camel.builder.component.dsl.AwsKmsComponentBuilderFactory.AwsKmsComponentBuilder awsKms() {
        return org.apache.camel.builder.component.dsl.AwsKmsComponentBuilderFactory.awsKms();
    }
    /**
     * AWS Lambda (camel-aws-lambda)
     * The aws-lambda is used for managing and invoking functions from Amazon
     * Lambda.
     * 
     * Category: cloud,computing,serverless
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-aws-lambda
     */
    static org.apache.camel.builder.component.dsl.AwsLambdaComponentBuilderFactory.AwsLambdaComponentBuilder awsLambda() {
        return org.apache.camel.builder.component.dsl.AwsLambdaComponentBuilderFactory.awsLambda();
    }
    /**
     * AWS MQ (camel-aws-mq)
     * The aws-mq is used for managing Amazon MQ instances.
     * 
     * Category: cloud,management
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-aws-mq
     */
    static org.apache.camel.builder.component.dsl.AwsMqComponentBuilderFactory.AwsMqComponentBuilder awsMq() {
        return org.apache.camel.builder.component.dsl.AwsMqComponentBuilderFactory.awsMq();
    }
    /**
     * AWS MSK (camel-aws-msk)
     * The aws-msk is used for managing Amazon MSK
     * 
     * Category: cloud,management
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-aws-msk
     */
    static org.apache.camel.builder.component.dsl.AwsMskComponentBuilderFactory.AwsMskComponentBuilder awsMsk() {
        return org.apache.camel.builder.component.dsl.AwsMskComponentBuilderFactory.awsMsk();
    }
    /**
     * AWS S3 Storage Service (camel-aws-s3)
     * The aws-s3 component is used for storing and retrieving object from
     * Amazon S3 Storage Service.
     * 
     * Category: cloud,file
     * Since: 2.8
     * Maven coordinates: org.apache.camel:camel-aws-s3
     */
    static org.apache.camel.builder.component.dsl.AwsS3ComponentBuilderFactory.AwsS3ComponentBuilder awsS3() {
        return org.apache.camel.builder.component.dsl.AwsS3ComponentBuilderFactory.awsS3();
    }
    /**
     * AWS SimpleDB (camel-aws-sdb)
     * The aws-sdb component is for storing and retrieving data from/to Amazon's
     * SDB service.
     * 
     * Category: cloud,database,nosql
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-aws-sdb
     */
    static org.apache.camel.builder.component.dsl.AwsSdbComponentBuilderFactory.AwsSdbComponentBuilder awsSdb() {
        return org.apache.camel.builder.component.dsl.AwsSdbComponentBuilderFactory.awsSdb();
    }
    /**
     * AWS Simple Email Service (camel-aws-ses)
     * The aws-ses component is used for sending emails with Amazon's SES
     * service.
     * 
     * Category: cloud,mail
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-aws-ses
     */
    static org.apache.camel.builder.component.dsl.AwsSesComponentBuilderFactory.AwsSesComponentBuilder awsSes() {
        return org.apache.camel.builder.component.dsl.AwsSesComponentBuilderFactory.awsSes();
    }
    /**
     * AWS Simple Notification System (camel-aws-sns)
     * The aws-sns component is used for sending messages to an Amazon Simple
     * Notification Topic.
     * 
     * Category: cloud,mobile,messaging
     * Since: 2.8
     * Maven coordinates: org.apache.camel:camel-aws-sns
     */
    static org.apache.camel.builder.component.dsl.AwsSnsComponentBuilderFactory.AwsSnsComponentBuilder awsSns() {
        return org.apache.camel.builder.component.dsl.AwsSnsComponentBuilderFactory.awsSns();
    }
    /**
     * AWS Simple Queue Service (camel-aws-sqs)
     * The aws-sqs component is used for sending and receiving messages to
     * Amazon's SQS service.
     * 
     * Category: cloud,messaging
     * Since: 2.6
     * Maven coordinates: org.apache.camel:camel-aws-sqs
     */
    static org.apache.camel.builder.component.dsl.AwsSqsComponentBuilderFactory.AwsSqsComponentBuilder awsSqs() {
        return org.apache.camel.builder.component.dsl.AwsSqsComponentBuilderFactory.awsSqs();
    }
    /**
     * AWS Simple Workflow (camel-aws-swf)
     * The aws-swf component is used for managing workflows from Amazon Simple
     * Workflow.
     * 
     * Category: cloud,workflow
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-aws-swf
     */
    static org.apache.camel.builder.component.dsl.AwsSwfComponentBuilderFactory.AwsSwfComponentBuilder awsSwf() {
        return org.apache.camel.builder.component.dsl.AwsSwfComponentBuilderFactory.awsSwf();
    }
    /**
     * AWS Translate (camel-aws-translate)
     * The aws-translate component is used for managing Amazon Translate
     * 
     * Category: cloud,management
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-aws-translate
     */
    static org.apache.camel.builder.component.dsl.AwsTranslateComponentBuilderFactory.AwsTranslateComponentBuilder awsTranslate() {
        return org.apache.camel.builder.component.dsl.AwsTranslateComponentBuilderFactory.awsTranslate();
    }
    /**
     * AWS 2 CloudWatch (camel-aws2-cw)
     * The aws2-cw component is used for sending metrics to an Amazon
     * CloudWatch.
     * 
     * Category: cloud,monitoring
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-cw
     */
    static org.apache.camel.builder.component.dsl.Aws2CwComponentBuilderFactory.Aws2CwComponentBuilder aws2Cw() {
        return org.apache.camel.builder.component.dsl.Aws2CwComponentBuilderFactory.aws2Cw();
    }
    /**
     * AWS 2 DynamoDB (camel-aws2-ddb)
     * The aws2-ddb component is used for storing and retrieving data from
     * Amazon's DynamoDB service.
     * 
     * Category: cloud,database,nosql
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ddb
     */
    static org.apache.camel.builder.component.dsl.Aws2DdbComponentBuilderFactory.Aws2DdbComponentBuilder aws2Ddb() {
        return org.apache.camel.builder.component.dsl.Aws2DdbComponentBuilderFactory.aws2Ddb();
    }
    /**
     * AWS 2 DynamoDB Streams (camel-aws2-ddb)
     * The aws2-ddbstream component is used for working with Amazon DynamoDB
     * Streams.
     * 
     * Category: cloud,messaging,streams
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ddb
     */
    static org.apache.camel.builder.component.dsl.Aws2DdbstreamComponentBuilderFactory.Aws2DdbstreamComponentBuilder aws2Ddbstream() {
        return org.apache.camel.builder.component.dsl.Aws2DdbstreamComponentBuilderFactory.aws2Ddbstream();
    }
    /**
     * AWS 2 EC2 (camel-aws2-ec2)
     * The aws2-ec2 is used for managing Amazon EC2 instances.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ec2
     */
    static org.apache.camel.builder.component.dsl.Aws2Ec2ComponentBuilderFactory.Aws2Ec2ComponentBuilder aws2Ec2() {
        return org.apache.camel.builder.component.dsl.Aws2Ec2ComponentBuilderFactory.aws2Ec2();
    }
    /**
     * AWS 2 ECS (camel-aws2-ecs)
     * The aws2-ecs is used for managing Amazon ECS
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ecs
     */
    static org.apache.camel.builder.component.dsl.Aws2EcsComponentBuilderFactory.Aws2EcsComponentBuilder aws2Ecs() {
        return org.apache.camel.builder.component.dsl.Aws2EcsComponentBuilderFactory.aws2Ecs();
    }
    /**
     * AWS 2 EKS (camel-aws2-eks)
     * The aws2-eks is used for managing Amazon EKS
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-eks
     */
    static org.apache.camel.builder.component.dsl.Aws2EksComponentBuilderFactory.Aws2EksComponentBuilder aws2Eks() {
        return org.apache.camel.builder.component.dsl.Aws2EksComponentBuilderFactory.aws2Eks();
    }
    /**
     * AWS 2 IAM (camel-aws2-iam)
     * The aws2-iam is used for managing Amazon IAM
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-iam
     */
    static org.apache.camel.builder.component.dsl.Aws2IamComponentBuilderFactory.Aws2IamComponentBuilder aws2Iam() {
        return org.apache.camel.builder.component.dsl.Aws2IamComponentBuilderFactory.aws2Iam();
    }
    /**
     * AWS 2 Kinesis (camel-aws2-kinesis)
     * The aws2-kinesis component is for consuming and producing records from
     * Amazon Kinesis Streams.
     * 
     * Category: cloud,messaging
     * Since: 3.2
     * Maven coordinates: org.apache.camel:camel-aws2-kinesis
     */
    static org.apache.camel.builder.component.dsl.Aws2KinesisComponentBuilderFactory.Aws2KinesisComponentBuilder aws2Kinesis() {
        return org.apache.camel.builder.component.dsl.Aws2KinesisComponentBuilderFactory.aws2Kinesis();
    }
    /**
     * AWS 2 Kinesis Firehose (camel-aws2-kinesis)
     * The aws2-kinesis-firehose component is used for producing Amazon's
     * Kinesis Firehose streams.
     * 
     * Category: cloud,messaging
     * Since: 3.2
     * Maven coordinates: org.apache.camel:camel-aws2-kinesis
     */
    static org.apache.camel.builder.component.dsl.Aws2KinesisFirehoseComponentBuilderFactory.Aws2KinesisFirehoseComponentBuilder aws2KinesisFirehose() {
        return org.apache.camel.builder.component.dsl.Aws2KinesisFirehoseComponentBuilderFactory.aws2KinesisFirehose();
    }
    /**
     * AWS 2 KMS (camel-aws2-kms)
     * The aws2-kms is used for managing Amazon KMS
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-kms
     */
    static org.apache.camel.builder.component.dsl.Aws2KmsComponentBuilderFactory.Aws2KmsComponentBuilder aws2Kms() {
        return org.apache.camel.builder.component.dsl.Aws2KmsComponentBuilderFactory.aws2Kms();
    }
    /**
     * AWS Lambda (camel-aws2-lambda)
     * The aws2-lambda is used for managing and invoking functions from Amazon
     * Lambda.
     * 
     * Category: cloud,computing,serverless
     * Since: 3.2
     * Maven coordinates: org.apache.camel:camel-aws2-lambda
     */
    static org.apache.camel.builder.component.dsl.Aws2LambdaComponentBuilderFactory.Aws2LambdaComponentBuilder aws2Lambda() {
        return org.apache.camel.builder.component.dsl.Aws2LambdaComponentBuilderFactory.aws2Lambda();
    }
    /**
     * AWS 2 MQ (camel-aws2-mq)
     * The aws2-mq is used for managing Amazon MQ instances.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-mq
     */
    static org.apache.camel.builder.component.dsl.Aws2MqComponentBuilderFactory.Aws2MqComponentBuilder aws2Mq() {
        return org.apache.camel.builder.component.dsl.Aws2MqComponentBuilderFactory.aws2Mq();
    }
    /**
     * AWS 2 MSK (camel-aws2-msk)
     * The aws2-msk is used for managing Amazon MSK
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-msk
     */
    static org.apache.camel.builder.component.dsl.Aws2MskComponentBuilderFactory.Aws2MskComponentBuilder aws2Msk() {
        return org.apache.camel.builder.component.dsl.Aws2MskComponentBuilderFactory.aws2Msk();
    }
    /**
     * AWS2 S3 Storage Service (camel-aws2-s3)
     * The aws2-s3 component is used for storing and retrieving object from
     * Amazon S3 Storage Service.
     * 
     * Category: cloud,file
     * Since: 3.2
     * Maven coordinates: org.apache.camel:camel-aws2-s3
     */
    static org.apache.camel.builder.component.dsl.Aws2S3ComponentBuilderFactory.Aws2S3ComponentBuilder aws2S3() {
        return org.apache.camel.builder.component.dsl.Aws2S3ComponentBuilderFactory.aws2S3();
    }
    /**
     * AWS 2 Simple Email Service (camel-aws2-ses)
     * The aws2-ses component is used for sending emails with Amazon's SES
     * service.
     * 
     * Category: cloud,mail
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ses
     */
    static org.apache.camel.builder.component.dsl.Aws2SesComponentBuilderFactory.Aws2SesComponentBuilder aws2Ses() {
        return org.apache.camel.builder.component.dsl.Aws2SesComponentBuilderFactory.aws2Ses();
    }
    /**
     * AWS 2 Simple Notification System (camel-aws2-sns)
     * The aws2-sns component is used for sending messages to an Amazon Simple
     * Notification Topic.
     * 
     * Category: cloud,mobile,messaging
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-sns
     */
    static org.apache.camel.builder.component.dsl.Aws2SnsComponentBuilderFactory.Aws2SnsComponentBuilder aws2Sns() {
        return org.apache.camel.builder.component.dsl.Aws2SnsComponentBuilderFactory.aws2Sns();
    }
    /**
     * AWS 2 Simple Queue Service (camel-aws2-sqs)
     * The aws2-sqs component is used for sending and receiving messages to
     * Amazon's SQS service.
     * 
     * Category: cloud,messaging
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-sqs
     */
    static org.apache.camel.builder.component.dsl.Aws2SqsComponentBuilderFactory.Aws2SqsComponentBuilder aws2Sqs() {
        return org.apache.camel.builder.component.dsl.Aws2SqsComponentBuilderFactory.aws2Sqs();
    }
    /**
     * AWS 2 Translate (camel-aws2-translate)
     * The aws2-translate component is used for managing Amazon Translate
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-translate
     */
    static org.apache.camel.builder.component.dsl.Aws2TranslateComponentBuilderFactory.Aws2TranslateComponentBuilder aws2Translate() {
        return org.apache.camel.builder.component.dsl.Aws2TranslateComponentBuilderFactory.aws2Translate();
    }
    /**
     * Azure Storage Blob Service (camel-azure)
     * The azure-blob component is used for storing and retrieving blobs from
     * Azure Storage Blob Service.
     * 
     * Category: cloud,database,nosql
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-azure
     */
    static org.apache.camel.builder.component.dsl.AzureBlobComponentBuilderFactory.AzureBlobComponentBuilder azureBlob() {
        return org.apache.camel.builder.component.dsl.AzureBlobComponentBuilderFactory.azureBlob();
    }
    /**
     * Azure Storage Queue Service (camel-azure)
     * The azure-queue component is used for storing and retrieving messages
     * from Azure Storage Queue Service.
     * 
     * Category: cloud,queue,azure
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-azure
     */
    static org.apache.camel.builder.component.dsl.AzureQueueComponentBuilderFactory.AzureQueueComponentBuilder azureQueue() {
        return org.apache.camel.builder.component.dsl.AzureQueueComponentBuilderFactory.azureQueue();
    }
    /**
     * Bean (camel-bean)
     * The bean component is for invoking Java beans from Camel.
     * 
     * Category: core,java
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-bean
     */
    static org.apache.camel.builder.component.dsl.BeanComponentBuilderFactory.BeanComponentBuilder bean() {
        return org.apache.camel.builder.component.dsl.BeanComponentBuilderFactory.bean();
    }
    /**
     * Bean Validator (camel-bean-validator)
     * The Validator component performs bean validation of the message body
     * using the Java Bean Validation API.
     * 
     * Category: validation
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-bean-validator
     */
    static org.apache.camel.builder.component.dsl.BeanValidatorComponentBuilderFactory.BeanValidatorComponentBuilder beanValidator() {
        return org.apache.camel.builder.component.dsl.BeanValidatorComponentBuilderFactory.beanValidator();
    }
    /**
     * Beanstalk (camel-beanstalk)
     * The beanstalk component is used for job retrieval and post-processing of
     * Beanstalk jobs.
     * 
     * Category: messaging
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-beanstalk
     */
    static org.apache.camel.builder.component.dsl.BeanstalkComponentBuilderFactory.BeanstalkComponentBuilder beanstalk() {
        return org.apache.camel.builder.component.dsl.BeanstalkComponentBuilderFactory.beanstalk();
    }
    /**
     * Bonita (camel-bonita)
     * Used for communicating with a remote Bonita BPM process engine.
     * 
     * Category: process
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-bonita
     */
    static org.apache.camel.builder.component.dsl.BonitaComponentBuilderFactory.BonitaComponentBuilder bonita() {
        return org.apache.camel.builder.component.dsl.BonitaComponentBuilderFactory.bonita();
    }
    /**
     * Box (camel-box)
     * For uploading downloading and managing files folders groups
     * collaborations etc on box DOT com.
     * 
     * Category: api,file,cloud
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-box
     */
    static org.apache.camel.builder.component.dsl.BoxComponentBuilderFactory.BoxComponentBuilder box() {
        return org.apache.camel.builder.component.dsl.BoxComponentBuilderFactory.box();
    }
    /**
     * Braintree (camel-braintree)
     * The braintree component is used for integrating with the Braintree
     * Payment System.
     * 
     * Category: api,cloud,payment
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-braintree
     */
    static org.apache.camel.builder.component.dsl.BraintreeComponentBuilderFactory.BraintreeComponentBuilder braintree() {
        return org.apache.camel.builder.component.dsl.BraintreeComponentBuilderFactory.braintree();
    }
    /**
     * Browse (camel-browse)
     * The browse component is used for viewing the messages received on
     * endpoints that supports BrowsableEndpoint.
     * 
     * Category: core,monitoring
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-browse
     */
    static org.apache.camel.builder.component.dsl.BrowseComponentBuilderFactory.BrowseComponentBuilder browse() {
        return org.apache.camel.builder.component.dsl.BrowseComponentBuilderFactory.browse();
    }
    /**
     * Caffeine Cache (camel-caffeine)
     * The caffeine-cache component is used for integration with Caffeine Cache.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-caffeine
     */
    static org.apache.camel.builder.component.dsl.CaffeineCacheComponentBuilderFactory.CaffeineCacheComponentBuilder caffeineCache() {
        return org.apache.camel.builder.component.dsl.CaffeineCacheComponentBuilderFactory.caffeineCache();
    }
    /**
     * Caffeine LoadCache (camel-caffeine)
     * The caffeine-loadcache component is used for integration with Caffeine
     * Load Cache.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-caffeine
     */
    static org.apache.camel.builder.component.dsl.CaffeineLoadcacheComponentBuilderFactory.CaffeineLoadcacheComponentBuilder caffeineLoadcache() {
        return org.apache.camel.builder.component.dsl.CaffeineLoadcacheComponentBuilderFactory.caffeineLoadcache();
    }
    /**
     * ChatScript (camel-chatscript)
     * Represents a ChatScript endpoint.
     * 
     * Category: ai,chatscript
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-chatscript
     */
    static org.apache.camel.builder.component.dsl.ChatscriptComponentBuilderFactory.ChatscriptComponentBuilder chatscript() {
        return org.apache.camel.builder.component.dsl.ChatscriptComponentBuilderFactory.chatscript();
    }
    /**
     * Chunk (camel-chunk)
     * Transforms the message using a Chunk template.
     * 
     * Category: transformation
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-chunk
     */
    static org.apache.camel.builder.component.dsl.ChunkComponentBuilderFactory.ChunkComponentBuilder chunk() {
        return org.apache.camel.builder.component.dsl.ChunkComponentBuilderFactory.chunk();
    }
    /**
     * Class (camel-bean)
     * The Class component is for invoking Java classes (Java beans) from Camel.
     * 
     * Category: core,java
     * Since: 2.4
     * Maven coordinates: org.apache.camel:camel-bean
     */
    static org.apache.camel.builder.component.dsl.ClasComponentBuilderFactory.ClasComponentBuilder clas() {
        return org.apache.camel.builder.component.dsl.ClasComponentBuilderFactory.clas();
    }
    /**
     * CM SMS Gateway (camel-cm-sms)
     * The cm-sms component allows to integrate with CM SMS Gateway.
     * 
     * Category: mobile
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-cm-sms
     */
    static org.apache.camel.builder.component.dsl.CmSmsComponentBuilderFactory.CmSmsComponentBuilder cmSms() {
        return org.apache.camel.builder.component.dsl.CmSmsComponentBuilderFactory.cmSms();
    }
    /**
     * CMIS (camel-cmis)
     * The cmis component uses the Apache Chemistry client API and allows you to
     * add/read nodes to/from a CMIS compliant content repositories.
     * 
     * Category: cms,database
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-cmis
     */
    static org.apache.camel.builder.component.dsl.CmisComponentBuilderFactory.CmisComponentBuilder cmis() {
        return org.apache.camel.builder.component.dsl.CmisComponentBuilderFactory.cmis();
    }
    /**
     * CoAP (camel-coap)
     * The coap component is used for sending and receiving messages from COAP
     * capable devices.
     * 
     * Category: iot
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-coap
     */
    static org.apache.camel.builder.component.dsl.CoapComponentBuilderFactory.CoapComponentBuilder coap() {
        return org.apache.camel.builder.component.dsl.CoapComponentBuilderFactory.coap();
    }
    /**
     * CoAP (camel-coap)
     * The coap component is used for sending and receiving messages from COAP
     * capable devices.
     * 
     * Category: iot
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-coap
     */
    static org.apache.camel.builder.component.dsl.CoapTcpComponentBuilderFactory.CoapTcpComponentBuilder coapTcp() {
        return org.apache.camel.builder.component.dsl.CoapTcpComponentBuilderFactory.coapTcp();
    }
    /**
     * CoAP (Secure) (camel-coap)
     * The coap component is used for sending and receiving messages from COAP
     * capable devices.
     * 
     * Category: iot
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-coap
     */
    static org.apache.camel.builder.component.dsl.CoapsComponentBuilderFactory.CoapsComponentBuilder coaps() {
        return org.apache.camel.builder.component.dsl.CoapsComponentBuilderFactory.coaps();
    }
    /**
     * CoAP (camel-coap)
     * The coap component is used for sending and receiving messages from COAP
     * capable devices.
     * 
     * Category: iot
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-coap
     */
    static org.apache.camel.builder.component.dsl.CoapsTcpComponentBuilderFactory.CoapsTcpComponentBuilder coapsTcp() {
        return org.apache.camel.builder.component.dsl.CoapsTcpComponentBuilderFactory.coapsTcp();
    }
    /**
     * CometD (camel-cometd)
     * The cometd component is a transport for working with the Jetty
     * implementation of the cometd/bayeux protocol.
     * 
     * Category: websocket
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-cometd
     */
    static org.apache.camel.builder.component.dsl.CometdComponentBuilderFactory.CometdComponentBuilder cometd() {
        return org.apache.camel.builder.component.dsl.CometdComponentBuilderFactory.cometd();
    }
    /**
     * CometD (Secure) (camel-cometd)
     * The cometd component is a transport for working with the Jetty
     * implementation of the cometd/bayeux protocol.
     * 
     * Category: websocket
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-cometd
     */
    static org.apache.camel.builder.component.dsl.CometdsComponentBuilderFactory.CometdsComponentBuilder cometds() {
        return org.apache.camel.builder.component.dsl.CometdsComponentBuilderFactory.cometds();
    }
    /**
     * Consul (camel-consul)
     * The camel consul component allows you to work with Consul, a distributed,
     * highly available, datacenter-aware, service discovery and configuration
     * system.
     * 
     * Category: api,cloud
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-consul
     */
    static org.apache.camel.builder.component.dsl.ConsulComponentBuilderFactory.ConsulComponentBuilder consul() {
        return org.apache.camel.builder.component.dsl.ConsulComponentBuilderFactory.consul();
    }
    /**
     * Control Bus (camel-controlbus)
     * The controlbus component provides easy management of Camel applications
     * based on the Control Bus EIP pattern.
     * 
     * Category: core,monitoring
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-controlbus
     */
    static org.apache.camel.builder.component.dsl.ControlbusComponentBuilderFactory.ControlbusComponentBuilder controlbus() {
        return org.apache.camel.builder.component.dsl.ControlbusComponentBuilderFactory.controlbus();
    }
    /**
     * Corda (camel-corda)
     * The corda component uses corda-rpc to interact with corda nodes.
     * 
     * Category: corda,blockchain
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-corda
     */
    static org.apache.camel.builder.component.dsl.CordaComponentBuilderFactory.CordaComponentBuilder corda() {
        return org.apache.camel.builder.component.dsl.CordaComponentBuilderFactory.corda();
    }
    /**
     * Couchbase (camel-couchbase)
     * Represents a Couchbase endpoint that can query Views with a Poll strategy
     * and/or produce various type of operations.
     * 
     * Category: database,nosql
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-couchbase
     */
    static org.apache.camel.builder.component.dsl.CouchbaseComponentBuilderFactory.CouchbaseComponentBuilder couchbase() {
        return org.apache.camel.builder.component.dsl.CouchbaseComponentBuilderFactory.couchbase();
    }
    /**
     * CouchDB (camel-couchdb)
     * The couchdb component is used for integrate with CouchDB databases.
     * 
     * Category: database,nosql
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-couchdb
     */
    static org.apache.camel.builder.component.dsl.CouchdbComponentBuilderFactory.CouchdbComponentBuilder couchdb() {
        return org.apache.camel.builder.component.dsl.CouchdbComponentBuilderFactory.couchdb();
    }
    /**
     * Cassandra CQL (camel-cassandraql)
     * The cql component aims at integrating Cassandra 2.0 using the CQL3 API
     * (not the Thrift API). It's based on Cassandra Java Driver provided by
     * DataStax.
     * 
     * Category: database,nosql
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-cassandraql
     */
    static org.apache.camel.builder.component.dsl.CqlComponentBuilderFactory.CqlComponentBuilder cql() {
        return org.apache.camel.builder.component.dsl.CqlComponentBuilderFactory.cql();
    }
    /**
     * Cron (camel-cron)
     * Camel Cron Component
     * 
     * Category: scheduling
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-cron
     */
    static org.apache.camel.builder.component.dsl.CronComponentBuilderFactory.CronComponentBuilder cron() {
        return org.apache.camel.builder.component.dsl.CronComponentBuilderFactory.cron();
    }
    /**
     * Crypto (JCE) (camel-crypto)
     * The crypto component is used for signing and verifying exchanges using
     * the Signature Service of the Java Cryptographic Extension (JCE).
     * 
     * Category: security,transformation
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-crypto
     */
    static org.apache.camel.builder.component.dsl.CryptoComponentBuilderFactory.CryptoComponentBuilder crypto() {
        return org.apache.camel.builder.component.dsl.CryptoComponentBuilderFactory.crypto();
    }
    /**
     * Crypto CMS (camel-crypto-cms)
     * The crypto cms component is used for encrypting data in CMS Enveloped
     * Data format, decrypting CMS Enveloped Data, signing data in CMS Signed
     * Data format, and verifying CMS Signed Data.
     * 
     * Category: security,transformation
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-crypto-cms
     */
    @Deprecated
    static org.apache.camel.builder.component.dsl.CryptoCmsComponentBuilderFactory.CryptoCmsComponentBuilder cryptoCms() {
        return org.apache.camel.builder.component.dsl.CryptoCmsComponentBuilderFactory.cryptoCms();
    }
    /**
     * CXF (camel-cxf)
     * The cxf component is used for SOAP WebServices using Apache CXF.
     * 
     * Category: soap,webservice
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-cxf
     */
    static org.apache.camel.builder.component.dsl.CxfComponentBuilderFactory.CxfComponentBuilder cxf() {
        return org.apache.camel.builder.component.dsl.CxfComponentBuilderFactory.cxf();
    }
    /**
     * CXF-RS (camel-cxf)
     * The cxfrs component is used for JAX-RS REST services using Apache CXF.
     * 
     * Category: rest
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-cxf
     */
    static org.apache.camel.builder.component.dsl.CxfrsComponentBuilderFactory.CxfrsComponentBuilder cxfrs() {
        return org.apache.camel.builder.component.dsl.CxfrsComponentBuilderFactory.cxfrs();
    }
    /**
     * Data Format (camel-dataformat)
     * The dataformat component is used for working with Data Formats as if it
     * was a regular Component supporting Endpoints and URIs.
     * 
     * Category: core,transformation
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-dataformat
     */
    static org.apache.camel.builder.component.dsl.DataformatComponentBuilderFactory.DataformatComponentBuilder dataformat() {
        return org.apache.camel.builder.component.dsl.DataformatComponentBuilderFactory.dataformat();
    }
    /**
     * Dataset (camel-dataset)
     * The dataset component provides a mechanism to easily perform load & soak
     * testing of your system.
     * 
     * Category: core,testing
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-dataset
     */
    static org.apache.camel.builder.component.dsl.DatasetComponentBuilderFactory.DatasetComponentBuilder dataset() {
        return org.apache.camel.builder.component.dsl.DatasetComponentBuilderFactory.dataset();
    }
    /**
     * DataSet Test (camel-dataset)
     * The dataset-test component extends the mock component by on startup to
     * pull messages from another endpoint to set the expected message bodies.
     * 
     * Category: core,testing
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-dataset
     */
    static org.apache.camel.builder.component.dsl.DatasetTestComponentBuilderFactory.DatasetTestComponentBuilder datasetTest() {
        return org.apache.camel.builder.component.dsl.DatasetTestComponentBuilderFactory.datasetTest();
    }
    /**
     * Debezium MongoDB Connector (camel-debezium-mongodb)
     * Represents a Debezium MongoDB endpoint which is used to capture changes
     * in MongoDB database so that that applications can see those changes and
     * respond to them.
     * 
     * Category: database,nosql,mongodb
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-mongodb
     */
    static org.apache.camel.builder.component.dsl.DebeziumMongodbComponentBuilderFactory.DebeziumMongodbComponentBuilder debeziumMongodb() {
        return org.apache.camel.builder.component.dsl.DebeziumMongodbComponentBuilderFactory.debeziumMongodb();
    }
    /**
     * Debezium MySQL Connector (camel-debezium-mysql)
     * Represents a Debezium MySQL endpoint which is used to capture changes in
     * MySQL database so that that applications can see those changes and
     * respond to them.
     * 
     * Category: database,sql,mysql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-mysql
     */
    static org.apache.camel.builder.component.dsl.DebeziumMysqlComponentBuilderFactory.DebeziumMysqlComponentBuilder debeziumMysql() {
        return org.apache.camel.builder.component.dsl.DebeziumMysqlComponentBuilderFactory.debeziumMysql();
    }
    /**
     * Debezium PostgresSQL Connector (camel-debezium-postgres)
     * Represents a Debezium PostgresSQL endpoint which is used to capture
     * changes in PostgresSQL database so that that applications can see those
     * changes and respond to them.
     * 
     * Category: database,sql,postgres
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-postgres
     */
    static org.apache.camel.builder.component.dsl.DebeziumPostgresComponentBuilderFactory.DebeziumPostgresComponentBuilder debeziumPostgres() {
        return org.apache.camel.builder.component.dsl.DebeziumPostgresComponentBuilderFactory.debeziumPostgres();
    }
    /**
     * Debezium SQL Server Connector (camel-debezium-sqlserver)
     * Represents a Debezium SQL Server endpoint which is used to capture
     * changes in SQL Server database so that that applications can see those
     * changes and respond to them.
     * 
     * Category: database,sql,sqlserver
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-sqlserver
     */
    static org.apache.camel.builder.component.dsl.DebeziumSqlserverComponentBuilderFactory.DebeziumSqlserverComponentBuilder debeziumSqlserver() {
        return org.apache.camel.builder.component.dsl.DebeziumSqlserverComponentBuilderFactory.debeziumSqlserver();
    }
    /**
     * DigitalOcean (camel-digitalocean)
     * The DigitalOcean component allows you to manage Droplets and resources
     * within the DigitalOcean cloud.
     * 
     * Category: cloud,management
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-digitalocean
     */
    static org.apache.camel.builder.component.dsl.DigitaloceanComponentBuilderFactory.DigitaloceanComponentBuilder digitalocean() {
        return org.apache.camel.builder.component.dsl.DigitaloceanComponentBuilderFactory.digitalocean();
    }
    /**
     * Direct (camel-direct)
     * The direct component provides direct, synchronous call to another
     * endpoint from the same CamelContext.
     * 
     * Category: core,endpoint
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-direct
     */
    static org.apache.camel.builder.component.dsl.DirectComponentBuilderFactory.DirectComponentBuilder direct() {
        return org.apache.camel.builder.component.dsl.DirectComponentBuilderFactory.direct();
    }
    /**
     * Direct VM (camel-directvm)
     * The direct-vm component provides direct, synchronous call to another
     * endpoint from any CamelContext in the same JVM.
     * 
     * Category: core,endpoint
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-directvm
     */
    static org.apache.camel.builder.component.dsl.DirectVmComponentBuilderFactory.DirectVmComponentBuilder directVm() {
        return org.apache.camel.builder.component.dsl.DirectVmComponentBuilderFactory.directVm();
    }
    /**
     * Disruptor (camel-disruptor)
     * The disruptor component provides asynchronous SEDA behavior using LMAX
     * Disruptor.
     * 
     * Category: endpoint
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-disruptor
     */
    static org.apache.camel.builder.component.dsl.DisruptorComponentBuilderFactory.DisruptorComponentBuilder disruptor() {
        return org.apache.camel.builder.component.dsl.DisruptorComponentBuilderFactory.disruptor();
    }
    /**
     * Disruptor VM (camel-disruptor)
     * The disruptor component provides asynchronous SEDA behavior using LMAX
     * Disruptor.
     * 
     * Category: endpoint
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-disruptor
     */
    static org.apache.camel.builder.component.dsl.DisruptorVmComponentBuilderFactory.DisruptorVmComponentBuilder disruptorVm() {
        return org.apache.camel.builder.component.dsl.DisruptorVmComponentBuilderFactory.disruptorVm();
    }
    /**
     * DNS (camel-dns)
     * To lookup domain information and run DNS queries using DNSJava.
     * 
     * Category: networking
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-dns
     */
    static org.apache.camel.builder.component.dsl.DnsComponentBuilderFactory.DnsComponentBuilder dns() {
        return org.apache.camel.builder.component.dsl.DnsComponentBuilderFactory.dns();
    }
    /**
     * Docker (camel-docker)
     * The docker component is used for managing Docker containers.
     * 
     * Category: container,cloud,paas
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-docker
     */
    static org.apache.camel.builder.component.dsl.DockerComponentBuilderFactory.DockerComponentBuilder docker() {
        return org.apache.camel.builder.component.dsl.DockerComponentBuilderFactory.docker();
    }
    /**
     * Dozer (camel-dozer)
     * The dozer component provides the ability to map between Java beans using
     * the Dozer mapping library.
     * 
     * Category: transformation
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-dozer
     */
    static org.apache.camel.builder.component.dsl.DozerComponentBuilderFactory.DozerComponentBuilder dozer() {
        return org.apache.camel.builder.component.dsl.DozerComponentBuilderFactory.dozer();
    }
    /**
     * Drill (camel-drill)
     * The drill component gives you the ability to quering into apache drill
     * cluster.
     * 
     * Category: database,sql
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-drill
     */
    static org.apache.camel.builder.component.dsl.DrillComponentBuilderFactory.DrillComponentBuilder drill() {
        return org.apache.camel.builder.component.dsl.DrillComponentBuilderFactory.drill();
    }
    /**
     * Dropbox (camel-dropbox)
     * For uploading, downloading and managing files, folders, groups,
     * collaborations, etc on dropbox DOT com.
     * 
     * Category: api,file
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-dropbox
     */
    static org.apache.camel.builder.component.dsl.DropboxComponentBuilderFactory.DropboxComponentBuilder dropbox() {
        return org.apache.camel.builder.component.dsl.DropboxComponentBuilderFactory.dropbox();
    }
    /**
     * Ehcache (camel-ehcache)
     * The ehcache component enables you to perform caching operations using
     * Ehcache as cache implementation.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-ehcache
     */
    static org.apache.camel.builder.component.dsl.EhcacheComponentBuilderFactory.EhcacheComponentBuilder ehcache() {
        return org.apache.camel.builder.component.dsl.EhcacheComponentBuilderFactory.ehcache();
    }
    /**
     * Elastichsearch Rest (camel-elasticsearch-rest)
     * The elasticsearch component is used for interfacing with ElasticSearch
     * server using REST API.
     * 
     * Category: monitoring,search
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-elasticsearch-rest
     */
    static org.apache.camel.builder.component.dsl.ElasticsearchRestComponentBuilderFactory.ElasticsearchRestComponentBuilder elasticsearchRest() {
        return org.apache.camel.builder.component.dsl.ElasticsearchRestComponentBuilderFactory.elasticsearchRest();
    }
    /**
     * ElSQL (camel-elsql)
     * The elsql component is an extension to the existing SQL Component that
     * uses ElSql to define the SQL queries.
     * 
     * Category: database,sql
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-elsql
     */
    static org.apache.camel.builder.component.dsl.ElsqlComponentBuilderFactory.ElsqlComponentBuilder elsql() {
        return org.apache.camel.builder.component.dsl.ElsqlComponentBuilderFactory.elsql();
    }
    /**
     * Etcd Keys (camel-etcd)
     * Camel Etcd support
     * 
     * Category: clustering,database
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-etcd
     */
    static org.apache.camel.builder.component.dsl.EtcdKeysComponentBuilderFactory.EtcdKeysComponentBuilder etcdKeys() {
        return org.apache.camel.builder.component.dsl.EtcdKeysComponentBuilderFactory.etcdKeys();
    }
    /**
     * Etcd Stats (camel-etcd)
     * The camel etcd component allows you to work with Etcd, a distributed
     * reliable key-value store.
     * 
     * Category: clustering,database
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-etcd
     */
    static org.apache.camel.builder.component.dsl.EtcdStatsComponentBuilderFactory.EtcdStatsComponentBuilder etcdStats() {
        return org.apache.camel.builder.component.dsl.EtcdStatsComponentBuilderFactory.etcdStats();
    }
    /**
     * Etcd Watch (camel-etcd)
     * The camel etcd component allows you to work with Etcd, a distributed
     * reliable key-value store.
     * 
     * Category: clustering,database
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-etcd
     */
    static org.apache.camel.builder.component.dsl.EtcdWatchComponentBuilderFactory.EtcdWatchComponentBuilder etcdWatch() {
        return org.apache.camel.builder.component.dsl.EtcdWatchComponentBuilderFactory.etcdWatch();
    }
    /**
     * Exec (camel-exec)
     * The exec component can be used to execute OS system commands.
     * 
     * Category: system
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-exec
     */
    static org.apache.camel.builder.component.dsl.ExecComponentBuilderFactory.ExecComponentBuilder exec() {
        return org.apache.camel.builder.component.dsl.ExecComponentBuilderFactory.exec();
    }
    /**
     * Facebook (camel-facebook)
     * The Facebook component provides access to all of the Facebook APIs
     * accessible using Facebook4J.
     * 
     * Category: social
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-facebook
     */
    static org.apache.camel.builder.component.dsl.FacebookComponentBuilderFactory.FacebookComponentBuilder facebook() {
        return org.apache.camel.builder.component.dsl.FacebookComponentBuilderFactory.facebook();
    }
    /**
     * FHIR (camel-fhir)
     * The fhir component is used for working with the FHIR protocol (health
     * care).
     * 
     * Category: hl7,api
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-fhir
     */
    static org.apache.camel.builder.component.dsl.FhirComponentBuilderFactory.FhirComponentBuilder fhir() {
        return org.apache.camel.builder.component.dsl.FhirComponentBuilderFactory.fhir();
    }
    /**
     * File (camel-file)
     * The file component is used for reading or writing files.
     * 
     * Category: core,file
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-file
     */
    static org.apache.camel.builder.component.dsl.FileComponentBuilderFactory.FileComponentBuilder file() {
        return org.apache.camel.builder.component.dsl.FileComponentBuilderFactory.file();
    }
    /**
     * File Watch (camel-file-watch)
     * The file-watch is used to monitor file events in directory using
     * java.nio.file.WatchService
     * 
     * Category: file
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-file-watch
     */
    static org.apache.camel.builder.component.dsl.FileWatchComponentBuilderFactory.FileWatchComponentBuilder fileWatch() {
        return org.apache.camel.builder.component.dsl.FileWatchComponentBuilderFactory.fileWatch();
    }
    /**
     * Flatpack (camel-flatpack)
     * The flatpack component supports fixed width and delimited file parsing
     * via the FlatPack library.
     * 
     * Category: transformation
     * Since: 1.4
     * Maven coordinates: org.apache.camel:camel-flatpack
     */
    static org.apache.camel.builder.component.dsl.FlatpackComponentBuilderFactory.FlatpackComponentBuilder flatpack() {
        return org.apache.camel.builder.component.dsl.FlatpackComponentBuilderFactory.flatpack();
    }
    /**
     * Flink (camel-flink)
     * The flink component can be used to send DataSet jobs to Apache Flink
     * cluster.
     * 
     * Category: hadoop
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-flink
     */
    static org.apache.camel.builder.component.dsl.FlinkComponentBuilderFactory.FlinkComponentBuilder flink() {
        return org.apache.camel.builder.component.dsl.FlinkComponentBuilderFactory.flink();
    }
    /**
     * FOP (camel-fop)
     * The fop component allows you to render a message into different output
     * formats using Apache FOP.
     * 
     * Category: transformation
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-fop
     */
    static org.apache.camel.builder.component.dsl.FopComponentBuilderFactory.FopComponentBuilder fop() {
        return org.apache.camel.builder.component.dsl.FopComponentBuilderFactory.fop();
    }
    /**
     * Freemarker (camel-freemarker)
     * Transforms the message using a FreeMarker template.
     * 
     * Category: transformation
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-freemarker
     */
    static org.apache.camel.builder.component.dsl.FreemarkerComponentBuilderFactory.FreemarkerComponentBuilder freemarker() {
        return org.apache.camel.builder.component.dsl.FreemarkerComponentBuilderFactory.freemarker();
    }
    /**
     * FTP (camel-ftp)
     * The ftp component is used for uploading or downloading files from FTP
     * servers.
     * 
     * Category: file
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-ftp
     */
    static org.apache.camel.builder.component.dsl.FtpComponentBuilderFactory.FtpComponentBuilder ftp() {
        return org.apache.camel.builder.component.dsl.FtpComponentBuilderFactory.ftp();
    }
    /**
     * FTPS (camel-ftp)
     * The ftps (FTP secure SSL/TLS) component is used for uploading or
     * downloading files from FTP servers.
     * 
     * Category: file
     * Since: 2.2
     * Maven coordinates: org.apache.camel:camel-ftp
     */
    static org.apache.camel.builder.component.dsl.FtpsComponentBuilderFactory.FtpsComponentBuilder ftps() {
        return org.apache.camel.builder.component.dsl.FtpsComponentBuilderFactory.ftps();
    }
    /**
     * Ganglia (camel-ganglia)
     * The ganglia component is used for sending metrics to the Ganglia
     * monitoring system.
     * 
     * Category: monitoring
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-ganglia
     */
    static org.apache.camel.builder.component.dsl.GangliaComponentBuilderFactory.GangliaComponentBuilder ganglia() {
        return org.apache.camel.builder.component.dsl.GangliaComponentBuilderFactory.ganglia();
    }
    /**
     * Geocoder (camel-geocoder)
     * The geocoder component is used for looking up geocodes (latitude and
     * longitude) for a given address, or reverse lookup.
     * 
     * Category: api,location
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-geocoder
     */
    static org.apache.camel.builder.component.dsl.GeocoderComponentBuilderFactory.GeocoderComponentBuilder geocoder() {
        return org.apache.camel.builder.component.dsl.GeocoderComponentBuilderFactory.geocoder();
    }
    /**
     * Git (camel-git)
     * The git component is used for working with git repositories.
     * 
     * Category: file
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-git
     */
    static org.apache.camel.builder.component.dsl.GitComponentBuilderFactory.GitComponentBuilder git() {
        return org.apache.camel.builder.component.dsl.GitComponentBuilderFactory.git();
    }
    /**
     * GitHub (camel-github)
     * The github component is used for integrating Camel with github.
     * 
     * Category: api,file
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-github
     */
    static org.apache.camel.builder.component.dsl.GithubComponentBuilderFactory.GithubComponentBuilder github() {
        return org.apache.camel.builder.component.dsl.GithubComponentBuilderFactory.github();
    }
    /**
     * Google BigQuery (camel-google-bigquery)
     * Google BigQuery data warehouse for analytics.
     * 
     * Category: cloud,messaging
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-google-bigquery
     */
    static org.apache.camel.builder.component.dsl.GoogleBigqueryComponentBuilderFactory.GoogleBigqueryComponentBuilder googleBigquery() {
        return org.apache.camel.builder.component.dsl.GoogleBigqueryComponentBuilderFactory.googleBigquery();
    }
    /**
     * Google BigQuery Standard SQL (camel-google-bigquery)
     * Google BigQuery data warehouse for analytics (using SQL queries).
     * 
     * Category: cloud,messaging
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-bigquery
     */
    static org.apache.camel.builder.component.dsl.GoogleBigquerySqlComponentBuilderFactory.GoogleBigquerySqlComponentBuilder googleBigquerySql() {
        return org.apache.camel.builder.component.dsl.GoogleBigquerySqlComponentBuilderFactory.googleBigquerySql();
    }
    /**
     * Google Calendar (camel-google-calendar)
     * The google-calendar component provides access to Google Calendar.
     * 
     * Category: api,cloud
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-google-calendar
     */
    static org.apache.camel.builder.component.dsl.GoogleCalendarComponentBuilderFactory.GoogleCalendarComponentBuilder googleCalendar() {
        return org.apache.camel.builder.component.dsl.GoogleCalendarComponentBuilderFactory.googleCalendar();
    }
    /**
     * Google Calendar Stream (camel-google-calendar)
     * The google-calendar-stream component provides access to Google Calendar
     * in a streaming mode.
     * 
     * Category: api,cloud
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-calendar
     */
    static org.apache.camel.builder.component.dsl.GoogleCalendarStreamComponentBuilderFactory.GoogleCalendarStreamComponentBuilder googleCalendarStream() {
        return org.apache.camel.builder.component.dsl.GoogleCalendarStreamComponentBuilderFactory.googleCalendarStream();
    }
    /**
     * Google Drive (camel-google-drive)
     * The google-drive component provides access to Google Drive file storage
     * service.
     * 
     * Category: api,cloud,file
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-google-drive
     */
    static org.apache.camel.builder.component.dsl.GoogleDriveComponentBuilderFactory.GoogleDriveComponentBuilder googleDrive() {
        return org.apache.camel.builder.component.dsl.GoogleDriveComponentBuilderFactory.googleDrive();
    }
    /**
     * Google Mail (camel-google-mail)
     * The google-mail component provides access to Google Mail.
     * 
     * Category: api,cloud,mail
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-google-mail
     */
    static org.apache.camel.builder.component.dsl.GoogleMailComponentBuilderFactory.GoogleMailComponentBuilder googleMail() {
        return org.apache.camel.builder.component.dsl.GoogleMailComponentBuilderFactory.googleMail();
    }
    /**
     * Google Mail Stream (camel-google-mail)
     * The google-mail component provides access to Google Mail.
     * 
     * Category: api,cloud,mail
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-google-mail
     */
    static org.apache.camel.builder.component.dsl.GoogleMailStreamComponentBuilderFactory.GoogleMailStreamComponentBuilder googleMailStream() {
        return org.apache.camel.builder.component.dsl.GoogleMailStreamComponentBuilderFactory.googleMailStream();
    }
    /**
     * Google Pubsub (camel-google-pubsub)
     * Messaging client for Google Cloud Platform PubSub Service Built on top of
     * the Google Cloud Pub/Sub libraries.
     * 
     * Category: messaging
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-google-pubsub
     */
    static org.apache.camel.builder.component.dsl.GooglePubsubComponentBuilderFactory.GooglePubsubComponentBuilder googlePubsub() {
        return org.apache.camel.builder.component.dsl.GooglePubsubComponentBuilderFactory.googlePubsub();
    }
    /**
     * Google Sheets (camel-google-sheets)
     * The google-sheets component provides access to Google Sheets.
     * 
     * Category: api,cloud,sheets
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-sheets
     */
    static org.apache.camel.builder.component.dsl.GoogleSheetsComponentBuilderFactory.GoogleSheetsComponentBuilder googleSheets() {
        return org.apache.camel.builder.component.dsl.GoogleSheetsComponentBuilderFactory.googleSheets();
    }
    /**
     * Google Sheets Stream (camel-google-sheets)
     * The google-sheets-stream component provides access to Google Sheets.
     * 
     * Category: api,cloud,sheets
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-sheets
     */
    static org.apache.camel.builder.component.dsl.GoogleSheetsStreamComponentBuilderFactory.GoogleSheetsStreamComponentBuilder googleSheetsStream() {
        return org.apache.camel.builder.component.dsl.GoogleSheetsStreamComponentBuilderFactory.googleSheetsStream();
    }
    /**
     * Gora (camel-gora)
     * The gora component allows you to work with NoSQL databases using the
     * Apache Gora framework.
     * 
     * Category: database,hadoop,nosql
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-gora
     */
    static org.apache.camel.builder.component.dsl.GoraComponentBuilderFactory.GoraComponentBuilder gora() {
        return org.apache.camel.builder.component.dsl.GoraComponentBuilderFactory.gora();
    }
    /**
     * Grape (camel-grape)
     * The grape component allows you to fetch, load and manage additional jars
     * when CamelContext is running.
     * 
     * Category: management,deployment
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-grape
     */
    static org.apache.camel.builder.component.dsl.GrapeComponentBuilderFactory.GrapeComponentBuilder grape() {
        return org.apache.camel.builder.component.dsl.GrapeComponentBuilderFactory.grape();
    }
    /**
     * GraphQL (camel-graphql)
     * A Camel GraphQL Component
     * 
     * Category: api
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-graphql
     */
    static org.apache.camel.builder.component.dsl.GraphqlComponentBuilderFactory.GraphqlComponentBuilder graphql() {
        return org.apache.camel.builder.component.dsl.GraphqlComponentBuilderFactory.graphql();
    }
    /**
     * gRPC (camel-grpc)
     * The gRPC component allows to call and expose remote procedures via HTTP/2
     * with protobuf dataformat
     * 
     * Category: rpc
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-grpc
     */
    static org.apache.camel.builder.component.dsl.GrpcComponentBuilderFactory.GrpcComponentBuilder grpc() {
        return org.apache.camel.builder.component.dsl.GrpcComponentBuilderFactory.grpc();
    }
    /**
     * Guava EventBus (camel-guava-eventbus)
     * The guava-eventbus component provides integration bridge between Camel
     * and Google Guava EventBus.
     * 
     * Category: eventbus
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-guava-eventbus
     */
    static org.apache.camel.builder.component.dsl.GuavaEventbusComponentBuilderFactory.GuavaEventbusComponentBuilder guavaEventbus() {
        return org.apache.camel.builder.component.dsl.GuavaEventbusComponentBuilderFactory.guavaEventbus();
    }
    /**
     * Hazelcast Atomic Number (camel-hazelcast)
     * The hazelcast-atomicvalue component is used to access Hazelcast atomic
     * number, which is an object that simply provides a grid wide number
     * (long).
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     */
    static org.apache.camel.builder.component.dsl.HazelcastAtomicvalueComponentBuilderFactory.HazelcastAtomicvalueComponentBuilder hazelcastAtomicvalue() {
        return org.apache.camel.builder.component.dsl.HazelcastAtomicvalueComponentBuilderFactory.hazelcastAtomicvalue();
    }
    /**
     * Hazelcast Instance (camel-hazelcast)
     * The hazelcast-instance component is used to consume join/leave events of
     * the cache instance in the cluster.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     */
    static org.apache.camel.builder.component.dsl.HazelcastInstanceComponentBuilderFactory.HazelcastInstanceComponentBuilder hazelcastInstance() {
        return org.apache.camel.builder.component.dsl.HazelcastInstanceComponentBuilderFactory.hazelcastInstance();
    }
    /**
     * Hazelcast List (camel-hazelcast)
     * The hazelcast-list component is used to access Hazelcast distributed
     * list.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     */
    static org.apache.camel.builder.component.dsl.HazelcastListComponentBuilderFactory.HazelcastListComponentBuilder hazelcastList() {
        return org.apache.camel.builder.component.dsl.HazelcastListComponentBuilderFactory.hazelcastList();
    }
    /**
     * Hazelcast Map (camel-hazelcast)
     * The hazelcast-map component is used to access Hazelcast distributed map.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     */
    static org.apache.camel.builder.component.dsl.HazelcastMapComponentBuilderFactory.HazelcastMapComponentBuilder hazelcastMap() {
        return org.apache.camel.builder.component.dsl.HazelcastMapComponentBuilderFactory.hazelcastMap();
    }
    /**
     * Hazelcast Multimap (camel-hazelcast)
     * The hazelcast-multimap component is used to to access Hazelcast
     * distributed multimap.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     */
    static org.apache.camel.builder.component.dsl.HazelcastMultimapComponentBuilderFactory.HazelcastMultimapComponentBuilder hazelcastMultimap() {
        return org.apache.camel.builder.component.dsl.HazelcastMultimapComponentBuilderFactory.hazelcastMultimap();
    }
    /**
     * Hazelcast Queue (camel-hazelcast)
     * The hazelcast-queue component is used to access Hazelcast distributed
     * queue.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     */
    static org.apache.camel.builder.component.dsl.HazelcastQueueComponentBuilderFactory.HazelcastQueueComponentBuilder hazelcastQueue() {
        return org.apache.camel.builder.component.dsl.HazelcastQueueComponentBuilderFactory.hazelcastQueue();
    }
    /**
     * Hazelcast Replicated Map (camel-hazelcast)
     * The hazelcast-replicatedmap component is used to access Hazelcast
     * replicated map.
     * 
     * Category: cache,datagrid
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-hazelcast
     */
    static org.apache.camel.builder.component.dsl.HazelcastReplicatedmapComponentBuilderFactory.HazelcastReplicatedmapComponentBuilder hazelcastReplicatedmap() {
        return org.apache.camel.builder.component.dsl.HazelcastReplicatedmapComponentBuilderFactory.hazelcastReplicatedmap();
    }
    /**
     * Hazelcast Ringbuffer (camel-hazelcast)
     * The hazelcast-ringbuffer component is used to access Hazelcast
     * distributed ringbuffer.
     * 
     * Category: cache,datagrid
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-hazelcast
     */
    static org.apache.camel.builder.component.dsl.HazelcastRingbufferComponentBuilderFactory.HazelcastRingbufferComponentBuilder hazelcastRingbuffer() {
        return org.apache.camel.builder.component.dsl.HazelcastRingbufferComponentBuilderFactory.hazelcastRingbuffer();
    }
    /**
     * Hazelcast SEDA (camel-hazelcast)
     * The hazelcast-seda component is used to access Hazelcast BlockingQueue.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     */
    static org.apache.camel.builder.component.dsl.HazelcastSedaComponentBuilderFactory.HazelcastSedaComponentBuilder hazelcastSeda() {
        return org.apache.camel.builder.component.dsl.HazelcastSedaComponentBuilderFactory.hazelcastSeda();
    }
    /**
     * Hazelcast Set (camel-hazelcast)
     * The hazelcast-set component is used to access Hazelcast distributed set.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     */
    static org.apache.camel.builder.component.dsl.HazelcastSetComponentBuilderFactory.HazelcastSetComponentBuilder hazelcastSet() {
        return org.apache.camel.builder.component.dsl.HazelcastSetComponentBuilderFactory.hazelcastSet();
    }
    /**
     * Hazelcast Topic (camel-hazelcast)
     * The hazelcast-topic component is used to access Hazelcast distributed
     * topic.
     * 
     * Category: cache,datagrid
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-hazelcast
     */
    static org.apache.camel.builder.component.dsl.HazelcastTopicComponentBuilderFactory.HazelcastTopicComponentBuilder hazelcastTopic() {
        return org.apache.camel.builder.component.dsl.HazelcastTopicComponentBuilderFactory.hazelcastTopic();
    }
    /**
     * HBase (camel-hbase)
     * For reading/writing from/to an HBase store (Hadoop database).
     * 
     * Category: hadoop
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-hbase
     */
    static org.apache.camel.builder.component.dsl.HbaseComponentBuilderFactory.HbaseComponentBuilder hbase() {
        return org.apache.camel.builder.component.dsl.HbaseComponentBuilderFactory.hbase();
    }
    /**
     * HDFS (camel-hdfs)
     * For reading/writing from/to an HDFS filesystem using Hadoop 2.x.
     * 
     * Category: hadoop,file
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-hdfs
     */
    static org.apache.camel.builder.component.dsl.HdfsComponentBuilderFactory.HdfsComponentBuilder hdfs() {
        return org.apache.camel.builder.component.dsl.HdfsComponentBuilderFactory.hdfs();
    }
    /**
     * Hipchat (camel-hipchat)
     * The hipchat component supports producing and consuming messages from/to
     * Hipchat service.
     * 
     * Category: api,cloud
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-hipchat
     */
    static org.apache.camel.builder.component.dsl.HipchatComponentBuilderFactory.HipchatComponentBuilder hipchat() {
        return org.apache.camel.builder.component.dsl.HipchatComponentBuilderFactory.hipchat();
    }
    /**
     * HTTP (camel-http)
     * For calling out to external HTTP servers using Apache HTTP Client 4.x.
     * 
     * Category: http
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-http
     */
    static org.apache.camel.builder.component.dsl.HttpComponentBuilderFactory.HttpComponentBuilder http() {
        return org.apache.camel.builder.component.dsl.HttpComponentBuilderFactory.http();
    }
    /**
     * HTTPS (Secure) (camel-http)
     * For calling out to external HTTP servers using Apache HTTP Client 4.x.
     * 
     * Category: http
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-http
     */
    static org.apache.camel.builder.component.dsl.HttpsComponentBuilderFactory.HttpsComponentBuilder https() {
        return org.apache.camel.builder.component.dsl.HttpsComponentBuilderFactory.https();
    }
    /**
     * IEC 60870 Client (camel-iec60870)
     * IEC 60870 component used for telecontrol (supervisory control and data
     * acquisition) such as controlling electric power transmission grids and
     * other geographically widespread control systems.
     * 
     * Category: iot
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-iec60870
     */
    static org.apache.camel.builder.component.dsl.Iec60870ClientComponentBuilderFactory.Iec60870ClientComponentBuilder iec60870Client() {
        return org.apache.camel.builder.component.dsl.Iec60870ClientComponentBuilderFactory.iec60870Client();
    }
    /**
     * IEC 60870 Server (camel-iec60870)
     * IEC 60870 component used for telecontrol (supervisory control and data
     * acquisition) such as controlling electric power transmission grids and
     * other geographically widespread control systems.
     * 
     * Category: iot
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-iec60870
     */
    static org.apache.camel.builder.component.dsl.Iec60870ServerComponentBuilderFactory.Iec60870ServerComponentBuilder iec60870Server() {
        return org.apache.camel.builder.component.dsl.Iec60870ServerComponentBuilderFactory.iec60870Server();
    }
    /**
     * Ignite Cache (camel-ignite)
     * The Ignite Cache endpoint is one of camel-ignite endpoints which allows
     * you to interact with an Ignite Cache.
     * 
     * Category: nosql,cache,compute
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     */
    static org.apache.camel.builder.component.dsl.IgniteCacheComponentBuilderFactory.IgniteCacheComponentBuilder igniteCache() {
        return org.apache.camel.builder.component.dsl.IgniteCacheComponentBuilderFactory.igniteCache();
    }
    /**
     * Ignite Compute (camel-ignite)
     * The Ignite Compute endpoint is one of camel-ignite endpoints which allows
     * you to run compute operations on the cluster by passing in an
     * IgniteCallable, an IgniteRunnable, an IgniteClosure, or collections of
     * them, along with their parameters if necessary.
     * 
     * Category: nosql,cache,compute
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     */
    static org.apache.camel.builder.component.dsl.IgniteComputeComponentBuilderFactory.IgniteComputeComponentBuilder igniteCompute() {
        return org.apache.camel.builder.component.dsl.IgniteComputeComponentBuilderFactory.igniteCompute();
    }
    /**
     * Ignite Events (camel-ignite)
     * The Ignite Events endpoint is one of camel-ignite endpoints which allows
     * you to receive events from the Ignite cluster by creating a local event
     * listener.
     * 
     * Category: nosql,cache,compute,messaging,data
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     */
    static org.apache.camel.builder.component.dsl.IgniteEventsComponentBuilderFactory.IgniteEventsComponentBuilder igniteEvents() {
        return org.apache.camel.builder.component.dsl.IgniteEventsComponentBuilderFactory.igniteEvents();
    }
    /**
     * Ignite ID Generator (camel-ignite)
     * The Ignite ID Generator endpoint is one of camel-ignite endpoints which
     * allows you to interact with Ignite Atomic Sequences and ID Generators.
     * 
     * Category: nosql,cache,compute
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     */
    static org.apache.camel.builder.component.dsl.IgniteIdgenComponentBuilderFactory.IgniteIdgenComponentBuilder igniteIdgen() {
        return org.apache.camel.builder.component.dsl.IgniteIdgenComponentBuilderFactory.igniteIdgen();
    }
    /**
     * Ignite Messaging (camel-ignite)
     * The Ignite Messaging endpoint is one of camel-ignite endpoints which
     * allows you to send and consume messages from an Ignite topic.
     * 
     * Category: nosql,cache,messaging
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     */
    static org.apache.camel.builder.component.dsl.IgniteMessagingComponentBuilderFactory.IgniteMessagingComponentBuilder igniteMessaging() {
        return org.apache.camel.builder.component.dsl.IgniteMessagingComponentBuilderFactory.igniteMessaging();
    }
    /**
     * Ignite Queues (camel-ignite)
     * The Ignite Queue endpoint is one of camel-ignite endpoints which allows
     * you to interact with Ignite Queue data structures.
     * 
     * Category: nosql,cache
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     */
    static org.apache.camel.builder.component.dsl.IgniteQueueComponentBuilderFactory.IgniteQueueComponentBuilder igniteQueue() {
        return org.apache.camel.builder.component.dsl.IgniteQueueComponentBuilderFactory.igniteQueue();
    }
    /**
     * Ignite Sets (camel-ignite)
     * The Ignite Sets endpoint is one of camel-ignite endpoints which allows
     * you to interact with Ignite Set data structures.
     * 
     * Category: nosql,cache
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     */
    static org.apache.camel.builder.component.dsl.IgniteSetComponentBuilderFactory.IgniteSetComponentBuilder igniteSet() {
        return org.apache.camel.builder.component.dsl.IgniteSetComponentBuilderFactory.igniteSet();
    }
    /**
     * IMAP (camel-mail)
     * To send or receive emails using imap/pop3 or smtp protocols.
     * 
     * Category: mail
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mail
     */
    static org.apache.camel.builder.component.dsl.ImapComponentBuilderFactory.ImapComponentBuilder imap() {
        return org.apache.camel.builder.component.dsl.ImapComponentBuilderFactory.imap();
    }
    /**
     * IMAPS (Secure) (camel-mail)
     * To send or receive emails using imap/pop3 or smtp protocols.
     * 
     * Category: mail
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mail
     */
    static org.apache.camel.builder.component.dsl.ImapsComponentBuilderFactory.ImapsComponentBuilder imaps() {
        return org.apache.camel.builder.component.dsl.ImapsComponentBuilderFactory.imaps();
    }
    /**
     * Infinispan (camel-infinispan)
     * For reading/writing from/to Infinispan distributed key/value store and
     * data grid.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-infinispan
     */
    static org.apache.camel.builder.component.dsl.InfinispanComponentBuilderFactory.InfinispanComponentBuilder infinispan() {
        return org.apache.camel.builder.component.dsl.InfinispanComponentBuilderFactory.infinispan();
    }
    /**
     * InfluxDB (camel-influxdb)
     * The influxdb component allows you to interact with InfluxDB, a time
     * series database.
     * 
     * Category: database
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-influxdb
     */
    static org.apache.camel.builder.component.dsl.InfluxdbComponentBuilderFactory.InfluxdbComponentBuilder influxdb() {
        return org.apache.camel.builder.component.dsl.InfluxdbComponentBuilderFactory.influxdb();
    }
    /**
     * IOTA (camel-iota)
     * Component for integrate IOTA DLT
     * 
     * Category: ledger
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-iota
     */
    static org.apache.camel.builder.component.dsl.IotaComponentBuilderFactory.IotaComponentBuilder iota() {
        return org.apache.camel.builder.component.dsl.IotaComponentBuilderFactory.iota();
    }
    /**
     * IPFS (camel-ipfs)
     * The camel-ipfs component provides access to the Interplanetary File
     * System (IPFS).
     * 
     * Category: file,ipfs
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-ipfs
     */
    static org.apache.camel.builder.component.dsl.IpfsComponentBuilderFactory.IpfsComponentBuilder ipfs() {
        return org.apache.camel.builder.component.dsl.IpfsComponentBuilderFactory.ipfs();
    }
    /**
     * IRC (camel-irc)
     * The irc component implements an IRC (Internet Relay Chat) transport.
     * 
     * Category: chat
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-irc
     */
    static org.apache.camel.builder.component.dsl.IrcComponentBuilderFactory.IrcComponentBuilder irc() {
        return org.apache.camel.builder.component.dsl.IrcComponentBuilderFactory.irc();
    }
    /**
     * IronMQ (camel-ironmq)
     * The ironmq provides integration with IronMQ an elastic and durable hosted
     * message queue as a service.
     * 
     * Category: cloud,messaging
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ironmq
     */
    static org.apache.camel.builder.component.dsl.IronmqComponentBuilderFactory.IronmqComponentBuilder ironmq() {
        return org.apache.camel.builder.component.dsl.IronmqComponentBuilderFactory.ironmq();
    }
    /**
     * JBPM (camel-jbpm)
     * The jbpm component provides integration with jBPM (Business Process
     * Management).
     * 
     * Category: process
     * Since: 2.6
     * Maven coordinates: org.apache.camel:camel-jbpm
     */
    static org.apache.camel.builder.component.dsl.JbpmComponentBuilderFactory.JbpmComponentBuilder jbpm() {
        return org.apache.camel.builder.component.dsl.JbpmComponentBuilderFactory.jbpm();
    }
    /**
     * JCache (camel-jcache)
     * The jcache component enables you to perform caching operations using
     * JSR107/JCache as cache implementation.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-jcache
     */
    static org.apache.camel.builder.component.dsl.JcacheComponentBuilderFactory.JcacheComponentBuilder jcache() {
        return org.apache.camel.builder.component.dsl.JcacheComponentBuilderFactory.jcache();
    }
    /**
     * JClouds (camel-jclouds)
     * For interacting with cloud compute & blobstore service via jclouds.
     * 
     * Category: api,cloud
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-jclouds
     */
    static org.apache.camel.builder.component.dsl.JcloudsComponentBuilderFactory.JcloudsComponentBuilder jclouds() {
        return org.apache.camel.builder.component.dsl.JcloudsComponentBuilderFactory.jclouds();
    }
    /**
     * JCR (camel-jcr)
     * The jcr component allows you to add/read nodes to/from a JCR compliant
     * content repository.
     * 
     * Category: cms,database
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-jcr
     */
    static org.apache.camel.builder.component.dsl.JcrComponentBuilderFactory.JcrComponentBuilder jcr() {
        return org.apache.camel.builder.component.dsl.JcrComponentBuilderFactory.jcr();
    }
    /**
     * JDBC (camel-jdbc)
     * The jdbc component enables you to access databases through JDBC, where
     * SQL queries are sent in the message body.
     * 
     * Category: database,sql
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-jdbc
     */
    static org.apache.camel.builder.component.dsl.JdbcComponentBuilderFactory.JdbcComponentBuilder jdbc() {
        return org.apache.camel.builder.component.dsl.JdbcComponentBuilderFactory.jdbc();
    }
    /**
     * Jetty (camel-jetty)
     * To use Jetty as a HTTP server as consumer for Camel routes.
     * 
     * Category: http
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-jetty
     */
    static org.apache.camel.builder.component.dsl.JettyComponentBuilderFactory.JettyComponentBuilder jetty() {
        return org.apache.camel.builder.component.dsl.JettyComponentBuilderFactory.jetty();
    }
    /**
     * JGroups (camel-jgroups)
     * The jgroups component provides exchange of messages between Camel and
     * JGroups clusters.
     * 
     * Category: clustering,messaging
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-jgroups
     */
    static org.apache.camel.builder.component.dsl.JgroupsComponentBuilderFactory.JgroupsComponentBuilder jgroups() {
        return org.apache.camel.builder.component.dsl.JgroupsComponentBuilderFactory.jgroups();
    }
    /**
     * JGroups raft (camel-jgroups-raft)
     * The jgroups component provides exchange of messages between Camel and
     * JGroups clusters.
     * 
     * Category: clustering,messaging
     * Since: 2.24
     * Maven coordinates: org.apache.camel:camel-jgroups-raft
     */
    static org.apache.camel.builder.component.dsl.JgroupsRaftComponentBuilderFactory.JgroupsRaftComponentBuilder jgroupsRaft() {
        return org.apache.camel.builder.component.dsl.JgroupsRaftComponentBuilderFactory.jgroupsRaft();
    }
    /**
     * Jing (camel-jing)
     * Validates the payload of a message using RelaxNG Syntax using Jing
     * library.
     * 
     * Category: validation
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-jing
     */
    static org.apache.camel.builder.component.dsl.JingComponentBuilderFactory.JingComponentBuilder jing() {
        return org.apache.camel.builder.component.dsl.JingComponentBuilderFactory.jing();
    }
    /**
     * Jira (camel-jira)
     * The jira component interacts with the JIRA issue tracker.
     * 
     * Category: api,reporting
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-jira
     */
    static org.apache.camel.builder.component.dsl.JiraComponentBuilderFactory.JiraComponentBuilder jira() {
        return org.apache.camel.builder.component.dsl.JiraComponentBuilderFactory.jira();
    }
    /**
     * JMS (camel-jms)
     * The jms component allows messages to be sent to (or consumed from) a JMS
     * Queue or Topic.
     * 
     * Category: messaging
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-jms
     */
    static org.apache.camel.builder.component.dsl.JmsComponentBuilderFactory.JmsComponentBuilder jms() {
        return org.apache.camel.builder.component.dsl.JmsComponentBuilderFactory.jms();
    }
    /**
     * JMX (camel-jmx)
     * The jmx component allows to receive JMX notifications.
     * 
     * Category: monitoring
     * Since: 2.6
     * Maven coordinates: org.apache.camel:camel-jmx
     */
    static org.apache.camel.builder.component.dsl.JmxComponentBuilderFactory.JmxComponentBuilder jmx() {
        return org.apache.camel.builder.component.dsl.JmxComponentBuilderFactory.jmx();
    }
    /**
     * JOLT (camel-jolt)
     * The jolt component allows you to process a JSON messages using an JOLT
     * specification (such as JSON-JSON transformation).
     * 
     * Category: transformation
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-jolt
     */
    static org.apache.camel.builder.component.dsl.JoltComponentBuilderFactory.JoltComponentBuilder jolt() {
        return org.apache.camel.builder.component.dsl.JoltComponentBuilderFactory.jolt();
    }
    /**
     * JOOQ (camel-jooq)
     * The jooq component enables you to store and retrieve entities from
     * databases using JOOQ
     * 
     * Category: database
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-jooq
     */
    static org.apache.camel.builder.component.dsl.JooqComponentBuilderFactory.JooqComponentBuilder jooq() {
        return org.apache.camel.builder.component.dsl.JooqComponentBuilderFactory.jooq();
    }
    /**
     * JPA (camel-jpa)
     * The jpa component enables you to store and retrieve Java objects from
     * databases using JPA.
     * 
     * Category: database,sql
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-jpa
     */
    static org.apache.camel.builder.component.dsl.JpaComponentBuilderFactory.JpaComponentBuilder jpa() {
        return org.apache.camel.builder.component.dsl.JpaComponentBuilderFactory.jpa();
    }
    /**
     * JSLT (camel-jslt)
     * The jslt component allows you to process a JSON messages using an JSLT
     * transformations.
     * 
     * Category: transformation
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-jslt
     */
    static org.apache.camel.builder.component.dsl.JsltComponentBuilderFactory.JsltComponentBuilder jslt() {
        return org.apache.camel.builder.component.dsl.JsltComponentBuilderFactory.jslt();
    }
    /**
     * JSON Schema Validator (camel-json-validator)
     * Validates the payload of a message using NetworkNT JSON Schema library.
     * 
     * Category: validation
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-json-validator
     */
    static org.apache.camel.builder.component.dsl.JsonValidatorComponentBuilderFactory.JsonValidatorComponentBuilder jsonValidator() {
        return org.apache.camel.builder.component.dsl.JsonValidatorComponentBuilderFactory.jsonValidator();
    }
    /**
     * JT400 (camel-jt400)
     * The jt400 component allows you to exchanges messages with an AS/400
     * system using data queues or program call.
     * 
     * Category: messaging
     * Since: 1.5
     * Maven coordinates: org.apache.camel:camel-jt400
     */
    static org.apache.camel.builder.component.dsl.Jt400ComponentBuilderFactory.Jt400ComponentBuilder jt400() {
        return org.apache.camel.builder.component.dsl.Jt400ComponentBuilderFactory.jt400();
    }
    /**
     * Kafka (camel-kafka)
     * The kafka component allows messages to be sent to (or consumed from)
     * Apache Kafka brokers.
     * 
     * Category: messaging
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-kafka
     */
    static org.apache.camel.builder.component.dsl.KafkaComponentBuilderFactory.KafkaComponentBuilder kafka() {
        return org.apache.camel.builder.component.dsl.KafkaComponentBuilderFactory.kafka();
    }
    /**
     * Kubernetes ConfigMap (camel-kubernetes)
     * The Kubernetes Configmaps component provides a producer to execute
     * kubernetes configmap operations.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     */
    static org.apache.camel.builder.component.dsl.KubernetesConfigMapsComponentBuilderFactory.KubernetesConfigMapsComponentBuilder kubernetesConfigMaps() {
        return org.apache.camel.builder.component.dsl.KubernetesConfigMapsComponentBuilderFactory.kubernetesConfigMaps();
    }
    /**
     * Kubernetes Deployments (camel-kubernetes)
     * The Kubernetes Nodes component provides a producer to execute kubernetes
     * node operations and a consumer to consume node events.
     * 
     * Category: container,cloud,paas
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-kubernetes
     */
    static org.apache.camel.builder.component.dsl.KubernetesDeploymentsComponentBuilderFactory.KubernetesDeploymentsComponentBuilder kubernetesDeployments() {
        return org.apache.camel.builder.component.dsl.KubernetesDeploymentsComponentBuilderFactory.kubernetesDeployments();
    }
    /**
     * Kubernetes HPA (camel-kubernetes)
     * The Kubernetes HPA component provides a producer to execute kubernetes
     * hpa operations and a consumer to consume HPA events.
     * 
     * Category: container,cloud,paas
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-kubernetes
     */
    static org.apache.camel.builder.component.dsl.KubernetesHpaComponentBuilderFactory.KubernetesHpaComponentBuilder kubernetesHpa() {
        return org.apache.camel.builder.component.dsl.KubernetesHpaComponentBuilderFactory.kubernetesHpa();
    }
    /**
     * Kubernetes Job (camel-kubernetes)
     * The Kubernetes Jobs component provides a producer to execute kubernetes
     * job operations
     * 
     * Category: container,cloud,paas
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-kubernetes
     */
    static org.apache.camel.builder.component.dsl.KubernetesJobComponentBuilderFactory.KubernetesJobComponentBuilder kubernetesJob() {
        return org.apache.camel.builder.component.dsl.KubernetesJobComponentBuilderFactory.kubernetesJob();
    }
    /**
     * Kubernetes Namespaces (camel-kubernetes)
     * The Kubernetes Namespaces component provides a producer to execute
     * kubernetes namespace operations and a consumer to consume namespace
     * events.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     */
    static org.apache.camel.builder.component.dsl.KubernetesNamespacesComponentBuilderFactory.KubernetesNamespacesComponentBuilder kubernetesNamespaces() {
        return org.apache.camel.builder.component.dsl.KubernetesNamespacesComponentBuilderFactory.kubernetesNamespaces();
    }
    /**
     * Kubernetes Nodes (camel-kubernetes)
     * The Kubernetes Nodes component provides a producer to execute kubernetes
     * node operations and a consumer to consume node events.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     */
    static org.apache.camel.builder.component.dsl.KubernetesNodesComponentBuilderFactory.KubernetesNodesComponentBuilder kubernetesNodes() {
        return org.apache.camel.builder.component.dsl.KubernetesNodesComponentBuilderFactory.kubernetesNodes();
    }
    /**
     * Kubernetes Persistent Volume (camel-kubernetes)
     * The Kubernetes Persistent Volumes component provides a producer to
     * execute kubernetes persistent volume operations.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     */
    static org.apache.camel.builder.component.dsl.KubernetesPersistentVolumesComponentBuilderFactory.KubernetesPersistentVolumesComponentBuilder kubernetesPersistentVolumes() {
        return org.apache.camel.builder.component.dsl.KubernetesPersistentVolumesComponentBuilderFactory.kubernetesPersistentVolumes();
    }
    /**
     * Kubernetes Persistent Volume Claim (camel-kubernetes)
     * The Kubernetes Persistent Volumes Claims component provides a producer to
     * execute kubernetes persistent volume claim operations.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     */
    static org.apache.camel.builder.component.dsl.KubernetesPersistentVolumesClaimsComponentBuilderFactory.KubernetesPersistentVolumesClaimsComponentBuilder kubernetesPersistentVolumesClaims() {
        return org.apache.camel.builder.component.dsl.KubernetesPersistentVolumesClaimsComponentBuilderFactory.kubernetesPersistentVolumesClaims();
    }
    /**
     * Kubernetes Pods (camel-kubernetes)
     * The Kubernetes Pods component provides a producer to execute kubernetes
     * pod operations and a consumer to consume pod events.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     */
    static org.apache.camel.builder.component.dsl.KubernetesPodsComponentBuilderFactory.KubernetesPodsComponentBuilder kubernetesPods() {
        return org.apache.camel.builder.component.dsl.KubernetesPodsComponentBuilderFactory.kubernetesPods();
    }
    /**
     * Kubernetes Replication Controller (camel-kubernetes)
     * The Kubernetes Replication Controllers component provides a producer to
     * execute kubernetes replication controller operations and a consumer to
     * consume replication controller events.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     */
    static org.apache.camel.builder.component.dsl.KubernetesReplicationControllersComponentBuilderFactory.KubernetesReplicationControllersComponentBuilder kubernetesReplicationControllers() {
        return org.apache.camel.builder.component.dsl.KubernetesReplicationControllersComponentBuilderFactory.kubernetesReplicationControllers();
    }
    /**
     * Kubernetes Resources Quota (camel-kubernetes)
     * The Kubernetes Resources Quota component provides a producer to execute
     * kubernetes resources quota operations.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     */
    static org.apache.camel.builder.component.dsl.KubernetesResourcesQuotaComponentBuilderFactory.KubernetesResourcesQuotaComponentBuilder kubernetesResourcesQuota() {
        return org.apache.camel.builder.component.dsl.KubernetesResourcesQuotaComponentBuilderFactory.kubernetesResourcesQuota();
    }
    /**
     * Kubernetes Secrets (camel-kubernetes)
     * The Kubernetes Secrets component provides a producer to execute
     * kubernetes secret operations.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     */
    static org.apache.camel.builder.component.dsl.KubernetesSecretsComponentBuilderFactory.KubernetesSecretsComponentBuilder kubernetesSecrets() {
        return org.apache.camel.builder.component.dsl.KubernetesSecretsComponentBuilderFactory.kubernetesSecrets();
    }
    /**
     * Kubernetes Service Account (camel-kubernetes)
     * The Kubernetes Service Accounts component provides a producer to execute
     * service account operations.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     */
    static org.apache.camel.builder.component.dsl.KubernetesServiceAccountsComponentBuilderFactory.KubernetesServiceAccountsComponentBuilder kubernetesServiceAccounts() {
        return org.apache.camel.builder.component.dsl.KubernetesServiceAccountsComponentBuilderFactory.kubernetesServiceAccounts();
    }
    /**
     * Kubernetes Services (camel-kubernetes)
     * The Kubernetes Services component provides a producer to execute service
     * operations and a consumer to consume service events.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     */
    static org.apache.camel.builder.component.dsl.KubernetesServicesComponentBuilderFactory.KubernetesServicesComponentBuilder kubernetesServices() {
        return org.apache.camel.builder.component.dsl.KubernetesServicesComponentBuilderFactory.kubernetesServices();
    }
    /**
     * Kudu (camel-kudu)
     * Represents a Kudu endpoint. A kudu endpoint allows you to interact with
     * Apache Kudu, a free and open source column-oriented data store of the
     * Apache Hadoop ecosystem.
     * 
     * Category: cloud,database,iot
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-kudu
     */
    static org.apache.camel.builder.component.dsl.KuduComponentBuilderFactory.KuduComponentBuilder kudu() {
        return org.apache.camel.builder.component.dsl.KuduComponentBuilderFactory.kudu();
    }
    /**
     * Language (camel-language)
     * The language component allows you to send a message to an endpoint which
     * executes a script by any of the supported Languages in Camel.
     * 
     * Category: core,script
     * Since: 2.5
     * Maven coordinates: org.apache.camel:camel-language
     */
    static org.apache.camel.builder.component.dsl.LanguageComponentBuilderFactory.LanguageComponentBuilder language() {
        return org.apache.camel.builder.component.dsl.LanguageComponentBuilderFactory.language();
    }
    /**
     * LDAP (camel-ldap)
     * The ldap component allows you to perform searches in LDAP servers using
     * filters as the message payload.
     * 
     * Category: ldap
     * Since: 1.5
     * Maven coordinates: org.apache.camel:camel-ldap
     */
    static org.apache.camel.builder.component.dsl.LdapComponentBuilderFactory.LdapComponentBuilder ldap() {
        return org.apache.camel.builder.component.dsl.LdapComponentBuilderFactory.ldap();
    }
    /**
     * LDIF (camel-ldif)
     * The ldif component allows you to do updates on an LDAP server from a LDIF
     * body content.
     * 
     * Category: ldap
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-ldif
     */
    static org.apache.camel.builder.component.dsl.LdifComponentBuilderFactory.LdifComponentBuilder ldif() {
        return org.apache.camel.builder.component.dsl.LdifComponentBuilderFactory.ldif();
    }
    /**
     * Log (camel-log)
     * The log component logs message exchanges to the underlying logging
     * mechanism.
     * 
     * Category: core,monitoring
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-log
     */
    static org.apache.camel.builder.component.dsl.LogComponentBuilderFactory.LogComponentBuilder log() {
        return org.apache.camel.builder.component.dsl.LogComponentBuilderFactory.log();
    }
    /**
     * Printer (camel-printer)
     * The printer component is used for sending messages to printers as print
     * jobs.
     * 
     * Category: printing
     * Since: 2.1
     * Maven coordinates: org.apache.camel:camel-printer
     */
    static org.apache.camel.builder.component.dsl.LprComponentBuilderFactory.LprComponentBuilder lpr() {
        return org.apache.camel.builder.component.dsl.LprComponentBuilderFactory.lpr();
    }
    /**
     * Lucene (camel-lucene)
     * To insert or query from Apache Lucene databases.
     * 
     * Category: database,search
     * Since: 2.2
     * Maven coordinates: org.apache.camel:camel-lucene
     */
    static org.apache.camel.builder.component.dsl.LuceneComponentBuilderFactory.LuceneComponentBuilder lucene() {
        return org.apache.camel.builder.component.dsl.LuceneComponentBuilderFactory.lucene();
    }
    /**
     * Lumberjack (camel-lumberjack)
     * The lumberjack retrieves logs sent over the network using the Lumberjack
     * protocol.
     * 
     * Category: log
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-lumberjack
     */
    static org.apache.camel.builder.component.dsl.LumberjackComponentBuilderFactory.LumberjackComponentBuilder lumberjack() {
        return org.apache.camel.builder.component.dsl.LumberjackComponentBuilderFactory.lumberjack();
    }
    /**
     * Master (camel-master)
     * Represents an endpoint which only becomes active when the
     * CamelClusterView has the leadership.
     * 
     * Category: clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-master
     */
    static org.apache.camel.builder.component.dsl.MasterComponentBuilderFactory.MasterComponentBuilder master() {
        return org.apache.camel.builder.component.dsl.MasterComponentBuilderFactory.master();
    }
    /**
     * Metrics (camel-metrics)
     * To collect various metrics directly from Camel routes using the
     * DropWizard metrics library.
     * 
     * Category: monitoring
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-metrics
     */
    static org.apache.camel.builder.component.dsl.MetricsComponentBuilderFactory.MetricsComponentBuilder metrics() {
        return org.apache.camel.builder.component.dsl.MetricsComponentBuilderFactory.metrics();
    }
    /**
     * Micrometer (camel-micrometer)
     * To collect various metrics directly from Camel routes using the
     * Micrometer library.
     * 
     * Category: monitoring
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-micrometer
     */
    static org.apache.camel.builder.component.dsl.MicrometerComponentBuilderFactory.MicrometerComponentBuilder micrometer() {
        return org.apache.camel.builder.component.dsl.MicrometerComponentBuilderFactory.micrometer();
    }
    /**
     * MicroProfile Metrics (camel-microprofile-metrics)
     * Camel metrics exposed with Eclipse MicroProfile Metrics
     * 
     * Category: monitoring
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-microprofile-metrics
     */
    static org.apache.camel.builder.component.dsl.MicroprofileMetricsComponentBuilderFactory.MicroprofileMetricsComponentBuilder microprofileMetrics() {
        return org.apache.camel.builder.component.dsl.MicroprofileMetricsComponentBuilderFactory.microprofileMetrics();
    }
    /**
     * OPC UA Client (camel-milo)
     * Connect to OPC UA servers using the binary protocol for acquiring
     * telemetry data
     * 
     * Category: iot
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-milo
     */
    static org.apache.camel.builder.component.dsl.MiloClientComponentBuilderFactory.MiloClientComponentBuilder miloClient() {
        return org.apache.camel.builder.component.dsl.MiloClientComponentBuilderFactory.miloClient();
    }
    /**
     * OPC UA Server (camel-milo)
     * Make telemetry data available as an OPC UA server
     * 
     * Category: iot
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-milo
     */
    static org.apache.camel.builder.component.dsl.MiloServerComponentBuilderFactory.MiloServerComponentBuilder miloServer() {
        return org.apache.camel.builder.component.dsl.MiloServerComponentBuilderFactory.miloServer();
    }
    /**
     * Mina (camel-mina)
     * Socket level networking using TCP or UDP with the Apache Mina 2.x
     * library.
     * 
     * Category: networking,tcp,udp
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-mina
     */
    static org.apache.camel.builder.component.dsl.MinaComponentBuilderFactory.MinaComponentBuilder mina() {
        return org.apache.camel.builder.component.dsl.MinaComponentBuilderFactory.mina();
    }
    /**
     * MLLP (camel-mllp)
     * Provides functionality required by Healthcare providers to communicate
     * with other systems using the MLLP protocol.
     * 
     * Category: mllp
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-mllp
     */
    static org.apache.camel.builder.component.dsl.MllpComponentBuilderFactory.MllpComponentBuilder mllp() {
        return org.apache.camel.builder.component.dsl.MllpComponentBuilderFactory.mllp();
    }
    /**
     * Mock (camel-mock)
     * The mock component is used for testing routes and mediation rules using
     * mocks.
     * 
     * Category: core,testing
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mock
     */
    static org.apache.camel.builder.component.dsl.MockComponentBuilderFactory.MockComponentBuilder mock() {
        return org.apache.camel.builder.component.dsl.MockComponentBuilderFactory.mock();
    }
    /**
     * MongoDB (camel-mongodb)
     * Component for working with documents stored in MongoDB database.
     * 
     * Category: database,nosql
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-mongodb
     */
    static org.apache.camel.builder.component.dsl.MongodbComponentBuilderFactory.MongodbComponentBuilder mongodb() {
        return org.apache.camel.builder.component.dsl.MongodbComponentBuilderFactory.mongodb();
    }
    /**
     * MongoDB GridFS (camel-mongodb-gridfs)
     * Component for working with MongoDB GridFS.
     * 
     * Category: database,nosql
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-mongodb-gridfs
     */
    static org.apache.camel.builder.component.dsl.MongodbGridfsComponentBuilderFactory.MongodbGridfsComponentBuilder mongodbGridfs() {
        return org.apache.camel.builder.component.dsl.MongodbGridfsComponentBuilderFactory.mongodbGridfs();
    }
    /**
     * MSV (camel-msv)
     * Validates the payload of a message using the MSV Library.
     * 
     * Category: validation
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-msv
     */
    static org.apache.camel.builder.component.dsl.MsvComponentBuilderFactory.MsvComponentBuilder msv() {
        return org.apache.camel.builder.component.dsl.MsvComponentBuilderFactory.msv();
    }
    /**
     * Mustache (camel-mustache)
     * Transforms the message using a Mustache template.
     * 
     * Category: transformation
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-mustache
     */
    static org.apache.camel.builder.component.dsl.MustacheComponentBuilderFactory.MustacheComponentBuilder mustache() {
        return org.apache.camel.builder.component.dsl.MustacheComponentBuilderFactory.mustache();
    }
    /**
     * MVEL (camel-mvel)
     * Transforms the message using a MVEL template.
     * 
     * Category: transformation,script
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-mvel
     */
    static org.apache.camel.builder.component.dsl.MvelComponentBuilderFactory.MvelComponentBuilder mvel() {
        return org.apache.camel.builder.component.dsl.MvelComponentBuilderFactory.mvel();
    }
    /**
     * MyBatis (camel-mybatis)
     * Performs a query, poll, insert, update or delete in a relational database
     * using MyBatis.
     * 
     * Category: database,sql
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-mybatis
     */
    static org.apache.camel.builder.component.dsl.MybatisComponentBuilderFactory.MybatisComponentBuilder mybatis() {
        return org.apache.camel.builder.component.dsl.MybatisComponentBuilderFactory.mybatis();
    }
    /**
     * MyBatis Bean (camel-mybatis)
     * Performs a query, insert, update or delete in a relational database using
     * MyBatis.
     * 
     * Category: database,sql
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-mybatis
     */
    static org.apache.camel.builder.component.dsl.MybatisBeanComponentBuilderFactory.MybatisBeanComponentBuilder mybatisBean() {
        return org.apache.camel.builder.component.dsl.MybatisBeanComponentBuilderFactory.mybatisBean();
    }
    /**
     * Nagios (camel-nagios)
     * To send passive checks to Nagios using JSendNSCA.
     * 
     * Category: monitoring
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-nagios
     */
    static org.apache.camel.builder.component.dsl.NagiosComponentBuilderFactory.NagiosComponentBuilder nagios() {
        return org.apache.camel.builder.component.dsl.NagiosComponentBuilderFactory.nagios();
    }
    /**
     * Nats (camel-nats)
     * The nats component allows you produce and consume messages from NATS.
     * 
     * Category: messaging
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-nats
     */
    static org.apache.camel.builder.component.dsl.NatsComponentBuilderFactory.NatsComponentBuilder nats() {
        return org.apache.camel.builder.component.dsl.NatsComponentBuilderFactory.nats();
    }
    /**
     * Netty (camel-netty)
     * Socket level networking using TCP or UDP with the Netty 4.x library.
     * 
     * Category: networking,tcp,udp
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-netty
     */
    static org.apache.camel.builder.component.dsl.NettyComponentBuilderFactory.NettyComponentBuilder netty() {
        return org.apache.camel.builder.component.dsl.NettyComponentBuilderFactory.netty();
    }
    /**
     * Netty HTTP (camel-netty-http)
     * Netty HTTP server and client using the Netty 4.x library.
     * 
     * Category: http
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-netty-http
     */
    static org.apache.camel.builder.component.dsl.NettyHttpComponentBuilderFactory.NettyHttpComponentBuilder nettyHttp() {
        return org.apache.camel.builder.component.dsl.NettyHttpComponentBuilderFactory.nettyHttp();
    }
    /**
     * Nitrite (camel-nitrite)
     * Used for integrating Camel with Nitrite databases.
     * 
     * Category: database,nosql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-nitrite
     */
    static org.apache.camel.builder.component.dsl.NitriteComponentBuilderFactory.NitriteComponentBuilder nitrite() {
        return org.apache.camel.builder.component.dsl.NitriteComponentBuilderFactory.nitrite();
    }
    /**
     * NSQ (camel-nsq)
     * Represents a nsq endpoint.
     * 
     * Category: messaging
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-nsq
     */
    static org.apache.camel.builder.component.dsl.NsqComponentBuilderFactory.NsqComponentBuilder nsq() {
        return org.apache.camel.builder.component.dsl.NsqComponentBuilderFactory.nsq();
    }
    /**
     * Olingo2 (camel-olingo2)
     * Communicates with OData 2.0 services using Apache Olingo.
     * 
     * Category: cloud
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-olingo2
     */
    static org.apache.camel.builder.component.dsl.Olingo2ComponentBuilderFactory.Olingo2ComponentBuilder olingo2() {
        return org.apache.camel.builder.component.dsl.Olingo2ComponentBuilderFactory.olingo2();
    }
    /**
     * Olingo4 (camel-olingo4)
     * Communicates with OData 4.0 services using Apache Olingo OData API.
     * 
     * Category: cloud
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-olingo4
     */
    static org.apache.camel.builder.component.dsl.Olingo4ComponentBuilderFactory.Olingo4ComponentBuilder olingo4() {
        return org.apache.camel.builder.component.dsl.Olingo4ComponentBuilderFactory.olingo4();
    }
    /**
     * Openshift Build Config (camel-kubernetes)
     * The Kubernetes Build Config component provides a producer to execute
     * kubernetes build config operations.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     */
    static org.apache.camel.builder.component.dsl.OpenshiftBuildConfigsComponentBuilderFactory.OpenshiftBuildConfigsComponentBuilder openshiftBuildConfigs() {
        return org.apache.camel.builder.component.dsl.OpenshiftBuildConfigsComponentBuilderFactory.openshiftBuildConfigs();
    }
    /**
     * Openshift Builds (camel-kubernetes)
     * The Openshift Builds component provides a producer to execute openshift
     * build operations.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     */
    static org.apache.camel.builder.component.dsl.OpenshiftBuildsComponentBuilderFactory.OpenshiftBuildsComponentBuilder openshiftBuilds() {
        return org.apache.camel.builder.component.dsl.OpenshiftBuildsComponentBuilderFactory.openshiftBuilds();
    }
    /**
     * OpenStack Cinder (camel-openstack)
     * The openstack-cinder component allows messages to be sent to an OpenStack
     * block storage services.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     */
    static org.apache.camel.builder.component.dsl.OpenstackCinderComponentBuilderFactory.OpenstackCinderComponentBuilder openstackCinder() {
        return org.apache.camel.builder.component.dsl.OpenstackCinderComponentBuilderFactory.openstackCinder();
    }
    /**
     * OpenStack Glance (camel-openstack)
     * The openstack-glance component allows messages to be sent to an OpenStack
     * image services.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     */
    static org.apache.camel.builder.component.dsl.OpenstackGlanceComponentBuilderFactory.OpenstackGlanceComponentBuilder openstackGlance() {
        return org.apache.camel.builder.component.dsl.OpenstackGlanceComponentBuilderFactory.openstackGlance();
    }
    /**
     * OpenStack Keystone (camel-openstack)
     * The openstack-keystone component allows messages to be sent to an
     * OpenStack identity services.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     */
    static org.apache.camel.builder.component.dsl.OpenstackKeystoneComponentBuilderFactory.OpenstackKeystoneComponentBuilder openstackKeystone() {
        return org.apache.camel.builder.component.dsl.OpenstackKeystoneComponentBuilderFactory.openstackKeystone();
    }
    /**
     * OpenStack Neutron (camel-openstack)
     * The openstack-neutron component allows messages to be sent to an
     * OpenStack network services.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     */
    static org.apache.camel.builder.component.dsl.OpenstackNeutronComponentBuilderFactory.OpenstackNeutronComponentBuilder openstackNeutron() {
        return org.apache.camel.builder.component.dsl.OpenstackNeutronComponentBuilderFactory.openstackNeutron();
    }
    /**
     * OpenStack Nova (camel-openstack)
     * The openstack-nova component allows messages to be sent to an OpenStack
     * compute services.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     */
    static org.apache.camel.builder.component.dsl.OpenstackNovaComponentBuilderFactory.OpenstackNovaComponentBuilder openstackNova() {
        return org.apache.camel.builder.component.dsl.OpenstackNovaComponentBuilderFactory.openstackNova();
    }
    /**
     * OpenStack Swift (camel-openstack)
     * The openstack-swift component allows messages to be sent to an OpenStack
     * object storage services.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     */
    static org.apache.camel.builder.component.dsl.OpenstackSwiftComponentBuilderFactory.OpenstackSwiftComponentBuilder openstackSwift() {
        return org.apache.camel.builder.component.dsl.OpenstackSwiftComponentBuilderFactory.openstackSwift();
    }
    /**
     * OptaPlanner (camel-optaplanner)
     * Solves the planning problem contained in a message with OptaPlanner.
     * 
     * Category: engine,planning
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-optaplanner
     */
    static org.apache.camel.builder.component.dsl.OptaplannerComponentBuilderFactory.OptaplannerComponentBuilder optaplanner() {
        return org.apache.camel.builder.component.dsl.OptaplannerComponentBuilderFactory.optaplanner();
    }
    /**
     * Paho (camel-paho)
     * Component for communicating with MQTT message brokers using Eclipse Paho
     * MQTT Client.
     * 
     * Category: messaging,iot
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-paho
     */
    static org.apache.camel.builder.component.dsl.PahoComponentBuilderFactory.PahoComponentBuilder paho() {
        return org.apache.camel.builder.component.dsl.PahoComponentBuilderFactory.paho();
    }
    /**
     * PDF (camel-pdf)
     * The pdf components provides the ability to create, modify or extract
     * content from PDF documents.
     * 
     * Category: document,transformation,printing
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-pdf
     */
    static org.apache.camel.builder.component.dsl.PdfComponentBuilderFactory.PdfComponentBuilder pdf() {
        return org.apache.camel.builder.component.dsl.PdfComponentBuilderFactory.pdf();
    }
    /**
     * PostgresSQL Replication Slot (camel-pg-replication-slot)
     * Consumer endpoint to receive from PostgreSQL Replication Slot.
     * 
     * Category: database,sql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-pg-replication-slot
     */
    static org.apache.camel.builder.component.dsl.PgReplicationSlotComponentBuilderFactory.PgReplicationSlotComponentBuilder pgReplicationSlot() {
        return org.apache.camel.builder.component.dsl.PgReplicationSlotComponentBuilderFactory.pgReplicationSlot();
    }
    /**
     * PostgresSQL Event (camel-pgevent)
     * The pgevent component allows for producing/consuming PostgreSQL events
     * related to the listen/notify commands.
     * 
     * Category: database,sql
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-pgevent
     */
    static org.apache.camel.builder.component.dsl.PgeventComponentBuilderFactory.PgeventComponentBuilder pgevent() {
        return org.apache.camel.builder.component.dsl.PgeventComponentBuilderFactory.pgevent();
    }
    /**
     * Platform HTTP (camel-platform-http)
     * HTTP service leveraging existing runtime platform HTTP server
     * 
     * Category: http
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-platform-http
     */
    static org.apache.camel.builder.component.dsl.PlatformHttpComponentBuilderFactory.PlatformHttpComponentBuilder platformHttp() {
        return org.apache.camel.builder.component.dsl.PlatformHttpComponentBuilderFactory.platformHttp();
    }
    /**
     * POP3 (camel-mail)
     * To send or receive emails using imap/pop3 or smtp protocols.
     * 
     * Category: mail
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mail
     */
    static org.apache.camel.builder.component.dsl.Pop3ComponentBuilderFactory.Pop3ComponentBuilder pop3() {
        return org.apache.camel.builder.component.dsl.Pop3ComponentBuilderFactory.pop3();
    }
    /**
     * POP3S (camel-mail)
     * To send or receive emails using imap/pop3 or smtp protocols.
     * 
     * Category: mail
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mail
     */
    static org.apache.camel.builder.component.dsl.Pop3sComponentBuilderFactory.Pop3sComponentBuilder pop3s() {
        return org.apache.camel.builder.component.dsl.Pop3sComponentBuilderFactory.pop3s();
    }
    /**
     * PubNub (camel-pubnub)
     * To send and receive messages to PubNub data stream network for connected
     * devices.
     * 
     * Category: cloud,iot,messaging
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-pubnub
     */
    static org.apache.camel.builder.component.dsl.PubnubComponentBuilderFactory.PubnubComponentBuilder pubnub() {
        return org.apache.camel.builder.component.dsl.PubnubComponentBuilderFactory.pubnub();
    }
    /**
     * Pulsar (camel-pulsar)
     * Camel Apache Pulsar Component
     * 
     * Category: messaging
     * Since: 2.24
     * Maven coordinates: org.apache.camel:camel-pulsar
     */
    static org.apache.camel.builder.component.dsl.PulsarComponentBuilderFactory.PulsarComponentBuilder pulsar() {
        return org.apache.camel.builder.component.dsl.PulsarComponentBuilderFactory.pulsar();
    }
    /**
     * Quartz (camel-quartz)
     * Provides a scheduled delivery of messages using the Quartz 2.x scheduler.
     * 
     * Category: scheduling
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-quartz
     */
    static org.apache.camel.builder.component.dsl.QuartzComponentBuilderFactory.QuartzComponentBuilder quartz() {
        return org.apache.camel.builder.component.dsl.QuartzComponentBuilderFactory.quartz();
    }
    /**
     * QuickFix (camel-quickfix)
     * The quickfix component allows to send Financial Interchange (FIX)
     * messages to the QuickFix engine.
     * 
     * Category: messaging
     * Since: 2.1
     * Maven coordinates: org.apache.camel:camel-quickfix
     */
    static org.apache.camel.builder.component.dsl.QuickfixComponentBuilderFactory.QuickfixComponentBuilder quickfix() {
        return org.apache.camel.builder.component.dsl.QuickfixComponentBuilderFactory.quickfix();
    }
    /**
     * RabbitMQ (camel-rabbitmq)
     * The rabbitmq component allows you produce and consume messages from
     * RabbitMQ instances.
     * 
     * Category: messaging
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-rabbitmq
     */
    static org.apache.camel.builder.component.dsl.RabbitmqComponentBuilderFactory.RabbitmqComponentBuilder rabbitmq() {
        return org.apache.camel.builder.component.dsl.RabbitmqComponentBuilderFactory.rabbitmq();
    }
    /**
     * Reactive Streams (camel-reactive-streams)
     * Reactive Camel using reactive streams
     * 
     * Category: reactive,streams
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-reactive-streams
     */
    static org.apache.camel.builder.component.dsl.ReactiveStreamsComponentBuilderFactory.ReactiveStreamsComponentBuilder reactiveStreams() {
        return org.apache.camel.builder.component.dsl.ReactiveStreamsComponentBuilderFactory.reactiveStreams();
    }
    /**
     * Ref (camel-ref)
     * The ref component is used for lookup of existing endpoints bound in the
     * Registry.
     * 
     * Category: core,endpoint
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-ref
     */
    static org.apache.camel.builder.component.dsl.RefComponentBuilderFactory.RefComponentBuilder ref() {
        return org.apache.camel.builder.component.dsl.RefComponentBuilderFactory.ref();
    }
    /**
     * REST (camel-rest)
     * The rest component is used for either hosting REST services (consumer) or
     * calling external REST services (producer).
     * 
     * Category: core,rest
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-rest
     */
    static org.apache.camel.builder.component.dsl.RestEndpointComponentBuilderFactory.RestEndpointComponentBuilder restEndpoint() {
        return org.apache.camel.builder.component.dsl.RestEndpointComponentBuilderFactory.restEndpoint();
    }
    /**
     * REST API (camel-rest)
     * The rest-api component is used for providing Swagger API of the REST
     * services which has been defined using the rest-dsl in Camel.
     * 
     * Category: core,rest
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-rest
     */
    static org.apache.camel.builder.component.dsl.RestApiComponentBuilderFactory.RestApiComponentBuilder restApi() {
        return org.apache.camel.builder.component.dsl.RestApiComponentBuilderFactory.restApi();
    }
    /**
     * REST OpenApi (camel-rest-openapi)
     * An awesome REST endpoint backed by OpenApi specifications.
     * 
     * Category: rest,openapi,http
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-rest-openapi
     */
    static org.apache.camel.builder.component.dsl.RestOpenapiComponentBuilderFactory.RestOpenapiComponentBuilder restOpenapi() {
        return org.apache.camel.builder.component.dsl.RestOpenapiComponentBuilderFactory.restOpenapi();
    }
    /**
     * REST Swagger (camel-rest-swagger)
     * An awesome REST endpoint backed by Swagger specifications.
     * 
     * Category: rest,swagger,http
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-rest-swagger
     */
    static org.apache.camel.builder.component.dsl.RestSwaggerComponentBuilderFactory.RestSwaggerComponentBuilder restSwagger() {
        return org.apache.camel.builder.component.dsl.RestSwaggerComponentBuilderFactory.restSwagger();
    }
    /**
     * Robot Framework (camel-robotframework)
     * Represents a RobotFramework endpoint.
     * 
     * Category: testing
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-robotframework
     */
    static org.apache.camel.builder.component.dsl.RobotframeworkComponentBuilderFactory.RobotframeworkComponentBuilder robotframework() {
        return org.apache.camel.builder.component.dsl.RobotframeworkComponentBuilderFactory.robotframework();
    }
    /**
     * RSS (camel-rss)
     * The rss component is used for consuming RSS feeds.
     * 
     * Category: rss
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-rss
     */
    static org.apache.camel.builder.component.dsl.RssComponentBuilderFactory.RssComponentBuilder rss() {
        return org.apache.camel.builder.component.dsl.RssComponentBuilderFactory.rss();
    }
    /**
     * Saga (camel-saga)
     * The saga component provides access to advanced options for managing the
     * flow in the Saga EIP.
     * 
     * Category: core,endpoint
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-saga
     */
    static org.apache.camel.builder.component.dsl.SagaComponentBuilderFactory.SagaComponentBuilder saga() {
        return org.apache.camel.builder.component.dsl.SagaComponentBuilderFactory.saga();
    }
    /**
     * Salesforce (camel-salesforce)
     * The salesforce component is used for integrating Camel with the massive
     * Salesforce API.
     * 
     * Category: api,cloud,crm
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-salesforce
     */
    static org.apache.camel.builder.component.dsl.SalesforceComponentBuilderFactory.SalesforceComponentBuilder salesforce() {
        return org.apache.camel.builder.component.dsl.SalesforceComponentBuilderFactory.salesforce();
    }
    /**
     * SAP NetWeaver (camel-sap-netweaver)
     * The sap-netweaver component integrates with the SAP NetWeaver Gateway
     * using HTTP transports.
     * 
     * Category: sap
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-sap-netweaver
     */
    static org.apache.camel.builder.component.dsl.SapNetweaverComponentBuilderFactory.SapNetweaverComponentBuilder sapNetweaver() {
        return org.apache.camel.builder.component.dsl.SapNetweaverComponentBuilderFactory.sapNetweaver();
    }
    /**
     * Scheduler (camel-scheduler)
     * The scheduler component is used for generating message exchanges when a
     * scheduler fires.
     * 
     * Category: core,scheduling
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-scheduler
     */
    static org.apache.camel.builder.component.dsl.SchedulerComponentBuilderFactory.SchedulerComponentBuilder scheduler() {
        return org.apache.camel.builder.component.dsl.SchedulerComponentBuilderFactory.scheduler();
    }
    /**
     * Schematron (camel-schematron)
     * Validates the payload of a message using the Schematron Library.
     * 
     * Category: validation
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-schematron
     */
    static org.apache.camel.builder.component.dsl.SchematronComponentBuilderFactory.SchematronComponentBuilder schematron() {
        return org.apache.camel.builder.component.dsl.SchematronComponentBuilderFactory.schematron();
    }
    /**
     * SCP (camel-jsch)
     * To copy files using the secure copy protocol (SCP).
     * 
     * Category: file
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-jsch
     */
    static org.apache.camel.builder.component.dsl.ScpComponentBuilderFactory.ScpComponentBuilder scp() {
        return org.apache.camel.builder.component.dsl.ScpComponentBuilderFactory.scp();
    }
    /**
     * SEDA (camel-seda)
     * The seda component provides asynchronous call to another endpoint from
     * any CamelContext in the same JVM.
     * 
     * Category: core,endpoint
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-seda
     */
    static org.apache.camel.builder.component.dsl.SedaComponentBuilderFactory.SedaComponentBuilder seda() {
        return org.apache.camel.builder.component.dsl.SedaComponentBuilderFactory.seda();
    }
    /**
     * Service (camel-service)
     * Represents an endpoint which is registered to a Service Registry such as
     * Consul, Etcd.
     * 
     * Category: cloud
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-service
     */
    static org.apache.camel.builder.component.dsl.ServiceComponentBuilderFactory.ServiceComponentBuilder service() {
        return org.apache.camel.builder.component.dsl.ServiceComponentBuilderFactory.service();
    }
    /**
     * ServiceNow (camel-servicenow)
     * The servicenow component is used to integrate Camel with ServiceNow cloud
     * services.
     * 
     * Category: api,cloud,management
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-servicenow
     */
    static org.apache.camel.builder.component.dsl.ServicenowComponentBuilderFactory.ServicenowComponentBuilder servicenow() {
        return org.apache.camel.builder.component.dsl.ServicenowComponentBuilderFactory.servicenow();
    }
    /**
     * Servlet (camel-servlet)
     * To use a HTTP Servlet as entry for Camel routes when running in a servlet
     * container.
     * 
     * Category: http
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-servlet
     */
    static org.apache.camel.builder.component.dsl.ServletComponentBuilderFactory.ServletComponentBuilder servlet() {
        return org.apache.camel.builder.component.dsl.ServletComponentBuilderFactory.servlet();
    }
    /**
     * SFTP (camel-ftp)
     * The sftp (FTP over SSH) component is used for uploading or downloading
     * files from SFTP servers.
     * 
     * Category: file
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-ftp
     */
    static org.apache.camel.builder.component.dsl.SftpComponentBuilderFactory.SftpComponentBuilder sftp() {
        return org.apache.camel.builder.component.dsl.SftpComponentBuilderFactory.sftp();
    }
    /**
     * SIP (camel-sip)
     * To send and receive messages using the SIP protocol (used in telco and
     * mobile).
     * 
     * Category: mobile
     * Since: 2.5
     * Maven coordinates: org.apache.camel:camel-sip
     */
    static org.apache.camel.builder.component.dsl.SipComponentBuilderFactory.SipComponentBuilder sip() {
        return org.apache.camel.builder.component.dsl.SipComponentBuilderFactory.sip();
    }
    /**
     * SIP (Secure) (camel-sip)
     * To send and receive messages using the SIP protocol (used in telco and
     * mobile).
     * 
     * Category: mobile
     * Since: 2.5
     * Maven coordinates: org.apache.camel:camel-sip
     */
    static org.apache.camel.builder.component.dsl.SipsComponentBuilderFactory.SipsComponentBuilder sips() {
        return org.apache.camel.builder.component.dsl.SipsComponentBuilderFactory.sips();
    }
    /**
     * Simple JMS (camel-sjms)
     * The sjms component (simple jms) allows messages to be sent to (or
     * consumed from) a JMS Queue or Topic (uses JMS 1.x API).
     * 
     * Category: messaging
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-sjms
     */
    static org.apache.camel.builder.component.dsl.SjmsComponentBuilderFactory.SjmsComponentBuilder sjms() {
        return org.apache.camel.builder.component.dsl.SjmsComponentBuilderFactory.sjms();
    }
    /**
     * Simple JMS Batch (camel-sjms)
     * The sjms-batch component is a specialized for highly performant,
     * transactional batch consumption from a JMS queue.
     * 
     * Category: messaging
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-sjms
     */
    static org.apache.camel.builder.component.dsl.SjmsBatchComponentBuilderFactory.SjmsBatchComponentBuilder sjmsBatch() {
        return org.apache.camel.builder.component.dsl.SjmsBatchComponentBuilderFactory.sjmsBatch();
    }
    /**
     * Simple JMS2 (camel-sjms2)
     * The sjms2 component (simple jms) allows messages to be sent to (or
     * consumed from) a JMS Queue or Topic (uses JMS 2.x API).
     * 
     * Category: messaging
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-sjms2
     */
    static org.apache.camel.builder.component.dsl.Sjms2ComponentBuilderFactory.Sjms2ComponentBuilder sjms2() {
        return org.apache.camel.builder.component.dsl.Sjms2ComponentBuilderFactory.sjms2();
    }
    /**
     * Slack (camel-slack)
     * The slack component allows you to send messages to Slack.
     * 
     * Category: social
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-slack
     */
    static org.apache.camel.builder.component.dsl.SlackComponentBuilderFactory.SlackComponentBuilder slack() {
        return org.apache.camel.builder.component.dsl.SlackComponentBuilderFactory.slack();
    }
    /**
     * SMPP (camel-smpp)
     * To send and receive SMS using a SMSC (Short Message Service Center).
     * 
     * Category: mobile
     * Since: 2.2
     * Maven coordinates: org.apache.camel:camel-smpp
     */
    static org.apache.camel.builder.component.dsl.SmppComponentBuilderFactory.SmppComponentBuilder smpp() {
        return org.apache.camel.builder.component.dsl.SmppComponentBuilderFactory.smpp();
    }
    /**
     * SMPP (Secure) (camel-smpp)
     * To send and receive SMS using a SMSC (Short Message Service Center).
     * 
     * Category: mobile
     * Since: 2.2
     * Maven coordinates: org.apache.camel:camel-smpp
     */
    static org.apache.camel.builder.component.dsl.SmppsComponentBuilderFactory.SmppsComponentBuilder smpps() {
        return org.apache.camel.builder.component.dsl.SmppsComponentBuilderFactory.smpps();
    }
    /**
     * SMTP (camel-mail)
     * To send or receive emails using imap/pop3 or smtp protocols.
     * 
     * Category: mail
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mail
     */
    static org.apache.camel.builder.component.dsl.SmtpComponentBuilderFactory.SmtpComponentBuilder smtp() {
        return org.apache.camel.builder.component.dsl.SmtpComponentBuilderFactory.smtp();
    }
    /**
     * SMTPS (camel-mail)
     * To send or receive emails using imap/pop3 or smtp protocols.
     * 
     * Category: mail
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mail
     */
    static org.apache.camel.builder.component.dsl.SmtpsComponentBuilderFactory.SmtpsComponentBuilder smtps() {
        return org.apache.camel.builder.component.dsl.SmtpsComponentBuilderFactory.smtps();
    }
    /**
     * SNMP (camel-snmp)
     * The snmp component gives you the ability to poll SNMP capable devices or
     * receiving traps.
     * 
     * Category: monitoring
     * Since: 2.1
     * Maven coordinates: org.apache.camel:camel-snmp
     */
    static org.apache.camel.builder.component.dsl.SnmpComponentBuilderFactory.SnmpComponentBuilder snmp() {
        return org.apache.camel.builder.component.dsl.SnmpComponentBuilderFactory.snmp();
    }
    /**
     * Solr (camel-solr)
     * The solr component allows you to interface with an Apache Lucene Solr
     * server.
     * 
     * Category: monitoring,search
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-solr
     */
    static org.apache.camel.builder.component.dsl.SolrComponentBuilderFactory.SolrComponentBuilder solr() {
        return org.apache.camel.builder.component.dsl.SolrComponentBuilderFactory.solr();
    }
    /**
     * Solr (camel-solr)
     * The solr component allows you to interface with an Apache Lucene Solr
     * server.
     * 
     * Category: monitoring,search
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-solr
     */
    static org.apache.camel.builder.component.dsl.SolrcloudComponentBuilderFactory.SolrcloudComponentBuilder solrcloud() {
        return org.apache.camel.builder.component.dsl.SolrcloudComponentBuilderFactory.solrcloud();
    }
    /**
     * Solr (Secure) (camel-solr)
     * The solr component allows you to interface with an Apache Lucene Solr
     * server.
     * 
     * Category: monitoring,search
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-solr
     */
    static org.apache.camel.builder.component.dsl.SolrsComponentBuilderFactory.SolrsComponentBuilder solrs() {
        return org.apache.camel.builder.component.dsl.SolrsComponentBuilderFactory.solrs();
    }
    /**
     * Soroush (camel-soroush)
     * To integrate with the Soroush chat bot.
     * 
     * Category: chat
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-soroush
     */
    static org.apache.camel.builder.component.dsl.SoroushComponentBuilderFactory.SoroushComponentBuilder soroush() {
        return org.apache.camel.builder.component.dsl.SoroushComponentBuilderFactory.soroush();
    }
    /**
     * Spark (camel-spark)
     * The spark component can be used to send RDD or DataFrame jobs to Apache
     * Spark cluster.
     * 
     * Category: bigdata,iot
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-spark
     */
    static org.apache.camel.builder.component.dsl.SparkComponentBuilderFactory.SparkComponentBuilder spark() {
        return org.apache.camel.builder.component.dsl.SparkComponentBuilderFactory.spark();
    }
    /**
     * Splunk (camel-splunk)
     * The splunk component allows to publish or search for events in Splunk.
     * 
     * Category: log,monitoring
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-splunk
     */
    static org.apache.camel.builder.component.dsl.SplunkComponentBuilderFactory.SplunkComponentBuilder splunk() {
        return org.apache.camel.builder.component.dsl.SplunkComponentBuilderFactory.splunk();
    }
    /**
     * Spring Batch (camel-spring-batch)
     * The spring-batch component allows to send messages to Spring Batch for
     * further processing.
     * 
     * Category: spring,batch,scheduling
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-spring-batch
     */
    static org.apache.camel.builder.component.dsl.SpringBatchComponentBuilderFactory.SpringBatchComponentBuilder springBatch() {
        return org.apache.camel.builder.component.dsl.SpringBatchComponentBuilderFactory.springBatch();
    }
    /**
     * Spring Event (camel-spring)
     * The spring-event component allows to listen for Spring Application
     * Events.
     * 
     * Category: spring,eventbus
     * Since: 1.4
     * Maven coordinates: org.apache.camel:camel-spring
     */
    static org.apache.camel.builder.component.dsl.SpringEventComponentBuilderFactory.SpringEventComponentBuilder springEvent() {
        return org.apache.camel.builder.component.dsl.SpringEventComponentBuilderFactory.springEvent();
    }
    /**
     * Spring Integration (camel-spring-integration)
     * Bridges Camel with Spring Integration.
     * 
     * Category: spring,eventbus
     * Since: 1.4
     * Maven coordinates: org.apache.camel:camel-spring-integration
     */
    static org.apache.camel.builder.component.dsl.SpringIntegrationComponentBuilderFactory.SpringIntegrationComponentBuilder springIntegration() {
        return org.apache.camel.builder.component.dsl.SpringIntegrationComponentBuilderFactory.springIntegration();
    }
    /**
     * Spring LDAP (camel-spring-ldap)
     * The spring-ldap component allows you to perform searches in LDAP servers
     * using filters as the message payload.
     * 
     * Category: spring,ldap
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-spring-ldap
     */
    static org.apache.camel.builder.component.dsl.SpringLdapComponentBuilderFactory.SpringLdapComponentBuilder springLdap() {
        return org.apache.camel.builder.component.dsl.SpringLdapComponentBuilderFactory.springLdap();
    }
    /**
     * Spring Redis (camel-spring-redis)
     * The spring-redis component allows sending and receiving messages from
     * Redis.
     * 
     * Category: spring,nosql
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-spring-redis
     */
    static org.apache.camel.builder.component.dsl.SpringRedisComponentBuilderFactory.SpringRedisComponentBuilder springRedis() {
        return org.apache.camel.builder.component.dsl.SpringRedisComponentBuilderFactory.springRedis();
    }
    /**
     * Spring WebService (camel-spring-ws)
     * The spring-ws component is used for SOAP WebServices using Spring
     * WebServices.
     * 
     * Category: spring,soap,webservice
     * Since: 2.6
     * Maven coordinates: org.apache.camel:camel-spring-ws
     */
    static org.apache.camel.builder.component.dsl.SpringWsComponentBuilderFactory.SpringWsComponentBuilder springWs() {
        return org.apache.camel.builder.component.dsl.SpringWsComponentBuilderFactory.springWs();
    }
    /**
     * SQL (camel-sql)
     * The sql component allows you to work with databases using JDBC SQL
     * queries.
     * 
     * Category: database,sql
     * Since: 1.4
     * Maven coordinates: org.apache.camel:camel-sql
     */
    static org.apache.camel.builder.component.dsl.SqlComponentBuilderFactory.SqlComponentBuilder sql() {
        return org.apache.camel.builder.component.dsl.SqlComponentBuilderFactory.sql();
    }
    /**
     * SQL Stored Procedure (camel-sql)
     * The sql component allows you to work with databases using JDBC Stored
     * Procedure queries.
     * 
     * Category: database,sql
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-sql
     */
    static org.apache.camel.builder.component.dsl.SqlStoredComponentBuilderFactory.SqlStoredComponentBuilder sqlStored() {
        return org.apache.camel.builder.component.dsl.SqlStoredComponentBuilderFactory.sqlStored();
    }
    /**
     * SSH (camel-ssh)
     * The ssh component enables access to SSH servers such that you can send an
     * SSH command, and process the response.
     * 
     * Category: file
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-ssh
     */
    static org.apache.camel.builder.component.dsl.SshComponentBuilderFactory.SshComponentBuilder ssh() {
        return org.apache.camel.builder.component.dsl.SshComponentBuilderFactory.ssh();
    }
    /**
     * StAX (camel-stax)
     * The stax component allows messages to be process through a SAX
     * ContentHandler.
     * 
     * Category: transformation
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-stax
     */
    static org.apache.camel.builder.component.dsl.StaxComponentBuilderFactory.StaxComponentBuilder stax() {
        return org.apache.camel.builder.component.dsl.StaxComponentBuilderFactory.stax();
    }
    /**
     * Stomp (camel-stomp)
     * The stomp component is used for communicating with Stomp compliant
     * message brokers.
     * 
     * Category: messaging
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-stomp
     */
    static org.apache.camel.builder.component.dsl.StompComponentBuilderFactory.StompComponentBuilder stomp() {
        return org.apache.camel.builder.component.dsl.StompComponentBuilderFactory.stomp();
    }
    /**
     * Stream (camel-stream)
     * The stream: component provides access to the system-in, system-out and
     * system-err streams as well as allowing streaming of file.
     * 
     * Category: file,system
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-stream
     */
    static org.apache.camel.builder.component.dsl.StreamComponentBuilderFactory.StreamComponentBuilder stream() {
        return org.apache.camel.builder.component.dsl.StreamComponentBuilderFactory.stream();
    }
    /**
     * String Template (camel-stringtemplate)
     * Transforms the message using a String template.
     * 
     * Category: transformation
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-stringtemplate
     */
    static org.apache.camel.builder.component.dsl.StringTemplateComponentBuilderFactory.StringTemplateComponentBuilder stringTemplate() {
        return org.apache.camel.builder.component.dsl.StringTemplateComponentBuilderFactory.stringTemplate();
    }
    /**
     * Stub (camel-stub)
     * The stub component provides a simple way to stub out any physical
     * endpoints while in development or testing.
     * 
     * Category: core,testing
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-stub
     */
    static org.apache.camel.builder.component.dsl.StubComponentBuilderFactory.StubComponentBuilder stub() {
        return org.apache.camel.builder.component.dsl.StubComponentBuilderFactory.stub();
    }
    /**
     * Telegram (camel-telegram)
     * The telegram component provides access to the Telegram Bot API.
     * 
     * Category: chat
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-telegram
     */
    static org.apache.camel.builder.component.dsl.TelegramComponentBuilderFactory.TelegramComponentBuilder telegram() {
        return org.apache.camel.builder.component.dsl.TelegramComponentBuilderFactory.telegram();
    }
    /**
     * Thrift (camel-thrift)
     * The Thrift component allows to call and expose remote procedures (RPC)
     * with Apache Thrift data format and serialization mechanism
     * 
     * Category: rpc
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-thrift
     */
    static org.apache.camel.builder.component.dsl.ThriftComponentBuilderFactory.ThriftComponentBuilder thrift() {
        return org.apache.camel.builder.component.dsl.ThriftComponentBuilderFactory.thrift();
    }
    /**
     * Tika (camel-tika)
     * This component integrates with Apache Tika to extract content and
     * metadata from thousands of file types.
     * 
     * Category: document,transformation
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-tika
     */
    static org.apache.camel.builder.component.dsl.TikaComponentBuilderFactory.TikaComponentBuilder tika() {
        return org.apache.camel.builder.component.dsl.TikaComponentBuilderFactory.tika();
    }
    /**
     * Timer (camel-timer)
     * The timer component is used for generating message exchanges when a timer
     * fires.
     * 
     * Category: core,scheduling
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-timer
     */
    static org.apache.camel.builder.component.dsl.TimerComponentBuilderFactory.TimerComponentBuilder timer() {
        return org.apache.camel.builder.component.dsl.TimerComponentBuilderFactory.timer();
    }
    /**
     * Twilio (camel-twilio)
     * The Twilio component allows you to interact with the Twilio REST APIs
     * using Twilio Java SDK.
     * 
     * Category: api,messaging,cloud
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-twilio
     */
    static org.apache.camel.builder.component.dsl.TwilioComponentBuilderFactory.TwilioComponentBuilder twilio() {
        return org.apache.camel.builder.component.dsl.TwilioComponentBuilderFactory.twilio();
    }
    /**
     * Twitter Direct Message (camel-twitter)
     * The Twitter Direct Message Component consumes/produces user's direct
     * messages.
     * 
     * Category: api,social
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-twitter
     */
    static org.apache.camel.builder.component.dsl.TwitterDirectmessageComponentBuilderFactory.TwitterDirectmessageComponentBuilder twitterDirectmessage() {
        return org.apache.camel.builder.component.dsl.TwitterDirectmessageComponentBuilderFactory.twitterDirectmessage();
    }
    /**
     * Twitter Search (camel-twitter)
     * The Twitter Search component consumes search results.
     * 
     * Category: api,social
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-twitter
     */
    static org.apache.camel.builder.component.dsl.TwitterSearchComponentBuilderFactory.TwitterSearchComponentBuilder twitterSearch() {
        return org.apache.camel.builder.component.dsl.TwitterSearchComponentBuilderFactory.twitterSearch();
    }
    /**
     * Twitter Timeline (camel-twitter)
     * The Twitter Timeline component consumes twitter timeline or update the
     * status of specific user.
     * 
     * Category: api,social
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-twitter
     */
    static org.apache.camel.builder.component.dsl.TwitterTimelineComponentBuilderFactory.TwitterTimelineComponentBuilder twitterTimeline() {
        return org.apache.camel.builder.component.dsl.TwitterTimelineComponentBuilderFactory.twitterTimeline();
    }
    /**
     * Undertow (camel-undertow)
     * The undertow component provides HTTP and WebSocket based endpoints for
     * consuming and producing HTTP/WebSocket requests.
     * 
     * Category: http,websocket
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-undertow
     */
    static org.apache.camel.builder.component.dsl.UndertowComponentBuilderFactory.UndertowComponentBuilder undertow() {
        return org.apache.camel.builder.component.dsl.UndertowComponentBuilderFactory.undertow();
    }
    /**
     * Validator (camel-validator)
     * Validates the payload of a message using XML Schema and JAXP Validation.
     * 
     * Category: core,validation
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-validator
     */
    static org.apache.camel.builder.component.dsl.ValidatorComponentBuilderFactory.ValidatorComponentBuilder validator() {
        return org.apache.camel.builder.component.dsl.ValidatorComponentBuilderFactory.validator();
    }
    /**
     * Velocity (camel-velocity)
     * Transforms the message using a Velocity template.
     * 
     * Category: transformation
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-velocity
     */
    static org.apache.camel.builder.component.dsl.VelocityComponentBuilderFactory.VelocityComponentBuilder velocity() {
        return org.apache.camel.builder.component.dsl.VelocityComponentBuilderFactory.velocity();
    }
    /**
     * Vert.x (camel-vertx)
     * The vertx component is used for sending and receive messages from a vertx
     * event bus.
     * 
     * Category: eventbus,reactive
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-vertx
     */
    static org.apache.camel.builder.component.dsl.VertxComponentBuilderFactory.VertxComponentBuilder vertx() {
        return org.apache.camel.builder.component.dsl.VertxComponentBuilderFactory.vertx();
    }
    /**
     * VM (camel-vm)
     * The vm component provides asynchronous call to another endpoint from the
     * same CamelContext.
     * 
     * Category: core,endpoint
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-vm
     */
    static org.apache.camel.builder.component.dsl.VmComponentBuilderFactory.VmComponentBuilder vm() {
        return org.apache.camel.builder.component.dsl.VmComponentBuilderFactory.vm();
    }
    /**
     * Weather (camel-weather)
     * Polls the weather information from Open Weather Map.
     * 
     * Category: api
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-weather
     */
    static org.apache.camel.builder.component.dsl.WeatherComponentBuilderFactory.WeatherComponentBuilder weather() {
        return org.apache.camel.builder.component.dsl.WeatherComponentBuilderFactory.weather();
    }
    /**
     * Web3j Ethereum Blockchain (camel-web3j)
     * The web3j component uses the Web3j client API and allows you to add/read
     * nodes to/from a web3j compliant content repositories.
     * 
     * Category: bitcoin,blockchain
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-web3j
     */
    static org.apache.camel.builder.component.dsl.Web3jComponentBuilderFactory.Web3jComponentBuilder web3j() {
        return org.apache.camel.builder.component.dsl.Web3jComponentBuilderFactory.web3j();
    }
    /**
     * Webhook (camel-webhook)
     * The webhook component allows other Camel components that can receive push
     * notifications to expose webhook endpoints and automatically register them
     * with their own webhook provider.
     * 
     * Category: cloud
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-webhook
     */
    static org.apache.camel.builder.component.dsl.WebhookComponentBuilderFactory.WebhookComponentBuilder webhook() {
        return org.apache.camel.builder.component.dsl.WebhookComponentBuilderFactory.webhook();
    }
    /**
     * Jetty Websocket (camel-websocket)
     * The websocket component provides websocket endpoints with Jetty for
     * communicating with clients using websocket.
     * 
     * Category: websocket
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-websocket
     */
    static org.apache.camel.builder.component.dsl.WebsocketComponentBuilderFactory.WebsocketComponentBuilder websocket() {
        return org.apache.camel.builder.component.dsl.WebsocketComponentBuilderFactory.websocket();
    }
    /**
     * Javax Websocket (camel-websocket-jsr356)
     * Camel WebSocket using JSR356 (javax)
     * 
     * Category: http
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-websocket-jsr356
     */
    static org.apache.camel.builder.component.dsl.WebsocketJsr356ComponentBuilderFactory.WebsocketJsr356ComponentBuilder websocketJsr356() {
        return org.apache.camel.builder.component.dsl.WebsocketJsr356ComponentBuilderFactory.websocketJsr356();
    }
    /**
     * Weka (camel-weka)
     * The camel-weka component provides Data Mining functionality through Weka.
     * 
     * Category: Datamining
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-weka
     */
    static org.apache.camel.builder.component.dsl.WekaComponentBuilderFactory.WekaComponentBuilder weka() {
        return org.apache.camel.builder.component.dsl.WekaComponentBuilderFactory.weka();
    }
    /**
     * Wordpress (camel-wordpress)
     * Integrates Camel with Wordpress.
     * 
     * Category: cms
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-wordpress
     */
    static org.apache.camel.builder.component.dsl.WordpressComponentBuilderFactory.WordpressComponentBuilder wordpress() {
        return org.apache.camel.builder.component.dsl.WordpressComponentBuilderFactory.wordpress();
    }
    /**
     * Workday (camel-workday)
     * Represents a Workday endpoint.
     * 
     * Category: hcm
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-workday
     */
    static org.apache.camel.builder.component.dsl.WorkdayComponentBuilderFactory.WorkdayComponentBuilder workday() {
        return org.apache.camel.builder.component.dsl.WorkdayComponentBuilderFactory.workday();
    }
    /**
     * XChange (camel-xchange)
     * The camel-xchange component provide access to many bitcoin and altcoin
     * exchanges for trading and accessing market data.
     * 
     * Category: bitcoin,blockchain
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-xchange
     */
    static org.apache.camel.builder.component.dsl.XchangeComponentBuilderFactory.XchangeComponentBuilder xchange() {
        return org.apache.camel.builder.component.dsl.XchangeComponentBuilderFactory.xchange();
    }
    /**
     * XJ (camel-xj)
     * Transforms json/xml message back and forth using a XSLT.
     * 
     * Category: transformation
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-xj
     */
    static org.apache.camel.builder.component.dsl.XjComponentBuilderFactory.XjComponentBuilder xj() {
        return org.apache.camel.builder.component.dsl.XjComponentBuilderFactory.xj();
    }
    /**
     * XML Security Sign (camel-xmlsecurity)
     * Used to sign exchanges using the XML signature specification.
     * 
     * Category: security,transformation
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-xmlsecurity
     */
    static org.apache.camel.builder.component.dsl.XmlsecuritySignComponentBuilderFactory.XmlsecuritySignComponentBuilder xmlsecuritySign() {
        return org.apache.camel.builder.component.dsl.XmlsecuritySignComponentBuilderFactory.xmlsecuritySign();
    }
    /**
     * XML Security Verify (camel-xmlsecurity)
     * Used to verify exchanges using the XML signature specification.
     * 
     * Category: security,transformation
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-xmlsecurity
     */
    static org.apache.camel.builder.component.dsl.XmlsecurityVerifyComponentBuilderFactory.XmlsecurityVerifyComponentBuilder xmlsecurityVerify() {
        return org.apache.camel.builder.component.dsl.XmlsecurityVerifyComponentBuilderFactory.xmlsecurityVerify();
    }
    /**
     * XMPP (camel-xmpp)
     * To send and receive messages from a XMPP (chat) server.
     * 
     * Category: chat,messaging
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-xmpp
     */
    static org.apache.camel.builder.component.dsl.XmppComponentBuilderFactory.XmppComponentBuilder xmpp() {
        return org.apache.camel.builder.component.dsl.XmppComponentBuilderFactory.xmpp();
    }
    /**
     * XQuery (camel-saxon)
     * Transforms the message using a XQuery template using Saxon.
     * 
     * Category: transformation
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-saxon
     */
    static org.apache.camel.builder.component.dsl.XqueryComponentBuilderFactory.XqueryComponentBuilder xquery() {
        return org.apache.camel.builder.component.dsl.XqueryComponentBuilderFactory.xquery();
    }
    /**
     * XSLT (camel-xslt)
     * Transforms the message using a XSLT template.
     * 
     * Category: core,transformation
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-xslt
     */
    static org.apache.camel.builder.component.dsl.XsltComponentBuilderFactory.XsltComponentBuilder xslt() {
        return org.apache.camel.builder.component.dsl.XsltComponentBuilderFactory.xslt();
    }
    /**
     * XSLT Saxon (camel-xslt-saxon)
     * Transforms the message using a XSLT template using Saxon.
     * 
     * Category: core,transformation
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-xslt-saxon
     */
    static org.apache.camel.builder.component.dsl.XsltSaxonComponentBuilderFactory.XsltSaxonComponentBuilder xsltSaxon() {
        return org.apache.camel.builder.component.dsl.XsltSaxonComponentBuilderFactory.xsltSaxon();
    }
    /**
     * Yammer (camel-yammer)
     * The yammer component allows you to interact with the Yammer enterprise
     * social network.
     * 
     * Category: social
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-yammer
     */
    static org.apache.camel.builder.component.dsl.YammerComponentBuilderFactory.YammerComponentBuilder yammer() {
        return org.apache.camel.builder.component.dsl.YammerComponentBuilderFactory.yammer();
    }
    /**
     * Zendesk (camel-zendesk)
     * Allows producing messages to manage Zendesk ticket, user, organization,
     * etc.
     * 
     * Category: api,support,cloud
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-zendesk
     */
    static org.apache.camel.builder.component.dsl.ZendeskComponentBuilderFactory.ZendeskComponentBuilder zendesk() {
        return org.apache.camel.builder.component.dsl.ZendeskComponentBuilderFactory.zendesk();
    }
    /**
     * ZooKeeper (camel-zookeeper)
     * The zookeeper component allows interaction with a ZooKeeper cluster.
     * 
     * Category: clustering
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-zookeeper
     */
    static org.apache.camel.builder.component.dsl.ZookeeperComponentBuilderFactory.ZookeeperComponentBuilder zookeeper() {
        return org.apache.camel.builder.component.dsl.ZookeeperComponentBuilderFactory.zookeeper();
    }
    /**
     * ZooKeeper Master (camel-zookeeper-master)
     * Represents an endpoint which only becomes active when it obtains the
     * master lock
     * 
     * Category: clustering
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-zookeeper-master
     */
    static org.apache.camel.builder.component.dsl.ZookeeperMasterComponentBuilderFactory.ZookeeperMasterComponentBuilder zookeeperMaster() {
        return org.apache.camel.builder.component.dsl.ZookeeperMasterComponentBuilderFactory.zookeeperMaster();
    }
}