/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.kafka.KafkaComponent;

/**
 * Sent and receive messages to/from an Apache Kafka broker.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface KafkaComponentBuilderFactory {

    /**
     * Kafka (camel-kafka)
     * Sent and receive messages to/from an Apache Kafka broker.
     * 
     * Category: messaging
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-kafka
     * 
     * @return the dsl builder
     */
    static KafkaComponentBuilder kafka() {
        return new KafkaComponentBuilderImpl();
    }

    /**
     * Builder for the Kafka component.
     */
    interface KafkaComponentBuilder extends ComponentBuilder<KafkaComponent> {
        /**
         * Sets additional properties for either kafka consumer or kafka
         * producer in case they can't be set directly on the camel
         * configurations (e.g: new Kafka properties that are not reflected yet
         * in Camel configurations), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&amp;amp;additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param additionalProperties the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder additionalProperties(
                java.util.Map<java.lang.String, java.lang.Object> additionalProperties) {
            doSetProperty("additionalProperties", additionalProperties);
            return this;
        }
        /**
         * URL of the Kafka brokers to use. The format is
         * host1:port1,host2:port2, and the list can be a subset of brokers or a
         * VIP pointing to a subset of brokers. This option is known as
         * bootstrap.servers in the Kafka documentation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param brokers the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder brokers(java.lang.String brokers) {
            doSetProperty("brokers", brokers);
            return this;
        }
        /**
         * The client id is a user-specified string sent in each request to help
         * trace calls. It should logically identify the application making the
         * request.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder clientId(java.lang.String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * Allows to pre-configure the Kafka component with common options that
         * the endpoints will reuse.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.kafka.KafkaConfiguration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder configuration(
                org.apache.camel.component.kafka.KafkaConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * The maximum amount of time in milliseconds to wait when reconnecting
         * to a broker that has repeatedly failed to connect. If provided, the
         * backoff per host will increase exponentially for each consecutive
         * connection failure, up to this maximum. After calculating the backoff
         * increase, 20% random jitter is added to avoid connection storms.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param reconnectBackoffMaxMs the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder reconnectBackoffMaxMs(
                java.lang.Integer reconnectBackoffMaxMs) {
            doSetProperty("reconnectBackoffMaxMs", reconnectBackoffMaxMs);
            return this;
        }
        /**
         * Timeout in milliseconds to wait gracefully for the consumer or
         * producer to shutdown and terminate its worker threads.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param shutdownTimeout the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder shutdownTimeout(int shutdownTimeout) {
            doSetProperty("shutdownTimeout", shutdownTimeout);
            return this;
        }
        /**
         * Whether to allow doing manual commits via KafkaManualCommit. If this
         * option is enabled then an instance of KafkaManualCommit is stored on
         * the Exchange message header, which allows end users to access this
         * API and perform manual offset commits via the Kafka consumer.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param allowManualCommit the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder allowManualCommit(
                boolean allowManualCommit) {
            doSetProperty("allowManualCommit", allowManualCommit);
            return this;
        }
        /**
         * If true, periodically commit to ZooKeeper the offset of messages
         * already fetched by the consumer. This committed offset will be used
         * when the process fails as the position from which the new consumer
         * will begin.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param autoCommitEnable the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder autoCommitEnable(boolean autoCommitEnable) {
            doSetProperty("autoCommitEnable", autoCommitEnable);
            return this;
        }
        /**
         * The frequency in ms that the consumer offsets are committed to
         * zookeeper.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param autoCommitIntervalMs the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder autoCommitIntervalMs(
                java.lang.Integer autoCommitIntervalMs) {
            doSetProperty("autoCommitIntervalMs", autoCommitIntervalMs);
            return this;
        }
        /**
         * What to do when there is no initial offset in ZooKeeper or if an
         * offset is out of range: earliest : automatically reset the offset to
         * the earliest offset latest : automatically reset the offset to the
         * latest offset fail: throw exception to the consumer.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: latest
         * Group: consumer
         * 
         * @param autoOffsetReset the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder autoOffsetReset(
                java.lang.String autoOffsetReset) {
            doSetProperty("autoOffsetReset", autoOffsetReset);
            return this;
        }
        /**
         * This options controls what happens when a consumer is processing an
         * exchange and it fails. If the option is false then the consumer
         * continues to the next message and processes it. If the option is true
         * then the consumer breaks out, and will seek back to offset of the
         * message that caused a failure, and then re-attempt to process this
         * message. However this can lead to endless processing of the same
         * message if its bound to fail every time, eg a poison message.
         * Therefore its recommended to deal with that for example by using
         * Camel's error handler.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param breakOnFirstError the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder breakOnFirstError(
                boolean breakOnFirstError) {
            doSetProperty("breakOnFirstError", breakOnFirstError);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Automatically check the CRC32 of the records consumed. This ensures
         * no on-the-wire or on-disk corruption to the messages occurred. This
         * check adds some overhead, so it may be disabled in cases seeking
         * extreme performance.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param checkCrcs the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder checkCrcs(java.lang.Boolean checkCrcs) {
            doSetProperty("checkCrcs", checkCrcs);
            return this;
        }
        /**
         * The maximum time, in milliseconds, that the code will wait for a
         * synchronous commit to complete.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param commitTimeoutMs the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder commitTimeoutMs(
                java.lang.Long commitTimeoutMs) {
            doSetProperty("commitTimeoutMs", commitTimeoutMs);
            return this;
        }
        /**
         * The configuration controls the maximum amount of time the client will
         * wait for the response of a request. If the response is not received
         * before the timeout elapses the client will resend the request if
         * necessary or fail the request if retries are exhausted.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 40000
         * Group: consumer
         * 
         * @param consumerRequestTimeoutMs the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder consumerRequestTimeoutMs(
                java.lang.Integer consumerRequestTimeoutMs) {
            doSetProperty("consumerRequestTimeoutMs", consumerRequestTimeoutMs);
            return this;
        }
        /**
         * The number of consumers that connect to kafka server. Each consumer
         * is run on a separate thread, that retrieves and process the incoming
         * data.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param consumersCount the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder consumersCount(int consumersCount) {
            doSetProperty("consumersCount", consumersCount);
            return this;
        }
        /**
         * The maximum amount of data the server should return for a fetch
         * request This is not an absolute maximum, if the first message in the
         * first non-empty partition of the fetch is larger than this value, the
         * message will still be returned to ensure that the consumer can make
         * progress. The maximum message size accepted by the broker is defined
         * via message.max.bytes (broker config) or max.message.bytes (topic
         * config). Note that the consumer performs multiple fetches in
         * parallel.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 52428800
         * Group: consumer
         * 
         * @param fetchMaxBytes the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder fetchMaxBytes(
                java.lang.Integer fetchMaxBytes) {
            doSetProperty("fetchMaxBytes", fetchMaxBytes);
            return this;
        }
        /**
         * The minimum amount of data the server should return for a fetch
         * request. If insufficient data is available the request will wait for
         * that much data to accumulate before answering the request.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param fetchMinBytes the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder fetchMinBytes(
                java.lang.Integer fetchMinBytes) {
            doSetProperty("fetchMinBytes", fetchMinBytes);
            return this;
        }
        /**
         * The maximum amount of time the server will block before answering the
         * fetch request if there isn't sufficient data to immediately satisfy
         * fetch.min.bytes.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: consumer
         * 
         * @param fetchWaitMaxMs the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder fetchWaitMaxMs(
                java.lang.Integer fetchWaitMaxMs) {
            doSetProperty("fetchWaitMaxMs", fetchWaitMaxMs);
            return this;
        }
        /**
         * A string that uniquely identifies the group of consumer processes to
         * which this consumer belongs. By setting the same group id multiple
         * processes indicate that they are all part of the same consumer group.
         * This option is required for consumers.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param groupId the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder groupId(java.lang.String groupId) {
            doSetProperty("groupId", groupId);
            return this;
        }
        /**
         * A unique identifier of the consumer instance provided by the end
         * user. Only non-empty strings are permitted. If set, the consumer is
         * treated as a static member, which means that only one instance with
         * this ID is allowed in the consumer group at any time. This can be
         * used in combination with a larger session timeout to avoid group
         * rebalances caused by transient unavailability (e.g. process
         * restarts). If not set, the consumer will join the group as a dynamic
         * member, which is the traditional behavior.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param groupInstanceId the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder groupInstanceId(
                java.lang.String groupInstanceId) {
            doSetProperty("groupInstanceId", groupInstanceId);
            return this;
        }
        /**
         * To use a custom KafkaHeaderDeserializer to deserialize kafka headers
         * values.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param headerDeserializer the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder headerDeserializer(
                org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer headerDeserializer) {
            doSetProperty("headerDeserializer", headerDeserializer);
            return this;
        }
        /**
         * The expected time between heartbeats to the consumer coordinator when
         * using Kafka's group management facilities. Heartbeats are used to
         * ensure that the consumer's session stays active and to facilitate
         * rebalancing when new consumers join or leave the group. The value
         * must be set lower than session.timeout.ms, but typically should be
         * set no higher than 1/3 of that value. It can be adjusted even lower
         * to control the expected time for normal rebalances.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 3000
         * Group: consumer
         * 
         * @param heartbeatIntervalMs the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder heartbeatIntervalMs(
                java.lang.Integer heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * Deserializer class for key that implements the Deserializer
         * interface.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.common.serialization.StringDeserializer
         * Group: consumer
         * 
         * @param keyDeserializer the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder keyDeserializer(
                java.lang.String keyDeserializer) {
            doSetProperty("keyDeserializer", keyDeserializer);
            return this;
        }
        /**
         * The maximum amount of data per-partition the server will return. The
         * maximum total memory used for a request will be #partitions
         * max.partition.fetch.bytes. This size must be at least as large as the
         * maximum message size the server allows or else it is possible for the
         * producer to send messages larger than the consumer can fetch. If that
         * happens, the consumer can get stuck trying to fetch a large message
         * on a certain partition.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: consumer
         * 
         * @param maxPartitionFetchBytes the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder maxPartitionFetchBytes(
                java.lang.Integer maxPartitionFetchBytes) {
            doSetProperty("maxPartitionFetchBytes", maxPartitionFetchBytes);
            return this;
        }
        /**
         * The maximum delay between invocations of poll() when using consumer
         * group management. This places an upper bound on the amount of time
         * that the consumer can be idle before fetching more records. If poll()
         * is not called before expiration of this timeout, then the consumer is
         * considered failed and the group will rebalance in order to reassign
         * the partitions to another member.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param maxPollIntervalMs the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder maxPollIntervalMs(
                java.lang.Long maxPollIntervalMs) {
            doSetProperty("maxPollIntervalMs", maxPollIntervalMs);
            return this;
        }
        /**
         * The maximum number of records returned in a single call to poll().
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: consumer
         * 
         * @param maxPollRecords the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder maxPollRecords(
                java.lang.Integer maxPollRecords) {
            doSetProperty("maxPollRecords", maxPollRecords);
            return this;
        }
        /**
         * The offset repository to use in order to locally store the offset of
         * each partition of the topic. Defining one will disable the
         * autocommit.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.StateRepository&amp;lt;java.lang.String, java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetRepository the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder offsetRepository(
                org.apache.camel.spi.StateRepository<java.lang.String, java.lang.String> offsetRepository) {
            doSetProperty("offsetRepository", offsetRepository);
            return this;
        }
        /**
         * The class name of the partition assignment strategy that the client
         * will use to distribute partition ownership amongst consumer instances
         * when group management is used.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.clients.consumer.RangeAssignor
         * Group: consumer
         * 
         * @param partitionAssignor the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder partitionAssignor(
                java.lang.String partitionAssignor) {
            doSetProperty("partitionAssignor", partitionAssignor);
            return this;
        }
        /**
         * What to do if kafka threw an exception while polling for new
         * messages. Will by default use the value from the component
         * configuration unless an explicit value has been configured on the
         * endpoint level. DISCARD will discard the message and continue to poll
         * next message. ERROR_HANDLER will use Camel's error handler to process
         * the exception, and afterwards continue to poll next message.
         * RECONNECT will re-connect the consumer and try poll the message again
         * RETRY will let the consumer retry polling the same message again STOP
         * will stop the consumer (have to be manually started/restarted if the
         * consumer should be able to consume messages again).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.kafka.PollOnError&lt;/code&gt;
         * type.
         * 
         * Default: ERROR_HANDLER
         * Group: consumer
         * 
         * @param pollOnError the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder pollOnError(
                org.apache.camel.component.kafka.PollOnError pollOnError) {
            doSetProperty("pollOnError", pollOnError);
            return this;
        }
        /**
         * The timeout used when polling the KafkaConsumer.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param pollTimeoutMs the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder pollTimeoutMs(java.lang.Long pollTimeoutMs) {
            doSetProperty("pollTimeoutMs", pollTimeoutMs);
            return this;
        }
        /**
         * Set if KafkaConsumer will read from beginning or end on startup:
         * SeekPolicy.BEGINNING: read from beginning. SeekPolicy.END: read from
         * end.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.kafka.SeekPolicy&lt;/code&gt;
         * type.
         * 
         * Group: consumer
         * 
         * @param seekTo the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder seekTo(
                org.apache.camel.component.kafka.SeekPolicy seekTo) {
            doSetProperty("seekTo", seekTo);
            return this;
        }
        /**
         * The timeout used to detect failures when using Kafka's group
         * management facilities.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: consumer
         * 
         * @param sessionTimeoutMs the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder sessionTimeoutMs(
                java.lang.Integer sessionTimeoutMs) {
            doSetProperty("sessionTimeoutMs", sessionTimeoutMs);
            return this;
        }
        /**
         * This enables the use of a specific Avro reader for use with the
         * Confluent Platform schema registry and the
         * io.confluent.kafka.serializers.KafkaAvroDeserializer. This option is
         * only available in the Confluent Platform (not standard Apache Kafka).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param specificAvroReader the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder specificAvroReader(
                boolean specificAvroReader) {
            doSetProperty("specificAvroReader", specificAvroReader);
            return this;
        }
        /**
         * Whether the topic is a pattern (regular expression). This can be used
         * to subscribe to dynamic number of topics matching the pattern.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param topicIsPattern the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder topicIsPattern(boolean topicIsPattern) {
            doSetProperty("topicIsPattern", topicIsPattern);
            return this;
        }
        /**
         * Deserializer class for value that implements the Deserializer
         * interface.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.common.serialization.StringDeserializer
         * Group: consumer
         * 
         * @param valueDeserializer the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder valueDeserializer(
                java.lang.String valueDeserializer) {
            doSetProperty("valueDeserializer", valueDeserializer);
            return this;
        }
        /**
         * The delay in millis seconds to wait before trying again to create the
         * kafka consumer (kafka-client).
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer (advanced)
         * 
         * @param createConsumerBackoffInterval the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder createConsumerBackoffInterval(
                long createConsumerBackoffInterval) {
            doSetProperty("createConsumerBackoffInterval", createConsumerBackoffInterval);
            return this;
        }
        /**
         * Maximum attempts to create the kafka consumer (kafka-client), before
         * eventually giving up and failing. Error during creating the consumer
         * may be fatal due to invalid configuration and as such recovery is not
         * possible. However, one part of the validation is DNS resolution of
         * the bootstrap broker hostnames. This may be a temporary networking
         * problem, and could potentially be recoverable. While other errors are
         * fatal such as some invalid kafka configurations. Unfortunately
         * kafka-client does not separate this kind of errors. Camel will by
         * default retry forever, and therefore never give up. If you want to
         * give up after many attempts then set this option and Camel will then
         * when giving up terminate the consumer. You can manually restart the
         * consumer by stopping and starting the route, to try again.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param createConsumerBackoffMaxAttempts the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder createConsumerBackoffMaxAttempts(
                int createConsumerBackoffMaxAttempts) {
            doSetProperty("createConsumerBackoffMaxAttempts", createConsumerBackoffMaxAttempts);
            return this;
        }
        /**
         * Controls how to read messages written transactionally. If set to
         * read_committed, consumer.poll() will only return transactional
         * messages which have been committed. If set to read_uncommitted (the
         * default), consumer.poll() will return all messages, even
         * transactional messages which have been aborted. Non-transactional
         * messages will be returned unconditionally in either mode. Messages
         * will always be returned in offset order. Hence, in read_committed
         * mode, consumer.poll() will only return messages up to the last stable
         * offset (LSO), which is the one less than the offset of the first open
         * transaction. In particular any messages appearing after messages
         * belonging to ongoing transactions will be withheld until the relevant
         * transaction has been completed. As a result, read_committed consumers
         * will not be able to read up to the high watermark when there are in
         * flight transactions. Further, when in read_committed the seekToEnd
         * method will return the LSO.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: read_uncommitted
         * Group: consumer (advanced)
         * 
         * @param isolationLevel the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder isolationLevel(
                java.lang.String isolationLevel) {
            doSetProperty("isolationLevel", isolationLevel);
            return this;
        }
        /**
         * Factory to use for creating KafkaManualCommit instances. This allows
         * to plugin a custom factory to create custom KafkaManualCommit
         * instances in case special logic is needed when doing manual commits
         * that deviates from the default implementation that comes out of the
         * box.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.kafka.consumer.KafkaManualCommitFactory&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param kafkaManualCommitFactory the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder kafkaManualCommitFactory(
                org.apache.camel.component.kafka.consumer.KafkaManualCommitFactory kafkaManualCommitFactory) {
            doSetProperty("kafkaManualCommitFactory", kafkaManualCommitFactory);
            return this;
        }
        /**
         * To use a custom strategy with the consumer to control how to handle
         * exceptions thrown from the Kafka broker while pooling messages.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.kafka.PollExceptionStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollExceptionStrategy the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder pollExceptionStrategy(
                org.apache.camel.component.kafka.PollExceptionStrategy pollExceptionStrategy) {
            doSetProperty("pollExceptionStrategy", pollExceptionStrategy);
            return this;
        }
        /**
         * The delay in millis seconds to wait before trying again to subscribe
         * to the kafka broker.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer (advanced)
         * 
         * @param subscribeConsumerBackoffInterval the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder subscribeConsumerBackoffInterval(
                long subscribeConsumerBackoffInterval) {
            doSetProperty("subscribeConsumerBackoffInterval", subscribeConsumerBackoffInterval);
            return this;
        }
        /**
         * Maximum number the kafka consumer will attempt to subscribe to the
         * kafka broker, before eventually giving up and failing. Error during
         * subscribing the consumer to the kafka topic could be temporary errors
         * due to network issues, and could potentially be recoverable. Camel
         * will by default retry forever, and therefore never give up. If you
         * want to give up after many attempts then set this option and Camel
         * will then when giving up terminate the consumer. You can manually
         * restart the consumer by stopping and starting the route, to try
         * again.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param subscribeConsumerBackoffMaxAttempts the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder subscribeConsumerBackoffMaxAttempts(
                int subscribeConsumerBackoffMaxAttempts) {
            doSetProperty("subscribeConsumerBackoffMaxAttempts", subscribeConsumerBackoffMaxAttempts);
            return this;
        }
        /**
         * If this feature is enabled and a single element of a batch is an
         * Exchange or Message, the producer will generate individual kafka
         * header values for it by using the batch Message to determine the
         * values. Normal behaviour consists in always using the same header
         * values (which are determined by the parent Exchange which contains
         * the Iterable or Iterator).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param batchWithIndividualHeaders the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder batchWithIndividualHeaders(
                boolean batchWithIndividualHeaders) {
            doSetProperty("batchWithIndividualHeaders", batchWithIndividualHeaders);
            return this;
        }
        /**
         * The total bytes of memory the producer can use to buffer records
         * waiting to be sent to the server. If records are sent faster than
         * they can be delivered to the server the producer will either block or
         * throw an exception based on the preference specified by
         * block.on.buffer.full.This setting should correspond roughly to the
         * total memory the producer will use, but is not a hard bound since not
         * all memory the producer uses is used for buffering. Some additional
         * memory will be used for compression (if compression is enabled) as
         * well as for maintaining in-flight requests.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 33554432
         * Group: producer
         * 
         * @param bufferMemorySize the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder bufferMemorySize(
                java.lang.Integer bufferMemorySize) {
            doSetProperty("bufferMemorySize", bufferMemorySize);
            return this;
        }
        /**
         * This parameter allows you to specify the compression codec for all
         * data generated by this producer. Valid values are none, gzip, snappy,
         * lz4 and zstd.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: none
         * Group: producer
         * 
         * @param compressionCodec the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder compressionCodec(
                java.lang.String compressionCodec) {
            doSetProperty("compressionCodec", compressionCodec);
            return this;
        }
        /**
         * Close idle connections after the number of milliseconds specified by
         * this config.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 540000
         * Group: producer
         * 
         * @param connectionMaxIdleMs the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder connectionMaxIdleMs(
                java.lang.Integer connectionMaxIdleMs) {
            doSetProperty("connectionMaxIdleMs", connectionMaxIdleMs);
            return this;
        }
        /**
         * An upper bound on the time to report success or failure after a call
         * to send() returns. This limits the total time that a record will be
         * delayed prior to sending, the time to await acknowledgement from the
         * broker (if expected), and the time allowed for retriable send
         * failures.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 120000
         * Group: producer
         * 
         * @param deliveryTimeoutMs the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder deliveryTimeoutMs(
                java.lang.Integer deliveryTimeoutMs) {
            doSetProperty("deliveryTimeoutMs", deliveryTimeoutMs);
            return this;
        }
        /**
         * When set to 'true', the producer will ensure that exactly one copy of
         * each message is written in the stream. If 'false', producer retries
         * due to broker failures, etc., may write duplicates of the retried
         * message in the stream. Note that enabling idempotence requires
         * max.in.flight.requests.per.connection to be less than or equal to 5
         * (with message ordering preserved for any allowable value), retries to
         * be greater than 0, and acks must be 'all'. Idempotence is enabled by
         * default if no conflicting configurations are set. If conflicting
         * configurations are set and idempotence is not explicitly enabled,
         * idempotence is disabled. If idempotence is explicitly enabled and
         * conflicting configurations are set, a ConfigException is thrown.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param enableIdempotence the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder enableIdempotence(
                boolean enableIdempotence) {
            doSetProperty("enableIdempotence", enableIdempotence);
            return this;
        }
        /**
         * To use a custom KafkaHeaderSerializer to serialize kafka headers
         * values.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.kafka.serde.KafkaHeaderSerializer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param headerSerializer the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder headerSerializer(
                org.apache.camel.component.kafka.serde.KafkaHeaderSerializer headerSerializer) {
            doSetProperty("headerSerializer", headerSerializer);
            return this;
        }
        /**
         * The record key (or null if no key is specified). If this option has
         * been configured then it take precedence over header
         * KafkaConstants#KEY.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder key(java.lang.String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * The serializer class for keys (defaults to the same as for messages
         * if nothing is given).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.common.serialization.StringSerializer
         * Group: producer
         * 
         * @param keySerializer the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder keySerializer(
                java.lang.String keySerializer) {
            doSetProperty("keySerializer", keySerializer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The producer groups together any records that arrive in between
         * request transmissions into a single batched request. Normally this
         * occurs only under load when records arrive faster than they can be
         * sent out. However in some circumstances the client may want to reduce
         * the number of requests even under moderate load. This setting
         * accomplishes this by adding a small amount of artificial delay that
         * is, rather than immediately sending out a record the producer will
         * wait for up to the given delay to allow other records to be sent so
         * that the sends can be batched together. This can be thought of as
         * analogous to Nagle's algorithm in TCP. This setting gives the upper
         * bound on the delay for batching: once we get batch.size worth of
         * records for a partition it will be sent immediately regardless of
         * this setting, however if we have fewer than this many bytes
         * accumulated for this partition we will 'linger' for the specified
         * time waiting for more records to show up. This setting defaults to 0
         * (i.e. no delay). Setting linger.ms=5, for example, would have the
         * effect of reducing the number of requests sent but would add up to
         * 5ms of latency to records sent in the absence of load.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: producer
         * 
         * @param lingerMs the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder lingerMs(java.lang.Integer lingerMs) {
            doSetProperty("lingerMs", lingerMs);
            return this;
        }
        /**
         * The configuration controls how long the KafkaProducer's send(),
         * partitionsFor(), initTransactions(), sendOffsetsToTransaction(),
         * commitTransaction() and abortTransaction() methods will block. For
         * send() this timeout bounds the total time waiting for both metadata
         * fetch and buffer allocation (blocking in the user-supplied
         * serializers or partitioner is not counted against this timeout). For
         * partitionsFor() this timeout bounds the time spent waiting for
         * metadata if it is unavailable. The transaction-related methods always
         * block, but may timeout if the transaction coordinator could not be
         * discovered or did not respond within the timeout.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: producer
         * 
         * @param maxBlockMs the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder maxBlockMs(java.lang.Integer maxBlockMs) {
            doSetProperty("maxBlockMs", maxBlockMs);
            return this;
        }
        /**
         * The maximum number of unacknowledged requests the client will send on
         * a single connection before blocking. Note that if this setting is set
         * to be greater than 1 and there are failed sends, there is a risk of
         * message re-ordering due to retries (i.e., if retries are enabled).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 5
         * Group: producer
         * 
         * @param maxInFlightRequest the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder maxInFlightRequest(
                java.lang.Integer maxInFlightRequest) {
            doSetProperty("maxInFlightRequest", maxInFlightRequest);
            return this;
        }
        /**
         * The maximum size of a request. This is also effectively a cap on the
         * maximum record size. Note that the server has its own cap on record
         * size which may be different from this. This setting will limit the
         * number of record batches the producer will send in a single request
         * to avoid sending huge requests.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: producer
         * 
         * @param maxRequestSize the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder maxRequestSize(
                java.lang.Integer maxRequestSize) {
            doSetProperty("maxRequestSize", maxRequestSize);
            return this;
        }
        /**
         * The period of time in milliseconds after which we force a refresh of
         * metadata even if we haven't seen any partition leadership changes to
         * proactively discover any new brokers or partitions.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 300000
         * Group: producer
         * 
         * @param metadataMaxAgeMs the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder metadataMaxAgeMs(
                java.lang.Integer metadataMaxAgeMs) {
            doSetProperty("metadataMaxAgeMs", metadataMaxAgeMs);
            return this;
        }
        /**
         * A list of classes to use as metrics reporters. Implementing the
         * MetricReporter interface allows plugging in classes that will be
         * notified of new metric creation. The JmxReporter is always included
         * to register JMX statistics.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param metricReporters the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder metricReporters(
                java.lang.String metricReporters) {
            doSetProperty("metricReporters", metricReporters);
            return this;
        }
        /**
         * The window of time a metrics sample is computed over.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: producer
         * 
         * @param metricsSampleWindowMs the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder metricsSampleWindowMs(
                java.lang.Integer metricsSampleWindowMs) {
            doSetProperty("metricsSampleWindowMs", metricsSampleWindowMs);
            return this;
        }
        /**
         * The number of samples maintained to compute metrics.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: producer
         * 
         * @param noOfMetricsSample the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder noOfMetricsSample(
                java.lang.Integer noOfMetricsSample) {
            doSetProperty("noOfMetricsSample", noOfMetricsSample);
            return this;
        }
        /**
         * The partitioner class for partitioning messages amongst sub-topics.
         * The default partitioner is based on the hash of the key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default:
         * org.apache.kafka.clients.producer.internals.DefaultPartitioner
         * Group: producer
         * 
         * @param partitioner the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder partitioner(java.lang.String partitioner) {
            doSetProperty("partitioner", partitioner);
            return this;
        }
        /**
         * The partition to which the record will be sent (or null if no
         * partition was specified). If this option has been configured then it
         * take precedence over header KafkaConstants#PARTITION_KEY.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param partitionKey the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder partitionKey(
                java.lang.Integer partitionKey) {
            doSetProperty("partitionKey", partitionKey);
            return this;
        }
        /**
         * The producer will attempt to batch records together into fewer
         * requests whenever multiple records are being sent to the same
         * partition. This helps performance on both the client and the server.
         * This configuration controls the default batch size in bytes. No
         * attempt will be made to batch records larger than this size.Requests
         * sent to brokers will contain multiple batches, one for each partition
         * with data available to be sent.A small batch size will make batching
         * less common and may reduce throughput (a batch size of zero will
         * disable batching entirely). A very large batch size may use memory a
         * bit more wastefully as we will always allocate a buffer of the
         * specified batch size in anticipation of additional records.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 16384
         * Group: producer
         * 
         * @param producerBatchSize the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder producerBatchSize(
                java.lang.Integer producerBatchSize) {
            doSetProperty("producerBatchSize", producerBatchSize);
            return this;
        }
        /**
         * The maximum number of unsent messages that can be queued up the
         * producer when using async mode before either the producer must be
         * blocked or data must be dropped.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: producer
         * 
         * @param queueBufferingMaxMessages the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder queueBufferingMaxMessages(
                java.lang.Integer queueBufferingMaxMessages) {
            doSetProperty("queueBufferingMaxMessages", queueBufferingMaxMessages);
            return this;
        }
        /**
         * The size of the TCP receive buffer (SO_RCVBUF) to use when reading
         * data.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: producer
         * 
         * @param receiveBufferBytes the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder receiveBufferBytes(
                java.lang.Integer receiveBufferBytes) {
            doSetProperty("receiveBufferBytes", receiveBufferBytes);
            return this;
        }
        /**
         * The amount of time to wait before attempting to reconnect to a given
         * host. This avoids repeatedly connecting to a host in a tight loop.
         * This backoff applies to all requests sent by the consumer to the
         * broker.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 50
         * Group: producer
         * 
         * @param reconnectBackoffMs the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder reconnectBackoffMs(
                java.lang.Integer reconnectBackoffMs) {
            doSetProperty("reconnectBackoffMs", reconnectBackoffMs);
            return this;
        }
        /**
         * Whether the producer should store the RecordMetadata results from
         * sending to Kafka. The results are stored in a List containing the
         * RecordMetadata metadata's. The list is stored on a header with the
         * key KafkaConstants#KAFKA_RECORDMETA.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param recordMetadata the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder recordMetadata(boolean recordMetadata) {
            doSetProperty("recordMetadata", recordMetadata);
            return this;
        }
        /**
         * The number of acknowledgments the producer requires the leader to
         * have received before considering a request complete. This controls
         * the durability of records that are sent. The following settings are
         * allowed: acks=0 If set to zero then the producer will not wait for
         * any acknowledgment from the server at all. The record will be
         * immediately added to the socket buffer and considered sent. No
         * guarantee can be made that the server has received the record in this
         * case, and the retries configuration will not take effect (as the
         * client won't generally know of any failures). The offset given back
         * for each record will always be set to -1. acks=1 This will mean the
         * leader will write the record to its local log but will respond
         * without awaiting full acknowledgement from all followers. In this
         * case should the leader fail immediately after acknowledging the
         * record but before the followers have replicated it then the record
         * will be lost. acks=all This means the leader will wait for the full
         * set of in-sync replicas to acknowledge the record. This guarantees
         * that the record will not be lost as long as at least one in-sync
         * replica remains alive. This is the strongest available guarantee.
         * This is equivalent to the acks=-1 setting. Note that enabling
         * idempotence requires this config value to be 'all'. If conflicting
         * configurations are set and idempotence is not explicitly enabled,
         * idempotence is disabled.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: all
         * Group: producer
         * 
         * @param requestRequiredAcks the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder requestRequiredAcks(
                java.lang.String requestRequiredAcks) {
            doSetProperty("requestRequiredAcks", requestRequiredAcks);
            return this;
        }
        /**
         * The amount of time the broker will wait trying to meet the
         * request.required.acks requirement before sending back an error to the
         * client.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: producer
         * 
         * @param requestTimeoutMs the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder requestTimeoutMs(
                java.lang.Integer requestTimeoutMs) {
            doSetProperty("requestTimeoutMs", requestTimeoutMs);
            return this;
        }
        /**
         * Setting a value greater than zero will cause the client to resend any
         * record whose send fails with a potentially transient error. Note that
         * this retry is no different than if the client resent the record upon
         * receiving the error. Produce requests will be failed before the
         * number of retries has been exhausted if the timeout configured by
         * delivery.timeout.ms expires first before successful acknowledgement.
         * Users should generally prefer to leave this config unset and instead
         * use delivery.timeout.ms to control retry behavior. Enabling
         * idempotence requires this config value to be greater than 0. If
         * conflicting configurations are set and idempotence is not explicitly
         * enabled, idempotence is disabled. Allowing retries while setting
         * enable.idempotence to false and max.in.flight.requests.per.connection
         * to 1 will potentially change the ordering of records because if two
         * batches are sent to a single partition, and the first fails and is
         * retried but the second succeeds, then the records in the second batch
         * may appear first.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param retries the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder retries(java.lang.Integer retries) {
            doSetProperty("retries", retries);
            return this;
        }
        /**
         * Before each retry, the producer refreshes the metadata of relevant
         * topics to see if a new leader has been elected. Since leader election
         * takes a bit of time, this property specifies the amount of time that
         * the producer waits before refreshing the metadata.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: producer
         * 
         * @param retryBackoffMs the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder retryBackoffMs(
                java.lang.Integer retryBackoffMs) {
            doSetProperty("retryBackoffMs", retryBackoffMs);
            return this;
        }
        /**
         * Socket write buffer size.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 131072
         * Group: producer
         * 
         * @param sendBufferBytes the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder sendBufferBytes(
                java.lang.Integer sendBufferBytes) {
            doSetProperty("sendBufferBytes", sendBufferBytes);
            return this;
        }
        /**
         * The serializer class for messages.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.common.serialization.StringSerializer
         * Group: producer
         * 
         * @param valueSerializer the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder valueSerializer(
                java.lang.String valueSerializer) {
            doSetProperty("valueSerializer", valueSerializer);
            return this;
        }
        /**
         * To use a custom worker pool for continue routing Exchange after kafka
         * server has acknowledge the message that was sent to it from
         * KafkaProducer using asynchronous non-blocking processing. If using
         * this option then you must handle the lifecycle of the thread pool to
         * shut the pool down when no longer needed.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ExecutorService&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param workerPool the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder workerPool(
                java.util.concurrent.ExecutorService workerPool) {
            doSetProperty("workerPool", workerPool);
            return this;
        }
        /**
         * Number of core threads for the worker pool for continue routing
         * Exchange after kafka server has acknowledge the message that was sent
         * to it from KafkaProducer using asynchronous non-blocking processing.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: producer
         * 
         * @param workerPoolCoreSize the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder workerPoolCoreSize(
                java.lang.Integer workerPoolCoreSize) {
            doSetProperty("workerPoolCoreSize", workerPoolCoreSize);
            return this;
        }
        /**
         * Maximum number of threads for the worker pool for continue routing
         * Exchange after kafka server has acknowledge the message that was sent
         * to it from KafkaProducer using asynchronous non-blocking processing.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 20
         * Group: producer
         * 
         * @param workerPoolMaxSize the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder workerPoolMaxSize(
                java.lang.Integer workerPoolMaxSize) {
            doSetProperty("workerPoolMaxSize", workerPoolMaxSize);
            return this;
        }
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
        /**
         * Factory to use for creating
         * org.apache.kafka.clients.consumer.KafkaConsumer and
         * org.apache.kafka.clients.producer.KafkaProducer instances. This
         * allows to configure a custom factory to create instances with logic
         * that extends the vanilla Kafka clients.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.kafka.KafkaClientFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param kafkaClientFactory the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder kafkaClientFactory(
                org.apache.camel.component.kafka.KafkaClientFactory kafkaClientFactory) {
            doSetProperty("kafkaClientFactory", kafkaClientFactory);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * URL of the Confluent Platform schema registry servers to use. The
         * format is host1:port1,host2:port2. This is known as
         * schema.registry.url in the Confluent Platform documentation. This
         * option is only available in the Confluent Platform (not standard
         * Apache Kafka).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: confluent
         * 
         * @param schemaRegistryURL the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder schemaRegistryURL(
                java.lang.String schemaRegistryURL) {
            doSetProperty("schemaRegistryURL", schemaRegistryURL);
            return this;
        }
        /**
         * Sets interceptors for producer or consumers. Producer interceptors
         * have to be classes implementing
         * org.apache.kafka.clients.producer.ProducerInterceptor Consumer
         * interceptors have to be classes implementing
         * org.apache.kafka.clients.consumer.ConsumerInterceptor Note that if
         * you use Producer interceptor on a consumer it will throw a class cast
         * exception in runtime.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: monitoring
         * 
         * @param interceptorClasses the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder interceptorClasses(
                java.lang.String interceptorClasses) {
            doSetProperty("interceptorClasses", interceptorClasses);
            return this;
        }
        /**
         * Login thread sleep time between refresh attempts.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: security
         * 
         * @param kerberosBeforeReloginMinTime the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder kerberosBeforeReloginMinTime(
                java.lang.Integer kerberosBeforeReloginMinTime) {
            doSetProperty("kerberosBeforeReloginMinTime", kerberosBeforeReloginMinTime);
            return this;
        }
        /**
         * Kerberos kinit command path. Default is /usr/bin/kinit.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: /usr/bin/kinit
         * Group: security
         * 
         * @param kerberosInitCmd the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder kerberosInitCmd(
                java.lang.String kerberosInitCmd) {
            doSetProperty("kerberosInitCmd", kerberosInitCmd);
            return this;
        }
        /**
         * A list of rules for mapping from principal names to short names
         * (typically operating system usernames). The rules are evaluated in
         * order and the first rule that matches a principal name is used to map
         * it to a short name. Any later rules in the list are ignored. By
         * default, principal names of the form {username}/{hostname}{REALM} are
         * mapped to {username}. For more details on the format please see the
         * security authorization and acls documentation (at the Apache Kafka
         * project). Multiple values can be separated by comma.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: DEFAULT
         * Group: security
         * 
         * @param kerberosPrincipalToLocalRules the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder kerberosPrincipalToLocalRules(
                java.lang.String kerberosPrincipalToLocalRules) {
            doSetProperty("kerberosPrincipalToLocalRules", kerberosPrincipalToLocalRules);
            return this;
        }
        /**
         * Percentage of random jitter added to the renewal time.
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 0.05
         * Group: security
         * 
         * @param kerberosRenewJitter the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder kerberosRenewJitter(
                java.lang.Double kerberosRenewJitter) {
            doSetProperty("kerberosRenewJitter", kerberosRenewJitter);
            return this;
        }
        /**
         * Login thread will sleep until the specified window factor of time
         * from last refresh to ticket's expiry has been reached, at which time
         * it will try to renew the ticket.
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 0.8
         * Group: security
         * 
         * @param kerberosRenewWindowFactor the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder kerberosRenewWindowFactor(
                java.lang.Double kerberosRenewWindowFactor) {
            doSetProperty("kerberosRenewWindowFactor", kerberosRenewWindowFactor);
            return this;
        }
        /**
         * Expose the kafka sasl.jaas.config parameter Example:
         * org.apache.kafka.common.security.plain.PlainLoginModule required
         * username=USERNAME password=PASSWORD;.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param saslJaasConfig the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder saslJaasConfig(
                java.lang.String saslJaasConfig) {
            doSetProperty("saslJaasConfig", saslJaasConfig);
            return this;
        }
        /**
         * The Kerberos principal name that Kafka runs as. This can be defined
         * either in Kafka's JAAS config or in Kafka's config.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param saslKerberosServiceName the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder saslKerberosServiceName(
                java.lang.String saslKerberosServiceName) {
            doSetProperty("saslKerberosServiceName", saslKerberosServiceName);
            return this;
        }
        /**
         * The Simple Authentication and Security Layer (SASL) Mechanism used.
         * For the valid values see
         * http://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: GSSAPI
         * Group: security
         * 
         * @param saslMechanism the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder saslMechanism(
                java.lang.String saslMechanism) {
            doSetProperty("saslMechanism", saslMechanism);
            return this;
        }
        /**
         * Protocol used to communicate with brokers. SASL_PLAINTEXT, PLAINTEXT,
         * SASL_SSL and SSL are supported.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: PLAINTEXT
         * Group: security
         * 
         * @param securityProtocol the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder securityProtocol(
                java.lang.String securityProtocol) {
            doSetProperty("securityProtocol", securityProtocol);
            return this;
        }
        /**
         * A list of cipher suites. This is a named combination of
         * authentication, encryption, MAC and key exchange algorithm used to
         * negotiate the security settings for a network connection using TLS or
         * SSL network protocol. By default all the available cipher suites are
         * supported.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslCipherSuites the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder sslCipherSuites(
                java.lang.String sslCipherSuites) {
            doSetProperty("sslCipherSuites", sslCipherSuites);
            return this;
        }
        /**
         * SSL configuration using a Camel SSLContextParameters object. If
         * configured it's applied before the other SSL endpoint parameters.
         * NOTE: Kafka only supports loading keystore from file locations, so
         * prefix the location with file: in the KeyStoreParameters.resource
         * option.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * The list of protocols enabled for SSL connections. The default is
         * TLSv1.2,TLSv1.3 when running with Java 11 or newer, TLSv1.2
         * otherwise. With the default value for Java 11, clients and servers
         * will prefer TLSv1.3 if both support it and fallback to TLSv1.2
         * otherwise (assuming both support at least TLSv1.2). This default
         * should be fine for most cases. Also see the config documentation for
         * SslProtocol.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslEnabledProtocols the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder sslEnabledProtocols(
                java.lang.String sslEnabledProtocols) {
            doSetProperty("sslEnabledProtocols", sslEnabledProtocols);
            return this;
        }
        /**
         * The endpoint identification algorithm to validate server hostname
         * using server certificate. Use none or false to disable server
         * hostname verification.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https
         * Group: security
         * 
         * @param sslEndpointAlgorithm the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder sslEndpointAlgorithm(
                java.lang.String sslEndpointAlgorithm) {
            doSetProperty("sslEndpointAlgorithm", sslEndpointAlgorithm);
            return this;
        }
        /**
         * The algorithm used by key manager factory for SSL connections.
         * Default value is the key manager factory algorithm configured for the
         * Java Virtual Machine.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: SunX509
         * Group: security
         * 
         * @param sslKeymanagerAlgorithm the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder sslKeymanagerAlgorithm(
                java.lang.String sslKeymanagerAlgorithm) {
            doSetProperty("sslKeymanagerAlgorithm", sslKeymanagerAlgorithm);
            return this;
        }
        /**
         * The password of the private key in the key store file or the PEM key
         * specified in sslKeystoreKey. This is required for clients only if
         * two-way authentication is configured.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslKeyPassword the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder sslKeyPassword(
                java.lang.String sslKeyPassword) {
            doSetProperty("sslKeyPassword", sslKeyPassword);
            return this;
        }
        /**
         * The location of the key store file. This is optional for client and
         * can be used for two-way authentication for client.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslKeystoreLocation the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder sslKeystoreLocation(
                java.lang.String sslKeystoreLocation) {
            doSetProperty("sslKeystoreLocation", sslKeystoreLocation);
            return this;
        }
        /**
         * The store password for the key store file. This is optional for
         * client and only needed if sslKeystoreLocation' is configured. Key
         * store password is not supported for PEM format.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslKeystorePassword the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder sslKeystorePassword(
                java.lang.String sslKeystorePassword) {
            doSetProperty("sslKeystorePassword", sslKeystorePassword);
            return this;
        }
        /**
         * The file format of the key store file. This is optional for client.
         * Default value is JKS.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: JKS
         * Group: security
         * 
         * @param sslKeystoreType the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder sslKeystoreType(
                java.lang.String sslKeystoreType) {
            doSetProperty("sslKeystoreType", sslKeystoreType);
            return this;
        }
        /**
         * The SSL protocol used to generate the SSLContext. The default is
         * TLSv1.3 when running with Java 11 or newer, TLSv1.2 otherwise. This
         * value should be fine for most use cases. Allowed values in recent
         * JVMs are TLSv1.2 and TLSv1.3. TLS, TLSv1.1, SSL, SSLv2 and SSLv3 may
         * be supported in older JVMs, but their usage is discouraged due to
         * known security vulnerabilities. With the default value for this
         * config and sslEnabledProtocols, clients will downgrade to TLSv1.2 if
         * the server does not support TLSv1.3. If this config is set to
         * TLSv1.2, clients will not use TLSv1.3 even if it is one of the values
         * in sslEnabledProtocols and the server only supports TLSv1.3.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslProtocol the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder sslProtocol(java.lang.String sslProtocol) {
            doSetProperty("sslProtocol", sslProtocol);
            return this;
        }
        /**
         * The name of the security provider used for SSL connections. Default
         * value is the default security provider of the JVM.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslProvider the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder sslProvider(java.lang.String sslProvider) {
            doSetProperty("sslProvider", sslProvider);
            return this;
        }
        /**
         * The algorithm used by trust manager factory for SSL connections.
         * Default value is the trust manager factory algorithm configured for
         * the Java Virtual Machine.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: PKIX
         * Group: security
         * 
         * @param sslTrustmanagerAlgorithm the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder sslTrustmanagerAlgorithm(
                java.lang.String sslTrustmanagerAlgorithm) {
            doSetProperty("sslTrustmanagerAlgorithm", sslTrustmanagerAlgorithm);
            return this;
        }
        /**
         * The location of the trust store file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslTruststoreLocation the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder sslTruststoreLocation(
                java.lang.String sslTruststoreLocation) {
            doSetProperty("sslTruststoreLocation", sslTruststoreLocation);
            return this;
        }
        /**
         * The password for the trust store file. If a password is not set,
         * trust store file configured will still be used, but integrity
         * checking is disabled. Trust store password is not supported for PEM
         * format.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslTruststorePassword the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder sslTruststorePassword(
                java.lang.String sslTruststorePassword) {
            doSetProperty("sslTruststorePassword", sslTruststorePassword);
            return this;
        }
        /**
         * The file format of the trust store file. Default value is JKS.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: JKS
         * Group: security
         * 
         * @param sslTruststoreType the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder sslTruststoreType(
                java.lang.String sslTruststoreType) {
            doSetProperty("sslTruststoreType", sslTruststoreType);
            return this;
        }
        /**
         * Enable usage of global SSL context parameters.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useGlobalSslContextParameters the value to set
         * @return the dsl builder
         */
        default KafkaComponentBuilder useGlobalSslContextParameters(
                boolean useGlobalSslContextParameters) {
            doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    }

    class KafkaComponentBuilderImpl
            extends
                AbstractComponentBuilder<KafkaComponent>
            implements
                KafkaComponentBuilder {
        @Override
        protected KafkaComponent buildConcreteComponent() {
            return new KafkaComponent();
        }
        private org.apache.camel.component.kafka.KafkaConfiguration getOrCreateConfiguration(
                org.apache.camel.component.kafka.KafkaComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.kafka.KafkaConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "additionalProperties": getOrCreateConfiguration((KafkaComponent) component).setAdditionalProperties((java.util.Map) value); return true;
            case "brokers": getOrCreateConfiguration((KafkaComponent) component).setBrokers((java.lang.String) value); return true;
            case "clientId": getOrCreateConfiguration((KafkaComponent) component).setClientId((java.lang.String) value); return true;
            case "configuration": ((KafkaComponent) component).setConfiguration((org.apache.camel.component.kafka.KafkaConfiguration) value); return true;
            case "headerFilterStrategy": getOrCreateConfiguration((KafkaComponent) component).setHeaderFilterStrategy((org.apache.camel.spi.HeaderFilterStrategy) value); return true;
            case "reconnectBackoffMaxMs": getOrCreateConfiguration((KafkaComponent) component).setReconnectBackoffMaxMs((java.lang.Integer) value); return true;
            case "shutdownTimeout": getOrCreateConfiguration((KafkaComponent) component).setShutdownTimeout((int) value); return true;
            case "allowManualCommit": getOrCreateConfiguration((KafkaComponent) component).setAllowManualCommit((boolean) value); return true;
            case "autoCommitEnable": getOrCreateConfiguration((KafkaComponent) component).setAutoCommitEnable((boolean) value); return true;
            case "autoCommitIntervalMs": getOrCreateConfiguration((KafkaComponent) component).setAutoCommitIntervalMs((java.lang.Integer) value); return true;
            case "autoOffsetReset": getOrCreateConfiguration((KafkaComponent) component).setAutoOffsetReset((java.lang.String) value); return true;
            case "breakOnFirstError": getOrCreateConfiguration((KafkaComponent) component).setBreakOnFirstError((boolean) value); return true;
            case "bridgeErrorHandler": ((KafkaComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "checkCrcs": getOrCreateConfiguration((KafkaComponent) component).setCheckCrcs((java.lang.Boolean) value); return true;
            case "commitTimeoutMs": getOrCreateConfiguration((KafkaComponent) component).setCommitTimeoutMs((java.lang.Long) value); return true;
            case "consumerRequestTimeoutMs": getOrCreateConfiguration((KafkaComponent) component).setConsumerRequestTimeoutMs((java.lang.Integer) value); return true;
            case "consumersCount": getOrCreateConfiguration((KafkaComponent) component).setConsumersCount((int) value); return true;
            case "fetchMaxBytes": getOrCreateConfiguration((KafkaComponent) component).setFetchMaxBytes((java.lang.Integer) value); return true;
            case "fetchMinBytes": getOrCreateConfiguration((KafkaComponent) component).setFetchMinBytes((java.lang.Integer) value); return true;
            case "fetchWaitMaxMs": getOrCreateConfiguration((KafkaComponent) component).setFetchWaitMaxMs((java.lang.Integer) value); return true;
            case "groupId": getOrCreateConfiguration((KafkaComponent) component).setGroupId((java.lang.String) value); return true;
            case "groupInstanceId": getOrCreateConfiguration((KafkaComponent) component).setGroupInstanceId((java.lang.String) value); return true;
            case "headerDeserializer": getOrCreateConfiguration((KafkaComponent) component).setHeaderDeserializer((org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer) value); return true;
            case "heartbeatIntervalMs": getOrCreateConfiguration((KafkaComponent) component).setHeartbeatIntervalMs((java.lang.Integer) value); return true;
            case "keyDeserializer": getOrCreateConfiguration((KafkaComponent) component).setKeyDeserializer((java.lang.String) value); return true;
            case "maxPartitionFetchBytes": getOrCreateConfiguration((KafkaComponent) component).setMaxPartitionFetchBytes((java.lang.Integer) value); return true;
            case "maxPollIntervalMs": getOrCreateConfiguration((KafkaComponent) component).setMaxPollIntervalMs((java.lang.Long) value); return true;
            case "maxPollRecords": getOrCreateConfiguration((KafkaComponent) component).setMaxPollRecords((java.lang.Integer) value); return true;
            case "offsetRepository": getOrCreateConfiguration((KafkaComponent) component).setOffsetRepository((org.apache.camel.spi.StateRepository) value); return true;
            case "partitionAssignor": getOrCreateConfiguration((KafkaComponent) component).setPartitionAssignor((java.lang.String) value); return true;
            case "pollOnError": getOrCreateConfiguration((KafkaComponent) component).setPollOnError((org.apache.camel.component.kafka.PollOnError) value); return true;
            case "pollTimeoutMs": getOrCreateConfiguration((KafkaComponent) component).setPollTimeoutMs((java.lang.Long) value); return true;
            case "seekTo": getOrCreateConfiguration((KafkaComponent) component).setSeekTo((org.apache.camel.component.kafka.SeekPolicy) value); return true;
            case "sessionTimeoutMs": getOrCreateConfiguration((KafkaComponent) component).setSessionTimeoutMs((java.lang.Integer) value); return true;
            case "specificAvroReader": getOrCreateConfiguration((KafkaComponent) component).setSpecificAvroReader((boolean) value); return true;
            case "topicIsPattern": getOrCreateConfiguration((KafkaComponent) component).setTopicIsPattern((boolean) value); return true;
            case "valueDeserializer": getOrCreateConfiguration((KafkaComponent) component).setValueDeserializer((java.lang.String) value); return true;
            case "createConsumerBackoffInterval": ((KafkaComponent) component).setCreateConsumerBackoffInterval((long) value); return true;
            case "createConsumerBackoffMaxAttempts": ((KafkaComponent) component).setCreateConsumerBackoffMaxAttempts((int) value); return true;
            case "isolationLevel": getOrCreateConfiguration((KafkaComponent) component).setIsolationLevel((java.lang.String) value); return true;
            case "kafkaManualCommitFactory": ((KafkaComponent) component).setKafkaManualCommitFactory((org.apache.camel.component.kafka.consumer.KafkaManualCommitFactory) value); return true;
            case "pollExceptionStrategy": ((KafkaComponent) component).setPollExceptionStrategy((org.apache.camel.component.kafka.PollExceptionStrategy) value); return true;
            case "subscribeConsumerBackoffInterval": ((KafkaComponent) component).setSubscribeConsumerBackoffInterval((long) value); return true;
            case "subscribeConsumerBackoffMaxAttempts": ((KafkaComponent) component).setSubscribeConsumerBackoffMaxAttempts((int) value); return true;
            case "batchWithIndividualHeaders": getOrCreateConfiguration((KafkaComponent) component).setBatchWithIndividualHeaders((boolean) value); return true;
            case "bufferMemorySize": getOrCreateConfiguration((KafkaComponent) component).setBufferMemorySize((java.lang.Integer) value); return true;
            case "compressionCodec": getOrCreateConfiguration((KafkaComponent) component).setCompressionCodec((java.lang.String) value); return true;
            case "connectionMaxIdleMs": getOrCreateConfiguration((KafkaComponent) component).setConnectionMaxIdleMs((java.lang.Integer) value); return true;
            case "deliveryTimeoutMs": getOrCreateConfiguration((KafkaComponent) component).setDeliveryTimeoutMs((java.lang.Integer) value); return true;
            case "enableIdempotence": getOrCreateConfiguration((KafkaComponent) component).setEnableIdempotence((boolean) value); return true;
            case "headerSerializer": getOrCreateConfiguration((KafkaComponent) component).setHeaderSerializer((org.apache.camel.component.kafka.serde.KafkaHeaderSerializer) value); return true;
            case "key": getOrCreateConfiguration((KafkaComponent) component).setKey((java.lang.String) value); return true;
            case "keySerializer": getOrCreateConfiguration((KafkaComponent) component).setKeySerializer((java.lang.String) value); return true;
            case "lazyStartProducer": ((KafkaComponent) component).setLazyStartProducer((boolean) value); return true;
            case "lingerMs": getOrCreateConfiguration((KafkaComponent) component).setLingerMs((java.lang.Integer) value); return true;
            case "maxBlockMs": getOrCreateConfiguration((KafkaComponent) component).setMaxBlockMs((java.lang.Integer) value); return true;
            case "maxInFlightRequest": getOrCreateConfiguration((KafkaComponent) component).setMaxInFlightRequest((java.lang.Integer) value); return true;
            case "maxRequestSize": getOrCreateConfiguration((KafkaComponent) component).setMaxRequestSize((java.lang.Integer) value); return true;
            case "metadataMaxAgeMs": getOrCreateConfiguration((KafkaComponent) component).setMetadataMaxAgeMs((java.lang.Integer) value); return true;
            case "metricReporters": getOrCreateConfiguration((KafkaComponent) component).setMetricReporters((java.lang.String) value); return true;
            case "metricsSampleWindowMs": getOrCreateConfiguration((KafkaComponent) component).setMetricsSampleWindowMs((java.lang.Integer) value); return true;
            case "noOfMetricsSample": getOrCreateConfiguration((KafkaComponent) component).setNoOfMetricsSample((java.lang.Integer) value); return true;
            case "partitioner": getOrCreateConfiguration((KafkaComponent) component).setPartitioner((java.lang.String) value); return true;
            case "partitionKey": getOrCreateConfiguration((KafkaComponent) component).setPartitionKey((java.lang.Integer) value); return true;
            case "producerBatchSize": getOrCreateConfiguration((KafkaComponent) component).setProducerBatchSize((java.lang.Integer) value); return true;
            case "queueBufferingMaxMessages": getOrCreateConfiguration((KafkaComponent) component).setQueueBufferingMaxMessages((java.lang.Integer) value); return true;
            case "receiveBufferBytes": getOrCreateConfiguration((KafkaComponent) component).setReceiveBufferBytes((java.lang.Integer) value); return true;
            case "reconnectBackoffMs": getOrCreateConfiguration((KafkaComponent) component).setReconnectBackoffMs((java.lang.Integer) value); return true;
            case "recordMetadata": getOrCreateConfiguration((KafkaComponent) component).setRecordMetadata((boolean) value); return true;
            case "requestRequiredAcks": getOrCreateConfiguration((KafkaComponent) component).setRequestRequiredAcks((java.lang.String) value); return true;
            case "requestTimeoutMs": getOrCreateConfiguration((KafkaComponent) component).setRequestTimeoutMs((java.lang.Integer) value); return true;
            case "retries": getOrCreateConfiguration((KafkaComponent) component).setRetries((java.lang.Integer) value); return true;
            case "retryBackoffMs": getOrCreateConfiguration((KafkaComponent) component).setRetryBackoffMs((java.lang.Integer) value); return true;
            case "sendBufferBytes": getOrCreateConfiguration((KafkaComponent) component).setSendBufferBytes((java.lang.Integer) value); return true;
            case "valueSerializer": getOrCreateConfiguration((KafkaComponent) component).setValueSerializer((java.lang.String) value); return true;
            case "workerPool": getOrCreateConfiguration((KafkaComponent) component).setWorkerPool((java.util.concurrent.ExecutorService) value); return true;
            case "workerPoolCoreSize": getOrCreateConfiguration((KafkaComponent) component).setWorkerPoolCoreSize((java.lang.Integer) value); return true;
            case "workerPoolMaxSize": getOrCreateConfiguration((KafkaComponent) component).setWorkerPoolMaxSize((java.lang.Integer) value); return true;
            case "autowiredEnabled": ((KafkaComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "kafkaClientFactory": ((KafkaComponent) component).setKafkaClientFactory((org.apache.camel.component.kafka.KafkaClientFactory) value); return true;
            case "synchronous": getOrCreateConfiguration((KafkaComponent) component).setSynchronous((boolean) value); return true;
            case "schemaRegistryURL": getOrCreateConfiguration((KafkaComponent) component).setSchemaRegistryURL((java.lang.String) value); return true;
            case "interceptorClasses": getOrCreateConfiguration((KafkaComponent) component).setInterceptorClasses((java.lang.String) value); return true;
            case "kerberosBeforeReloginMinTime": getOrCreateConfiguration((KafkaComponent) component).setKerberosBeforeReloginMinTime((java.lang.Integer) value); return true;
            case "kerberosInitCmd": getOrCreateConfiguration((KafkaComponent) component).setKerberosInitCmd((java.lang.String) value); return true;
            case "kerberosPrincipalToLocalRules": getOrCreateConfiguration((KafkaComponent) component).setKerberosPrincipalToLocalRules((java.lang.String) value); return true;
            case "kerberosRenewJitter": getOrCreateConfiguration((KafkaComponent) component).setKerberosRenewJitter((java.lang.Double) value); return true;
            case "kerberosRenewWindowFactor": getOrCreateConfiguration((KafkaComponent) component).setKerberosRenewWindowFactor((java.lang.Double) value); return true;
            case "saslJaasConfig": getOrCreateConfiguration((KafkaComponent) component).setSaslJaasConfig((java.lang.String) value); return true;
            case "saslKerberosServiceName": getOrCreateConfiguration((KafkaComponent) component).setSaslKerberosServiceName((java.lang.String) value); return true;
            case "saslMechanism": getOrCreateConfiguration((KafkaComponent) component).setSaslMechanism((java.lang.String) value); return true;
            case "securityProtocol": getOrCreateConfiguration((KafkaComponent) component).setSecurityProtocol((java.lang.String) value); return true;
            case "sslCipherSuites": getOrCreateConfiguration((KafkaComponent) component).setSslCipherSuites((java.lang.String) value); return true;
            case "sslContextParameters": getOrCreateConfiguration((KafkaComponent) component).setSslContextParameters((org.apache.camel.support.jsse.SSLContextParameters) value); return true;
            case "sslEnabledProtocols": getOrCreateConfiguration((KafkaComponent) component).setSslEnabledProtocols((java.lang.String) value); return true;
            case "sslEndpointAlgorithm": getOrCreateConfiguration((KafkaComponent) component).setSslEndpointAlgorithm((java.lang.String) value); return true;
            case "sslKeymanagerAlgorithm": getOrCreateConfiguration((KafkaComponent) component).setSslKeymanagerAlgorithm((java.lang.String) value); return true;
            case "sslKeyPassword": getOrCreateConfiguration((KafkaComponent) component).setSslKeyPassword((java.lang.String) value); return true;
            case "sslKeystoreLocation": getOrCreateConfiguration((KafkaComponent) component).setSslKeystoreLocation((java.lang.String) value); return true;
            case "sslKeystorePassword": getOrCreateConfiguration((KafkaComponent) component).setSslKeystorePassword((java.lang.String) value); return true;
            case "sslKeystoreType": getOrCreateConfiguration((KafkaComponent) component).setSslKeystoreType((java.lang.String) value); return true;
            case "sslProtocol": getOrCreateConfiguration((KafkaComponent) component).setSslProtocol((java.lang.String) value); return true;
            case "sslProvider": getOrCreateConfiguration((KafkaComponent) component).setSslProvider((java.lang.String) value); return true;
            case "sslTrustmanagerAlgorithm": getOrCreateConfiguration((KafkaComponent) component).setSslTrustmanagerAlgorithm((java.lang.String) value); return true;
            case "sslTruststoreLocation": getOrCreateConfiguration((KafkaComponent) component).setSslTruststoreLocation((java.lang.String) value); return true;
            case "sslTruststorePassword": getOrCreateConfiguration((KafkaComponent) component).setSslTruststorePassword((java.lang.String) value); return true;
            case "sslTruststoreType": getOrCreateConfiguration((KafkaComponent) component).setSslTruststoreType((java.lang.String) value); return true;
            case "useGlobalSslContextParameters": ((KafkaComponent) component).setUseGlobalSslContextParameters((boolean) value); return true;
            default: return false;
            }
        }
    }
}