/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.facebook.FacebookComponent;

/**
 * Send requests to Facebook APIs supported by Facebook4J.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface FacebookComponentBuilderFactory {

    /**
     * Facebook (camel-facebook)
     * Send requests to Facebook APIs supported by Facebook4J.
     * 
     * Category: social
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-facebook
     * 
     * @return the dsl builder
     */
    static FacebookComponentBuilder facebook() {
        return new FacebookComponentBuilderImpl();
    }

    /**
     * Builder for the Facebook component.
     */
    interface FacebookComponentBuilder
            extends
                ComponentBuilder<FacebookComponent> {
        /**
         * Facebook4J API client URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientURL the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder clientURL(java.lang.String clientURL) {
            doSetProperty("clientURL", clientURL);
            return this;
        }
        /**
         * Facebook4J client API version.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientVersion the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder clientVersion(
                java.lang.String clientVersion) {
            doSetProperty("clientVersion", clientVersion);
            return this;
        }
        /**
         * Enables deubg output. Effective only with the embedded logger.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param debugEnabled the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder debugEnabled(
                java.lang.Boolean debugEnabled) {
            doSetProperty("debugEnabled", debugEnabled);
            return this;
        }
        /**
         * Use Facebook GZIP encoding.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param gzipEnabled the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder gzipEnabled(
                java.lang.Boolean gzipEnabled) {
            doSetProperty("gzipEnabled", gzipEnabled);
            return this;
        }
        /**
         * Http connection timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: common
         * 
         * @param httpConnectionTimeout the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder httpConnectionTimeout(
                java.lang.Integer httpConnectionTimeout) {
            doSetProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * HTTP maximum connections per route.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param httpDefaultMaxPerRoute the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder httpDefaultMaxPerRoute(
                java.lang.Integer httpDefaultMaxPerRoute) {
            doSetProperty("httpDefaultMaxPerRoute", httpDefaultMaxPerRoute);
            return this;
        }
        /**
         * HTTP maximum total connections.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 20
         * Group: common
         * 
         * @param httpMaxTotalConnections the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder httpMaxTotalConnections(
                java.lang.Integer httpMaxTotalConnections) {
            doSetProperty("httpMaxTotalConnections", httpMaxTotalConnections);
            return this;
        }
        /**
         * Http read timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 120000
         * Group: common
         * 
         * @param httpReadTimeout the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder httpReadTimeout(
                java.lang.Integer httpReadTimeout) {
            doSetProperty("httpReadTimeout", httpReadTimeout);
            return this;
        }
        /**
         * Number of HTTP retries.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param httpRetryCount the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder httpRetryCount(
                java.lang.Integer httpRetryCount) {
            doSetProperty("httpRetryCount", httpRetryCount);
            return this;
        }
        /**
         * HTTP retry interval in seconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 5
         * Group: common
         * 
         * @param httpRetryIntervalSeconds the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder httpRetryIntervalSeconds(
                java.lang.Integer httpRetryIntervalSeconds) {
            doSetProperty("httpRetryIntervalSeconds", httpRetryIntervalSeconds);
            return this;
        }
        /**
         * HTTP streaming read timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 40000
         * Group: common
         * 
         * @param httpStreamingReadTimeout the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder httpStreamingReadTimeout(
                java.lang.Integer httpStreamingReadTimeout) {
            doSetProperty("httpStreamingReadTimeout", httpStreamingReadTimeout);
            return this;
        }
        /**
         * If set to true, raw JSON forms will be stored in DataObjectFactory.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param jsonStoreEnabled the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder jsonStoreEnabled(
                java.lang.Boolean jsonStoreEnabled) {
            doSetProperty("jsonStoreEnabled", jsonStoreEnabled);
            return this;
        }
        /**
         * If set to true, Facebook4J mbean will be registerd.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param mbeanEnabled the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder mbeanEnabled(
                java.lang.Boolean mbeanEnabled) {
            doSetProperty("mbeanEnabled", mbeanEnabled);
            return this;
        }
        /**
         * Prettify JSON debug output if set to true.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param prettyDebugEnabled the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder prettyDebugEnabled(
                java.lang.Boolean prettyDebugEnabled) {
            doSetProperty("prettyDebugEnabled", prettyDebugEnabled);
            return this;
        }
        /**
         * API base URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://graph.facebook.com/
         * Group: common
         * 
         * @param restBaseURL the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder restBaseURL(
                java.lang.String restBaseURL) {
            doSetProperty("restBaseURL", restBaseURL);
            return this;
        }
        /**
         * Use SSL.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param useSSL the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder useSSL(java.lang.Boolean useSSL) {
            doSetProperty("useSSL", useSSL);
            return this;
        }
        /**
         * Video API base URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://graph-video.facebook.com/
         * Group: common
         * 
         * @param videoBaseURL the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder videoBaseURL(
                java.lang.String videoBaseURL) {
            doSetProperty("videoBaseURL", videoBaseURL);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder autowiredEnabled(
                boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
        /**
         * To use the shared configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.facebook.config.FacebookConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder configuration(
                org.apache.camel.component.facebook.config.FacebookConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * HTTP proxy server host name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyHost the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder httpProxyHost(
                java.lang.String httpProxyHost) {
            doSetProperty("httpProxyHost", httpProxyHost);
            return this;
        }
        /**
         * HTTP proxy server password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyPassword the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder httpProxyPassword(
                java.lang.String httpProxyPassword) {
            doSetProperty("httpProxyPassword", httpProxyPassword);
            return this;
        }
        /**
         * HTTP proxy server port.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyPort the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder httpProxyPort(
                java.lang.Integer httpProxyPort) {
            doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * HTTP proxy server user name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyUser the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder httpProxyUser(
                java.lang.String httpProxyUser) {
            doSetProperty("httpProxyUser", httpProxyUser);
            return this;
        }
        /**
         * The user access token.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oAuthAccessToken the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder oAuthAccessToken(
                java.lang.String oAuthAccessToken) {
            doSetProperty("oAuthAccessToken", oAuthAccessToken);
            return this;
        }
        /**
         * OAuth access token URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://graph.facebook.com/oauth/access_token
         * Group: security
         * 
         * @param oAuthAccessTokenURL the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder oAuthAccessTokenURL(
                java.lang.String oAuthAccessTokenURL) {
            doSetProperty("oAuthAccessTokenURL", oAuthAccessTokenURL);
            return this;
        }
        /**
         * The application Id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oAuthAppId the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder oAuthAppId(java.lang.String oAuthAppId) {
            doSetProperty("oAuthAppId", oAuthAppId);
            return this;
        }
        /**
         * The application Secret.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oAuthAppSecret the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder oAuthAppSecret(
                java.lang.String oAuthAppSecret) {
            doSetProperty("oAuthAppSecret", oAuthAppSecret);
            return this;
        }
        /**
         * OAuth authorization URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://www.facebook.com/dialog/oauth
         * Group: security
         * 
         * @param oAuthAuthorizationURL the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder oAuthAuthorizationURL(
                java.lang.String oAuthAuthorizationURL) {
            doSetProperty("oAuthAuthorizationURL", oAuthAuthorizationURL);
            return this;
        }
        /**
         * Default OAuth permissions. Comma separated permission names. See
         * https://developers.facebook.com/docs/reference/login/#permissions for
         * the detail.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oAuthPermissions the value to set
         * @return the dsl builder
         */
        default FacebookComponentBuilder oAuthPermissions(
                java.lang.String oAuthPermissions) {
            doSetProperty("oAuthPermissions", oAuthPermissions);
            return this;
        }
    }

    class FacebookComponentBuilderImpl
            extends
                AbstractComponentBuilder<FacebookComponent>
            implements
                FacebookComponentBuilder {
        @Override
        protected FacebookComponent buildConcreteComponent() {
            return new FacebookComponent();
        }
        private org.apache.camel.component.facebook.config.FacebookConfiguration getOrCreateConfiguration(
                org.apache.camel.component.facebook.FacebookComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.facebook.config.FacebookConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "clientURL": getOrCreateConfiguration((FacebookComponent) component).setClientURL((java.lang.String) value); return true;
            case "clientVersion": getOrCreateConfiguration((FacebookComponent) component).setClientVersion((java.lang.String) value); return true;
            case "debugEnabled": getOrCreateConfiguration((FacebookComponent) component).setDebugEnabled((java.lang.Boolean) value); return true;
            case "gzipEnabled": getOrCreateConfiguration((FacebookComponent) component).setGzipEnabled((java.lang.Boolean) value); return true;
            case "httpConnectionTimeout": getOrCreateConfiguration((FacebookComponent) component).setHttpConnectionTimeout((java.lang.Integer) value); return true;
            case "httpDefaultMaxPerRoute": getOrCreateConfiguration((FacebookComponent) component).setHttpDefaultMaxPerRoute((java.lang.Integer) value); return true;
            case "httpMaxTotalConnections": getOrCreateConfiguration((FacebookComponent) component).setHttpMaxTotalConnections((java.lang.Integer) value); return true;
            case "httpReadTimeout": getOrCreateConfiguration((FacebookComponent) component).setHttpReadTimeout((java.lang.Integer) value); return true;
            case "httpRetryCount": getOrCreateConfiguration((FacebookComponent) component).setHttpRetryCount((java.lang.Integer) value); return true;
            case "httpRetryIntervalSeconds": getOrCreateConfiguration((FacebookComponent) component).setHttpRetryIntervalSeconds((java.lang.Integer) value); return true;
            case "httpStreamingReadTimeout": getOrCreateConfiguration((FacebookComponent) component).setHttpStreamingReadTimeout((java.lang.Integer) value); return true;
            case "jsonStoreEnabled": getOrCreateConfiguration((FacebookComponent) component).setJsonStoreEnabled((java.lang.Boolean) value); return true;
            case "mbeanEnabled": getOrCreateConfiguration((FacebookComponent) component).setMbeanEnabled((java.lang.Boolean) value); return true;
            case "prettyDebugEnabled": getOrCreateConfiguration((FacebookComponent) component).setPrettyDebugEnabled((java.lang.Boolean) value); return true;
            case "restBaseURL": getOrCreateConfiguration((FacebookComponent) component).setRestBaseURL((java.lang.String) value); return true;
            case "useSSL": getOrCreateConfiguration((FacebookComponent) component).setUseSSL((java.lang.Boolean) value); return true;
            case "videoBaseURL": getOrCreateConfiguration((FacebookComponent) component).setVideoBaseURL((java.lang.String) value); return true;
            case "bridgeErrorHandler": ((FacebookComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "lazyStartProducer": ((FacebookComponent) component).setLazyStartProducer((boolean) value); return true;
            case "autowiredEnabled": ((FacebookComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "configuration": ((FacebookComponent) component).setConfiguration((org.apache.camel.component.facebook.config.FacebookConfiguration) value); return true;
            case "httpProxyHost": getOrCreateConfiguration((FacebookComponent) component).setHttpProxyHost((java.lang.String) value); return true;
            case "httpProxyPassword": getOrCreateConfiguration((FacebookComponent) component).setHttpProxyPassword((java.lang.String) value); return true;
            case "httpProxyPort": getOrCreateConfiguration((FacebookComponent) component).setHttpProxyPort((java.lang.Integer) value); return true;
            case "httpProxyUser": getOrCreateConfiguration((FacebookComponent) component).setHttpProxyUser((java.lang.String) value); return true;
            case "oAuthAccessToken": getOrCreateConfiguration((FacebookComponent) component).setOAuthAccessToken((java.lang.String) value); return true;
            case "oAuthAccessTokenURL": getOrCreateConfiguration((FacebookComponent) component).setOAuthAccessTokenURL((java.lang.String) value); return true;
            case "oAuthAppId": getOrCreateConfiguration((FacebookComponent) component).setOAuthAppId((java.lang.String) value); return true;
            case "oAuthAppSecret": getOrCreateConfiguration((FacebookComponent) component).setOAuthAppSecret((java.lang.String) value); return true;
            case "oAuthAuthorizationURL": getOrCreateConfiguration((FacebookComponent) component).setOAuthAuthorizationURL((java.lang.String) value); return true;
            case "oAuthPermissions": getOrCreateConfiguration((FacebookComponent) component).setOAuthPermissions((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}