/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.milo.browse.MiloBrowseComponent;
import org.apache.camel.component.milo.client.MiloClientConfiguration;
import org.apache.camel.component.milo.client.MiloClientConnectionManager;

public interface MiloBrowseComponentBuilderFactory {
    public static MiloBrowseComponentBuilder miloBrowse() {
        return new MiloBrowseComponentBuilderImpl();
    }

    public static class MiloBrowseComponentBuilderImpl
    extends AbstractComponentBuilder<MiloBrowseComponent>
    implements MiloBrowseComponentBuilder {
        @Override
        protected MiloBrowseComponent buildConcreteComponent() {
            return new MiloBrowseComponent();
        }

        private MiloClientConfiguration getOrCreateConfiguration(MiloBrowseComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new MiloClientConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "clientId": {
                    this.getOrCreateConfiguration((MiloBrowseComponent)component).setClientId((String)value);
                    return true;
                }
                case "configuration": {
                    ((MiloBrowseComponent)component).setConfiguration((MiloClientConfiguration)value);
                    return true;
                }
                case "discoveryEndpointSuffix": {
                    this.getOrCreateConfiguration((MiloBrowseComponent)component).setDiscoveryEndpointSuffix((String)value);
                    return true;
                }
                case "discoveryEndpointUri": {
                    this.getOrCreateConfiguration((MiloBrowseComponent)component).setDiscoveryEndpointUri((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((MiloBrowseComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((MiloBrowseComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "allowedSecurityPolicies": {
                    this.getOrCreateConfiguration((MiloBrowseComponent)component).setAllowedSecurityPolicies((String)value);
                    return true;
                }
                case "applicationName": {
                    this.getOrCreateConfiguration((MiloBrowseComponent)component).setApplicationName((String)value);
                    return true;
                }
                case "applicationUri": {
                    this.getOrCreateConfiguration((MiloBrowseComponent)component).setApplicationUri((String)value);
                    return true;
                }
                case "channelLifetime": {
                    this.getOrCreateConfiguration((MiloBrowseComponent)component).setChannelLifetime((Long)value);
                    return true;
                }
                case "keyAlias": {
                    this.getOrCreateConfiguration((MiloBrowseComponent)component).setKeyAlias((String)value);
                    return true;
                }
                case "keyPassword": {
                    this.getOrCreateConfiguration((MiloBrowseComponent)component).setKeyPassword((String)value);
                    return true;
                }
                case "keyStorePassword": {
                    this.getOrCreateConfiguration((MiloBrowseComponent)component).setKeyStorePassword((String)value);
                    return true;
                }
                case "keyStoreType": {
                    this.getOrCreateConfiguration((MiloBrowseComponent)component).setKeyStoreType((String)value);
                    return true;
                }
                case "keyStoreUrl": {
                    this.getOrCreateConfiguration((MiloBrowseComponent)component).setKeyStoreUrl((String)value);
                    return true;
                }
                case "maxPendingPublishRequests": {
                    this.getOrCreateConfiguration((MiloBrowseComponent)component).setMaxPendingPublishRequests((Long)value);
                    return true;
                }
                case "maxResponseMessageSize": {
                    this.getOrCreateConfiguration((MiloBrowseComponent)component).setMaxResponseMessageSize((Long)value);
                    return true;
                }
                case "miloClientConnectionManager": {
                    ((MiloBrowseComponent)component).setMiloClientConnectionManager((MiloClientConnectionManager)value);
                    return true;
                }
                case "overrideHost": {
                    this.getOrCreateConfiguration((MiloBrowseComponent)component).setOverrideHost(((Boolean)value).booleanValue());
                    return true;
                }
                case "productUri": {
                    this.getOrCreateConfiguration((MiloBrowseComponent)component).setProductUri((String)value);
                    return true;
                }
                case "requestedPublishingInterval": {
                    this.getOrCreateConfiguration((MiloBrowseComponent)component).setRequestedPublishingInterval((Double)value);
                    return true;
                }
                case "requestTimeout": {
                    this.getOrCreateConfiguration((MiloBrowseComponent)component).setRequestTimeout((Long)value);
                    return true;
                }
                case "sessionName": {
                    this.getOrCreateConfiguration((MiloBrowseComponent)component).setSessionName((String)value);
                    return true;
                }
                case "sessionTimeout": {
                    this.getOrCreateConfiguration((MiloBrowseComponent)component).setSessionTimeout((Long)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface MiloBrowseComponentBuilder
    extends ComponentBuilder<MiloBrowseComponent> {
        default public MiloBrowseComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public MiloBrowseComponentBuilder configuration(MiloClientConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public MiloBrowseComponentBuilder discoveryEndpointSuffix(String discoveryEndpointSuffix) {
            this.doSetProperty("discoveryEndpointSuffix", discoveryEndpointSuffix);
            return this;
        }

        default public MiloBrowseComponentBuilder discoveryEndpointUri(String discoveryEndpointUri) {
            this.doSetProperty("discoveryEndpointUri", discoveryEndpointUri);
            return this;
        }

        default public MiloBrowseComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public MiloBrowseComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public MiloBrowseComponentBuilder allowedSecurityPolicies(String allowedSecurityPolicies) {
            this.doSetProperty("allowedSecurityPolicies", allowedSecurityPolicies);
            return this;
        }

        default public MiloBrowseComponentBuilder applicationName(String applicationName) {
            this.doSetProperty("applicationName", applicationName);
            return this;
        }

        default public MiloBrowseComponentBuilder applicationUri(String applicationUri) {
            this.doSetProperty("applicationUri", applicationUri);
            return this;
        }

        default public MiloBrowseComponentBuilder channelLifetime(Long channelLifetime) {
            this.doSetProperty("channelLifetime", channelLifetime);
            return this;
        }

        default public MiloBrowseComponentBuilder keyAlias(String keyAlias) {
            this.doSetProperty("keyAlias", keyAlias);
            return this;
        }

        default public MiloBrowseComponentBuilder keyPassword(String keyPassword) {
            this.doSetProperty("keyPassword", keyPassword);
            return this;
        }

        default public MiloBrowseComponentBuilder keyStorePassword(String keyStorePassword) {
            this.doSetProperty("keyStorePassword", keyStorePassword);
            return this;
        }

        default public MiloBrowseComponentBuilder keyStoreType(String keyStoreType) {
            this.doSetProperty("keyStoreType", keyStoreType);
            return this;
        }

        default public MiloBrowseComponentBuilder keyStoreUrl(String keyStoreUrl) {
            this.doSetProperty("keyStoreUrl", keyStoreUrl);
            return this;
        }

        default public MiloBrowseComponentBuilder maxPendingPublishRequests(Long maxPendingPublishRequests) {
            this.doSetProperty("maxPendingPublishRequests", maxPendingPublishRequests);
            return this;
        }

        default public MiloBrowseComponentBuilder maxResponseMessageSize(Long maxResponseMessageSize) {
            this.doSetProperty("maxResponseMessageSize", maxResponseMessageSize);
            return this;
        }

        default public MiloBrowseComponentBuilder miloClientConnectionManager(MiloClientConnectionManager miloClientConnectionManager) {
            this.doSetProperty("miloClientConnectionManager", miloClientConnectionManager);
            return this;
        }

        default public MiloBrowseComponentBuilder overrideHost(boolean overrideHost) {
            this.doSetProperty("overrideHost", overrideHost);
            return this;
        }

        default public MiloBrowseComponentBuilder productUri(String productUri) {
            this.doSetProperty("productUri", productUri);
            return this;
        }

        default public MiloBrowseComponentBuilder requestedPublishingInterval(Double requestedPublishingInterval) {
            this.doSetProperty("requestedPublishingInterval", requestedPublishingInterval);
            return this;
        }

        default public MiloBrowseComponentBuilder requestTimeout(Long requestTimeout) {
            this.doSetProperty("requestTimeout", requestTimeout);
            return this;
        }

        default public MiloBrowseComponentBuilder sessionName(String sessionName) {
            this.doSetProperty("sessionName", sessionName);
            return this;
        }

        default public MiloBrowseComponentBuilder sessionTimeout(Long sessionTimeout) {
            this.doSetProperty("sessionTimeout", sessionTimeout);
            return this;
        }
    }
}

