/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.crypto.DigitalSignatureComponent;
import org.apache.camel.component.crypto.DigitalSignatureConfiguration;
import org.apache.camel.support.jsse.KeyStoreParameters;

public interface CryptoComponentBuilderFactory {
    public static CryptoComponentBuilder crypto() {
        return new CryptoComponentBuilderImpl();
    }

    public static class CryptoComponentBuilderImpl
    extends AbstractComponentBuilder<DigitalSignatureComponent>
    implements CryptoComponentBuilder {
        @Override
        protected DigitalSignatureComponent buildConcreteComponent() {
            return new DigitalSignatureComponent();
        }

        private DigitalSignatureConfiguration getOrCreateConfiguration(DigitalSignatureComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new DigitalSignatureConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "algorithm": {
                    this.getOrCreateConfiguration((DigitalSignatureComponent)component).setAlgorithm((String)value);
                    return true;
                }
                case "alias": {
                    this.getOrCreateConfiguration((DigitalSignatureComponent)component).setAlias((String)value);
                    return true;
                }
                case "certificateName": {
                    this.getOrCreateConfiguration((DigitalSignatureComponent)component).setCertificateName((String)value);
                    return true;
                }
                case "keystore": {
                    this.getOrCreateConfiguration((DigitalSignatureComponent)component).setKeystore((KeyStore)value);
                    return true;
                }
                case "keystoreName": {
                    this.getOrCreateConfiguration((DigitalSignatureComponent)component).setKeystoreName((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((DigitalSignatureComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "privateKey": {
                    this.getOrCreateConfiguration((DigitalSignatureComponent)component).setPrivateKey((PrivateKey)value);
                    return true;
                }
                case "privateKeyName": {
                    this.getOrCreateConfiguration((DigitalSignatureComponent)component).setPrivateKeyName((String)value);
                    return true;
                }
                case "provider": {
                    this.getOrCreateConfiguration((DigitalSignatureComponent)component).setProvider((String)value);
                    return true;
                }
                case "publicKeyName": {
                    this.getOrCreateConfiguration((DigitalSignatureComponent)component).setPublicKeyName((String)value);
                    return true;
                }
                case "secureRandomName": {
                    this.getOrCreateConfiguration((DigitalSignatureComponent)component).setSecureRandomName((String)value);
                    return true;
                }
                case "signatureHeaderName": {
                    this.getOrCreateConfiguration((DigitalSignatureComponent)component).setSignatureHeaderName((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((DigitalSignatureComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "bufferSize": {
                    this.getOrCreateConfiguration((DigitalSignatureComponent)component).setBufferSize((Integer)value);
                    return true;
                }
                case "certificate": {
                    this.getOrCreateConfiguration((DigitalSignatureComponent)component).setCertificate((Certificate)value);
                    return true;
                }
                case "clearHeaders": {
                    this.getOrCreateConfiguration((DigitalSignatureComponent)component).setClearHeaders(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((DigitalSignatureComponent)component).setConfiguration((DigitalSignatureConfiguration)value);
                    return true;
                }
                case "keyStoreParameters": {
                    this.getOrCreateConfiguration((DigitalSignatureComponent)component).setKeyStoreParameters((KeyStoreParameters)value);
                    return true;
                }
                case "publicKey": {
                    this.getOrCreateConfiguration((DigitalSignatureComponent)component).setPublicKey((PublicKey)value);
                    return true;
                }
                case "secureRandom": {
                    this.getOrCreateConfiguration((DigitalSignatureComponent)component).setSecureRandom((SecureRandom)value);
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((DigitalSignatureComponent)component).setPassword((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface CryptoComponentBuilder
    extends ComponentBuilder<DigitalSignatureComponent> {
        default public CryptoComponentBuilder algorithm(String algorithm) {
            this.doSetProperty("algorithm", algorithm);
            return this;
        }

        default public CryptoComponentBuilder alias(String alias) {
            this.doSetProperty("alias", alias);
            return this;
        }

        default public CryptoComponentBuilder certificateName(String certificateName) {
            this.doSetProperty("certificateName", certificateName);
            return this;
        }

        default public CryptoComponentBuilder keystore(KeyStore keystore) {
            this.doSetProperty("keystore", keystore);
            return this;
        }

        default public CryptoComponentBuilder keystoreName(String keystoreName) {
            this.doSetProperty("keystoreName", keystoreName);
            return this;
        }

        default public CryptoComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public CryptoComponentBuilder privateKey(PrivateKey privateKey) {
            this.doSetProperty("privateKey", privateKey);
            return this;
        }

        default public CryptoComponentBuilder privateKeyName(String privateKeyName) {
            this.doSetProperty("privateKeyName", privateKeyName);
            return this;
        }

        default public CryptoComponentBuilder provider(String provider) {
            this.doSetProperty("provider", provider);
            return this;
        }

        default public CryptoComponentBuilder publicKeyName(String publicKeyName) {
            this.doSetProperty("publicKeyName", publicKeyName);
            return this;
        }

        default public CryptoComponentBuilder secureRandomName(String secureRandomName) {
            this.doSetProperty("secureRandomName", secureRandomName);
            return this;
        }

        default public CryptoComponentBuilder signatureHeaderName(String signatureHeaderName) {
            this.doSetProperty("signatureHeaderName", signatureHeaderName);
            return this;
        }

        default public CryptoComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public CryptoComponentBuilder bufferSize(Integer bufferSize) {
            this.doSetProperty("bufferSize", bufferSize);
            return this;
        }

        default public CryptoComponentBuilder certificate(Certificate certificate) {
            this.doSetProperty("certificate", certificate);
            return this;
        }

        default public CryptoComponentBuilder clearHeaders(boolean clearHeaders) {
            this.doSetProperty("clearHeaders", clearHeaders);
            return this;
        }

        default public CryptoComponentBuilder configuration(DigitalSignatureConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public CryptoComponentBuilder keyStoreParameters(KeyStoreParameters keyStoreParameters) {
            this.doSetProperty("keyStoreParameters", keyStoreParameters);
            return this;
        }

        default public CryptoComponentBuilder publicKey(PublicKey publicKey) {
            this.doSetProperty("publicKey", publicKey);
            return this;
        }

        default public CryptoComponentBuilder secureRandom(SecureRandom secureRandom) {
            this.doSetProperty("secureRandom", secureRandom);
            return this;
        }

        default public CryptoComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }
    }
}

