/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import javax.net.ssl.HostnameVerifier;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.http.common.HttpConfiguration;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.http.client.CookieStore;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

public interface HttpComponentBuilderFactory {
    public static HttpComponentBuilder http() {
        return new HttpComponentBuilderImpl();
    }

    public static class HttpComponentBuilderImpl
    extends AbstractComponentBuilder<HttpComponent>
    implements HttpComponentBuilder {
        @Override
        protected HttpComponent buildConcreteComponent() {
            return new HttpComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "followRedirects": {
                    ((HttpComponent)component).setFollowRedirects(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((HttpComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "cookieStore": {
                    ((HttpComponent)component).setCookieStore((CookieStore)value);
                    return true;
                }
                case "copyHeaders": {
                    ((HttpComponent)component).setCopyHeaders(((Boolean)value).booleanValue());
                    return true;
                }
                case "responsePayloadStreamingThreshold": {
                    ((HttpComponent)component).setResponsePayloadStreamingThreshold(((Integer)value).intValue());
                    return true;
                }
                case "skipRequestHeaders": {
                    ((HttpComponent)component).setSkipRequestHeaders(((Boolean)value).booleanValue());
                    return true;
                }
                case "skipResponseHeaders": {
                    ((HttpComponent)component).setSkipResponseHeaders(((Boolean)value).booleanValue());
                    return true;
                }
                case "allowJavaSerializedObject": {
                    ((HttpComponent)component).setAllowJavaSerializedObject(((Boolean)value).booleanValue());
                    return true;
                }
                case "authCachingDisabled": {
                    ((HttpComponent)component).setAuthCachingDisabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "automaticRetriesDisabled": {
                    ((HttpComponent)component).setAutomaticRetriesDisabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((HttpComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "clientConnectionManager": {
                    ((HttpComponent)component).setClientConnectionManager((HttpClientConnectionManager)value);
                    return true;
                }
                case "connectionsPerRoute": {
                    ((HttpComponent)component).setConnectionsPerRoute(((Integer)value).intValue());
                    return true;
                }
                case "connectionStateDisabled": {
                    ((HttpComponent)component).setConnectionStateDisabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "connectionTimeToLive": {
                    ((HttpComponent)component).setConnectionTimeToLive(((Long)value).longValue());
                    return true;
                }
                case "contentCompressionDisabled": {
                    ((HttpComponent)component).setContentCompressionDisabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "cookieManagementDisabled": {
                    ((HttpComponent)component).setCookieManagementDisabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "defaultUserAgentDisabled": {
                    ((HttpComponent)component).setDefaultUserAgentDisabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "httpBinding": {
                    ((HttpComponent)component).setHttpBinding((HttpBinding)value);
                    return true;
                }
                case "httpClientConfigurer": {
                    ((HttpComponent)component).setHttpClientConfigurer((HttpClientConfigurer)value);
                    return true;
                }
                case "httpConfiguration": {
                    ((HttpComponent)component).setHttpConfiguration((HttpConfiguration)value);
                    return true;
                }
                case "httpContext": {
                    ((HttpComponent)component).setHttpContext((HttpContext)value);
                    return true;
                }
                case "maxTotalConnections": {
                    ((HttpComponent)component).setMaxTotalConnections(((Integer)value).intValue());
                    return true;
                }
                case "redirectHandlingDisabled": {
                    ((HttpComponent)component).setRedirectHandlingDisabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "headerFilterStrategy": {
                    ((HttpComponent)component).setHeaderFilterStrategy((HeaderFilterStrategy)value);
                    return true;
                }
                case "proxyAuthDomain": {
                    ((HttpComponent)component).setProxyAuthDomain((String)value);
                    return true;
                }
                case "proxyAuthHost": {
                    ((HttpComponent)component).setProxyAuthHost((String)value);
                    return true;
                }
                case "proxyAuthMethod": {
                    ((HttpComponent)component).setProxyAuthMethod((String)value);
                    return true;
                }
                case "proxyAuthNtHost": {
                    ((HttpComponent)component).setProxyAuthNtHost((String)value);
                    return true;
                }
                case "proxyAuthPassword": {
                    ((HttpComponent)component).setProxyAuthPassword((String)value);
                    return true;
                }
                case "proxyAuthPort": {
                    ((HttpComponent)component).setProxyAuthPort((Integer)value);
                    return true;
                }
                case "proxyAuthScheme": {
                    ((HttpComponent)component).setProxyAuthScheme((String)value);
                    return true;
                }
                case "proxyAuthUsername": {
                    ((HttpComponent)component).setProxyAuthUsername((String)value);
                    return true;
                }
                case "sslContextParameters": {
                    ((HttpComponent)component).setSslContextParameters((SSLContextParameters)value);
                    return true;
                }
                case "useGlobalSslContextParameters": {
                    ((HttpComponent)component).setUseGlobalSslContextParameters(((Boolean)value).booleanValue());
                    return true;
                }
                case "x509HostnameVerifier": {
                    ((HttpComponent)component).setX509HostnameVerifier((HostnameVerifier)value);
                    return true;
                }
                case "connectionRequestTimeout": {
                    ((HttpComponent)component).setConnectionRequestTimeout(((Integer)value).intValue());
                    return true;
                }
                case "connectTimeout": {
                    ((HttpComponent)component).setConnectTimeout(((Integer)value).intValue());
                    return true;
                }
                case "socketTimeout": {
                    ((HttpComponent)component).setSocketTimeout(((Integer)value).intValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface HttpComponentBuilder
    extends ComponentBuilder<HttpComponent> {
        default public HttpComponentBuilder followRedirects(boolean followRedirects) {
            this.doSetProperty("followRedirects", followRedirects);
            return this;
        }

        default public HttpComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public HttpComponentBuilder cookieStore(CookieStore cookieStore) {
            this.doSetProperty("cookieStore", cookieStore);
            return this;
        }

        default public HttpComponentBuilder copyHeaders(boolean copyHeaders) {
            this.doSetProperty("copyHeaders", copyHeaders);
            return this;
        }

        default public HttpComponentBuilder responsePayloadStreamingThreshold(int responsePayloadStreamingThreshold) {
            this.doSetProperty("responsePayloadStreamingThreshold", responsePayloadStreamingThreshold);
            return this;
        }

        default public HttpComponentBuilder skipRequestHeaders(boolean skipRequestHeaders) {
            this.doSetProperty("skipRequestHeaders", skipRequestHeaders);
            return this;
        }

        default public HttpComponentBuilder skipResponseHeaders(boolean skipResponseHeaders) {
            this.doSetProperty("skipResponseHeaders", skipResponseHeaders);
            return this;
        }

        default public HttpComponentBuilder allowJavaSerializedObject(boolean allowJavaSerializedObject) {
            this.doSetProperty("allowJavaSerializedObject", allowJavaSerializedObject);
            return this;
        }

        default public HttpComponentBuilder authCachingDisabled(boolean authCachingDisabled) {
            this.doSetProperty("authCachingDisabled", authCachingDisabled);
            return this;
        }

        default public HttpComponentBuilder automaticRetriesDisabled(boolean automaticRetriesDisabled) {
            this.doSetProperty("automaticRetriesDisabled", automaticRetriesDisabled);
            return this;
        }

        default public HttpComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public HttpComponentBuilder clientConnectionManager(HttpClientConnectionManager clientConnectionManager) {
            this.doSetProperty("clientConnectionManager", clientConnectionManager);
            return this;
        }

        default public HttpComponentBuilder connectionsPerRoute(int connectionsPerRoute) {
            this.doSetProperty("connectionsPerRoute", connectionsPerRoute);
            return this;
        }

        default public HttpComponentBuilder connectionStateDisabled(boolean connectionStateDisabled) {
            this.doSetProperty("connectionStateDisabled", connectionStateDisabled);
            return this;
        }

        default public HttpComponentBuilder connectionTimeToLive(long connectionTimeToLive) {
            this.doSetProperty("connectionTimeToLive", connectionTimeToLive);
            return this;
        }

        default public HttpComponentBuilder contentCompressionDisabled(boolean contentCompressionDisabled) {
            this.doSetProperty("contentCompressionDisabled", contentCompressionDisabled);
            return this;
        }

        default public HttpComponentBuilder cookieManagementDisabled(boolean cookieManagementDisabled) {
            this.doSetProperty("cookieManagementDisabled", cookieManagementDisabled);
            return this;
        }

        default public HttpComponentBuilder defaultUserAgentDisabled(boolean defaultUserAgentDisabled) {
            this.doSetProperty("defaultUserAgentDisabled", defaultUserAgentDisabled);
            return this;
        }

        default public HttpComponentBuilder httpBinding(HttpBinding httpBinding) {
            this.doSetProperty("httpBinding", httpBinding);
            return this;
        }

        default public HttpComponentBuilder httpClientConfigurer(HttpClientConfigurer httpClientConfigurer) {
            this.doSetProperty("httpClientConfigurer", httpClientConfigurer);
            return this;
        }

        default public HttpComponentBuilder httpConfiguration(HttpConfiguration httpConfiguration) {
            this.doSetProperty("httpConfiguration", httpConfiguration);
            return this;
        }

        default public HttpComponentBuilder httpContext(HttpContext httpContext) {
            this.doSetProperty("httpContext", httpContext);
            return this;
        }

        default public HttpComponentBuilder maxTotalConnections(int maxTotalConnections) {
            this.doSetProperty("maxTotalConnections", maxTotalConnections);
            return this;
        }

        default public HttpComponentBuilder redirectHandlingDisabled(boolean redirectHandlingDisabled) {
            this.doSetProperty("redirectHandlingDisabled", redirectHandlingDisabled);
            return this;
        }

        default public HttpComponentBuilder headerFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public HttpComponentBuilder proxyAuthDomain(String proxyAuthDomain) {
            this.doSetProperty("proxyAuthDomain", proxyAuthDomain);
            return this;
        }

        default public HttpComponentBuilder proxyAuthHost(String proxyAuthHost) {
            this.doSetProperty("proxyAuthHost", proxyAuthHost);
            return this;
        }

        default public HttpComponentBuilder proxyAuthMethod(String proxyAuthMethod) {
            this.doSetProperty("proxyAuthMethod", proxyAuthMethod);
            return this;
        }

        default public HttpComponentBuilder proxyAuthNtHost(String proxyAuthNtHost) {
            this.doSetProperty("proxyAuthNtHost", proxyAuthNtHost);
            return this;
        }

        default public HttpComponentBuilder proxyAuthPassword(String proxyAuthPassword) {
            this.doSetProperty("proxyAuthPassword", proxyAuthPassword);
            return this;
        }

        default public HttpComponentBuilder proxyAuthPort(Integer proxyAuthPort) {
            this.doSetProperty("proxyAuthPort", proxyAuthPort);
            return this;
        }

        default public HttpComponentBuilder proxyAuthScheme(String proxyAuthScheme) {
            this.doSetProperty("proxyAuthScheme", proxyAuthScheme);
            return this;
        }

        default public HttpComponentBuilder proxyAuthUsername(String proxyAuthUsername) {
            this.doSetProperty("proxyAuthUsername", proxyAuthUsername);
            return this;
        }

        default public HttpComponentBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public HttpComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            this.doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }

        default public HttpComponentBuilder x509HostnameVerifier(HostnameVerifier x509HostnameVerifier) {
            this.doSetProperty("x509HostnameVerifier", x509HostnameVerifier);
            return this;
        }

        default public HttpComponentBuilder connectionRequestTimeout(int connectionRequestTimeout) {
            this.doSetProperty("connectionRequestTimeout", connectionRequestTimeout);
            return this;
        }

        default public HttpComponentBuilder connectTimeout(int connectTimeout) {
            this.doSetProperty("connectTimeout", connectTimeout);
            return this;
        }

        default public HttpComponentBuilder socketTimeout(int socketTimeout) {
            this.doSetProperty("socketTimeout", socketTimeout);
            return this;
        }
    }
}

