/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.cw.CwComponent;

/**
 * Send metrics to AWS CloudWatch.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface AwsCwComponentBuilderFactory {

    /**
     * AWS CloudWatch (camel-aws-cw)
     * Send metrics to AWS CloudWatch.
     * 
     * Category: cloud,monitoring
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-aws-cw
     */
    static AwsCwComponentBuilder awsCw() {
        return new AwsCwComponentBuilderImpl();
    }

    /**
     * Builder for the AWS CloudWatch component.
     */
    interface AwsCwComponentBuilder extends ComponentBuilder<CwComponent> {
        /**
         * To use the AmazonCloudWatch as the client.
         * 
         * The option is a:
         * <code>com.amazonaws.services.cloudwatch.AmazonCloudWatch</code> type.
         * 
         * Group: producer
         */
        default AwsCwComponentBuilder amazonCwClient(
                com.amazonaws.services.cloudwatch.AmazonCloudWatch amazonCwClient) {
            doSetProperty("amazonCwClient", amazonCwClient);
            return this;
        }
        /**
         * The component configuration.
         * 
         * The option is a:
         * <code>org.apache.camel.component.aws.cw.CwConfiguration</code> type.
         * 
         * Group: producer
         */
        default AwsCwComponentBuilder configuration(
                org.apache.camel.component.aws.cw.CwConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default AwsCwComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The metric name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default AwsCwComponentBuilder name(java.lang.String name) {
            doSetProperty("name", name);
            return this;
        }
        /**
         * To define a proxy host when instantiating the CW client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default AwsCwComponentBuilder proxyHost(java.lang.String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the CW client.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: producer
         */
        default AwsCwComponentBuilder proxyPort(java.lang.Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the CW client.
         * 
         * The option is a: <code>com.amazonaws.Protocol</code> type.
         * 
         * Default: HTTPS
         * Group: producer
         */
        default AwsCwComponentBuilder proxyProtocol(
                com.amazonaws.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * The region in which CW client needs to work. When using this
         * parameter, the configuration will expect the capitalized name of the
         * region (for example AP_EAST_1) You'll need to use the name
         * Regions.EU_WEST_1.name().
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default AwsCwComponentBuilder region(java.lang.String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * The metric timestamp.
         * 
         * The option is a: <code>java.util.Date</code> type.
         * 
         * Group: producer
         */
        default AwsCwComponentBuilder timestamp(java.util.Date timestamp) {
            doSetProperty("timestamp", timestamp);
            return this;
        }
        /**
         * The metric unit.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default AwsCwComponentBuilder unit(java.lang.String unit) {
            doSetProperty("unit", unit);
            return this;
        }
        /**
         * The metric value.
         * 
         * The option is a: <code>java.lang.Double</code> type.
         * 
         * Group: producer
         */
        default AwsCwComponentBuilder value(java.lang.Double value) {
            doSetProperty("value", value);
            return this;
        }
        /**
         * Whether the component should use basic property binding (Camel 2.x)
         * or the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AwsCwComponentBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default AwsCwComponentBuilder accessKey(java.lang.String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default AwsCwComponentBuilder secretKey(java.lang.String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
    }

    class AwsCwComponentBuilderImpl
            extends
                AbstractComponentBuilder<CwComponent>
            implements
                AwsCwComponentBuilder {
        @Override
        protected CwComponent buildConcreteComponent() {
            return new CwComponent();
        }
        private org.apache.camel.component.aws.cw.CwConfiguration getOrCreateConfiguration(
                org.apache.camel.component.aws.cw.CwComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.aws.cw.CwConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "amazonCwClient": getOrCreateConfiguration((CwComponent) component).setAmazonCwClient((com.amazonaws.services.cloudwatch.AmazonCloudWatch) value); return true;
            case "configuration": ((CwComponent) component).setConfiguration((org.apache.camel.component.aws.cw.CwConfiguration) value); return true;
            case "lazyStartProducer": ((CwComponent) component).setLazyStartProducer((boolean) value); return true;
            case "name": getOrCreateConfiguration((CwComponent) component).setName((java.lang.String) value); return true;
            case "proxyHost": getOrCreateConfiguration((CwComponent) component).setProxyHost((java.lang.String) value); return true;
            case "proxyPort": getOrCreateConfiguration((CwComponent) component).setProxyPort((java.lang.Integer) value); return true;
            case "proxyProtocol": getOrCreateConfiguration((CwComponent) component).setProxyProtocol((com.amazonaws.Protocol) value); return true;
            case "region": getOrCreateConfiguration((CwComponent) component).setRegion((java.lang.String) value); return true;
            case "timestamp": getOrCreateConfiguration((CwComponent) component).setTimestamp((java.util.Date) value); return true;
            case "unit": getOrCreateConfiguration((CwComponent) component).setUnit((java.lang.String) value); return true;
            case "value": getOrCreateConfiguration((CwComponent) component).setValue((java.lang.Double) value); return true;
            case "basicPropertyBinding": ((CwComponent) component).setBasicPropertyBinding((boolean) value); return true;
            case "accessKey": getOrCreateConfiguration((CwComponent) component).setAccessKey((java.lang.String) value); return true;
            case "secretKey": getOrCreateConfiguration((CwComponent) component).setSecretKey((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}