/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import io.atomix.Atomix;
import io.atomix.catalyst.transport.Address;
import io.atomix.resource.ReadConsistency;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.atomix.client.value.AtomixValue;
import org.apache.camel.component.atomix.client.value.AtomixValueComponent;
import org.apache.camel.component.atomix.client.value.AtomixValueConfiguration;

public interface AtomixValueComponentBuilderFactory {
    public static AtomixValueComponentBuilder atomixValue() {
        return new AtomixValueComponentBuilderImpl();
    }

    public static class AtomixValueComponentBuilderImpl
    extends AbstractComponentBuilder<AtomixValueComponent>
    implements AtomixValueComponentBuilder {
        @Override
        protected AtomixValueComponent buildConcreteComponent() {
            return new AtomixValueComponent();
        }

        private AtomixValueConfiguration getOrCreateConfiguration(AtomixValueComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new AtomixValueConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "atomix": {
                    this.getOrCreateConfiguration((AtomixValueComponent)component).setAtomix((Atomix)value);
                    return true;
                }
                case "configuration": {
                    ((AtomixValueComponent)component).setConfiguration((AtomixValueConfiguration)value);
                    return true;
                }
                case "configurationUri": {
                    ((AtomixValueComponent)component).setConfigurationUri((String)value);
                    return true;
                }
                case "defaultAction": {
                    this.getOrCreateConfiguration((AtomixValueComponent)component).setDefaultAction((AtomixValue.Action)value);
                    return true;
                }
                case "nodes": {
                    ((AtomixValueComponent)component).setNodes((List)value);
                    return true;
                }
                case "resultHeader": {
                    this.getOrCreateConfiguration((AtomixValueComponent)component).setResultHeader((String)value);
                    return true;
                }
                case "transportClassName": {
                    this.getOrCreateConfiguration((AtomixValueComponent)component).setTransportClassName((String)value);
                    return true;
                }
                case "ttl": {
                    this.getOrCreateConfiguration((AtomixValueComponent)component).setTtl(((Long)value).longValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((AtomixValueComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((AtomixValueComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((AtomixValueComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "defaultResourceConfig": {
                    this.getOrCreateConfiguration((AtomixValueComponent)component).setDefaultResourceConfig((Properties)value);
                    return true;
                }
                case "defaultResourceOptions": {
                    this.getOrCreateConfiguration((AtomixValueComponent)component).setDefaultResourceOptions((Properties)value);
                    return true;
                }
                case "ephemeral": {
                    this.getOrCreateConfiguration((AtomixValueComponent)component).setEphemeral(((Boolean)value).booleanValue());
                    return true;
                }
                case "readConsistency": {
                    this.getOrCreateConfiguration((AtomixValueComponent)component).setReadConsistency((ReadConsistency)value);
                    return true;
                }
                case "resourceConfigs": {
                    this.getOrCreateConfiguration((AtomixValueComponent)component).setResourceConfigs((Map)value);
                    return true;
                }
                case "resourceOptions": {
                    this.getOrCreateConfiguration((AtomixValueComponent)component).setResourceOptions((Map)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AtomixValueComponentBuilder
    extends ComponentBuilder<AtomixValueComponent> {
        default public AtomixValueComponentBuilder atomix(Atomix atomix) {
            this.doSetProperty("atomix", atomix);
            return this;
        }

        default public AtomixValueComponentBuilder configuration(AtomixValueConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AtomixValueComponentBuilder configurationUri(String configurationUri) {
            this.doSetProperty("configurationUri", configurationUri);
            return this;
        }

        default public AtomixValueComponentBuilder defaultAction(AtomixValue.Action defaultAction) {
            this.doSetProperty("defaultAction", defaultAction);
            return this;
        }

        default public AtomixValueComponentBuilder nodes(List<Address> nodes) {
            this.doSetProperty("nodes", nodes);
            return this;
        }

        default public AtomixValueComponentBuilder resultHeader(String resultHeader) {
            this.doSetProperty("resultHeader", resultHeader);
            return this;
        }

        default public AtomixValueComponentBuilder transportClassName(String transportClassName) {
            this.doSetProperty("transportClassName", transportClassName);
            return this;
        }

        default public AtomixValueComponentBuilder ttl(long ttl) {
            this.doSetProperty("ttl", ttl);
            return this;
        }

        default public AtomixValueComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AtomixValueComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AtomixValueComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AtomixValueComponentBuilder defaultResourceConfig(Properties defaultResourceConfig) {
            this.doSetProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }

        default public AtomixValueComponentBuilder defaultResourceOptions(Properties defaultResourceOptions) {
            this.doSetProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }

        default public AtomixValueComponentBuilder ephemeral(boolean ephemeral) {
            this.doSetProperty("ephemeral", ephemeral);
            return this;
        }

        default public AtomixValueComponentBuilder readConsistency(ReadConsistency readConsistency) {
            this.doSetProperty("readConsistency", readConsistency);
            return this;
        }

        default public AtomixValueComponentBuilder resourceConfigs(Map<String, Properties> resourceConfigs) {
            this.doSetProperty("resourceConfigs", resourceConfigs);
            return this;
        }

        default public AtomixValueComponentBuilder resourceOptions(Map<String, Properties> resourceOptions) {
            this.doSetProperty("resourceOptions", resourceOptions);
            return this;
        }
    }
}

