/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.amazonaws.Protocol;
import com.amazonaws.services.mq.AmazonMQ;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.mq.MQComponent;
import org.apache.camel.component.aws.mq.MQConfiguration;
import org.apache.camel.component.aws.mq.MQOperations;

public interface AwsMqComponentBuilderFactory {
    public static AwsMqComponentBuilder awsMq() {
        return new AwsMqComponentBuilderImpl();
    }

    public static class AwsMqComponentBuilderImpl
    extends AbstractComponentBuilder<MQComponent>
    implements AwsMqComponentBuilder {
        @Override
        protected MQComponent buildConcreteComponent() {
            return new MQComponent();
        }

        private MQConfiguration getOrCreateConfiguration(MQComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new MQConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "accessKey": {
                    this.getOrCreateConfiguration((MQComponent)component).setAccessKey((String)value);
                    return true;
                }
                case "amazonMqClient": {
                    this.getOrCreateConfiguration((MQComponent)component).setAmazonMqClient((AmazonMQ)value);
                    return true;
                }
                case "configuration": {
                    ((MQComponent)component).setConfiguration((MQConfiguration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((MQComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((MQComponent)component).setOperation((MQOperations)value);
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((MQComponent)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((MQComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((MQComponent)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((MQComponent)component).setRegion((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((MQComponent)component).setSecretKey((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((MQComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AwsMqComponentBuilder
    extends ComponentBuilder<MQComponent> {
        default public AwsMqComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AwsMqComponentBuilder amazonMqClient(AmazonMQ amazonMqClient) {
            this.doSetProperty("amazonMqClient", amazonMqClient);
            return this;
        }

        default public AwsMqComponentBuilder configuration(MQConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AwsMqComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AwsMqComponentBuilder operation(MQOperations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public AwsMqComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public AwsMqComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AwsMqComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AwsMqComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AwsMqComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public AwsMqComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
    }
}

