/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.Properties;
import javax.mail.Session;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.mail.AttachmentsContentTransferEncodingResolver;
import org.apache.camel.component.mail.ContentTypeResolver;
import org.apache.camel.component.mail.JavaMailSender;
import org.apache.camel.component.mail.MailAuthenticator;
import org.apache.camel.component.mail.MailComponent;
import org.apache.camel.component.mail.MailConfiguration;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.jsse.SSLContextParameters;

public interface SmtpComponentBuilderFactory {
    public static SmtpComponentBuilder smtp() {
        return new SmtpComponentBuilderImpl();
    }

    public static class SmtpComponentBuilderImpl
    extends AbstractComponentBuilder<MailComponent>
    implements SmtpComponentBuilder {
        @Override
        protected MailComponent buildConcreteComponent() {
            return new MailComponent();
        }

        private MailConfiguration getOrCreateConfiguration(MailComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new MailConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "bridgeErrorHandler": {
                    ((MailComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "closeFolder": {
                    this.getOrCreateConfiguration((MailComponent)component).setCloseFolder(((Boolean)value).booleanValue());
                    return true;
                }
                case "copyTo": {
                    this.getOrCreateConfiguration((MailComponent)component).setCopyTo((String)value);
                    return true;
                }
                case "delete": {
                    this.getOrCreateConfiguration((MailComponent)component).setDelete(((Boolean)value).booleanValue());
                    return true;
                }
                case "disconnect": {
                    this.getOrCreateConfiguration((MailComponent)component).setDisconnect(((Boolean)value).booleanValue());
                    return true;
                }
                case "handleFailedMessage": {
                    this.getOrCreateConfiguration((MailComponent)component).setHandleFailedMessage(((Boolean)value).booleanValue());
                    return true;
                }
                case "mimeDecodeHeaders": {
                    this.getOrCreateConfiguration((MailComponent)component).setMimeDecodeHeaders(((Boolean)value).booleanValue());
                    return true;
                }
                case "moveTo": {
                    this.getOrCreateConfiguration((MailComponent)component).setMoveTo((String)value);
                    return true;
                }
                case "peek": {
                    this.getOrCreateConfiguration((MailComponent)component).setPeek(((Boolean)value).booleanValue());
                    return true;
                }
                case "skipFailedMessage": {
                    this.getOrCreateConfiguration((MailComponent)component).setSkipFailedMessage(((Boolean)value).booleanValue());
                    return true;
                }
                case "unseen": {
                    this.getOrCreateConfiguration((MailComponent)component).setUnseen(((Boolean)value).booleanValue());
                    return true;
                }
                case "fetchSize": {
                    this.getOrCreateConfiguration((MailComponent)component).setFetchSize(((Integer)value).intValue());
                    return true;
                }
                case "folderName": {
                    this.getOrCreateConfiguration((MailComponent)component).setFolderName((String)value);
                    return true;
                }
                case "mapMailMessage": {
                    this.getOrCreateConfiguration((MailComponent)component).setMapMailMessage(((Boolean)value).booleanValue());
                    return true;
                }
                case "bcc": {
                    this.getOrCreateConfiguration((MailComponent)component).setBcc((String)value);
                    return true;
                }
                case "cc": {
                    this.getOrCreateConfiguration((MailComponent)component).setCc((String)value);
                    return true;
                }
                case "from": {
                    this.getOrCreateConfiguration((MailComponent)component).setFrom((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((MailComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "replyTo": {
                    this.getOrCreateConfiguration((MailComponent)component).setReplyTo((String)value);
                    return true;
                }
                case "subject": {
                    this.getOrCreateConfiguration((MailComponent)component).setSubject((String)value);
                    return true;
                }
                case "to": {
                    this.getOrCreateConfiguration((MailComponent)component).setTo((String)value);
                    return true;
                }
                case "javaMailSender": {
                    this.getOrCreateConfiguration((MailComponent)component).setJavaMailSender((JavaMailSender)value);
                    return true;
                }
                case "additionalJavaMailProperties": {
                    this.getOrCreateConfiguration((MailComponent)component).setAdditionalJavaMailProperties((Properties)value);
                    return true;
                }
                case "alternativeBodyHeader": {
                    this.getOrCreateConfiguration((MailComponent)component).setAlternativeBodyHeader((String)value);
                    return true;
                }
                case "attachmentsContentTransferEncodingResolver": {
                    this.getOrCreateConfiguration((MailComponent)component).setAttachmentsContentTransferEncodingResolver((AttachmentsContentTransferEncodingResolver)value);
                    return true;
                }
                case "authenticator": {
                    this.getOrCreateConfiguration((MailComponent)component).setAuthenticator((MailAuthenticator)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((MailComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((MailComponent)component).setConfiguration((MailConfiguration)value);
                    return true;
                }
                case "connectionTimeout": {
                    this.getOrCreateConfiguration((MailComponent)component).setConnectionTimeout(((Integer)value).intValue());
                    return true;
                }
                case "contentType": {
                    this.getOrCreateConfiguration((MailComponent)component).setContentType((String)value);
                    return true;
                }
                case "contentTypeResolver": {
                    ((MailComponent)component).setContentTypeResolver((ContentTypeResolver)value);
                    return true;
                }
                case "debugMode": {
                    this.getOrCreateConfiguration((MailComponent)component).setDebugMode(((Boolean)value).booleanValue());
                    return true;
                }
                case "ignoreUnsupportedCharset": {
                    this.getOrCreateConfiguration((MailComponent)component).setIgnoreUnsupportedCharset(((Boolean)value).booleanValue());
                    return true;
                }
                case "ignoreUriScheme": {
                    this.getOrCreateConfiguration((MailComponent)component).setIgnoreUriScheme(((Boolean)value).booleanValue());
                    return true;
                }
                case "javaMailProperties": {
                    this.getOrCreateConfiguration((MailComponent)component).setJavaMailProperties((Properties)value);
                    return true;
                }
                case "session": {
                    this.getOrCreateConfiguration((MailComponent)component).setSession((Session)value);
                    return true;
                }
                case "useInlineAttachments": {
                    this.getOrCreateConfiguration((MailComponent)component).setUseInlineAttachments(((Boolean)value).booleanValue());
                    return true;
                }
                case "headerFilterStrategy": {
                    ((MailComponent)component).setHeaderFilterStrategy((HeaderFilterStrategy)value);
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((MailComponent)component).setPassword((String)value);
                    return true;
                }
                case "sslContextParameters": {
                    this.getOrCreateConfiguration((MailComponent)component).setSslContextParameters((SSLContextParameters)value);
                    return true;
                }
                case "useGlobalSslContextParameters": {
                    ((MailComponent)component).setUseGlobalSslContextParameters(((Boolean)value).booleanValue());
                    return true;
                }
                case "username": {
                    this.getOrCreateConfiguration((MailComponent)component).setUsername((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface SmtpComponentBuilder
    extends ComponentBuilder<MailComponent> {
        default public SmtpComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public SmtpComponentBuilder closeFolder(boolean closeFolder) {
            this.doSetProperty("closeFolder", closeFolder);
            return this;
        }

        default public SmtpComponentBuilder copyTo(String copyTo) {
            this.doSetProperty("copyTo", copyTo);
            return this;
        }

        default public SmtpComponentBuilder delete(boolean delete) {
            this.doSetProperty("delete", delete);
            return this;
        }

        default public SmtpComponentBuilder disconnect(boolean disconnect) {
            this.doSetProperty("disconnect", disconnect);
            return this;
        }

        default public SmtpComponentBuilder handleFailedMessage(boolean handleFailedMessage) {
            this.doSetProperty("handleFailedMessage", handleFailedMessage);
            return this;
        }

        default public SmtpComponentBuilder mimeDecodeHeaders(boolean mimeDecodeHeaders) {
            this.doSetProperty("mimeDecodeHeaders", mimeDecodeHeaders);
            return this;
        }

        default public SmtpComponentBuilder moveTo(String moveTo) {
            this.doSetProperty("moveTo", moveTo);
            return this;
        }

        default public SmtpComponentBuilder peek(boolean peek) {
            this.doSetProperty("peek", peek);
            return this;
        }

        default public SmtpComponentBuilder skipFailedMessage(boolean skipFailedMessage) {
            this.doSetProperty("skipFailedMessage", skipFailedMessage);
            return this;
        }

        default public SmtpComponentBuilder unseen(boolean unseen) {
            this.doSetProperty("unseen", unseen);
            return this;
        }

        default public SmtpComponentBuilder fetchSize(int fetchSize) {
            this.doSetProperty("fetchSize", fetchSize);
            return this;
        }

        default public SmtpComponentBuilder folderName(String folderName) {
            this.doSetProperty("folderName", folderName);
            return this;
        }

        default public SmtpComponentBuilder mapMailMessage(boolean mapMailMessage) {
            this.doSetProperty("mapMailMessage", mapMailMessage);
            return this;
        }

        default public SmtpComponentBuilder bcc(String bcc) {
            this.doSetProperty("bcc", bcc);
            return this;
        }

        default public SmtpComponentBuilder cc(String cc) {
            this.doSetProperty("cc", cc);
            return this;
        }

        default public SmtpComponentBuilder from(String from) {
            this.doSetProperty("from", from);
            return this;
        }

        default public SmtpComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public SmtpComponentBuilder replyTo(String replyTo) {
            this.doSetProperty("replyTo", replyTo);
            return this;
        }

        default public SmtpComponentBuilder subject(String subject) {
            this.doSetProperty("subject", subject);
            return this;
        }

        default public SmtpComponentBuilder to(String to) {
            this.doSetProperty("to", to);
            return this;
        }

        default public SmtpComponentBuilder javaMailSender(JavaMailSender javaMailSender) {
            this.doSetProperty("javaMailSender", javaMailSender);
            return this;
        }

        default public SmtpComponentBuilder additionalJavaMailProperties(Properties additionalJavaMailProperties) {
            this.doSetProperty("additionalJavaMailProperties", additionalJavaMailProperties);
            return this;
        }

        default public SmtpComponentBuilder alternativeBodyHeader(String alternativeBodyHeader) {
            this.doSetProperty("alternativeBodyHeader", alternativeBodyHeader);
            return this;
        }

        default public SmtpComponentBuilder attachmentsContentTransferEncodingResolver(AttachmentsContentTransferEncodingResolver attachmentsContentTransferEncodingResolver) {
            this.doSetProperty("attachmentsContentTransferEncodingResolver", attachmentsContentTransferEncodingResolver);
            return this;
        }

        default public SmtpComponentBuilder authenticator(MailAuthenticator authenticator) {
            this.doSetProperty("authenticator", authenticator);
            return this;
        }

        default public SmtpComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public SmtpComponentBuilder configuration(MailConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public SmtpComponentBuilder connectionTimeout(int connectionTimeout) {
            this.doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }

        default public SmtpComponentBuilder contentType(String contentType) {
            this.doSetProperty("contentType", contentType);
            return this;
        }

        default public SmtpComponentBuilder contentTypeResolver(ContentTypeResolver contentTypeResolver) {
            this.doSetProperty("contentTypeResolver", contentTypeResolver);
            return this;
        }

        default public SmtpComponentBuilder debugMode(boolean debugMode) {
            this.doSetProperty("debugMode", debugMode);
            return this;
        }

        default public SmtpComponentBuilder ignoreUnsupportedCharset(boolean ignoreUnsupportedCharset) {
            this.doSetProperty("ignoreUnsupportedCharset", ignoreUnsupportedCharset);
            return this;
        }

        default public SmtpComponentBuilder ignoreUriScheme(boolean ignoreUriScheme) {
            this.doSetProperty("ignoreUriScheme", ignoreUriScheme);
            return this;
        }

        default public SmtpComponentBuilder javaMailProperties(Properties javaMailProperties) {
            this.doSetProperty("javaMailProperties", javaMailProperties);
            return this;
        }

        default public SmtpComponentBuilder session(Session session) {
            this.doSetProperty("session", session);
            return this;
        }

        default public SmtpComponentBuilder useInlineAttachments(boolean useInlineAttachments) {
            this.doSetProperty("useInlineAttachments", useInlineAttachments);
            return this;
        }

        default public SmtpComponentBuilder headerFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public SmtpComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public SmtpComponentBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public SmtpComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            this.doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }

        default public SmtpComponentBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }
    }
}

