/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.lambda.Lambda2Component;
import org.apache.camel.component.aws2.lambda.Lambda2Configuration;
import org.apache.camel.component.aws2.lambda.Lambda2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.lambda.LambdaClient;

public interface Aws2LambdaComponentBuilderFactory {
    public static Aws2LambdaComponentBuilder aws2Lambda() {
        return new Aws2LambdaComponentBuilderImpl();
    }

    public static class Aws2LambdaComponentBuilderImpl
    extends AbstractComponentBuilder<Lambda2Component>
    implements Aws2LambdaComponentBuilder {
        @Override
        protected Lambda2Component buildConcreteComponent() {
            return new Lambda2Component();
        }

        private Lambda2Configuration getOrCreateConfiguration(Lambda2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new Lambda2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((Lambda2Component)component).setConfiguration((Lambda2Configuration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((Lambda2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setOperation((Lambda2Operations)value);
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setRegion((String)value);
                    return true;
                }
                case "awsLambdaClient": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setAwsLambdaClient((LambdaClient)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((Lambda2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((Lambda2Component)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2LambdaComponentBuilder
    extends ComponentBuilder<Lambda2Component> {
        default public Aws2LambdaComponentBuilder configuration(Lambda2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2LambdaComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2LambdaComponentBuilder operation(Lambda2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2LambdaComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Aws2LambdaComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2LambdaComponentBuilder awsLambdaClient(LambdaClient awsLambdaClient) {
            this.doSetProperty("awsLambdaClient", awsLambdaClient);
            return this;
        }

        default public Aws2LambdaComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public Aws2LambdaComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2LambdaComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2LambdaComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2LambdaComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2LambdaComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

