/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.orbitz.consul.Consul;
import com.orbitz.consul.option.ConsistencyMode;
import java.math.BigInteger;
import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.consul.ConsulComponent;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.support.jsse.SSLContextParameters;

public interface ConsulComponentBuilderFactory {
    public static ConsulComponentBuilder consul() {
        return new ConsulComponentBuilderImpl();
    }

    public static class ConsulComponentBuilderImpl
    extends AbstractComponentBuilder<ConsulComponent>
    implements ConsulComponentBuilder {
        @Override
        protected ConsulComponent buildConcreteComponent() {
            return new ConsulComponent();
        }

        private ConsulConfiguration getOrCreateConfiguration(ConsulComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new ConsulConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "connectTimeoutMillis": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setConnectTimeoutMillis((Long)value);
                    return true;
                }
                case "consulClient": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setConsulClient((Consul)value);
                    return true;
                }
                case "key": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setKey((String)value);
                    return true;
                }
                case "pingInstance": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setPingInstance(((Boolean)value).booleanValue());
                    return true;
                }
                case "readTimeoutMillis": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setReadTimeoutMillis((Long)value);
                    return true;
                }
                case "tags": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setTags((String)value);
                    return true;
                }
                case "url": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setUrl((String)value);
                    return true;
                }
                case "writeTimeoutMillis": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setWriteTimeoutMillis((Long)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((ConsulComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "action": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setAction((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((ConsulComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "valueAsString": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setValueAsString(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((ConsulComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((ConsulComponent)component).setConfiguration((ConsulConfiguration)value);
                    return true;
                }
                case "consistencyMode": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setConsistencyMode((ConsistencyMode)value);
                    return true;
                }
                case "datacenter": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setDatacenter((String)value);
                    return true;
                }
                case "nearNode": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setNearNode((String)value);
                    return true;
                }
                case "nodeMeta": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setNodeMeta((List)value);
                    return true;
                }
                case "aclToken": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setAclToken((String)value);
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setPassword((String)value);
                    return true;
                }
                case "sslContextParameters": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setSslContextParameters((SSLContextParameters)value);
                    return true;
                }
                case "useGlobalSslContextParameters": {
                    ((ConsulComponent)component).setUseGlobalSslContextParameters(((Boolean)value).booleanValue());
                    return true;
                }
                case "userName": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setUserName((String)value);
                    return true;
                }
                case "blockSeconds": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setBlockSeconds((Integer)value);
                    return true;
                }
                case "firstIndex": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setFirstIndex((BigInteger)value);
                    return true;
                }
                case "recursive": {
                    this.getOrCreateConfiguration((ConsulComponent)component).setRecursive(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface ConsulComponentBuilder
    extends ComponentBuilder<ConsulComponent> {
        default public ConsulComponentBuilder connectTimeoutMillis(Long connectTimeoutMillis) {
            this.doSetProperty("connectTimeoutMillis", connectTimeoutMillis);
            return this;
        }

        default public ConsulComponentBuilder consulClient(Consul consulClient) {
            this.doSetProperty("consulClient", consulClient);
            return this;
        }

        default public ConsulComponentBuilder key(String key) {
            this.doSetProperty("key", key);
            return this;
        }

        default public ConsulComponentBuilder pingInstance(boolean pingInstance) {
            this.doSetProperty("pingInstance", pingInstance);
            return this;
        }

        default public ConsulComponentBuilder readTimeoutMillis(Long readTimeoutMillis) {
            this.doSetProperty("readTimeoutMillis", readTimeoutMillis);
            return this;
        }

        default public ConsulComponentBuilder tags(String tags) {
            this.doSetProperty("tags", tags);
            return this;
        }

        default public ConsulComponentBuilder url(String url) {
            this.doSetProperty("url", url);
            return this;
        }

        default public ConsulComponentBuilder writeTimeoutMillis(Long writeTimeoutMillis) {
            this.doSetProperty("writeTimeoutMillis", writeTimeoutMillis);
            return this;
        }

        default public ConsulComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public ConsulComponentBuilder action(String action) {
            this.doSetProperty("action", action);
            return this;
        }

        default public ConsulComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public ConsulComponentBuilder valueAsString(boolean valueAsString) {
            this.doSetProperty("valueAsString", valueAsString);
            return this;
        }

        default public ConsulComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public ConsulComponentBuilder configuration(ConsulConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public ConsulComponentBuilder consistencyMode(ConsistencyMode consistencyMode) {
            this.doSetProperty("consistencyMode", consistencyMode);
            return this;
        }

        default public ConsulComponentBuilder datacenter(String datacenter) {
            this.doSetProperty("datacenter", datacenter);
            return this;
        }

        default public ConsulComponentBuilder nearNode(String nearNode) {
            this.doSetProperty("nearNode", nearNode);
            return this;
        }

        default public ConsulComponentBuilder nodeMeta(List<String> nodeMeta) {
            this.doSetProperty("nodeMeta", nodeMeta);
            return this;
        }

        default public ConsulComponentBuilder aclToken(String aclToken) {
            this.doSetProperty("aclToken", aclToken);
            return this;
        }

        default public ConsulComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public ConsulComponentBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public ConsulComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            this.doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }

        default public ConsulComponentBuilder userName(String userName) {
            this.doSetProperty("userName", userName);
            return this;
        }

        default public ConsulComponentBuilder blockSeconds(Integer blockSeconds) {
            this.doSetProperty("blockSeconds", blockSeconds);
            return this;
        }

        default public ConsulComponentBuilder firstIndex(BigInteger firstIndex) {
            this.doSetProperty("firstIndex", firstIndex);
            return this;
        }

        default public ConsulComponentBuilder recursive(boolean recursive) {
            this.doSetProperty("recursive", recursive);
            return this;
        }
    }
}

