/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.athena.Athena2Component;
import org.apache.camel.component.aws2.athena.Athena2Configuration;
import org.apache.camel.component.aws2.athena.Athena2Operations;
import org.apache.camel.component.aws2.athena.Athena2OutputType;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.model.EncryptionOption;

public interface Aws2AthenaComponentBuilderFactory {
    public static Aws2AthenaComponentBuilder aws2Athena() {
        return new Aws2AthenaComponentBuilderImpl();
    }

    public static class Aws2AthenaComponentBuilderImpl
    extends AbstractComponentBuilder<Athena2Component>
    implements Aws2AthenaComponentBuilder {
        @Override
        protected Athena2Component buildConcreteComponent() {
            return new Athena2Component();
        }

        private Athena2Configuration getOrCreateConfiguration(Athena2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new Athena2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "accessKey": {
                    this.getOrCreateConfiguration((Athena2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "amazonAthenaClient": {
                    this.getOrCreateConfiguration((Athena2Component)component).setAmazonAthenaClient((AthenaClient)value);
                    return true;
                }
                case "configuration": {
                    ((Athena2Component)component).setConfiguration((Athena2Configuration)value);
                    return true;
                }
                case "database": {
                    this.getOrCreateConfiguration((Athena2Component)component).setDatabase((String)value);
                    return true;
                }
                case "delay": {
                    this.getOrCreateConfiguration((Athena2Component)component).setDelay(((Long)value).longValue());
                    return true;
                }
                case "encryptionOption": {
                    this.getOrCreateConfiguration((Athena2Component)component).setEncryptionOption((EncryptionOption)value);
                    return true;
                }
                case "includeTrace": {
                    this.getOrCreateConfiguration((Athena2Component)component).setIncludeTrace(((Boolean)value).booleanValue());
                    return true;
                }
                case "initialDelay": {
                    this.getOrCreateConfiguration((Athena2Component)component).setInitialDelay(((Long)value).longValue());
                    return true;
                }
                case "kmsKey": {
                    this.getOrCreateConfiguration((Athena2Component)component).setKmsKey((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((Athena2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "maxAttempts": {
                    this.getOrCreateConfiguration((Athena2Component)component).setMaxAttempts(((Integer)value).intValue());
                    return true;
                }
                case "maxResults": {
                    this.getOrCreateConfiguration((Athena2Component)component).setMaxResults((Integer)value);
                    return true;
                }
                case "nextToken": {
                    this.getOrCreateConfiguration((Athena2Component)component).setNextToken((String)value);
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((Athena2Component)component).setOperation((Athena2Operations)value);
                    return true;
                }
                case "outputLocation": {
                    this.getOrCreateConfiguration((Athena2Component)component).setOutputLocation((String)value);
                    return true;
                }
                case "outputType": {
                    this.getOrCreateConfiguration((Athena2Component)component).setOutputType((Athena2OutputType)value);
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((Athena2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((Athena2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((Athena2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "queryExecutionId": {
                    this.getOrCreateConfiguration((Athena2Component)component).setQueryExecutionId((String)value);
                    return true;
                }
                case "queryString": {
                    this.getOrCreateConfiguration((Athena2Component)component).setQueryString((String)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((Athena2Component)component).setRegion((String)value);
                    return true;
                }
                case "resetWaitTimeoutOnRetry": {
                    this.getOrCreateConfiguration((Athena2Component)component).setResetWaitTimeoutOnRetry(((Boolean)value).booleanValue());
                    return true;
                }
                case "retry": {
                    this.getOrCreateConfiguration((Athena2Component)component).setRetry((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((Athena2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "waitTimeout": {
                    this.getOrCreateConfiguration((Athena2Component)component).setWaitTimeout(((Long)value).longValue());
                    return true;
                }
                case "workGroup": {
                    this.getOrCreateConfiguration((Athena2Component)component).setWorkGroup((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((Athena2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "clientRequestToken": {
                    this.getOrCreateConfiguration((Athena2Component)component).setClientRequestToken((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2AthenaComponentBuilder
    extends ComponentBuilder<Athena2Component> {
        default public Aws2AthenaComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2AthenaComponentBuilder amazonAthenaClient(AthenaClient amazonAthenaClient) {
            this.doSetProperty("amazonAthenaClient", amazonAthenaClient);
            return this;
        }

        default public Aws2AthenaComponentBuilder configuration(Athena2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2AthenaComponentBuilder database(String database) {
            this.doSetProperty("database", database);
            return this;
        }

        default public Aws2AthenaComponentBuilder delay(long delay) {
            this.doSetProperty("delay", delay);
            return this;
        }

        default public Aws2AthenaComponentBuilder encryptionOption(EncryptionOption encryptionOption) {
            this.doSetProperty("encryptionOption", encryptionOption);
            return this;
        }

        default public Aws2AthenaComponentBuilder includeTrace(boolean includeTrace) {
            this.doSetProperty("includeTrace", includeTrace);
            return this;
        }

        default public Aws2AthenaComponentBuilder initialDelay(long initialDelay) {
            this.doSetProperty("initialDelay", initialDelay);
            return this;
        }

        default public Aws2AthenaComponentBuilder kmsKey(String kmsKey) {
            this.doSetProperty("kmsKey", kmsKey);
            return this;
        }

        default public Aws2AthenaComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2AthenaComponentBuilder maxAttempts(int maxAttempts) {
            this.doSetProperty("maxAttempts", maxAttempts);
            return this;
        }

        default public Aws2AthenaComponentBuilder maxResults(Integer maxResults) {
            this.doSetProperty("maxResults", maxResults);
            return this;
        }

        default public Aws2AthenaComponentBuilder nextToken(String nextToken) {
            this.doSetProperty("nextToken", nextToken);
            return this;
        }

        default public Aws2AthenaComponentBuilder operation(Athena2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2AthenaComponentBuilder outputLocation(String outputLocation) {
            this.doSetProperty("outputLocation", outputLocation);
            return this;
        }

        default public Aws2AthenaComponentBuilder outputType(Athena2OutputType outputType) {
            this.doSetProperty("outputType", outputType);
            return this;
        }

        default public Aws2AthenaComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2AthenaComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2AthenaComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2AthenaComponentBuilder queryExecutionId(String queryExecutionId) {
            this.doSetProperty("queryExecutionId", queryExecutionId);
            return this;
        }

        default public Aws2AthenaComponentBuilder queryString(String queryString) {
            this.doSetProperty("queryString", queryString);
            return this;
        }

        default public Aws2AthenaComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2AthenaComponentBuilder resetWaitTimeoutOnRetry(boolean resetWaitTimeoutOnRetry) {
            this.doSetProperty("resetWaitTimeoutOnRetry", resetWaitTimeoutOnRetry);
            return this;
        }

        default public Aws2AthenaComponentBuilder retry(String retry) {
            this.doSetProperty("retry", retry);
            return this;
        }

        default public Aws2AthenaComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2AthenaComponentBuilder waitTimeout(long waitTimeout) {
            this.doSetProperty("waitTimeout", waitTimeout);
            return this;
        }

        default public Aws2AthenaComponentBuilder workGroup(String workGroup) {
            this.doSetProperty("workGroup", workGroup);
            return this;
        }

        default public Aws2AthenaComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public Aws2AthenaComponentBuilder clientRequestToken(String clientRequestToken) {
            this.doSetProperty("clientRequestToken", clientRequestToken);
            return this;
        }
    }
}

