/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.msk.MSK2Component;
import org.apache.camel.component.aws2.msk.MSK2Configuration;
import org.apache.camel.component.aws2.msk.MSK2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.kafka.KafkaClient;

public interface Aws2MskComponentBuilderFactory {
    public static Aws2MskComponentBuilder aws2Msk() {
        return new Aws2MskComponentBuilderImpl();
    }

    public static class Aws2MskComponentBuilderImpl
    extends AbstractComponentBuilder<MSK2Component>
    implements Aws2MskComponentBuilder {
        @Override
        protected MSK2Component buildConcreteComponent() {
            return new MSK2Component();
        }

        private MSK2Configuration getOrCreateConfiguration(MSK2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new MSK2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((MSK2Component)component).setConfiguration((MSK2Configuration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((MSK2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "mskClient": {
                    this.getOrCreateConfiguration((MSK2Component)component).setMskClient((KafkaClient)value);
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((MSK2Component)component).setOperation((MSK2Operations)value);
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((MSK2Component)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((MSK2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((MSK2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((MSK2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((MSK2Component)component).setRegion((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((MSK2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((MSK2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((MSK2Component)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2MskComponentBuilder
    extends ComponentBuilder<MSK2Component> {
        default public Aws2MskComponentBuilder configuration(MSK2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2MskComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2MskComponentBuilder mskClient(KafkaClient mskClient) {
            this.doSetProperty("mskClient", mskClient);
            return this;
        }

        default public Aws2MskComponentBuilder operation(MSK2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2MskComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Aws2MskComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2MskComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2MskComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2MskComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2MskComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public Aws2MskComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2MskComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

