/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.docker.DockerComponent;
import org.apache.camel.component.docker.DockerConfiguration;

public interface DockerComponentBuilderFactory {
    public static DockerComponentBuilder docker() {
        return new DockerComponentBuilderImpl();
    }

    public static class DockerComponentBuilderImpl
    extends AbstractComponentBuilder<DockerComponent>
    implements DockerComponentBuilder {
        @Override
        protected DockerComponent buildConcreteComponent() {
            return new DockerComponent();
        }

        private DockerConfiguration getOrCreateConfiguration(DockerComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new DockerConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((DockerComponent)component).setConfiguration((DockerConfiguration)value);
                    return true;
                }
                case "email": {
                    this.getOrCreateConfiguration((DockerComponent)component).setEmail((String)value);
                    return true;
                }
                case "host": {
                    this.getOrCreateConfiguration((DockerComponent)component).setHost((String)value);
                    return true;
                }
                case "port": {
                    this.getOrCreateConfiguration((DockerComponent)component).setPort((Integer)value);
                    return true;
                }
                case "requestTimeout": {
                    this.getOrCreateConfiguration((DockerComponent)component).setRequestTimeout((Integer)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((DockerComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((DockerComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((DockerComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "cmdExecFactory": {
                    this.getOrCreateConfiguration((DockerComponent)component).setCmdExecFactory((String)value);
                    return true;
                }
                case "followRedirectFilter": {
                    this.getOrCreateConfiguration((DockerComponent)component).setFollowRedirectFilter(((Boolean)value).booleanValue());
                    return true;
                }
                case "loggingFilter": {
                    this.getOrCreateConfiguration((DockerComponent)component).setLoggingFilter(((Boolean)value).booleanValue());
                    return true;
                }
                case "maxPerRouteConnections": {
                    this.getOrCreateConfiguration((DockerComponent)component).setMaxPerRouteConnections((Integer)value);
                    return true;
                }
                case "maxTotalConnections": {
                    this.getOrCreateConfiguration((DockerComponent)component).setMaxTotalConnections((Integer)value);
                    return true;
                }
                case "parameters": {
                    this.getOrCreateConfiguration((DockerComponent)component).setParameters((Map)value);
                    return true;
                }
                case "serverAddress": {
                    this.getOrCreateConfiguration((DockerComponent)component).setServerAddress((String)value);
                    return true;
                }
                case "socket": {
                    this.getOrCreateConfiguration((DockerComponent)component).setSocket(((Boolean)value).booleanValue());
                    return true;
                }
                case "certPath": {
                    this.getOrCreateConfiguration((DockerComponent)component).setCertPath((String)value);
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((DockerComponent)component).setPassword((String)value);
                    return true;
                }
                case "secure": {
                    this.getOrCreateConfiguration((DockerComponent)component).setSecure(((Boolean)value).booleanValue());
                    return true;
                }
                case "tlsVerify": {
                    this.getOrCreateConfiguration((DockerComponent)component).setTlsVerify(((Boolean)value).booleanValue());
                    return true;
                }
                case "username": {
                    this.getOrCreateConfiguration((DockerComponent)component).setUsername((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface DockerComponentBuilder
    extends ComponentBuilder<DockerComponent> {
        default public DockerComponentBuilder configuration(DockerConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public DockerComponentBuilder email(String email) {
            this.doSetProperty("email", email);
            return this;
        }

        default public DockerComponentBuilder host(String host) {
            this.doSetProperty("host", host);
            return this;
        }

        default public DockerComponentBuilder port(Integer port) {
            this.doSetProperty("port", port);
            return this;
        }

        default public DockerComponentBuilder requestTimeout(Integer requestTimeout) {
            this.doSetProperty("requestTimeout", requestTimeout);
            return this;
        }

        default public DockerComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public DockerComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public DockerComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public DockerComponentBuilder cmdExecFactory(String cmdExecFactory) {
            this.doSetProperty("cmdExecFactory", cmdExecFactory);
            return this;
        }

        default public DockerComponentBuilder followRedirectFilter(boolean followRedirectFilter) {
            this.doSetProperty("followRedirectFilter", followRedirectFilter);
            return this;
        }

        default public DockerComponentBuilder loggingFilter(boolean loggingFilter) {
            this.doSetProperty("loggingFilter", loggingFilter);
            return this;
        }

        default public DockerComponentBuilder maxPerRouteConnections(Integer maxPerRouteConnections) {
            this.doSetProperty("maxPerRouteConnections", maxPerRouteConnections);
            return this;
        }

        default public DockerComponentBuilder maxTotalConnections(Integer maxTotalConnections) {
            this.doSetProperty("maxTotalConnections", maxTotalConnections);
            return this;
        }

        default public DockerComponentBuilder parameters(Map<String, Object> parameters) {
            this.doSetProperty("parameters", parameters);
            return this;
        }

        default public DockerComponentBuilder serverAddress(String serverAddress) {
            this.doSetProperty("serverAddress", serverAddress);
            return this;
        }

        default public DockerComponentBuilder socket(boolean socket) {
            this.doSetProperty("socket", socket);
            return this;
        }

        default public DockerComponentBuilder certPath(String certPath) {
            this.doSetProperty("certPath", certPath);
            return this;
        }

        default public DockerComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public DockerComponentBuilder secure(boolean secure) {
            this.doSetProperty("secure", secure);
            return this;
        }

        default public DockerComponentBuilder tlsVerify(boolean tlsVerify) {
            this.doSetProperty("tlsVerify", tlsVerify);
            return this;
        }

        default public DockerComponentBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }
    }
}

