/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.io.File;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.lucene.LuceneComponent;
import org.apache.camel.component.lucene.LuceneConfiguration;
import org.apache.lucene.analysis.Analyzer;

public interface LuceneComponentBuilderFactory {
    public static LuceneComponentBuilder lucene() {
        return new LuceneComponentBuilderImpl();
    }

    public static class LuceneComponentBuilderImpl
    extends AbstractComponentBuilder<LuceneComponent>
    implements LuceneComponentBuilder {
        @Override
        protected LuceneComponent buildConcreteComponent() {
            return new LuceneComponent();
        }

        private LuceneConfiguration getOrCreateConfiguration(LuceneComponent component) {
            if (component.getConfig() == null) {
                component.setConfig(new LuceneConfiguration());
            }
            return component.getConfig();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "analyzer": {
                    this.getOrCreateConfiguration((LuceneComponent)component).setAnalyzer((Analyzer)value);
                    return true;
                }
                case "indexDir": {
                    this.getOrCreateConfiguration((LuceneComponent)component).setIndexDir((File)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((LuceneComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "maxHits": {
                    this.getOrCreateConfiguration((LuceneComponent)component).setMaxHits(((Integer)value).intValue());
                    return true;
                }
                case "srcDir": {
                    this.getOrCreateConfiguration((LuceneComponent)component).setSrcDir((File)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((LuceneComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "config": {
                    ((LuceneComponent)component).setConfig((LuceneConfiguration)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface LuceneComponentBuilder
    extends ComponentBuilder<LuceneComponent> {
        default public LuceneComponentBuilder analyzer(Analyzer analyzer) {
            this.doSetProperty("analyzer", analyzer);
            return this;
        }

        default public LuceneComponentBuilder indexDir(File indexDir) {
            this.doSetProperty("indexDir", indexDir);
            return this;
        }

        default public LuceneComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public LuceneComponentBuilder maxHits(int maxHits) {
            this.doSetProperty("maxHits", maxHits);
            return this;
        }

        default public LuceneComponentBuilder srcDir(File srcDir) {
            this.doSetProperty("srcDir", srcDir);
            return this;
        }

        default public LuceneComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public LuceneComponentBuilder config(LuceneConfiguration config) {
            this.doSetProperty("config", config);
            return this;
        }
    }
}

