/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.math.BigInteger;
import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.web3j.Web3jComponent;
import org.apache.camel.component.web3j.Web3jConfiguration;
import org.web3j.protocol.Web3j;

public interface Web3jComponentBuilderFactory {
    public static Web3jComponentBuilder web3j() {
        return new Web3jComponentBuilderImpl();
    }

    public static class Web3jComponentBuilderImpl
    extends AbstractComponentBuilder<Web3jComponent>
    implements Web3jComponentBuilder {
        @Override
        protected Web3jComponent buildConcreteComponent() {
            return new Web3jComponent();
        }

        private Web3jConfiguration getOrCreateConfiguration(Web3jComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new Web3jConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "addresses": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setAddresses((List)value);
                    return true;
                }
                case "configuration": {
                    ((Web3jComponent)component).setConfiguration((Web3jConfiguration)value);
                    return true;
                }
                case "fromAddress": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setFromAddress((String)value);
                    return true;
                }
                case "fromBlock": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setFromBlock((String)value);
                    return true;
                }
                case "fullTransactionObjects": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setFullTransactionObjects(((Boolean)value).booleanValue());
                    return true;
                }
                case "gasLimit": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setGasLimit((BigInteger)value);
                    return true;
                }
                case "privateFor": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setPrivateFor((List)value);
                    return true;
                }
                case "quorumAPI": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setQuorumAPI(((Boolean)value).booleanValue());
                    return true;
                }
                case "toAddress": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setToAddress((String)value);
                    return true;
                }
                case "toBlock": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setToBlock((String)value);
                    return true;
                }
                case "topics": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setTopics((String)value);
                    return true;
                }
                case "web3j": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setWeb3j((Web3j)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((Web3jComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "address": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setAddress((String)value);
                    return true;
                }
                case "atBlock": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setAtBlock((String)value);
                    return true;
                }
                case "blockHash": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setBlockHash((String)value);
                    return true;
                }
                case "clientId": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setClientId((String)value);
                    return true;
                }
                case "data": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setData((String)value);
                    return true;
                }
                case "databaseName": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setDatabaseName((String)value);
                    return true;
                }
                case "filterId": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setFilterId((BigInteger)value);
                    return true;
                }
                case "gasPrice": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setGasPrice((BigInteger)value);
                    return true;
                }
                case "hashrate": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setHashrate((String)value);
                    return true;
                }
                case "headerPowHash": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setHeaderPowHash((String)value);
                    return true;
                }
                case "index": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setIndex((BigInteger)value);
                    return true;
                }
                case "keyName": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setKeyName((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((Web3jComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "mixDigest": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setMixDigest((String)value);
                    return true;
                }
                case "nonce": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setNonce((String)value);
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setOperation((String)value);
                    return true;
                }
                case "position": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setPosition((BigInteger)value);
                    return true;
                }
                case "priority": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setPriority((BigInteger)value);
                    return true;
                }
                case "sha3HashOfDataToSign": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setSha3HashOfDataToSign((String)value);
                    return true;
                }
                case "signedTransactionData": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setSignedTransactionData((String)value);
                    return true;
                }
                case "sourceCode": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setSourceCode((String)value);
                    return true;
                }
                case "transactionHash": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setTransactionHash((String)value);
                    return true;
                }
                case "ttl": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setTtl((BigInteger)value);
                    return true;
                }
                case "value": {
                    this.getOrCreateConfiguration((Web3jComponent)component).setValue((BigInteger)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((Web3jComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Web3jComponentBuilder
    extends ComponentBuilder<Web3jComponent> {
        default public Web3jComponentBuilder addresses(List<String> addresses) {
            this.doSetProperty("addresses", addresses);
            return this;
        }

        default public Web3jComponentBuilder configuration(Web3jConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Web3jComponentBuilder fromAddress(String fromAddress) {
            this.doSetProperty("fromAddress", fromAddress);
            return this;
        }

        default public Web3jComponentBuilder fromBlock(String fromBlock) {
            this.doSetProperty("fromBlock", fromBlock);
            return this;
        }

        default public Web3jComponentBuilder fullTransactionObjects(boolean fullTransactionObjects) {
            this.doSetProperty("fullTransactionObjects", fullTransactionObjects);
            return this;
        }

        default public Web3jComponentBuilder gasLimit(BigInteger gasLimit) {
            this.doSetProperty("gasLimit", gasLimit);
            return this;
        }

        default public Web3jComponentBuilder privateFor(List<String> privateFor) {
            this.doSetProperty("privateFor", privateFor);
            return this;
        }

        default public Web3jComponentBuilder quorumAPI(boolean quorumAPI) {
            this.doSetProperty("quorumAPI", quorumAPI);
            return this;
        }

        default public Web3jComponentBuilder toAddress(String toAddress) {
            this.doSetProperty("toAddress", toAddress);
            return this;
        }

        default public Web3jComponentBuilder toBlock(String toBlock) {
            this.doSetProperty("toBlock", toBlock);
            return this;
        }

        default public Web3jComponentBuilder topics(String topics) {
            this.doSetProperty("topics", topics);
            return this;
        }

        default public Web3jComponentBuilder web3j(Web3j web3j) {
            this.doSetProperty("web3j", web3j);
            return this;
        }

        default public Web3jComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public Web3jComponentBuilder address(String address) {
            this.doSetProperty("address", address);
            return this;
        }

        default public Web3jComponentBuilder atBlock(String atBlock) {
            this.doSetProperty("atBlock", atBlock);
            return this;
        }

        default public Web3jComponentBuilder blockHash(String blockHash) {
            this.doSetProperty("blockHash", blockHash);
            return this;
        }

        default public Web3jComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public Web3jComponentBuilder data(String data) {
            this.doSetProperty("data", data);
            return this;
        }

        default public Web3jComponentBuilder databaseName(String databaseName) {
            this.doSetProperty("databaseName", databaseName);
            return this;
        }

        default public Web3jComponentBuilder filterId(BigInteger filterId) {
            this.doSetProperty("filterId", filterId);
            return this;
        }

        default public Web3jComponentBuilder gasPrice(BigInteger gasPrice) {
            this.doSetProperty("gasPrice", gasPrice);
            return this;
        }

        default public Web3jComponentBuilder hashrate(String hashrate) {
            this.doSetProperty("hashrate", hashrate);
            return this;
        }

        default public Web3jComponentBuilder headerPowHash(String headerPowHash) {
            this.doSetProperty("headerPowHash", headerPowHash);
            return this;
        }

        default public Web3jComponentBuilder index(BigInteger index) {
            this.doSetProperty("index", index);
            return this;
        }

        default public Web3jComponentBuilder keyName(String keyName) {
            this.doSetProperty("keyName", keyName);
            return this;
        }

        default public Web3jComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Web3jComponentBuilder mixDigest(String mixDigest) {
            this.doSetProperty("mixDigest", mixDigest);
            return this;
        }

        default public Web3jComponentBuilder nonce(String nonce) {
            this.doSetProperty("nonce", nonce);
            return this;
        }

        default public Web3jComponentBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Web3jComponentBuilder position(BigInteger position) {
            this.doSetProperty("position", position);
            return this;
        }

        default public Web3jComponentBuilder priority(BigInteger priority) {
            this.doSetProperty("priority", priority);
            return this;
        }

        default public Web3jComponentBuilder sha3HashOfDataToSign(String sha3HashOfDataToSign) {
            this.doSetProperty("sha3HashOfDataToSign", sha3HashOfDataToSign);
            return this;
        }

        default public Web3jComponentBuilder signedTransactionData(String signedTransactionData) {
            this.doSetProperty("signedTransactionData", signedTransactionData);
            return this;
        }

        default public Web3jComponentBuilder sourceCode(String sourceCode) {
            this.doSetProperty("sourceCode", sourceCode);
            return this;
        }

        default public Web3jComponentBuilder transactionHash(String transactionHash) {
            this.doSetProperty("transactionHash", transactionHash);
            return this;
        }

        default public Web3jComponentBuilder ttl(BigInteger ttl) {
            this.doSetProperty("ttl", ttl);
            return this;
        }

        default public Web3jComponentBuilder value(BigInteger value) {
            this.doSetProperty("value", value);
            return this;
        }

        default public Web3jComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
    }
}

