/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.kms.KMS2Component;
import org.apache.camel.component.aws2.kms.KMS2Configuration;
import org.apache.camel.component.aws2.kms.KMS2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.kms.KmsClient;

public interface Aws2KmsComponentBuilderFactory {
    public static Aws2KmsComponentBuilder aws2Kms() {
        return new Aws2KmsComponentBuilderImpl();
    }

    public static class Aws2KmsComponentBuilderImpl
    extends AbstractComponentBuilder<KMS2Component>
    implements Aws2KmsComponentBuilder {
        @Override
        protected KMS2Component buildConcreteComponent() {
            return new KMS2Component();
        }

        private KMS2Configuration getOrCreateConfiguration(KMS2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new KMS2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((KMS2Component)component).setConfiguration((KMS2Configuration)value);
                    return true;
                }
                case "kmsClient": {
                    this.getOrCreateConfiguration((KMS2Component)component).setKmsClient((KmsClient)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((KMS2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((KMS2Component)component).setOperation((KMS2Operations)value);
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((KMS2Component)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((KMS2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((KMS2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((KMS2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((KMS2Component)component).setRegion((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((KMS2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((KMS2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((KMS2Component)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2KmsComponentBuilder
    extends ComponentBuilder<KMS2Component> {
        default public Aws2KmsComponentBuilder configuration(KMS2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2KmsComponentBuilder kmsClient(KmsClient kmsClient) {
            this.doSetProperty("kmsClient", kmsClient);
            return this;
        }

        default public Aws2KmsComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2KmsComponentBuilder operation(KMS2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2KmsComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Aws2KmsComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2KmsComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2KmsComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2KmsComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2KmsComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public Aws2KmsComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2KmsComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

