/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.amazonaws.Protocol;
import com.amazonaws.services.ec2.AmazonEC2;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.ec2.EC2Component;
import org.apache.camel.component.aws.ec2.EC2Configuration;
import org.apache.camel.component.aws.ec2.EC2Operations;

public interface AwsEc2ComponentBuilderFactory {
    public static AwsEc2ComponentBuilder awsEc2() {
        return new AwsEc2ComponentBuilderImpl();
    }

    public static class AwsEc2ComponentBuilderImpl
    extends AbstractComponentBuilder<EC2Component>
    implements AwsEc2ComponentBuilder {
        @Override
        protected EC2Component buildConcreteComponent() {
            return new EC2Component();
        }

        private EC2Configuration getOrCreateConfiguration(EC2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new EC2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "accessKey": {
                    this.getOrCreateConfiguration((EC2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "amazonEc2Client": {
                    this.getOrCreateConfiguration((EC2Component)component).setAmazonEc2Client((AmazonEC2)value);
                    return true;
                }
                case "configuration": {
                    ((EC2Component)component).setConfiguration((EC2Configuration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((EC2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((EC2Component)component).setOperation((EC2Operations)value);
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((EC2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((EC2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((EC2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((EC2Component)component).setRegion((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((EC2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((EC2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AwsEc2ComponentBuilder
    extends ComponentBuilder<EC2Component> {
        default public AwsEc2ComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AwsEc2ComponentBuilder amazonEc2Client(AmazonEC2 amazonEc2Client) {
            this.doSetProperty("amazonEc2Client", amazonEc2Client);
            return this;
        }

        default public AwsEc2ComponentBuilder configuration(EC2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AwsEc2ComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AwsEc2ComponentBuilder operation(EC2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public AwsEc2ComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public AwsEc2ComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AwsEc2ComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AwsEc2ComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AwsEc2ComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public AwsEc2ComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
    }
}

