/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.amazonaws.Protocol;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.kinesis.KinesisComponent;
import org.apache.camel.component.aws.kinesis.KinesisConfiguration;
import org.apache.camel.component.aws.kinesis.KinesisShardClosedStrategyEnum;

public interface AwsKinesisComponentBuilderFactory {
    public static AwsKinesisComponentBuilder awsKinesis() {
        return new AwsKinesisComponentBuilderImpl();
    }

    public static class AwsKinesisComponentBuilderImpl
    extends AbstractComponentBuilder<KinesisComponent>
    implements AwsKinesisComponentBuilder {
        @Override
        protected KinesisComponent buildConcreteComponent() {
            return new KinesisComponent();
        }

        private KinesisConfiguration getOrCreateConfiguration(KinesisComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new KinesisConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "amazonKinesisClient": {
                    this.getOrCreateConfiguration((KinesisComponent)component).setAmazonKinesisClient((AmazonKinesis)value);
                    return true;
                }
                case "configuration": {
                    ((KinesisComponent)component).setConfiguration((KinesisConfiguration)value);
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((KinesisComponent)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((KinesisComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((KinesisComponent)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((KinesisComponent)component).setRegion((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((KinesisComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "iteratorType": {
                    this.getOrCreateConfiguration((KinesisComponent)component).setIteratorType((ShardIteratorType)value);
                    return true;
                }
                case "maxResultsPerRequest": {
                    this.getOrCreateConfiguration((KinesisComponent)component).setMaxResultsPerRequest(((Integer)value).intValue());
                    return true;
                }
                case "sequenceNumber": {
                    this.getOrCreateConfiguration((KinesisComponent)component).setSequenceNumber((String)value);
                    return true;
                }
                case "shardClosed": {
                    this.getOrCreateConfiguration((KinesisComponent)component).setShardClosed((KinesisShardClosedStrategyEnum)value);
                    return true;
                }
                case "shardId": {
                    this.getOrCreateConfiguration((KinesisComponent)component).setShardId((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((KinesisComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((KinesisComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((KinesisComponent)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((KinesisComponent)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AwsKinesisComponentBuilder
    extends ComponentBuilder<KinesisComponent> {
        default public AwsKinesisComponentBuilder amazonKinesisClient(AmazonKinesis amazonKinesisClient) {
            this.doSetProperty("amazonKinesisClient", amazonKinesisClient);
            return this;
        }

        default public AwsKinesisComponentBuilder configuration(KinesisConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AwsKinesisComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public AwsKinesisComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AwsKinesisComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AwsKinesisComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AwsKinesisComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AwsKinesisComponentBuilder iteratorType(ShardIteratorType iteratorType) {
            this.doSetProperty("iteratorType", iteratorType);
            return this;
        }

        default public AwsKinesisComponentBuilder maxResultsPerRequest(int maxResultsPerRequest) {
            this.doSetProperty("maxResultsPerRequest", maxResultsPerRequest);
            return this;
        }

        default public AwsKinesisComponentBuilder sequenceNumber(String sequenceNumber) {
            this.doSetProperty("sequenceNumber", sequenceNumber);
            return this;
        }

        default public AwsKinesisComponentBuilder shardClosed(KinesisShardClosedStrategyEnum shardClosed) {
            this.doSetProperty("shardClosed", shardClosed);
            return this;
        }

        default public AwsKinesisComponentBuilder shardId(String shardId) {
            this.doSetProperty("shardId", shardId);
            return this;
        }

        default public AwsKinesisComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AwsKinesisComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AwsKinesisComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AwsKinesisComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

