/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.Map;
import javax.cache.configuration.Configuration;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.jcache.JCacheComponent;

public interface JcacheComponentBuilderFactory {
    public static JcacheComponentBuilder jcache() {
        return new JcacheComponentBuilderImpl();
    }

    public static class JcacheComponentBuilderImpl
    extends AbstractComponentBuilder<JCacheComponent>
    implements JcacheComponentBuilder {
        @Override
        protected JCacheComponent buildConcreteComponent() {
            return new JCacheComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "cacheConfiguration": {
                    ((JCacheComponent)component).setCacheConfiguration((Configuration)value);
                    return true;
                }
                case "cacheConfigurationProperties": {
                    ((JCacheComponent)component).setCacheConfigurationProperties((Map)value);
                    return true;
                }
                case "cacheConfigurationPropertiesRef": {
                    ((JCacheComponent)component).setCacheConfigurationPropertiesRef((String)value);
                    return true;
                }
                case "cachingProvider": {
                    ((JCacheComponent)component).setCachingProvider((String)value);
                    return true;
                }
                case "configurationUri": {
                    ((JCacheComponent)component).setConfigurationUri((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((JCacheComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((JCacheComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((JCacheComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface JcacheComponentBuilder
    extends ComponentBuilder<JCacheComponent> {
        default public JcacheComponentBuilder cacheConfiguration(Configuration cacheConfiguration) {
            this.doSetProperty("cacheConfiguration", cacheConfiguration);
            return this;
        }

        default public JcacheComponentBuilder cacheConfigurationProperties(Map cacheConfigurationProperties) {
            this.doSetProperty("cacheConfigurationProperties", cacheConfigurationProperties);
            return this;
        }

        default public JcacheComponentBuilder cacheConfigurationPropertiesRef(String cacheConfigurationPropertiesRef) {
            this.doSetProperty("cacheConfigurationPropertiesRef", cacheConfigurationPropertiesRef);
            return this;
        }

        default public JcacheComponentBuilder cachingProvider(String cachingProvider) {
            this.doSetProperty("cachingProvider", cachingProvider);
            return this;
        }

        default public JcacheComponentBuilder configurationUri(String configurationUri) {
            this.doSetProperty("configurationUri", configurationUri);
            return this;
        }

        default public JcacheComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public JcacheComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public JcacheComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
    }
}

