/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.netty.ClientInitializerFactory;
import org.apache.camel.component.netty.NettyCamelStateCorrelationManager;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyServerBootstrapFactory;
import org.apache.camel.component.netty.ServerInitializerFactory;
import org.apache.camel.component.netty.TextLineDelimiter;
import org.apache.camel.component.netty.http.NettyHttpBinding;
import org.apache.camel.component.netty.http.NettyHttpComponent;
import org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.jsse.SSLContextParameters;

public interface NettyHttpComponentBuilderFactory {
    public static NettyHttpComponentBuilder nettyHttp() {
        return new NettyHttpComponentBuilderImpl();
    }

    public static class NettyHttpComponentBuilderImpl
    extends AbstractComponentBuilder<NettyHttpComponent>
    implements NettyHttpComponentBuilder {
        @Override
        protected NettyHttpComponent buildConcreteComponent() {
            return new NettyHttpComponent();
        }

        private NettyConfiguration getOrCreateConfiguration(NettyHttpComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new NettyConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((NettyHttpComponent)component).setConfiguration((NettyConfiguration)value);
                    return true;
                }
                case "disconnect": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setDisconnect(((Boolean)value).booleanValue());
                    return true;
                }
                case "keepAlive": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setKeepAlive(((Boolean)value).booleanValue());
                    return true;
                }
                case "reuseAddress": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setReuseAddress(((Boolean)value).booleanValue());
                    return true;
                }
                case "reuseChannel": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setReuseChannel(((Boolean)value).booleanValue());
                    return true;
                }
                case "sync": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setSync(((Boolean)value).booleanValue());
                    return true;
                }
                case "tcpNoDelay": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setTcpNoDelay(((Boolean)value).booleanValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((NettyHttpComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "broadcast": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setBroadcast(((Boolean)value).booleanValue());
                    return true;
                }
                case "clientMode": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setClientMode(((Boolean)value).booleanValue());
                    return true;
                }
                case "reconnect": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setReconnect(((Boolean)value).booleanValue());
                    return true;
                }
                case "reconnectInterval": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setReconnectInterval(((Integer)value).intValue());
                    return true;
                }
                case "backlog": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setBacklog(((Integer)value).intValue());
                    return true;
                }
                case "bossCount": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setBossCount(((Integer)value).intValue());
                    return true;
                }
                case "bossGroup": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setBossGroup((EventLoopGroup)value);
                    return true;
                }
                case "disconnectOnNoReply": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setDisconnectOnNoReply(((Boolean)value).booleanValue());
                    return true;
                }
                case "executorService": {
                    ((NettyHttpComponent)component).setExecutorService((EventExecutorGroup)value);
                    return true;
                }
                case "maximumPoolSize": {
                    ((NettyHttpComponent)component).setMaximumPoolSize(((Integer)value).intValue());
                    return true;
                }
                case "nettyServerBootstrapFactory": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setNettyServerBootstrapFactory((NettyServerBootstrapFactory)value);
                    return true;
                }
                case "networkInterface": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setNetworkInterface((String)value);
                    return true;
                }
                case "noReplyLogLevel": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setNoReplyLogLevel((LoggingLevel)value);
                    return true;
                }
                case "serverClosedChannelExceptionCaughtLogLevel": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setServerClosedChannelExceptionCaughtLogLevel((LoggingLevel)value);
                    return true;
                }
                case "serverExceptionCaughtLogLevel": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setServerExceptionCaughtLogLevel((LoggingLevel)value);
                    return true;
                }
                case "serverInitializerFactory": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setServerInitializerFactory((ServerInitializerFactory)value);
                    return true;
                }
                case "usingExecutorService": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setUsingExecutorService(((Boolean)value).booleanValue());
                    return true;
                }
                case "connectTimeout": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setConnectTimeout(((Integer)value).intValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((NettyHttpComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "requestTimeout": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setRequestTimeout(((Long)value).longValue());
                    return true;
                }
                case "clientInitializerFactory": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setClientInitializerFactory((ClientInitializerFactory)value);
                    return true;
                }
                case "correlationManager": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setCorrelationManager((NettyCamelStateCorrelationManager)value);
                    return true;
                }
                case "lazyChannelCreation": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setLazyChannelCreation(((Boolean)value).booleanValue());
                    return true;
                }
                case "producerPoolEnabled": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setProducerPoolEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "producerPoolMaxActive": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setProducerPoolMaxActive(((Integer)value).intValue());
                    return true;
                }
                case "producerPoolMaxIdle": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setProducerPoolMaxIdle(((Integer)value).intValue());
                    return true;
                }
                case "producerPoolMinEvictableIdle": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setProducerPoolMinEvictableIdle(((Long)value).longValue());
                    return true;
                }
                case "producerPoolMinIdle": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setProducerPoolMinIdle(((Integer)value).intValue());
                    return true;
                }
                case "udpConnectionlessSending": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setUdpConnectionlessSending(((Boolean)value).booleanValue());
                    return true;
                }
                case "useByteBuf": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setUseByteBuf(((Boolean)value).booleanValue());
                    return true;
                }
                case "allowSerializedHeaders": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setAllowSerializedHeaders(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((NettyHttpComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "channelGroup": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setChannelGroup((ChannelGroup)value);
                    return true;
                }
                case "headerFilterStrategy": {
                    ((NettyHttpComponent)component).setHeaderFilterStrategy((HeaderFilterStrategy)value);
                    return true;
                }
                case "nativeTransport": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setNativeTransport(((Boolean)value).booleanValue());
                    return true;
                }
                case "nettyHttpBinding": {
                    ((NettyHttpComponent)component).setNettyHttpBinding((NettyHttpBinding)value);
                    return true;
                }
                case "options": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setOptions((Map)value);
                    return true;
                }
                case "receiveBufferSize": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setReceiveBufferSize(((Integer)value).intValue());
                    return true;
                }
                case "receiveBufferSizePredictor": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setReceiveBufferSizePredictor(((Integer)value).intValue());
                    return true;
                }
                case "sendBufferSize": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setSendBufferSize(((Integer)value).intValue());
                    return true;
                }
                case "transferExchange": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setTransferExchange(((Boolean)value).booleanValue());
                    return true;
                }
                case "udpByteArrayCodec": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setUdpByteArrayCodec(((Boolean)value).booleanValue());
                    return true;
                }
                case "workerCount": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setWorkerCount(((Integer)value).intValue());
                    return true;
                }
                case "workerGroup": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setWorkerGroup((EventLoopGroup)value);
                    return true;
                }
                case "allowDefaultCodec": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setAllowDefaultCodec(((Boolean)value).booleanValue());
                    return true;
                }
                case "autoAppendDelimiter": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setAutoAppendDelimiter(((Boolean)value).booleanValue());
                    return true;
                }
                case "decoderMaxLineLength": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setDecoderMaxLineLength(((Integer)value).intValue());
                    return true;
                }
                case "decoders": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setDecoders((List)value);
                    return true;
                }
                case "delimiter": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setDelimiter((TextLineDelimiter)value);
                    return true;
                }
                case "encoders": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setEncoders((List)value);
                    return true;
                }
                case "encoding": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setEncoding((String)value);
                    return true;
                }
                case "textline": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setTextline(((Boolean)value).booleanValue());
                    return true;
                }
                case "enabledProtocols": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setEnabledProtocols((String)value);
                    return true;
                }
                case "hostnameVerification": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setHostnameVerification(((Boolean)value).booleanValue());
                    return true;
                }
                case "keyStoreFile": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setKeyStoreFile((File)value);
                    return true;
                }
                case "keyStoreFormat": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setKeyStoreFormat((String)value);
                    return true;
                }
                case "keyStoreResource": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setKeyStoreResource((String)value);
                    return true;
                }
                case "needClientAuth": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setNeedClientAuth(((Boolean)value).booleanValue());
                    return true;
                }
                case "passphrase": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setPassphrase((String)value);
                    return true;
                }
                case "securityConfiguration": {
                    ((NettyHttpComponent)component).setSecurityConfiguration((NettyHttpSecurityConfiguration)value);
                    return true;
                }
                case "securityProvider": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setSecurityProvider((String)value);
                    return true;
                }
                case "ssl": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setSsl(((Boolean)value).booleanValue());
                    return true;
                }
                case "sslClientCertHeaders": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setSslClientCertHeaders(((Boolean)value).booleanValue());
                    return true;
                }
                case "sslContextParameters": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setSslContextParameters((SSLContextParameters)value);
                    return true;
                }
                case "sslHandler": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setSslHandler((SslHandler)value);
                    return true;
                }
                case "trustStoreFile": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setTrustStoreFile((File)value);
                    return true;
                }
                case "trustStoreResource": {
                    this.getOrCreateConfiguration((NettyHttpComponent)component).setTrustStoreResource((String)value);
                    return true;
                }
                case "useGlobalSslContextParameters": {
                    ((NettyHttpComponent)component).setUseGlobalSslContextParameters(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface NettyHttpComponentBuilder
    extends ComponentBuilder<NettyHttpComponent> {
        default public NettyHttpComponentBuilder configuration(NettyConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public NettyHttpComponentBuilder disconnect(boolean disconnect) {
            this.doSetProperty("disconnect", disconnect);
            return this;
        }

        default public NettyHttpComponentBuilder keepAlive(boolean keepAlive) {
            this.doSetProperty("keepAlive", keepAlive);
            return this;
        }

        default public NettyHttpComponentBuilder reuseAddress(boolean reuseAddress) {
            this.doSetProperty("reuseAddress", reuseAddress);
            return this;
        }

        default public NettyHttpComponentBuilder reuseChannel(boolean reuseChannel) {
            this.doSetProperty("reuseChannel", reuseChannel);
            return this;
        }

        default public NettyHttpComponentBuilder sync(boolean sync) {
            this.doSetProperty("sync", sync);
            return this;
        }

        default public NettyHttpComponentBuilder tcpNoDelay(boolean tcpNoDelay) {
            this.doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }

        default public NettyHttpComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public NettyHttpComponentBuilder broadcast(boolean broadcast) {
            this.doSetProperty("broadcast", broadcast);
            return this;
        }

        default public NettyHttpComponentBuilder clientMode(boolean clientMode) {
            this.doSetProperty("clientMode", clientMode);
            return this;
        }

        default public NettyHttpComponentBuilder reconnect(boolean reconnect) {
            this.doSetProperty("reconnect", reconnect);
            return this;
        }

        default public NettyHttpComponentBuilder reconnectInterval(int reconnectInterval) {
            this.doSetProperty("reconnectInterval", reconnectInterval);
            return this;
        }

        default public NettyHttpComponentBuilder backlog(int backlog) {
            this.doSetProperty("backlog", backlog);
            return this;
        }

        default public NettyHttpComponentBuilder bossCount(int bossCount) {
            this.doSetProperty("bossCount", bossCount);
            return this;
        }

        default public NettyHttpComponentBuilder bossGroup(EventLoopGroup bossGroup) {
            this.doSetProperty("bossGroup", bossGroup);
            return this;
        }

        default public NettyHttpComponentBuilder disconnectOnNoReply(boolean disconnectOnNoReply) {
            this.doSetProperty("disconnectOnNoReply", disconnectOnNoReply);
            return this;
        }

        default public NettyHttpComponentBuilder executorService(EventExecutorGroup executorService) {
            this.doSetProperty("executorService", executorService);
            return this;
        }

        default public NettyHttpComponentBuilder maximumPoolSize(int maximumPoolSize) {
            this.doSetProperty("maximumPoolSize", maximumPoolSize);
            return this;
        }

        default public NettyHttpComponentBuilder nettyServerBootstrapFactory(NettyServerBootstrapFactory nettyServerBootstrapFactory) {
            this.doSetProperty("nettyServerBootstrapFactory", nettyServerBootstrapFactory);
            return this;
        }

        default public NettyHttpComponentBuilder networkInterface(String networkInterface) {
            this.doSetProperty("networkInterface", networkInterface);
            return this;
        }

        default public NettyHttpComponentBuilder noReplyLogLevel(LoggingLevel noReplyLogLevel) {
            this.doSetProperty("noReplyLogLevel", noReplyLogLevel);
            return this;
        }

        default public NettyHttpComponentBuilder serverClosedChannelExceptionCaughtLogLevel(LoggingLevel serverClosedChannelExceptionCaughtLogLevel) {
            this.doSetProperty("serverClosedChannelExceptionCaughtLogLevel", serverClosedChannelExceptionCaughtLogLevel);
            return this;
        }

        default public NettyHttpComponentBuilder serverExceptionCaughtLogLevel(LoggingLevel serverExceptionCaughtLogLevel) {
            this.doSetProperty("serverExceptionCaughtLogLevel", serverExceptionCaughtLogLevel);
            return this;
        }

        default public NettyHttpComponentBuilder serverInitializerFactory(ServerInitializerFactory serverInitializerFactory) {
            this.doSetProperty("serverInitializerFactory", serverInitializerFactory);
            return this;
        }

        default public NettyHttpComponentBuilder usingExecutorService(boolean usingExecutorService) {
            this.doSetProperty("usingExecutorService", usingExecutorService);
            return this;
        }

        default public NettyHttpComponentBuilder connectTimeout(int connectTimeout) {
            this.doSetProperty("connectTimeout", connectTimeout);
            return this;
        }

        default public NettyHttpComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public NettyHttpComponentBuilder requestTimeout(long requestTimeout) {
            this.doSetProperty("requestTimeout", requestTimeout);
            return this;
        }

        default public NettyHttpComponentBuilder clientInitializerFactory(ClientInitializerFactory clientInitializerFactory) {
            this.doSetProperty("clientInitializerFactory", clientInitializerFactory);
            return this;
        }

        default public NettyHttpComponentBuilder correlationManager(NettyCamelStateCorrelationManager correlationManager) {
            this.doSetProperty("correlationManager", correlationManager);
            return this;
        }

        default public NettyHttpComponentBuilder lazyChannelCreation(boolean lazyChannelCreation) {
            this.doSetProperty("lazyChannelCreation", lazyChannelCreation);
            return this;
        }

        default public NettyHttpComponentBuilder producerPoolEnabled(boolean producerPoolEnabled) {
            this.doSetProperty("producerPoolEnabled", producerPoolEnabled);
            return this;
        }

        default public NettyHttpComponentBuilder producerPoolMaxActive(int producerPoolMaxActive) {
            this.doSetProperty("producerPoolMaxActive", producerPoolMaxActive);
            return this;
        }

        default public NettyHttpComponentBuilder producerPoolMaxIdle(int producerPoolMaxIdle) {
            this.doSetProperty("producerPoolMaxIdle", producerPoolMaxIdle);
            return this;
        }

        default public NettyHttpComponentBuilder producerPoolMinEvictableIdle(long producerPoolMinEvictableIdle) {
            this.doSetProperty("producerPoolMinEvictableIdle", producerPoolMinEvictableIdle);
            return this;
        }

        default public NettyHttpComponentBuilder producerPoolMinIdle(int producerPoolMinIdle) {
            this.doSetProperty("producerPoolMinIdle", producerPoolMinIdle);
            return this;
        }

        default public NettyHttpComponentBuilder udpConnectionlessSending(boolean udpConnectionlessSending) {
            this.doSetProperty("udpConnectionlessSending", udpConnectionlessSending);
            return this;
        }

        default public NettyHttpComponentBuilder useByteBuf(boolean useByteBuf) {
            this.doSetProperty("useByteBuf", useByteBuf);
            return this;
        }

        default public NettyHttpComponentBuilder allowSerializedHeaders(boolean allowSerializedHeaders) {
            this.doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }

        default public NettyHttpComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public NettyHttpComponentBuilder channelGroup(ChannelGroup channelGroup) {
            this.doSetProperty("channelGroup", channelGroup);
            return this;
        }

        default public NettyHttpComponentBuilder headerFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public NettyHttpComponentBuilder nativeTransport(boolean nativeTransport) {
            this.doSetProperty("nativeTransport", nativeTransport);
            return this;
        }

        default public NettyHttpComponentBuilder nettyHttpBinding(NettyHttpBinding nettyHttpBinding) {
            this.doSetProperty("nettyHttpBinding", nettyHttpBinding);
            return this;
        }

        default public NettyHttpComponentBuilder options(Map<String, Object> options) {
            this.doSetProperty("options", options);
            return this;
        }

        default public NettyHttpComponentBuilder receiveBufferSize(int receiveBufferSize) {
            this.doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }

        default public NettyHttpComponentBuilder receiveBufferSizePredictor(int receiveBufferSizePredictor) {
            this.doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }

        default public NettyHttpComponentBuilder sendBufferSize(int sendBufferSize) {
            this.doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }

        default public NettyHttpComponentBuilder transferExchange(boolean transferExchange) {
            this.doSetProperty("transferExchange", transferExchange);
            return this;
        }

        default public NettyHttpComponentBuilder udpByteArrayCodec(boolean udpByteArrayCodec) {
            this.doSetProperty("udpByteArrayCodec", udpByteArrayCodec);
            return this;
        }

        default public NettyHttpComponentBuilder workerCount(int workerCount) {
            this.doSetProperty("workerCount", workerCount);
            return this;
        }

        default public NettyHttpComponentBuilder workerGroup(EventLoopGroup workerGroup) {
            this.doSetProperty("workerGroup", workerGroup);
            return this;
        }

        default public NettyHttpComponentBuilder allowDefaultCodec(boolean allowDefaultCodec) {
            this.doSetProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }

        default public NettyHttpComponentBuilder autoAppendDelimiter(boolean autoAppendDelimiter) {
            this.doSetProperty("autoAppendDelimiter", autoAppendDelimiter);
            return this;
        }

        default public NettyHttpComponentBuilder decoderMaxLineLength(int decoderMaxLineLength) {
            this.doSetProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }

        default public NettyHttpComponentBuilder decoders(List<ChannelHandler> decoders) {
            this.doSetProperty("decoders", decoders);
            return this;
        }

        default public NettyHttpComponentBuilder delimiter(TextLineDelimiter delimiter) {
            this.doSetProperty("delimiter", delimiter);
            return this;
        }

        default public NettyHttpComponentBuilder encoders(List<ChannelHandler> encoders) {
            this.doSetProperty("encoders", encoders);
            return this;
        }

        default public NettyHttpComponentBuilder encoding(String encoding) {
            this.doSetProperty("encoding", encoding);
            return this;
        }

        default public NettyHttpComponentBuilder textline(boolean textline) {
            this.doSetProperty("textline", textline);
            return this;
        }

        default public NettyHttpComponentBuilder enabledProtocols(String enabledProtocols) {
            this.doSetProperty("enabledProtocols", enabledProtocols);
            return this;
        }

        default public NettyHttpComponentBuilder hostnameVerification(boolean hostnameVerification) {
            this.doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }

        default public NettyHttpComponentBuilder keyStoreFile(File keyStoreFile) {
            this.doSetProperty("keyStoreFile", keyStoreFile);
            return this;
        }

        default public NettyHttpComponentBuilder keyStoreFormat(String keyStoreFormat) {
            this.doSetProperty("keyStoreFormat", keyStoreFormat);
            return this;
        }

        default public NettyHttpComponentBuilder keyStoreResource(String keyStoreResource) {
            this.doSetProperty("keyStoreResource", keyStoreResource);
            return this;
        }

        default public NettyHttpComponentBuilder needClientAuth(boolean needClientAuth) {
            this.doSetProperty("needClientAuth", needClientAuth);
            return this;
        }

        default public NettyHttpComponentBuilder passphrase(String passphrase) {
            this.doSetProperty("passphrase", passphrase);
            return this;
        }

        default public NettyHttpComponentBuilder securityConfiguration(NettyHttpSecurityConfiguration securityConfiguration) {
            this.doSetProperty("securityConfiguration", securityConfiguration);
            return this;
        }

        default public NettyHttpComponentBuilder securityProvider(String securityProvider) {
            this.doSetProperty("securityProvider", securityProvider);
            return this;
        }

        default public NettyHttpComponentBuilder ssl(boolean ssl) {
            this.doSetProperty("ssl", ssl);
            return this;
        }

        default public NettyHttpComponentBuilder sslClientCertHeaders(boolean sslClientCertHeaders) {
            this.doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }

        default public NettyHttpComponentBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public NettyHttpComponentBuilder sslHandler(SslHandler sslHandler) {
            this.doSetProperty("sslHandler", sslHandler);
            return this;
        }

        default public NettyHttpComponentBuilder trustStoreFile(File trustStoreFile) {
            this.doSetProperty("trustStoreFile", trustStoreFile);
            return this;
        }

        default public NettyHttpComponentBuilder trustStoreResource(String trustStoreResource) {
            this.doSetProperty("trustStoreResource", trustStoreResource);
            return this;
        }

        default public NettyHttpComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            this.doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    }
}

