/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.amazonaws.Protocol;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.ddb.DdbComponent;
import org.apache.camel.component.aws.ddb.DdbConfiguration;
import org.apache.camel.component.aws.ddb.DdbOperations;

public interface AwsDdbComponentBuilderFactory {
    public static AwsDdbComponentBuilder awsDdb() {
        return new AwsDdbComponentBuilderImpl();
    }

    public static class AwsDdbComponentBuilderImpl
    extends AbstractComponentBuilder<DdbComponent>
    implements AwsDdbComponentBuilder {
        @Override
        protected DdbComponent buildConcreteComponent() {
            return new DdbComponent();
        }

        private DdbConfiguration getOrCreateConfiguration(DdbComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new DdbConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "amazonDDBClient": {
                    this.getOrCreateConfiguration((DdbComponent)component).setAmazonDDBClient((AmazonDynamoDB)value);
                    return true;
                }
                case "autoDiscoverClient": {
                    this.getOrCreateConfiguration((DdbComponent)component).setAutoDiscoverClient(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((DdbComponent)component).setConfiguration((DdbConfiguration)value);
                    return true;
                }
                case "consistentRead": {
                    this.getOrCreateConfiguration((DdbComponent)component).setConsistentRead(((Boolean)value).booleanValue());
                    return true;
                }
                case "keyAttributeName": {
                    this.getOrCreateConfiguration((DdbComponent)component).setKeyAttributeName((String)value);
                    return true;
                }
                case "keyAttributeType": {
                    this.getOrCreateConfiguration((DdbComponent)component).setKeyAttributeType((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((DdbComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((DdbComponent)component).setOperation((DdbOperations)value);
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((DdbComponent)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((DdbComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((DdbComponent)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "readCapacity": {
                    this.getOrCreateConfiguration((DdbComponent)component).setReadCapacity((Long)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((DdbComponent)component).setRegion((String)value);
                    return true;
                }
                case "writeCapacity": {
                    this.getOrCreateConfiguration((DdbComponent)component).setWriteCapacity((Long)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((DdbComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((DdbComponent)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((DdbComponent)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AwsDdbComponentBuilder
    extends ComponentBuilder<DdbComponent> {
        default public AwsDdbComponentBuilder amazonDDBClient(AmazonDynamoDB amazonDDBClient) {
            this.doSetProperty("amazonDDBClient", amazonDDBClient);
            return this;
        }

        default public AwsDdbComponentBuilder autoDiscoverClient(boolean autoDiscoverClient) {
            this.doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }

        default public AwsDdbComponentBuilder configuration(DdbConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AwsDdbComponentBuilder consistentRead(boolean consistentRead) {
            this.doSetProperty("consistentRead", consistentRead);
            return this;
        }

        default public AwsDdbComponentBuilder keyAttributeName(String keyAttributeName) {
            this.doSetProperty("keyAttributeName", keyAttributeName);
            return this;
        }

        default public AwsDdbComponentBuilder keyAttributeType(String keyAttributeType) {
            this.doSetProperty("keyAttributeType", keyAttributeType);
            return this;
        }

        default public AwsDdbComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AwsDdbComponentBuilder operation(DdbOperations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public AwsDdbComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public AwsDdbComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AwsDdbComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AwsDdbComponentBuilder readCapacity(Long readCapacity) {
            this.doSetProperty("readCapacity", readCapacity);
            return this;
        }

        default public AwsDdbComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AwsDdbComponentBuilder writeCapacity(Long writeCapacity) {
            this.doSetProperty("writeCapacity", writeCapacity);
            return this;
        }

        default public AwsDdbComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AwsDdbComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AwsDdbComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

