/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.time.Duration;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.azure.storage.blob.BlobComponent;
import org.apache.camel.component.azure.storage.blob.BlobConfiguration;
import org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition;
import org.apache.camel.component.azure.storage.blob.BlobType;

public interface AzureStorageBlobComponentBuilderFactory {
    public static AzureStorageBlobComponentBuilder azureStorageBlob() {
        return new AzureStorageBlobComponentBuilderImpl();
    }

    public static class AzureStorageBlobComponentBuilderImpl
    extends AbstractComponentBuilder<BlobComponent>
    implements AzureStorageBlobComponentBuilder {
        @Override
        protected BlobComponent buildConcreteComponent() {
            return new BlobComponent();
        }

        private BlobConfiguration getOrCreateConfiguration(BlobComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new BlobConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "autoDiscoverClient": {
                    this.getOrCreateConfiguration((BlobComponent)component).setAutoDiscoverClient(((Boolean)value).booleanValue());
                    return true;
                }
                case "blobName": {
                    this.getOrCreateConfiguration((BlobComponent)component).setBlobName((String)value);
                    return true;
                }
                case "blobOffset": {
                    this.getOrCreateConfiguration((BlobComponent)component).setBlobOffset(((Long)value).longValue());
                    return true;
                }
                case "blobType": {
                    this.getOrCreateConfiguration((BlobComponent)component).setBlobType((BlobType)value);
                    return true;
                }
                case "closeStreamAfterRead": {
                    this.getOrCreateConfiguration((BlobComponent)component).setCloseStreamAfterRead(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((BlobComponent)component).setConfiguration((BlobConfiguration)value);
                    return true;
                }
                case "credentials": {
                    this.getOrCreateConfiguration((BlobComponent)component).setCredentials((StorageSharedKeyCredential)value);
                    return true;
                }
                case "dataCount": {
                    this.getOrCreateConfiguration((BlobComponent)component).setDataCount((Long)value);
                    return true;
                }
                case "fileDir": {
                    this.getOrCreateConfiguration((BlobComponent)component).setFileDir((String)value);
                    return true;
                }
                case "maxResultsPerPage": {
                    this.getOrCreateConfiguration((BlobComponent)component).setMaxResultsPerPage((Integer)value);
                    return true;
                }
                case "maxRetryRequests": {
                    this.getOrCreateConfiguration((BlobComponent)component).setMaxRetryRequests(((Integer)value).intValue());
                    return true;
                }
                case "prefix": {
                    this.getOrCreateConfiguration((BlobComponent)component).setPrefix((String)value);
                    return true;
                }
                case "serviceClient": {
                    this.getOrCreateConfiguration((BlobComponent)component).setServiceClient((BlobServiceClient)value);
                    return true;
                }
                case "timeout": {
                    this.getOrCreateConfiguration((BlobComponent)component).setTimeout((Duration)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((BlobComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "blobSequenceNumber": {
                    this.getOrCreateConfiguration((BlobComponent)component).setBlobSequenceNumber((Long)value);
                    return true;
                }
                case "blockListType": {
                    this.getOrCreateConfiguration((BlobComponent)component).setBlockListType((BlockListType)value);
                    return true;
                }
                case "closeStreamAfterWrite": {
                    this.getOrCreateConfiguration((BlobComponent)component).setCloseStreamAfterWrite(((Boolean)value).booleanValue());
                    return true;
                }
                case "commitBlockListLater": {
                    this.getOrCreateConfiguration((BlobComponent)component).setCommitBlockListLater(((Boolean)value).booleanValue());
                    return true;
                }
                case "createAppendBlob": {
                    this.getOrCreateConfiguration((BlobComponent)component).setCreateAppendBlob(((Boolean)value).booleanValue());
                    return true;
                }
                case "createPageBlob": {
                    this.getOrCreateConfiguration((BlobComponent)component).setCreatePageBlob(((Boolean)value).booleanValue());
                    return true;
                }
                case "downloadLinkExpiration": {
                    this.getOrCreateConfiguration((BlobComponent)component).setDownloadLinkExpiration((Long)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((BlobComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((BlobComponent)component).setOperation((BlobOperationsDefinition)value);
                    return true;
                }
                case "pageBlobSize": {
                    this.getOrCreateConfiguration((BlobComponent)component).setPageBlobSize((Long)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((BlobComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((BlobComponent)component).setAccessKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AzureStorageBlobComponentBuilder
    extends ComponentBuilder<BlobComponent> {
        default public AzureStorageBlobComponentBuilder autoDiscoverClient(boolean autoDiscoverClient) {
            this.doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }

        default public AzureStorageBlobComponentBuilder blobName(String blobName) {
            this.doSetProperty("blobName", blobName);
            return this;
        }

        default public AzureStorageBlobComponentBuilder blobOffset(long blobOffset) {
            this.doSetProperty("blobOffset", blobOffset);
            return this;
        }

        default public AzureStorageBlobComponentBuilder blobType(BlobType blobType) {
            this.doSetProperty("blobType", blobType);
            return this;
        }

        default public AzureStorageBlobComponentBuilder closeStreamAfterRead(boolean closeStreamAfterRead) {
            this.doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }

        default public AzureStorageBlobComponentBuilder configuration(BlobConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AzureStorageBlobComponentBuilder credentials(StorageSharedKeyCredential credentials) {
            this.doSetProperty("credentials", credentials);
            return this;
        }

        default public AzureStorageBlobComponentBuilder dataCount(Long dataCount) {
            this.doSetProperty("dataCount", dataCount);
            return this;
        }

        default public AzureStorageBlobComponentBuilder fileDir(String fileDir) {
            this.doSetProperty("fileDir", fileDir);
            return this;
        }

        default public AzureStorageBlobComponentBuilder maxResultsPerPage(Integer maxResultsPerPage) {
            this.doSetProperty("maxResultsPerPage", maxResultsPerPage);
            return this;
        }

        default public AzureStorageBlobComponentBuilder maxRetryRequests(int maxRetryRequests) {
            this.doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }

        default public AzureStorageBlobComponentBuilder prefix(String prefix) {
            this.doSetProperty("prefix", prefix);
            return this;
        }

        default public AzureStorageBlobComponentBuilder serviceClient(BlobServiceClient serviceClient) {
            this.doSetProperty("serviceClient", serviceClient);
            return this;
        }

        default public AzureStorageBlobComponentBuilder timeout(Duration timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }

        default public AzureStorageBlobComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AzureStorageBlobComponentBuilder blobSequenceNumber(Long blobSequenceNumber) {
            this.doSetProperty("blobSequenceNumber", blobSequenceNumber);
            return this;
        }

        default public AzureStorageBlobComponentBuilder blockListType(BlockListType blockListType) {
            this.doSetProperty("blockListType", blockListType);
            return this;
        }

        default public AzureStorageBlobComponentBuilder closeStreamAfterWrite(boolean closeStreamAfterWrite) {
            this.doSetProperty("closeStreamAfterWrite", closeStreamAfterWrite);
            return this;
        }

        default public AzureStorageBlobComponentBuilder commitBlockListLater(boolean commitBlockListLater) {
            this.doSetProperty("commitBlockListLater", commitBlockListLater);
            return this;
        }

        default public AzureStorageBlobComponentBuilder createAppendBlob(boolean createAppendBlob) {
            this.doSetProperty("createAppendBlob", createAppendBlob);
            return this;
        }

        default public AzureStorageBlobComponentBuilder createPageBlob(boolean createPageBlob) {
            this.doSetProperty("createPageBlob", createPageBlob);
            return this;
        }

        default public AzureStorageBlobComponentBuilder downloadLinkExpiration(Long downloadLinkExpiration) {
            this.doSetProperty("downloadLinkExpiration", downloadLinkExpiration);
            return this;
        }

        default public AzureStorageBlobComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AzureStorageBlobComponentBuilder operation(BlobOperationsDefinition operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public AzureStorageBlobComponentBuilder pageBlobSize(Long pageBlobSize) {
            this.doSetProperty("pageBlobSize", pageBlobSize);
            return this;
        }

        default public AzureStorageBlobComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AzureStorageBlobComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }
    }
}

